/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

namespace QuantConnect.Securities.Positions
{
    /// <summary>
    /// Defines the result for <see cref="IBuyingPowerModel.GetReservedBuyingPowerForPosition"/>
    /// </summary>
    public class ReservedBuyingPowerForPositionGroup
    {
        /// <summary>
        /// Gets the reserved buying power
        /// </summary>
        public decimal AbsoluteUsedBuyingPower { get; }

        /// <summary>
        /// Initializes a new instance of the <see cref="ReservedBuyingPowerForPosition"/> class
        /// </summary>
        /// <param name="reservedBuyingPowerForPosition">The reserved buying power for the security's holdings</param>
        public ReservedBuyingPowerForPositionGroup(decimal reservedBuyingPowerForPosition)
        {
            AbsoluteUsedBuyingPower = reservedBuyingPowerForPosition;
        }

        /// <summary>
        /// Implicit operator to <see cref="decimal"/> to remove noise
        /// </summary>
        public static implicit operator decimal(ReservedBuyingPowerForPositionGroup reservedBuyingPower)
        {
            return reservedBuyingPower.AbsoluteUsedBuyingPower;
        }

        /// <summary>
        /// Implicit operator to <see cref="decimal"/> to remove noise
        /// </summary>
        public static implicit operator ReservedBuyingPowerForPositionGroup(decimal reservedBuyingPower)
        {
            return new ReservedBuyingPowerForPositionGroup(reservedBuyingPower);
        }
    }
}
