import { describe, expect, it } from "vitest";
import { extractReadableContent } from "./web-tools.js";

const SAMPLE_HTML = `<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <title>Example Article</title>
  </head>
  <body>
    <nav>
      <ul>
        <li><a href="/home">Home</a></li>
        <li><a href="/about">About</a></li>
      </ul>
    </nav>
    <main>
      <article>
        <h1>Example Article</h1>
        <p>Main content starts here with enough words to satisfy readability.</p>
        <p>Second paragraph for a bit more signal.</p>
      </article>
    </main>
    <footer>Footer text</footer>
  </body>
</html>`;

describe("web fetch readability", () => {
  it("extracts readable text", async () => {
    const result = await extractReadableContent({
      html: SAMPLE_HTML,
      url: "https://example.com/article",
      extractMode: "text",
    });
    expect(result?.text).toContain("Main content starts here");
    expect(result?.title).toBe("Example Article");
  });

  it("extracts readable markdown", async () => {
    const result = await extractReadableContent({
      html: SAMPLE_HTML,
      url: "https://example.com/article",
      extractMode: "markdown",
    });
    expect(result?.text).toContain("Main content starts here");
    expect(result?.title).toBe("Example Article");
  });
});
