import type { TranslationMap } from "../lib/types.ts";

export const en: TranslationMap = {
  common: {
    version: "Version",
    health: "Health",
    ok: "OK",
    offline: "Offline",
    connect: "Connect",
    refresh: "Refresh",
    enabled: "Enabled",
    disabled: "Disabled",
    na: "n/a",
    docs: "Docs",
    resources: "Resources",
  },
  nav: {
    chat: "Chat",
    control: "Control",
    agent: "Agent",
    settings: "Settings",
    expand: "Expand sidebar",
    collapse: "Collapse sidebar",
  },
  tabs: {
    agents: "Agents",
    overview: "Overview",
    channels: "Channels",
    instances: "Instances",
    sessions: "Sessions",
    usage: "Usage",
    cron: "Cron Jobs",
    skills: "Skills",
    nodes: "Nodes",
    chat: "Chat",
    config: "Config",
    debug: "Debug",
    logs: "Logs",
  },
  subtitles: {
    agents: "Manage agent workspaces, tools, and identities.",
    overview: "Gateway status, entry points, and a fast health read.",
    channels: "Manage channels and settings.",
    instances: "Presence beacons from connected clients and nodes.",
    sessions: "Inspect active sessions and adjust per-session defaults.",
    usage: "Monitor API usage and costs.",
    cron: "Schedule wakeups and recurring agent runs.",
    skills: "Manage skill availability and API key injection.",
    nodes: "Paired devices, capabilities, and command exposure.",
    chat: "Direct gateway chat session for quick interventions.",
    config: "Edit ~/.openclaw/openclaw.json safely.",
    debug: "Gateway snapshots, events, and manual RPC calls.",
    logs: "Live tail of the gateway file logs.",
  },
  overview: {
    access: {
      title: "Gateway Access",
      subtitle: "Where the dashboard connects and how it authenticates.",
      wsUrl: "WebSocket URL",
      token: "Gateway Token",
      password: "Password (not stored)",
      sessionKey: "Default Session Key",
      language: "Language",
      connectHint: "Click Connect to apply connection changes.",
      trustedProxy: "Authenticated via trusted proxy.",
    },
    snapshot: {
      title: "Snapshot",
      subtitle: "Latest gateway handshake information.",
      status: "Status",
      uptime: "Uptime",
      tickInterval: "Tick Interval",
      lastChannelsRefresh: "Last Channels Refresh",
      channelsHint: "Use Channels to link WhatsApp, Telegram, Discord, Signal, or iMessage.",
    },
    stats: {
      instances: "Instances",
      instancesHint: "Presence beacons in the last 5 minutes.",
      sessions: "Sessions",
      sessionsHint: "Recent session keys tracked by the gateway.",
      cron: "Cron",
      cronNext: "Next wake {time}",
    },
    notes: {
      title: "Notes",
      subtitle: "Quick reminders for remote control setups.",
      tailscaleTitle: "Tailscale serve",
      tailscaleText: "Prefer serve mode to keep the gateway on loopback with tailnet auth.",
      sessionTitle: "Session hygiene",
      sessionText: "Use /new or sessions.patch to reset context.",
      cronTitle: "Cron reminders",
      cronText: "Use isolated sessions for recurring runs.",
    },
    auth: {
      required: "This gateway requires auth. Add a token or password, then click Connect.",
      failed:
        "Auth failed. Re-copy a tokenized URL with {command}, or update the token, then click Connect.",
    },
    pairing: {
      hint: "This device needs pairing approval from the gateway host.",
      mobileHint:
        "On mobile? Copy the full URL (including #token=...) from openclaw dashboard --no-open on your desktop.",
    },
    insecure: {
      hint: "This page is HTTP, so the browser blocks device identity. Use HTTPS (Tailscale Serve) or open {url} on the gateway host.",
      stayHttp: "If you must stay on HTTP, set {config} (token-only).",
    },
  },
  chat: {
    disconnected: "Disconnected from gateway.",
    refreshTitle: "Refresh chat data",
    thinkingToggle: "Toggle assistant thinking/working output",
    focusToggle: "Toggle focus mode (hide sidebar + page header)",
    onboardingDisabled: "Disabled during onboarding",
  },
  languages: {
    en: "English",
    zhCN: "简体中文 (Simplified Chinese)",
    zhTW: "繁體中文 (Traditional Chinese)",
    ptBR: "Português (Brazilian Portuguese)",
  },
};
