import type { TranslationMap } from "../lib/types.ts";

export const zh_TW: TranslationMap = {
  common: {
    version: "版本",
    health: "健康狀況",
    ok: "正常",
    offline: "離線",
    connect: "連接",
    refresh: "刷新",
    enabled: "已啟用",
    disabled: "已禁用",
    na: "不適用",
    docs: "文檔",
    resources: "資源",
  },
  nav: {
    chat: "聊天",
    control: "控制",
    agent: "代理",
    settings: "設置",
    expand: "展開側邊欄",
    collapse: "折疊側邊欄",
  },
  tabs: {
    agents: "代理",
    overview: "概覽",
    channels: "頻道",
    instances: "實例",
    sessions: "會話",
    usage: "使用情況",
    cron: "定時任務",
    skills: "技能",
    nodes: "節點",
    chat: "聊天",
    config: "配置",
    debug: "調試",
    logs: "日誌",
  },
  subtitles: {
    agents: "管理代理工作區、工具和身份。",
    overview: "網關狀態、入口點和快速健康讀取。",
    channels: "管理頻道和設置。",
    instances: "來自已連接客戶端和節點的在線信號。",
    sessions: "檢查活動會話並調整每個會話的默認設置。",
    usage: "監控 API 使用情況和成本。",
    cron: "安排喚醒和重複的代理運行。",
    skills: "管理技能可用性和 API 密鑰注入。",
    nodes: "配對設備、功能和命令公開。",
    chat: "用於快速干預的直接網關聊天會話。",
    config: "安全地編輯 ~/.openclaw/openclaw.json。",
    debug: "網關快照、事件和手動 RPC 調用。",
    logs: "網關文件日志的實時追蹤。",
  },
  overview: {
    access: {
      title: "網關訪問",
      subtitle: "儀表板連接的位置及其身份驗證方式。",
      wsUrl: "WebSocket URL",
      token: "網關令牌",
      password: "密碼 (不存儲)",
      sessionKey: "默認會話密鑰",
      language: "語言",
      connectHint: "點擊連接以應用連接更改。",
      trustedProxy: "通過受信任代理身份驗證。",
    },
    snapshot: {
      title: "快照",
      subtitle: "最新的網關握手信息。",
      status: "狀態",
      uptime: "運行時間",
      tickInterval: "刻度間隔",
      lastChannelsRefresh: "最後頻道刷新",
      channelsHint: "使用頻道鏈接 WhatsApp、Telegram、Discord、Signal 或 iMessage。",
    },
    stats: {
      instances: "實例",
      instancesHint: "過去 5 分鐘內的在線信號。",
      sessions: "會話",
      sessionsHint: "網關跟蹤的最近會話密鑰。",
      cron: "定時任務",
      cronNext: "下次喚醒 {time}",
    },
    notes: {
      title: "備註",
      subtitle: "遠程控制設置的快速提醒。",
      tailscaleTitle: "Tailscale serve",
      tailscaleText: "首選 serve 模式以通過 tailnet 身份驗證將網關保持在回環地址。",
      sessionTitle: "會話清理",
      sessionText: "使用 /new 或 sessions.patch 重置上下文。",
      cronTitle: "定時任務提醒",
      cronText: "為重複運行使用隔離的會話。",
    },
    auth: {
      required: "此網關需要身份驗證。添加令牌或密碼，然後點擊連接。",
      failed: "身份驗證失敗。請使用 {command} 重新複製令牌化 URL，或更新令牌，然後點擊連接。",
    },
    pairing: {
      hint: "此裝置需要閘道主機的配對批准。",
      mobileHint:
        "在手機上？從桌面執行 openclaw dashboard --no-open 複製完整 URL（包括 #token=...）。",
    },
    insecure: {
      hint: "此頁面為 HTTP，因此瀏覽器阻止設備標識。請使用 HTTPS (Tailscale Serve) 或在網關主機上打開 {url}。",
      stayHttp: "如果您必須保持 HTTP，請設置 {config} (僅限令牌)。",
    },
  },
  chat: {
    disconnected: "已斷開與網關的連接。",
    refreshTitle: "刷新聊天數據",
    thinkingToggle: "切換助手思考/工作輸出",
    focusToggle: "切換專注模式 (隱藏側邊欄 + 頁面頁眉)",
    onboardingDisabled: "引導期間禁用",
  },
  languages: {
    en: "English",
    zhCN: "简体中文 (簡體中文)",
    zhTW: "繁體中文 (繁體中文)",
    ptBR: "Português (巴西葡萄牙語)",
  },
};
