# A2UI Gemini Agent Guide

This document serves as a guide for using the Gemini agent within the A2UI repository. It outlines the repository's structure, explains the core concepts of the A2UI protocol, and provides instructions for running the various demos and keeping this guide up-to-date.

## Repository Structure

The A2UI repository is organized into several key directories:

-   `specification/0.8/docs/`: Contains the primary human-readable documentation for the A2UI protocol.
    -   `a2ui_protocol.md`: The foundational specification document. This is the best place to start to understand the protocol's fundamental goals.
-   `specification/0.8/json/`: Contains the formal JSON schema definitions for the protocol.
    -   `server_to_client.json`: Defines the schema for messages sent from the server to the client.
    -   `client_to_server.json`: Defines the schema for event messages sent from the client to the server.
-   `a2a_agents/python/`: Contains Python code relating to server-side integration of A2UI
    -   `a2ui_extension/`: Python implementation of the A2UI A2A extension.
    -   `adk/samples/`: Contains demo applications that showcase the A2UI protocol in action using the ADK framework.
-   `web/`: Contains the web-based client implementations (using Lit and Vite) for the samples, including a shared library (`renderers/lit`).
-   `angular/`: Contains an alternative web-based client implementation using Angular.
-   `eval/`: Contains a Genkit-based framework for evaluating LLM performance in generating A2UI responses.

## A2UI Specification Overview

The A2UI protocol is a JSONL-based, streaming UI protocol designed to be easily generated by Large Language Models (LLMs). It enables a server to stream a platform-agnostic, abstract UI definition to a client, which then renders it progressively using a native widget set.

### Core Concepts

The core concepts of the A2UI protocol are detailed in the main specification document. Rather than duplicating the content here, you should refer to the authoritative source:

-   **A2UI Protocol Specification**: `@docs/a2ui_protocol.md`

This document covers the design philosophy, architecture, data flow, and core concepts of the protocol.

### Schemas

The formal, machine-readable definitions of the protocol are maintained as JSON schemas:

-   **Server-to-Client Schema**: `@specification/0.8/json/server_to_client.json`
-   **Server-to-Client Schema, with standard catalog**: `@specification/0.8/json/server_to_client_with_standard_catalog.json`
-   **Client-to-Server Schema**: `@specification/0.8/json/client_to_server.json`

## Running the Demos

There are three demos available in the `a2a_samples/` directory. Each demo has a corresponding web client in the `web/` and `angular/` directories. To run a demo, you will need to start both the server and the client.

### Running a Demo Server

To run a demo server, navigate to the demo's directory and run the `__main__.py` script. For example, to run the contact lookup demo:

```bash
cd a2a_samples/a2ui_contact_lookup
python -m __main__
```

### Running a Demo Client (Lit)

To run a demo client, navigate to the corresponding client directory in `web/` and start the development server. For example, to run the contact lookup client:

```bash
cd web/contact
npm install
npm run dev
```

### Running a Demo Client (Angular)

To run a demo client, navigate to the `angular/` directory and start the development server with the project name. For example, to run the contact lookup client:

```bash
cd angular
npm install
npm start -- contact
```

## Renderers

There are three renderers available for A2UI:

-   **Web (Lit)**: Located in `renderers/lit`, this is the primary web renderer used by the demos in `web/`.
-   **Angular**: Located in `angular/projects/lib`, this is an alternative web renderer for Angular applications.
-   **Flutter**: The Flutter renderer is in a separate repository: [https://github.com/flutter/genui](https://github.com/flutter/genui)

## Keeping This Guide Updated

This document is intended to be a living guide for the repository. As the repository evolves, it's important to keep this file up-to-date. When making changes to the repository, please consider the following:

-   **New Demos or Clients**: If you add a new demo or client, add it to the "Running the Demos" section.
-   **Specification Changes**: If you make significant changes to the A2UI protocol, ensure that the "A2UI Specification Overview" section is updated to reflect the changes, and that any linked documents are also updated.
-   **Repository Structure Changes**: If you change the directory structure of the repository, update the "Repository Structure" section.

To get this file back in sync, you can run the following commands:

1. List all the files in the entire repo with `git ls-tree main --name-only -r`
2. Read the ~50 most important files in the list, potentially in batches.
3. Update this file.
