# A2UI JSON Schema Files

This directory contains the formal JSON Schema definitions for the A2UI protocol.

## Schema Descriptions

-   `server_to_client.json`: This is the core, catalog-agnostic schema for messages sent from the server to the client. It defines the four main message types (`beginRendering`, `surfaceUpdate`, `dataModelUpdate`, `deleteSurface`) and their structure. In this schema, the `component` object within a `surfaceUpdate` message is generic (`"additionalProperties": true`), allowing any component definitions to be passed.

-   `client_to_server.json`: This schema defines the structure for event messages sent from the client to the server. This includes user-initiated actions (`userAction`), error reporting (`error`), and the crucial `clientUiCapabilities` message, which allows a client to inform the server about the component catalog it supports.

-   `catalog_description_schema.json`: This is a meta-schema that defines the structure of an A2UI component catalog. A catalog consists of a `components` object and a `styles` object, where each key is a component/style name and the value is a JSON schema defining its properties. This allows for the creation of custom component sets.

-   `standard_catalog_definition.json`: This file is a concrete implementation of a catalog, conforming to the `catalog_description_schema.json`. It defines the standard set of components (e.g., `Text`, `Image`, `Row`, `Card`) and styles that are part of the baseline A2UI specification.

-   `server_to_client_with_standard_catalog.json`: This is a resolved, LLM-friendly version of the server-to-client schema. It is generated by combining `server_to_client.json` with the `standard_catalog_definition.json`. In this version, the generic `component` object is replaced with a strict `oneOf` definition that includes every component from the standard catalog. This provides a complete, strictly-typed schema that is ideal for LLMs to use for generating valid A2UI messages without ambiguity.
