# 量化投资实战教程 —— Python实用宝典

许多技术投资方面的教材，经常会用几幅上涨的图来表明某些指标的用处，实际上那些上涨的图很可能只是假象。作者为了证明他所强调的指标的作用，选定了符合该指标策略的股票上升趋势图，但实际上这些策略并不一定适合全部股票，许多人被傻傻地骗了进去，血本无归。

因此，判断一个策略的好坏一定要有回测证据，要有数字证明，而非花言巧语，而本教程的最终目的，就是教你如何生成这些证据。

本Github仓库记录了量化投资系列教程文章的源代码，教程:

1.[Backtrader 教程 — 量化投资实战教程(1)](https://pythondict.com/quant/backtrader-easy-quant-one/) - 2020/04/12

2.[Python 量化投资实战教程(2) — MACD策略](https://pythondict.com/quant/backtrader-easy-quant-macd-26profit/) - 2020/04/20

3.[Python 量化投资实战教程(3) — A股回测MACD策略](https://pythondict.com/quant/back-trader-a-market-with-macd/) - 2020/04/26

4.[Python 量化投资实战教程(4) — KDJ 策略](https://pythondict.com/quant/backtrader-kdj/) - 2020/05/06

5.[Python 量化投资实战教程(5) — A股回测KDJ策略](https://pythondict.com/quant/backtrader-kdj-a-market/) - 2020/05/16

6.[Python 量化投资实战教程(6) — 交易平均收益](https://pythondict.com/quant/backtrader-average-profit/) - 2020/05/26

7.[Python 量化投资实战教程(7) — 孕线真的有用吗？](https://pythondict.com/quant/python-quant-harami/) - 2020/08/20

8.[Python 量化投资实战教程(8) - A股回测“孕线”策略](https://pythondict.com/quant/quant-a-stock-backtrader-harami/) - 2020/09/08

9.[Python 量化投资实战教程(9) - 自定义MySQL数据流](https://pythondict.com/quant/backtrader-custom-mysql-datafeed/) - 2020/11/12

10.[Python 量化投资实战教程(10) - 可转债薅羊毛策略](https://pythondict.com/quant/convert_bond/) - 2021/03/07

11.[Prometheus 实战教程 + Grafana + Python — 实时监控东方财富人气榜股票](https://pythondict.com/scrapy/prometheus-grafana-python/) - 2021/06/13

12.[Lean — 优秀好用的开源量化交易平台](https://pythondict.com/quant/lean/?hilite=lean) - 2021年10月21日

13.[量化投资单因子回测神器 — Alphalens](https://pythondict.com/quant/%e9%87%8f%e5%8c%96%e6%8a%95%e8%b5%84%e5%8d%95%e5%9b%a0%e5%ad%90%e5%9b%9e%e6%b5%8b%e7%a5%9e%e5%99%a8-alphalens/) - 2021年11月23日

14.[微软开源！世界首个AI 量化投资平台 Qlib 使用教程](https://pythondict.com/quant/qlib/) - 2021年11月1日

15.[什么是强化学习？预测股票的效果如何？](https://pythondict.com/quant/reinforcement-learnning/)

基于[Backtrader](https://github.com/mementum/backtrader)，感谢开发者。

Python实用宝典：[pythondict.com](https://pythondict.com)，欢迎关注Python实用宝典公众号阅读最新的文章。

## 问题反馈
1.如遇到`ImportError: cannot import name 'warnings'`错误，请安装matplotlib-3.2.2
```
pip install matplotlib==3.2.2
```