## 重要提示!

- <b>Qbot 目前仅在 python3.8 pyhont3.9 下测试过，其他版本未测试。</b>
- <b>Qbot 倡导每个交易员都应搭建属于自己的交易系统；所以我们源代码交付；</b>
- <b>Qbot 支持非商业用途的二次开发；</b>
- <b><a href="Qbot用户协议">Qbot 用户协议</a>；</b>

# qbot-pro 本地安装部署操作流程

安装步骤简单分为三步: 下载安装包、安装系统依赖、启动qbot。解压后，可以直接在python3.8/3.9环境下，``python main.py`` 启动程序，根据提示安装缺省的python库，如：
```bash
pip install baostock tables -i https://pypi.tuna.tsinghua.edu.cn/simple/ --trusted-host pypi.tuna.tsinghua.edu.cn
```

1. 解压安装包，例如: qbot-pro_code_v1.3.7.tar.gz

```bash
tar -zxvf qbot-pro_code_v1.3.7.tar.gz
```

2. 安装系统依赖

可设置pip安装源，提高下载速度：
```bash
pip config set global.index-url https://pypi.tuna.tsinghua.edu.cn/simple
```

```bash
cd qbot_code/
pip install -r dev/requirements.txt
```

> 备注：wxPython、Ta-Lib 需要手动安装; Mac系统在安装之前需要手动安装tables库的依赖hdf5，以及pythonw.<b> (方法见下方《常见问题》)</b>

3. 启动软件
```bash
python main.py
```
> 备注： Mac系统用 ``pythonw main.py``

### 常见问题：

- F1: <b>wxPython、Ta-Lib 需要手动安装，pip wheel 在 dev/ 路径下。</b>
https://github.com/UFund-Me/Qbot/issues/76

<table><tbody><tr><td>
Recommended:

|       | python | wxpython |                          eg                            | 
|   --  |   --   |   --     |                          --                            |
| linux |   3.8  |   4.2.0  |  wxPython-4.2.0-cp38-cp38-linux_x86_64.whl             |
| linux |   3.9  |   4.2.0  |  wxPython-4.2.0-cp39-cp39-linux_x86_64.whl             |
|  mac  |   3.8  |   4.2.0  |  wxPython-4.2.1-cp38-cp38-macosx_11_0_universal2.whl   |
|  mac  |   3.9  |   4.2.0  |  wxPython-4.2.1-cp39-cp39-macosx_10_10_universal2.whl  |
|  win  |   3.8  |   4.2.0  |  wxPython-4.2.1-cp38-cp38-win_amd64.whl                | 


<h4>参考文档：</h4>
- wxPython https://wxpython.org/Phoenix/snapshot-builds/  https://pypi.org/project/wxPython/#files 

### wxPython
- linux: python3.8 -m pip install dev/wxPython-4.2.0-cp38-cp38-linux_x86_64.whl
         pip install -U -f https://extras.wxpython.org/wxPython4/extras/linux/gtk3/ubuntu-20.04/ wxPython
         pip install -U -f https://extras.wxpython.org/wxPython4/extras/linux/gtk3/ubuntu-18.04/ wxPython
- win: python3.8 -m pip install dev/wxPython-4.2.1-cp38-cp38-win_amd64.whl
- mac: brew install wxpython

### Ta-Lib 
https://github.com/cgohlke/talib-build/releases
- linux: python3.8 -m pip install dev/TA_Lib-0.4.28-cp38-cp38-linux_x86_64.whl
- win: python3.8 -m pip pip install dev/TA_Lib-0.4.21-cp38-cp38-win_amd64.whl
- mac: 
      ``which brew || /usr/bin/ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)``
      brew install ta-lib
      pip install ta-lib

</td></tr></tbody></table>

- F2: <b>Mac系统在安装之前需要手动安装tables库的依赖hdf5，以及pythonw</b>

https://github.com/UFund-Me/Qbot/issues/11 

```bash
brew install hdf5
brew install c-blosc
export HDF5_DIR=/opt/homebrew/opt/hdf5 
export BLOSC_DIR=/opt/homebrew/opt/c-blosc
```

<b>----> 欢迎继续记录，提PR或issue。</b>

[常见问题](FQA.md)