#include "CustomMdSpi.h"
#include "TickToKlineHelper.h"
#include <fstream>
#include <iostream>
#include <unordered_map>

// ---- ȫֲ ---- //
extern CThostFtdcMdApi *g_pMdUserApi;            // ָ
extern char gMdFrontAddr[];                      // ģǰõַ
extern TThostFtdcBrokerIDType gBrokerID;         // ģ⾭̴
extern TThostFtdcInvestorIDType gInvesterID;     // Ͷ˻
extern TThostFtdcPasswordType gInvesterPassword; // Ͷ
extern char
    *g_pInstrumentID[];   // ԼбСϡ֣ѡһ
extern int instrumentNum; // Լ
extern std::unordered_map<std::string, TickToKlineHelper>
    g_KlineHash; // kߴ洢

// ---- ctp_apiص ---- //
// ӳɹӦ
void CustomMdSpi::OnFrontConnected() {
  std::cout << "=====ӳɹ=====" << std::endl;
  // ʼ¼
  CThostFtdcReqUserLoginField loginReq;
  memset(&loginReq, 0, sizeof(loginReq));
  strcpy(loginReq.BrokerID, gBrokerID);
  strcpy(loginReq.UserID, gInvesterID);
  strcpy(loginReq.Password, gInvesterPassword);
  static int requestID = 0; // 
  int rt = g_pMdUserApi->ReqUserLogin(&loginReq, requestID);
  if (!rt)
    std::cout << ">>>>>>͵¼ɹ" << std::endl;
  else
    std::cerr << "--->>>͵¼ʧ" << std::endl;
}

// Ͽ֪ͨ
void CustomMdSpi::OnFrontDisconnected(int nReason) {
  std::cerr << "=====ӶϿ=====" << std::endl;
  std::cerr << "룺 " << nReason << std::endl;
}

// ʱ
void CustomMdSpi::OnHeartBeatWarning(int nTimeLapse) {
  std::cerr << "=====ʱ=====" << std::endl;
  std::cerr << "ϴʱ䣺 " << nTimeLapse << std::endl;
}

// ¼Ӧ
void CustomMdSpi::OnRspUserLogin(CThostFtdcRspUserLoginField *pRspUserLogin,
                                 CThostFtdcRspInfoField *pRspInfo,
                                 int nRequestID, bool bIsLast) {
  bool bResult = pRspInfo && (pRspInfo->ErrorID != 0);
  if (!bResult) {
    std::cout << "=====˻¼ɹ=====" << std::endl;
    std::cout << "գ " << pRspUserLogin->TradingDay << std::endl;
    std::cout << "¼ʱ䣺 " << pRspUserLogin->LoginTime << std::endl;
    std::cout << "̣ " << pRspUserLogin->BrokerID << std::endl;
    std::cout << "ʻ " << pRspUserLogin->UserID << std::endl;
    // ʼ
    int rt = g_pMdUserApi->SubscribeMarketData(g_pInstrumentID, instrumentNum);
    if (!rt)
      std::cout << ">>>>>>Ͷɹ" << std::endl;
    else
      std::cerr << "--->>>Ͷʧ" << std::endl;
  } else
    std::cerr << "ش--->>> ErrorID=" << pRspInfo->ErrorID
              << ", ErrorMsg=" << pRspInfo->ErrorMsg << std::endl;
}

// ǳӦ
void CustomMdSpi::OnRspUserLogout(CThostFtdcUserLogoutField *pUserLogout,
                                  CThostFtdcRspInfoField *pRspInfo,
                                  int nRequestID, bool bIsLast) {
  bool bResult = pRspInfo && (pRspInfo->ErrorID != 0);
  if (!bResult) {
    std::cout << "=====˻ǳɹ=====" << std::endl;
    std::cout << "̣ " << pUserLogout->BrokerID << std::endl;
    std::cout << "ʻ " << pUserLogout->UserID << std::endl;
  } else
    std::cerr << "ش--->>> ErrorID=" << pRspInfo->ErrorID
              << ", ErrorMsg=" << pRspInfo->ErrorMsg << std::endl;
}

// ֪ͨ
void CustomMdSpi::OnRspError(CThostFtdcRspInfoField *pRspInfo, int nRequestID,
                             bool bIsLast) {
  bool bResult = pRspInfo && (pRspInfo->ErrorID != 0);
  if (bResult)
    std::cerr << "ش--->>> ErrorID=" << pRspInfo->ErrorID
              << ", ErrorMsg=" << pRspInfo->ErrorMsg << std::endl;
}

// Ӧ
void CustomMdSpi::OnRspSubMarketData(
    CThostFtdcSpecificInstrumentField *pSpecificInstrument,
    CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {
  bool bResult = pRspInfo && (pRspInfo->ErrorID != 0);
  if (!bResult) {
    std::cout << "=====ɹ=====" << std::endl;
    std::cout << "Լ룺 " << pSpecificInstrument->InstrumentID
              << std::endl;
    // Ҫļݿ⣬ﴴͷ,ͬĺԼ洢
    char filePath[100] = {'\0'};
    sprintf(filePath, "%s_market_data.csv", pSpecificInstrument->InstrumentID);
    std::ofstream outFile;
    outFile.open(filePath, std::ios::out); // ¿ļ
    outFile << "Լ"
            << ","
            << "ʱ"
            << ","
            << "¼"
            << ","
            << "ɽ"
            << ","
            << "һ"
            << ","
            << "һ"
            << ","
            << "һ"
            << ","
            << "һ"
            << ","
            << "ֲ"
            << ","
            << "" << std::endl;
    outFile.close();
  } else
    std::cerr << "ش--->>> ErrorID=" << pRspInfo->ErrorID
              << ", ErrorMsg=" << pRspInfo->ErrorMsg << std::endl;
}

// ȡӦ
void CustomMdSpi::OnRspUnSubMarketData(
    CThostFtdcSpecificInstrumentField *pSpecificInstrument,
    CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {
  bool bResult = pRspInfo && (pRspInfo->ErrorID != 0);
  if (!bResult) {
    std::cout << "=====ȡɹ=====" << std::endl;
    std::cout << "Լ룺 " << pSpecificInstrument->InstrumentID
              << std::endl;
  } else
    std::cerr << "ش--->>> ErrorID=" << pRspInfo->ErrorID
              << ", ErrorMsg=" << pRspInfo->ErrorMsg << std::endl;
}

// ѯӦ
void CustomMdSpi::OnRspSubForQuoteRsp(
    CThostFtdcSpecificInstrumentField *pSpecificInstrument,
    CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {
  bool bResult = pRspInfo && (pRspInfo->ErrorID != 0);
  if (!bResult) {
    std::cout << "=====ѯ۳ɹ=====" << std::endl;
    std::cout << "Լ룺 " << pSpecificInstrument->InstrumentID
              << std::endl;
  } else
    std::cerr << "ش--->>> ErrorID=" << pRspInfo->ErrorID
              << ", ErrorMsg=" << pRspInfo->ErrorMsg << std::endl;
}

// ȡѯӦ
void CustomMdSpi::OnRspUnSubForQuoteRsp(
    CThostFtdcSpecificInstrumentField *pSpecificInstrument,
    CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {
  bool bResult = pRspInfo && (pRspInfo->ErrorID != 0);
  if (!bResult) {
    std::cout << "=====ȡѯ۳ɹ=====" << std::endl;
    std::cout << "Լ룺 " << pSpecificInstrument->InstrumentID
              << std::endl;
  } else
    std::cerr << "ش--->>> ErrorID=" << pRspInfo->ErrorID
              << ", ErrorMsg=" << pRspInfo->ErrorMsg << std::endl;
}

// ֪ͨ
void CustomMdSpi::OnRtnDepthMarketData(
    CThostFtdcDepthMarketDataField *pDepthMarketData) {
  // ӡ飬ֶν϶࣬ȡ
  std::cout << "==========" << std::endl;
  std::cout << "գ " << pDepthMarketData->TradingDay << std::endl;
  std::cout << "룺 " << pDepthMarketData->ExchangeID << std::endl;
  std::cout << "Լ룺 " << pDepthMarketData->InstrumentID << std::endl;
  std::cout << "ԼڽĴ룺 " << pDepthMarketData->ExchangeInstID
            << std::endl;
  std::cout << "¼ۣ " << pDepthMarketData->LastPrice << std::endl;
  std::cout << " " << pDepthMarketData->Volume << std::endl;
  // ֻȡĳһԼ飬tickشļݿ
  char filePath[100] = {'\0'};
  sprintf(filePath, "%s_market_data.csv", pDepthMarketData->InstrumentID);
  std::ofstream outFile;
  outFile.open(filePath, std::ios::app); // ļ׷д
  outFile << pDepthMarketData->InstrumentID << ","
          << pDepthMarketData->UpdateTime << "."
          << pDepthMarketData->UpdateMillisec << ","
          << pDepthMarketData->LastPrice << "," << pDepthMarketData->Volume
          << "," << pDepthMarketData->BidPrice1 << ","
          << pDepthMarketData->BidVolume1 << "," << pDepthMarketData->AskPrice1
          << "," << pDepthMarketData->AskVolume1 << ","
          << pDepthMarketData->OpenInterest << "," << pDepthMarketData->Turnover
          << std::endl;
  outFile.close();

  // ʵʱk
  std::string instrumentKey = std::string(pDepthMarketData->InstrumentID);
  if (g_KlineHash.find(instrumentKey) == g_KlineHash.end())
    g_KlineHash[instrumentKey] = TickToKlineHelper();
  g_KlineHash[instrumentKey].KLineFromRealtimeData(pDepthMarketData);

  // ȡ
  // int rt = g_pMdUserApi->UnSubscribeMarketData(g_pInstrumentID,
  // instrumentNum); if (!rt) 	std::cout << ">>>>>>ȡɹ" <<
  // std::endl; else 	std::cerr << "--->>>ȡʧ" <<
  // std::endl;
}

// ѯ֪ͨ
void CustomMdSpi::OnRtnForQuoteRsp(CThostFtdcForQuoteRspField *pForQuoteRsp) {
  // ѯ۽
  std::cout << "=====ѯ۽=====" << std::endl;
  std::cout << "գ " << pForQuoteRsp->TradingDay << std::endl;
  std::cout << "룺 " << pForQuoteRsp->ExchangeID << std::endl;
  std::cout << "Լ룺 " << pForQuoteRsp->InstrumentID << std::endl;
  std::cout << "ѯ۱ţ " << pForQuoteRsp->ForQuoteSysID << std::endl;
}