#include "CustomTradeSpi.h"
#include "StrategyTrade.h"
#include <chrono>
#include <iostream>
#include <thread>
#include <time.h>

// ---- ȫֲ ---- //
extern TThostFtdcBrokerIDType gBrokerID;                // ģ⾭̴
extern TThostFtdcInvestorIDType gInvesterID;            // Ͷ˻
extern TThostFtdcPasswordType gInvesterPassword;        // Ͷ
extern CThostFtdcTraderApi *g_pTradeUserApi;            // ָ
extern char gTradeFrontAddr[];                          // ģ⽻ǰõַ
extern TThostFtdcInstrumentIDType g_pTradeInstrumentID; // ׵ĺԼ
extern TThostFtdcDirectionType gTradeDirection;         // 
extern TThostFtdcPriceType gLimitPrice;                 // ׼۸

// Ự
TThostFtdcFrontIDType trade_front_id; //ǰñ
TThostFtdcSessionIDType session_id;   //Ự
TThostFtdcOrderRefType order_ref;     //
time_t lOrderTime;
time_t lOrderOkTime;

void CustomTradeSpi::OnFrontConnected() {
  std::cout << "=====ӳɹ=====" << std::endl;
  // ʼ¼
  reqUserLogin();
}

void CustomTradeSpi::OnRspUserLogin(CThostFtdcRspUserLoginField *pRspUserLogin,
                                    CThostFtdcRspInfoField *pRspInfo,
                                    int nRequestID, bool bIsLast) {
  if (!isErrorRspInfo(pRspInfo)) {
    std::cout << "=====˻¼ɹ=====" << std::endl;
    loginFlag = true;
    std::cout << "գ " << pRspUserLogin->TradingDay << std::endl;
    std::cout << "¼ʱ䣺 " << pRspUserLogin->LoginTime << std::endl;
    std::cout << "̣ " << pRspUserLogin->BrokerID << std::endl;
    std::cout << "ʻ " << pRspUserLogin->UserID << std::endl;
    // Ự
    trade_front_id = pRspUserLogin->FrontID;
    session_id = pRspUserLogin->SessionID;
    strcpy(order_ref, pRspUserLogin->MaxOrderRef);

    // Ͷ߽ȷ
    reqSettlementInfoConfirm();
  }
}

void CustomTradeSpi::OnRspError(CThostFtdcRspInfoField *pRspInfo,
                                int nRequestID, bool bIsLast) {
  isErrorRspInfo(pRspInfo);
}

void CustomTradeSpi::OnFrontDisconnected(int nReason) {
  std::cerr << "=====ӶϿ=====" << std::endl;
  std::cerr << "룺 " << nReason << std::endl;
}

void CustomTradeSpi::OnHeartBeatWarning(int nTimeLapse) {
  std::cerr << "=====ʱ=====" << std::endl;
  std::cerr << "ϴʱ䣺 " << nTimeLapse << std::endl;
}

void CustomTradeSpi::OnRspUserLogout(CThostFtdcUserLogoutField *pUserLogout,
                                     CThostFtdcRspInfoField *pRspInfo,
                                     int nRequestID, bool bIsLast) {
  if (!isErrorRspInfo(pRspInfo)) {
    loginFlag = false; // ǳͲٽ
    std::cout << "=====˻ǳɹ=====" << std::endl;
    std::cout << "̣ " << pUserLogout->BrokerID << std::endl;
    std::cout << "ʻ " << pUserLogout->UserID << std::endl;
  }
}

void CustomTradeSpi::OnRspSettlementInfoConfirm(
    CThostFtdcSettlementInfoConfirmField *pSettlementInfoConfirm,
    CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {
  if (!isErrorRspInfo(pRspInfo)) {
    std::cout << "=====Ͷ߽ȷϳɹ=====" << std::endl;
    std::cout << "ȷڣ " << pSettlementInfoConfirm->ConfirmDate
              << std::endl;
    std::cout << "ȷʱ䣺 " << pSettlementInfoConfirm->ConfirmTime
              << std::endl;
    // ѯԼ
    reqQueryInstrument();
  }
}

void CustomTradeSpi::OnRspQryInstrument(CThostFtdcInstrumentField *pInstrument,
                                        CThostFtdcRspInfoField *pRspInfo,
                                        int nRequestID, bool bIsLast) {
  if (!isErrorRspInfo(pRspInfo)) {
    std::cout << "=====ѯԼɹ=====" << std::endl;
    std::cout << "룺 " << pInstrument->ExchangeID << std::endl;
    std::cout << "Լ룺 " << pInstrument->InstrumentID << std::endl;
    std::cout << "ԼڽĴ룺 " << pInstrument->ExchangeInstID
              << std::endl;
    std::cout << "ִмۣ " << pInstrument->StrikePrice << std::endl;
    std::cout << "գ " << pInstrument->EndDelivDate << std::endl;
    std::cout << "ǰ״̬ " << pInstrument->IsTrading << std::endl;
    // ѯͶʽ˻
    reqQueryTradingAccount();
  }
}

void CustomTradeSpi::OnRspQryTradingAccount(
    CThostFtdcTradingAccountField *pTradingAccount,
    CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {
  if (!isErrorRspInfo(pRspInfo)) {
    std::cout << "=====ѯͶʽ˻ɹ=====" << std::endl;
    std::cout << "Ͷ˺ţ " << pTradingAccount->AccountID << std::endl;
    std::cout << "ʽ " << pTradingAccount->Available << std::endl;
    std::cout << "ȡʽ " << pTradingAccount->WithdrawQuota << std::endl;
    std::cout << "ǰ֤: " << pTradingAccount->CurrMargin << std::endl;
    std::cout << "ƽӯ " << pTradingAccount->CloseProfit << std::endl;
    // ѯͶֲ߳
    reqQueryInvestorPosition();
  }
}

void CustomTradeSpi::OnRspQryInvestorPosition(
    CThostFtdcInvestorPositionField *pInvestorPosition,
    CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {
  if (!isErrorRspInfo(pRspInfo)) {
    std::cout << "=====ѯͶֲֳ߳ɹ=====" << std::endl;
    if (pInvestorPosition) {
      std::cout << "Լ룺 " << pInvestorPosition->InstrumentID
                << std::endl;
      std::cout << "ּ۸ " << pInvestorPosition->OpenAmount << std::endl;
      std::cout << " " << pInvestorPosition->OpenVolume << std::endl;
      std::cout << "ַ " << pInvestorPosition->PosiDirection
                << std::endl;
      std::cout << "ռñ֤" << pInvestorPosition->UseMargin << std::endl;
    } else
      std::cout << "----->úԼδֲ" << std::endl;

    // ¼һӿڣ˴ǰ˳ִУ
    /*if (loginFlag)
            reqOrderInsert();*/
    // if (loginFlag)
    //	reqOrderInsertWithParams(g_pTradeInstrumentID, gLimitPrice, 1,
    // gTradeDirection); // Զһʽ

    // Խ
    std::cout << "=====ʼԽ=====" << std::endl;
    while (loginFlag)
      StrategyCheckAndTrade(g_pTradeInstrumentID, this);
  }
}

void CustomTradeSpi::OnRspOrderInsert(CThostFtdcInputOrderField *pInputOrder,
                                      CThostFtdcRspInfoField *pRspInfo,
                                      int nRequestID, bool bIsLast) {
  if (!isErrorRspInfo(pRspInfo)) {
    std::cout << "=====¼ɹ=====" << std::endl;
    std::cout << "Լ룺 " << pInputOrder->InstrumentID << std::endl;
    std::cout << "۸ " << pInputOrder->LimitPrice << std::endl;
    std::cout << " " << pInputOrder->VolumeTotalOriginal << std::endl;
    std::cout << "ַ " << pInputOrder->Direction << std::endl;
  }
}

void CustomTradeSpi::OnRspOrderAction(
    CThostFtdcInputOrderActionField *pInputOrderAction,
    CThostFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast) {
  if (!isErrorRspInfo(pRspInfo)) {
    std::cout << "=====ɹ=====" << std::endl;
    std::cout << "Լ룺 " << pInputOrderAction->InstrumentID << std::endl;
    std::cout << "־ " << pInputOrderAction->ActionFlag;
  }
}

void CustomTradeSpi::OnRtnOrder(CThostFtdcOrderField *pOrder) {
  char str[10];
  sprintf(str, "%d", pOrder->OrderSubmitStatus);
  int orderState = atoi(str) - 48; //״̬0=Ѿύ3=Ѿ

  std::cout << "=====յӦ=====" << std::endl;

  if (isMyOrder(pOrder)) {
    if (isTradingOrder(pOrder)) {
      std::cout << "--->>> ȴɽУ" << std::endl;
      // reqOrderAction(pOrder); // Գ
      // reqUserLogout(); // ǳ
    } else if (pOrder->OrderStatus == THOST_FTDC_OST_Canceled)
      std::cout << "--->>> ɹ" << std::endl;
  }
}

void CustomTradeSpi::OnRtnTrade(CThostFtdcTradeField *pTrade) {
  std::cout << "=====ɹɽ=====" << std::endl;
  std::cout << "ɽʱ䣺 " << pTrade->TradeTime << std::endl;
  std::cout << "Լ룺 " << pTrade->InstrumentID << std::endl;
  std::cout << "ɽ۸ " << pTrade->Price << std::endl;
  std::cout << "ɽ " << pTrade->Volume << std::endl;
  std::cout << "ƽַ " << pTrade->Direction << std::endl;
}

bool CustomTradeSpi::isErrorRspInfo(CThostFtdcRspInfoField *pRspInfo) {
  bool bResult = pRspInfo && (pRspInfo->ErrorID != 0);
  if (bResult)
    std::cerr << "ش--->>> ErrorID=" << pRspInfo->ErrorID
              << ", ErrorMsg=" << pRspInfo->ErrorMsg << std::endl;
  return bResult;
}

void CustomTradeSpi::reqUserLogin() {
  CThostFtdcReqUserLoginField loginReq;
  memset(&loginReq, 0, sizeof(loginReq));
  strcpy(loginReq.BrokerID, gBrokerID);
  strcpy(loginReq.UserID, gInvesterID);
  strcpy(loginReq.Password, gInvesterPassword);
  static int requestID = 0; // 
  int rt = g_pTradeUserApi->ReqUserLogin(&loginReq, requestID);
  if (!rt)
    std::cout << ">>>>>>͵¼ɹ" << std::endl;
  else
    std::cerr << "--->>>͵¼ʧ" << std::endl;
}

void CustomTradeSpi::reqUserLogout() {
  CThostFtdcUserLogoutField logoutReq;
  memset(&logoutReq, 0, sizeof(logoutReq));
  strcpy(logoutReq.BrokerID, gBrokerID);
  strcpy(logoutReq.UserID, gInvesterID);
  static int requestID = 0; // 
  int rt = g_pTradeUserApi->ReqUserLogout(&logoutReq, requestID);
  if (!rt)
    std::cout << ">>>>>>͵ǳɹ" << std::endl;
  else
    std::cerr << "--->>>͵ǳʧ" << std::endl;
}

void CustomTradeSpi::reqSettlementInfoConfirm() {
  CThostFtdcSettlementInfoConfirmField settlementConfirmReq;
  memset(&settlementConfirmReq, 0, sizeof(settlementConfirmReq));
  strcpy(settlementConfirmReq.BrokerID, gBrokerID);
  strcpy(settlementConfirmReq.InvestorID, gInvesterID);
  static int requestID = 0; // 
  int rt = g_pTradeUserApi->ReqSettlementInfoConfirm(&settlementConfirmReq,
                                                     requestID);
  if (!rt)
    std::cout << ">>>>>>Ͷ߽ȷɹ" << std::endl;
  else
    std::cerr << "--->>>Ͷ߽ȷʧ" << std::endl;
}

void CustomTradeSpi::reqQueryInstrument() {
  CThostFtdcQryInstrumentField instrumentReq;
  memset(&instrumentReq, 0, sizeof(instrumentReq));
  strcpy(instrumentReq.InstrumentID, g_pTradeInstrumentID);
  static int requestID = 0; // 
  int rt = g_pTradeUserApi->ReqQryInstrument(&instrumentReq, requestID);
  if (!rt)
    std::cout << ">>>>>>ͺԼѯɹ" << std::endl;
  else
    std::cerr << "--->>>ͺԼѯʧ" << std::endl;
}

void CustomTradeSpi::reqQueryTradingAccount() {
  CThostFtdcQryTradingAccountField tradingAccountReq;
  memset(&tradingAccountReq, 0, sizeof(tradingAccountReq));
  strcpy(tradingAccountReq.BrokerID, gBrokerID);
  strcpy(tradingAccountReq.InvestorID, gInvesterID);
  static int requestID = 0; // 
  std::this_thread::sleep_for(
      std::chrono::milliseconds(700)); // ʱҪͣһܲѯɹ
  int rt = g_pTradeUserApi->ReqQryTradingAccount(&tradingAccountReq, requestID);
  if (!rt)
    std::cout << ">>>>>>Ͷʽ˻ѯɹ" << std::endl;
  else
    std::cerr << "--->>>Ͷʽ˻ѯʧ" << std::endl;
}

void CustomTradeSpi::reqQueryInvestorPosition() {
  CThostFtdcQryInvestorPositionField postionReq;
  memset(&postionReq, 0, sizeof(postionReq));
  strcpy(postionReq.BrokerID, gBrokerID);
  strcpy(postionReq.InvestorID, gInvesterID);
  strcpy(postionReq.InstrumentID, g_pTradeInstrumentID);
  static int requestID = 0; // 
  std::this_thread::sleep_for(
      std::chrono::milliseconds(700)); // ʱҪͣһܲѯɹ
  int rt = g_pTradeUserApi->ReqQryInvestorPosition(&postionReq, requestID);
  if (!rt)
    std::cout << ">>>>>>Ͷֲֲ߳ѯɹ" << std::endl;
  else
    std::cerr << "--->>>Ͷֲֲ߳ѯʧ" << std::endl;
}

void CustomTradeSpi::reqOrderInsert() {
  CThostFtdcInputOrderField orderInsertReq;
  memset(&orderInsertReq, 0, sizeof(orderInsertReq));
  ///͹˾
  strcpy(orderInsertReq.BrokerID, gBrokerID);
  ///Ͷߴ
  strcpy(orderInsertReq.InvestorID, gInvesterID);
  ///Լ
  strcpy(orderInsertReq.InstrumentID, g_pTradeInstrumentID);
  ///
  strcpy(orderInsertReq.OrderRef, order_ref);
  ///۸: ޼
  orderInsertReq.OrderPriceType = THOST_FTDC_OPT_LimitPrice;
  ///:
  orderInsertReq.Direction = gTradeDirection;
  ///Ͽƽ־: 
  orderInsertReq.CombOffsetFlag[0] = THOST_FTDC_OF_Open;
  ///Ͷױ־
  orderInsertReq.CombHedgeFlag[0] = THOST_FTDC_HF_Speculation;
  ///۸
  orderInsertReq.LimitPrice = gLimitPrice;
  ///1
  orderInsertReq.VolumeTotalOriginal = 1;
  ///Ч: Ч
  orderInsertReq.TimeCondition = THOST_FTDC_TC_GFD;
  ///ɽ: κ
  orderInsertReq.VolumeCondition = THOST_FTDC_VC_AV;
  ///Сɽ: 1
  orderInsertReq.MinVolume = 1;
  ///: 
  orderInsertReq.ContingentCondition = THOST_FTDC_CC_Immediately;
  ///ǿƽԭ: ǿƽ
  orderInsertReq.ForceCloseReason = THOST_FTDC_FCC_NotForceClose;
  ///Զ־: 
  orderInsertReq.IsAutoSuspend = 0;
  ///ûǿ־: 
  orderInsertReq.UserForceClose = 0;

  static int requestID = 0; // 
  int rt = g_pTradeUserApi->ReqOrderInsert(&orderInsertReq, ++requestID);
  if (!rt)
    std::cout << ">>>>>>ͱ¼ɹ" << std::endl;
  else
    std::cerr << "--->>>ͱ¼ʧ" << std::endl;
}

void CustomTradeSpi::reqOrderInsert(TThostFtdcInstrumentIDType instrumentID,
                                    TThostFtdcPriceType price,
                                    TThostFtdcVolumeType volume,
                                    TThostFtdcDirectionType direction) {
  CThostFtdcInputOrderField orderInsertReq;
  memset(&orderInsertReq, 0, sizeof(orderInsertReq));
  ///͹˾
  strcpy(orderInsertReq.BrokerID, gBrokerID);
  ///Ͷߴ
  strcpy(orderInsertReq.InvestorID, gInvesterID);
  ///Լ
  strcpy(orderInsertReq.InstrumentID, instrumentID);
  ///
  strcpy(orderInsertReq.OrderRef, order_ref);
  ///۸: ޼
  orderInsertReq.OrderPriceType = THOST_FTDC_OPT_LimitPrice;
  ///:
  orderInsertReq.Direction = direction;
  ///Ͽƽ־: 
  orderInsertReq.CombOffsetFlag[0] = THOST_FTDC_OF_Open;
  ///Ͷױ־
  orderInsertReq.CombHedgeFlag[0] = THOST_FTDC_HF_Speculation;
  ///۸
  orderInsertReq.LimitPrice = price;
  ///1
  orderInsertReq.VolumeTotalOriginal = volume;
  ///Ч: Ч
  orderInsertReq.TimeCondition = THOST_FTDC_TC_GFD;
  ///ɽ: κ
  orderInsertReq.VolumeCondition = THOST_FTDC_VC_AV;
  ///Сɽ: 1
  orderInsertReq.MinVolume = 1;
  ///: 
  orderInsertReq.ContingentCondition = THOST_FTDC_CC_Immediately;
  ///ǿƽԭ: ǿƽ
  orderInsertReq.ForceCloseReason = THOST_FTDC_FCC_NotForceClose;
  ///Զ־: 
  orderInsertReq.IsAutoSuspend = 0;
  ///ûǿ־: 
  orderInsertReq.UserForceClose = 0;

  static int requestID = 0; // 
  int rt = g_pTradeUserApi->ReqOrderInsert(&orderInsertReq, ++requestID);
  if (!rt)
    std::cout << ">>>>>>ͱ¼ɹ" << std::endl;
  else
    std::cerr << "--->>>ͱ¼ʧ" << std::endl;
}

void CustomTradeSpi::reqOrderAction(CThostFtdcOrderField *pOrder) {
  static bool orderActionSentFlag = false; // Ƿ˱
  if (orderActionSentFlag)
    return;

  CThostFtdcInputOrderActionField orderActionReq;
  memset(&orderActionReq, 0, sizeof(orderActionReq));
  ///͹˾
  strcpy(orderActionReq.BrokerID, pOrder->BrokerID);
  ///Ͷߴ
  strcpy(orderActionReq.InvestorID, pOrder->InvestorID);
  ///
  //	TThostFtdcOrderActionRefType	OrderActionRef;
  ///
  strcpy(orderActionReq.OrderRef, pOrder->OrderRef);
  ///
  //	TThostFtdcRequestIDType	RequestID;
  ///ǰñ
  orderActionReq.FrontID = trade_front_id;
  ///Ự
  orderActionReq.SessionID = session_id;
  ///
  //	TThostFtdcExchangeIDType	ExchangeID;
  ///
  //	TThostFtdcOrderSysIDType	OrderSysID;
  ///־
  orderActionReq.ActionFlag = THOST_FTDC_AF_Delete;
  ///۸
  //	TThostFtdcPriceType	LimitPrice;
  ///仯
  //	TThostFtdcVolumeType	VolumeChange;
  ///û
  //	TThostFtdcUserIDType	UserID;
  ///Լ
  strcpy(orderActionReq.InstrumentID, pOrder->InstrumentID);
  static int requestID = 0; // 
  int rt = g_pTradeUserApi->ReqOrderAction(&orderActionReq, ++requestID);
  if (!rt)
    std::cout << ">>>>>>ͱɹ" << std::endl;
  else
    std::cerr << "--->>>ͱʧ" << std::endl;
  orderActionSentFlag = true;
}

bool CustomTradeSpi::isMyOrder(CThostFtdcOrderField *pOrder) {
  return ((pOrder->FrontID == trade_front_id) &&
          (pOrder->SessionID == session_id) &&
          (strcmp(pOrder->OrderRef, order_ref) == 0));
}

bool CustomTradeSpi::isTradingOrder(CThostFtdcOrderField *pOrder) {
  return ((pOrder->OrderStatus != THOST_FTDC_OST_PartTradedNotQueueing) &&
          (pOrder->OrderStatus != THOST_FTDC_OST_Canceled) &&
          (pOrder->OrderStatus != THOST_FTDC_OST_AllTraded));
}