#include "StrategyTrade.h"
#include "CustomTradeSpi.h"
#include <mutex>
#include <string>
#include <thread>
#include <unordered_map>
#include <vector>

extern std::unordered_map<std::string, TickToKlineHelper> g_KlineHash;

// ̻߳
std::mutex marketDataMutex;

void StrategyCheckAndTrade(TThostFtdcInstrumentIDType instrumentID,
                           CustomTradeSpi *customTradeSpi) {
  // 
  std::lock_guard<std::mutex> lk(marketDataMutex);
  TickToKlineHelper tickToKlineObject =
      g_KlineHash.at(std::string(instrumentID));
  // 
  std::vector<double> priceVec = tickToKlineObject.m_priceVec;
  if (priceVec.size() >= 3) {
    int len = priceVec.size();
    // Ǿ򿪲,֮,ʱһ۸µ
    if (priceVec[len - 1] > priceVec[len - 2] &&
        priceVec[len - 2] > priceVec[len - 3])
      customTradeSpi->reqOrderInsert(instrumentID, priceVec[len - 1], 1,
                                     THOST_FTDC_D_Buy);
    else if (priceVec[len - 1] < priceVec[len - 2] &&
             priceVec[len - 2] < priceVec[len - 3])
      customTradeSpi->reqOrderInsert(instrumentID, priceVec[len - 1], 1,
                                     THOST_FTDC_D_Buy);
  }
}
