#include "TickToKlineHelper.h"
#include "CTP_API/ThostFtdcUserApiStruct.h"
#include <algorithm>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>

const int kDataLineNum = 2 * 60; // 1k(ĩβһӵȥ)

void TickToKlineHelper::KLineFromLocalData(const std::string &sFilePath,
                                           const std::string &dFilePath) {
  // 
  m_priceVec.clear();
  m_volumeVec.clear();
  m_KLineDataArray.clear();

  std::cout << "ʼתtickk..." << std::endl;
  // Ĭ϶ȡtickݱ4ֶΣԼ롢ʱ䡢¼ۡɽ
  std::ifstream srcInFile;
  std::ofstream dstOutFile;
  srcInFile.open(sFilePath, std::ios::in);
  dstOutFile.open(dFilePath, std::ios::out);
  dstOutFile << "̼" << ',' << "߼" << ',' << "ͼ" << ','
             << "̼" << ',' << "ɽ" << std::endl;

  // һļһ߼kݣ1kÿζȡ60 * 2 = 120
  std::string lineStr;
  bool isFirstLine = true;
  while (std::getline(srcInFile, lineStr)) {
    if (isFirstLine) {
      // һбͷ
      isFirstLine = false;
      continue;
    }
    std::istringstream ss(lineStr);
    std::string fieldStr;
    int count = 4;
    while (std::getline(ss, fieldStr, ',')) {
      count--;
      if (count == 1)
        m_priceVec.push_back(std::atof(fieldStr.c_str()));
      else if (count == 0) {
        m_volumeVec.push_back(std::atoi(fieldStr.c_str()));
        break;
      }
    }

    // k

    if (m_priceVec.size() == kDataLineNum) {
      KLineDataType k_line_data;
      k_line_data.open_price = m_priceVec.front();
      k_line_data.high_price =
          *std::max_element(m_priceVec.cbegin(), m_priceVec.cend());
      k_line_data.low_price =
          *std::min_element(m_priceVec.cbegin(), m_priceVec.cend());
      k_line_data.close_price = m_priceVec.back();
      // ɽʵ㷨ǵǰһɽȥȥһһɽ
      k_line_data.volume = m_volumeVec.back() - m_volumeVec.front();
      // m_KLineDataArray.push_back(k_line_data); // ˴Դ浽ڴ

      dstOutFile << k_line_data.open_price << ',' << k_line_data.high_price
                 << ',' << k_line_data.low_price << ','
                 << k_line_data.close_price << ',' << k_line_data.volume
                 << std::endl;

      m_priceVec.clear();
      m_volumeVec.clear();
    }
  }

  srcInFile.close();
  dstOutFile.close();

  std::cout << "kɳɹ" << std::endl;
}

void TickToKlineHelper::KLineFromRealtimeData(
    CThostFtdcDepthMarketDataField *pDepthMarketData) {
  m_priceVec.push_back(pDepthMarketData->LastPrice);
  m_volumeVec.push_back(pDepthMarketData->Volume);
  if (m_priceVec.size() == kDataLineNum) {
    KLineDataType k_line_data;
    k_line_data.open_price = m_priceVec.front();
    k_line_data.high_price =
        *std::max_element(m_priceVec.cbegin(), m_priceVec.cend());
    k_line_data.low_price =
        *std::min_element(m_priceVec.cbegin(), m_priceVec.cend());
    k_line_data.close_price = m_priceVec.back();
    // ɽʵ㷨ǵǰһɽȥȥһһɽ
    k_line_data.volume = m_volumeVec.back() - m_volumeVec.front();
    m_KLineDataArray.push_back(k_line_data); // ˴Դ浽ڴ

    m_priceVec.clear();
    m_volumeVec.clear();
  }
}
