# coding=utf-8
T = dict()
T['TE_RESUME'] = 'int'  # 流重传方式
TERT_RESTART = 0  # 从本交易日开始重传
TERT_RESUME = 1  # 从上次收到的续传
TERT_QUICK = 2  # 只传送登录后的流内容
T['TraderID'] = 'char[21]'  # 交易所交易员代码
T['InvestorID'] = 'char[13]'  # 投资者代码
T['BrokerID'] = 'char[11]'  # 经纪公司代码
T['BrokerAbbr'] = 'char[9]'  # 经纪公司简称
T['BrokerName'] = 'char[81]'  # 经纪公司名称
T['ExchangeInstID'] = 'char[31]'  # 合约在交易所的代码
T['OrderRef'] = 'char[13]'  # 报单引用
T['ParticipantID'] = 'char[11]'  # 会员代码
T['UserID'] = 'char[16]'  # 用户代码
T['Password'] = 'char[41]'  # 密码
T['ClientID'] = 'char[11]'  # 交易编码
T['InstrumentID'] = 'char[31]'  # 合约代码
T['MarketID'] = 'char[31]'  # 市场代码
T['ProductName'] = 'char[21]'  # 产品名称
T['ExchangeID'] = 'char[9]'  # 交易所代码
T['ExchangeName'] = 'char[61]'  # 交易所名称
T['ExchangeAbbr'] = 'char[9]'  # 交易所简称
T['ExchangeFlag'] = 'char[2]'  # 交易所标志
T['MacAddress'] = 'char[21]'  # Mac地址
T['SystemID'] = 'char[21]'  # 系统编号
T['ExchangeProperty'] = 'char'  # 交易所属性
EXP_Normal = '0'  # 正常
EXP_GenOrderByTrade = '1'  # 根据成交生成报单
T['Date'] = 'char[9]'  # 日期
T['Time'] = 'char[9]'  # 时间
T['LongTime'] = 'char[13]'  # 长时间
T['InstrumentName'] = 'char[21]'  # 合约名称
T['SettlementGroupID'] = 'char[9]'  # 结算组代码
T['OrderSysID'] = 'char[21]'  # 报单编号
T['TradeID'] = 'char[21]'  # 成交编号
T['CommandType'] = 'char[65]'  # DB命令类型
T['IPAddress'] = 'char[16]'  # IP地址
T['IPPort'] = 'int'  # IP端口
T['ProductInfo'] = 'char[11]'  # 产品信息
T['ProtocolInfo'] = 'char[11]'  # 协议信息
T['BusinessUnit'] = 'char[21]'  # 业务单元
T['DepositSeqNo'] = 'char[15]'  # 出入金流水号
T['IdentifiedCardNo'] = 'char[51]'  # 证件号码
T['IdCardType'] = 'char'  # 证件类型
ICT_EID = '0'  # 组织机构代码
ICT_IDCard = '1'  # 中国公民身份证
ICT_OfficerIDCard = '2'  # 军官证
ICT_PoliceIDCard = '3'  # 警官证
ICT_SoldierIDCard = '4'  # 士兵证
ICT_HouseholdRegister = '5'  # 户口簿
ICT_Passport = '6'  # 护照
ICT_TaiwanCompatriotIDCard = '7'  # 台胞证
ICT_HomeComingCard = '8'  # 回乡证
ICT_LicenseNo = '9'  # 营业执照号
ICT_TaxNo = 'A'  # 税务登记号/当地纳税ID
ICT_HMMainlandTravelPermit = 'B'  # 港澳居民来往内地通行证
ICT_TwMainlandTravelPermit = 'C'  # 台湾居民来往大陆通行证
ICT_DrivingLicense = 'D'  # 驾照
ICT_SocialID = 'F'  # 当地社保ID
ICT_LocalID = 'G'  # 当地身份证
ICT_BusinessRegistration = 'H'  # 商业登记证
ICT_HKMCIDCard = 'I'  # 港澳永久性居民身份证
ICT_AccountsPermits = 'J'  # 人行开户许可证
ICT_OtherCard = 'x'  # 其他证件
T['OrderLocalID'] = 'char[13]'  # 本地报单编号
T['UserName'] = 'char[81]'  # 用户名称
T['PartyName'] = 'char[81]'  # 参与人名称
T['ErrorMsg'] = 'char[81]'  # 错误信息
T['FieldName'] = 'char[2049]'  # 字段名
T['FieldContent'] = 'char[2049]'  # 字段内容
T['SystemName'] = 'char[41]'  # 系统名称
T['Content'] = 'char[501]'  # 消息正文
T['InvestorRange'] = 'char'  # 投资者范围
IR_All = '1'  # 所有
IR_Group = '2'  # 投资者组
IR_Single = '3'  # 单一投资者
T['DepartmentRange'] = 'char'  # 投资者范围
DR_All = '1'  # 所有
DR_Group = '2'  # 组织架构
DR_Single = '3'  # 单一投资者
T['DataSyncStatus'] = 'char'  # 数据同步状态
DS_Asynchronous = '1'  # 未同步
DS_Synchronizing = '2'  # 同步中
DS_Synchronized = '3'  # 已同步
T['BrokerDataSyncStatus'] = 'char'  # 经纪公司数据同步状态
BDS_Synchronized = '1'  # 已同步
BDS_Synchronizing = '2'  # 同步中
T['ExchangeConnectStatus'] = 'char'  # 交易所连接状态
ECS_NoConnection = '1'  # 没有任何连接
ECS_QryInstrumentSent = '2'  # 已经发出合约查询请求
ECS_GotInformation = '9'  # 已经获取信息
T['TraderConnectStatus'] = 'char'  # 交易所交易员连接状态
TCS_NotConnected = '1'  # 没有任何连接
TCS_Connected = '2'  # 已经连接
TCS_QryInstrumentSent = '3'  # 已经发出合约查询请求
TCS_SubPrivateFlow = '4'  # 订阅私有流
T['FunctionCode'] = 'char'  # 功能代码
FC_DataAsync = '1'  # 数据异步化
FC_ForceUserLogout = '2'  # 强制用户登出
FC_UserPasswordUpdate = '3'  # 变更管理用户口令
FC_BrokerPasswordUpdate = '4'  # 变更经纪公司口令
FC_InvestorPasswordUpdate = '5'  # 变更投资者口令
FC_OrderInsert = '6'  # 报单插入
FC_OrderAction = '7'  # 报单操作
FC_SyncSystemData = '8'  # 同步系统数据
FC_SyncBrokerData = '9'  # 同步经纪公司数据
FC_BachSyncBrokerData = 'A'  # 批量同步经纪公司数据
FC_SuperQuery = 'B'  # 超级查询
FC_ParkedOrderInsert = 'C'  # 预埋报单插入
FC_ParkedOrderAction = 'D'  # 预埋报单操作
FC_SyncOTP = 'E'  # 同步动态令牌
FC_DeleteOrder = 'F'  # 删除未知单
T['BrokerFunctionCode'] = 'char'  # 经纪公司功能代码
BFC_ForceUserLogout = '1'  # 强制用户登出
BFC_UserPasswordUpdate = '2'  # 变更用户口令
BFC_SyncBrokerData = '3'  # 同步经纪公司数据
BFC_BachSyncBrokerData = '4'  # 批量同步经纪公司数据
BFC_OrderInsert = '5'  # 报单插入
BFC_OrderAction = '6'  # 报单操作
BFC_AllQuery = '7'  # 全部查询
BFC_log = 'a'  # 系统功能：登入/登出/修改密码等
BFC_BaseQry = 'b'  # 基本查询：查询基础数据，如合约，交易所等常量
BFC_TradeQry = 'c'  # 交易查询：如查成交，委托
BFC_Trade = 'd'  # 交易功能：报单，撤单
BFC_Virement = 'e'  # 银期转账
BFC_Risk = 'f'  # 风险监控
BFC_Session = 'g'  # 查询/管理：查询会话，踢人等
BFC_RiskNoticeCtl = 'h'  # 风控通知控制
BFC_RiskNotice = 'i'  # 风控通知发送
BFC_BrokerDeposit = 'j'  # 察看经纪公司资金权限
BFC_QueryFund = 'k'  # 资金查询
BFC_QueryOrder = 'l'  # 报单查询
BFC_QueryTrade = 'm'  # 成交查询
BFC_QueryPosition = 'n'  # 持仓查询
BFC_QueryMarketData = 'o'  # 行情查询
BFC_QueryUserEvent = 'p'  # 用户事件查询
BFC_QueryRiskNotify = 'q'  # 风险通知查询
BFC_QueryFundChange = 'r'  # 出入金查询
BFC_QueryInvestor = 's'  # 投资者信息查询
BFC_QueryTradingCode = 't'  # 交易编码查询
BFC_ForceClose = 'u'  # 强平
BFC_PressTest = 'v'  # 压力测试
BFC_RemainCalc = 'w'  # 权益反算
BFC_NetPositionInd = 'x'  # 净持仓保证金指标
BFC_RiskPredict = 'y'  # 风险预算
BFC_DataExport = 'z'  # 数据导出
BFC_RiskTargetSetup = 'A'  # 风控指标设置
BFC_MarketDataWarn = 'B'  # 行情预警
BFC_QryBizNotice = 'C'  # 业务通知查询
BFC_CfgBizNotice = 'D'  # 业务通知模板设置
BFC_SyncOTP = 'E'  # 同步动态令牌
BFC_SendBizNotice = 'F'  # 发送业务通知
BFC_CfgRiskLevelStd = 'G'  # 风险级别标准设置
BFC_TbCommand = 'H'  # 交易终端应急功能
BFC_DeleteOrder = 'J'  # 删除未知单
BFC_ParkedOrderInsert = 'K'  # 预埋报单插入
BFC_ParkedOrderAction = 'L'  # 预埋报单操作
T['OrderActionStatus'] = 'char'  # 报单操作状态
OAS_Submitted = 'a'  # 已经提交
OAS_Accepted = 'b'  # 已经接受
OAS_Rejected = 'c'  # 已经被拒绝
T['OrderStatus'] = 'char'  # 报单状态
OST_AllTraded = '0'  # 全部成交
OST_PartTradedQueueing = '1'  # 部分成交还在队列中
OST_PartTradedNotQueueing = '2'  # 部分成交不在队列中
OST_NoTradeQueueing = '3'  # 未成交还在队列中
OST_NoTradeNotQueueing = '4'  # 未成交不在队列中
OST_Canceled = '5'  # 撤单
OST_Unknown = 'a'  # 未知
OST_NotTouched = 'b'  # 尚未触发
OST_Touched = 'c'  # 已触发
T['OrderSubmitStatus'] = 'char'  # 报单提交状态
OSS_InsertSubmitted = '0'  # 已经提交
OSS_CancelSubmitted = '1'  # 撤单已经提交
OSS_ModifySubmitted = '2'  # 修改已经提交
OSS_Accepted = '3'  # 已经接受
OSS_InsertRejected = '4'  # 报单已经被拒绝
OSS_CancelRejected = '5'  # 撤单已经被拒绝
OSS_ModifyRejected = '6'  # 改单已经被拒绝
T['PositionDate'] = 'char'  # 持仓日期
PSD_Today = '1'  # 今日持仓
PSD_History = '2'  # 历史持仓
T['PositionDateType'] = 'char'  # 持仓日期类型
PDT_UseHistory = '1'  # 使用历史持仓
PDT_NoUseHistory = '2'  # 不使用历史持仓
T['TradingRole'] = 'char'  # 交易角色
ER_Broker = '1'  # 代理
ER_Host = '2'  # 自营
ER_Maker = '3'  # 做市商
T['ProductClass'] = 'char'  # 产品类型
PC_Futures = '1'  # 期货
PC_Options = '2'  # 期货期权
PC_Combination = '3'  # 组合
PC_Spot = '4'  # 即期
PC_EFP = '5'  # 期转现
PC_SpotOption = '6'  # 现货期权
T['InstLifePhase'] = 'char'  # 合约生命周期状态
IP_NotStart = '0'  # 未上市
IP_Started = '1'  # 上市
IP_Pause = '2'  # 停牌
IP_Expired = '3'  # 到期
T['Direction'] = 'char'  # 买卖方向
D_Buy = '0'  # 买
D_Sell = '1'  # 卖
T['PositionType'] = 'char'  # 持仓类型
PT_Net = '1'  # 净持仓
PT_Gross = '2'  # 综合持仓
T['PosiDirection'] = 'char'  # 持仓多空方向
PD_Net = '1'  # 净
PD_Long = '2'  # 多头
PD_Short = '3'  # 空头
T['SysSettlementStatus'] = 'char'  # 系统结算状态
SS_NonActive = '1'  # 不活跃
SS_Startup = '2'  # 启动
SS_Operating = '3'  # 操作
SS_Settlement = '4'  # 结算
SS_SettlementFinished = '5'  # 结算完成
T['RatioAttr'] = 'char'  # 费率属性
RA_Trade = '0'  # 交易费率
RA_Settlement = '1'  # 结算费率
T['HedgeFlag'] = 'char'  # 投机套保标志
HF_Speculation = '1'  # 投机
HF_Arbitrage = '2'  # 套利
HF_Hedge = '3'  # 套保
T['BillHedgeFlag'] = 'char'  # 投机套保标志
BHF_Speculation = '1'  # 投机
BHF_Arbitrage = '2'  # 套利
BHF_Hedge = '3'  # 套保
T['ClientIDType'] = 'char'  # 交易编码类型
CIDT_Speculation = '1'  # 投机
CIDT_Arbitrage = '2'  # 套利
CIDT_Hedge = '3'  # 套保
T['OrderPriceType'] = 'char'  # 报单价格条件
OPT_AnyPrice = '1'  # 任意价
OPT_LimitPrice = '2'  # 限价
OPT_BestPrice = '3'  # 最优价
OPT_LastPrice = '4'  # 最新价
OPT_LastPricePlusOneTicks = '5'  # 最新价浮动上浮1个ticks
OPT_LastPricePlusTwoTicks = '6'  # 最新价浮动上浮2个ticks
OPT_LastPricePlusThreeTicks = '7'  # 最新价浮动上浮3个ticks
OPT_AskPrice1 = '8'  # 卖一价
OPT_AskPrice1PlusOneTicks = '9'  # 卖一价浮动上浮1个ticks
OPT_AskPrice1PlusTwoTicks = 'A'  # 卖一价浮动上浮2个ticks
OPT_AskPrice1PlusThreeTicks = 'B'  # 卖一价浮动上浮3个ticks
OPT_BidPrice1 = 'C'  # 买一价
OPT_BidPrice1PlusOneTicks = 'D'  # 买一价浮动上浮1个ticks
OPT_BidPrice1PlusTwoTicks = 'E'  # 买一价浮动上浮2个ticks
OPT_BidPrice1PlusThreeTicks = 'F'  # 买一价浮动上浮3个ticks
OPT_FiveLevelPrice = 'G'  # 五档价
T['OffsetFlag'] = 'char'  # 开平标志
OF_Open = '0'  # 开仓
OF_Close = '1'  # 平仓
OF_ForceClose = '2'  # 强平
OF_CloseToday = '3'  # 平今
OF_CloseYesterday = '4'  # 平昨
OF_ForceOff = '5'  # 强减
OF_LocalForceClose = '6'  # 本地强平
T['ForceCloseReason'] = 'char'  # 强平原因
FCC_NotForceClose = '0'  # 非强平
FCC_LackDeposit = '1'  # 资金不足
FCC_ClientOverPositionLimit = '2'  # 客户超仓
FCC_MemberOverPositionLimit = '3'  # 会员超仓
FCC_NotMultiple = '4'  # 持仓非整数倍
FCC_Violation = '5'  # 违规
FCC_Other = '6'  # 其它
FCC_PersonDeliv = '7'  # 自然人临近交割
T['OrderType'] = 'char'  # 报单类型
ORDT_Normal = '0'  # 正常
ORDT_DeriveFromQuote = '1'  # 报价衍生
ORDT_DeriveFromCombination = '2'  # 组合衍生
ORDT_Combination = '3'  # 组合报单
ORDT_ConditionalOrder = '4'  # 条件单
ORDT_Swap = '5'  # 互换单
T['TimeCondition'] = 'char'  # 有效期类型
TC_IOC = '1'  # 立即完成，否则撤销
TC_GFS = '2'  # 本节有效
TC_GFD = '3'  # 当日有效
TC_GTD = '4'  # 指定日期前有效
TC_GTC = '5'  # 撤销前有效
TC_GFA = '6'  # 集合竞价有效
T['VolumeCondition'] = 'char'  # 成交量类型
VC_AV = '1'  # 任何数量
VC_MV = '2'  # 最小数量
VC_CV = '3'  # 全部数量
T['ContingentCondition'] = 'char'  # 触发条件
CC_Immediately = '1'  # 立即
CC_Touch = '2'  # 止损
CC_TouchProfit = '3'  # 止赢
CC_ParkedOrder = '4'  # 预埋单
CC_LastPriceGreaterThanStopPrice = '5'  # 最新价大于条件价
CC_LastPriceGreaterEqualStopPrice = '6'  # 最新价大于等于条件价
CC_LastPriceLesserThanStopPrice = '7'  # 最新价小于条件价
CC_LastPriceLesserEqualStopPrice = '8'  # 最新价小于等于条件价
CC_AskPriceGreaterThanStopPrice = '9'  # 卖一价大于条件价
CC_AskPriceGreaterEqualStopPrice = 'A'  # 卖一价大于等于条件价
CC_AskPriceLesserThanStopPrice = 'B'  # 卖一价小于条件价
CC_AskPriceLesserEqualStopPrice = 'C'  # 卖一价小于等于条件价
CC_BidPriceGreaterThanStopPrice = 'D'  # 买一价大于条件价
CC_BidPriceGreaterEqualStopPrice = 'E'  # 买一价大于等于条件价
CC_BidPriceLesserThanStopPrice = 'F'  # 买一价小于条件价
CC_BidPriceLesserEqualStopPrice = 'H'  # 买一价小于等于条件价
T['ActionFlag'] = 'char'  # 操作标志
AF_Delete = '0'  # 删除
AF_Modify = '3'  # 修改
T['TradingRight'] = 'char'  # 交易权限
TR_Allow = '0'  # 可以交易
TR_CloseOnly = '1'  # 只能平仓
TR_Forbidden = '2'  # 不能交易
T['OrderSource'] = 'char'  # 报单来源
OSRC_Participant = '0'  # 来自参与者
OSRC_Administrator = '1'  # 来自管理员
T['TradeType'] = 'char'  # 成交类型
TRDT_SplitCombination = '#'  # 组合持仓拆分为单一持仓,初始化不应包含该类型的持仓
TRDT_Common = '0'  # 普通成交
TRDT_OptionsExecution = '1'  # 期权执行
TRDT_OTC = '2'  # OTC成交
TRDT_EFPDerived = '3'  # 期转现衍生成交
TRDT_CombinationDerived = '4'  # 组合衍生成交
T['PriceSource'] = 'char'  # 成交价来源
PSRC_LastPrice = '0'  # 前成交价
PSRC_Buy = '1'  # 买委托价
PSRC_Sell = '2'  # 卖委托价
T['InstrumentStatus'] = 'char'  # 合约交易状态
IS_BeforeTrading = '0'  # 开盘前
IS_NoTrading = '1'  # 非交易
IS_Continous = '2'  # 连续交易
IS_AuctionOrdering = '3'  # 集合竞价报单
IS_AuctionBalance = '4'  # 集合竞价价格平衡
IS_AuctionMatch = '5'  # 集合竞价撮合
IS_Closed = '6'  # 收盘
T['InstStatusEnterReason'] = 'char'  # 品种进入交易状态原因
IER_Automatic = '1'  # 自动切换
IER_Manual = '2'  # 手动切换
IER_Fuse = '3'  # 熔断
T['OrderActionRef'] = 'int'  # 报单操作引用
T['InstallCount'] = 'int'  # 安装数量
T['InstallID'] = 'int'  # 安装编号
T['ErrorID'] = 'int'  # 错误代码
T['SettlementID'] = 'int'  # 结算编号
T['Volume'] = 'int'  # 数量
T['FrontID'] = 'int'  # 前置编号
T['SessionID'] = 'int'  # 会话编号
T['SequenceNo'] = 'int'  # 序号
T['CommandNo'] = 'int'  # DB命令序号
T['Millisec'] = 'int'  # 时间（毫秒）
T['VolumeMultiple'] = 'int'  # 合约数量乘数
T['TradingSegmentSN'] = 'int'  # 交易阶段编号
T['RequestID'] = 'int'  # 请求编号
T['Year'] = 'int'  # 年份
T['Month'] = 'int'  # 月份
T['Bool'] = 'int'  # 布尔型
T['Price'] = 'double'  # 价格
T['CombOffsetFlag'] = 'char[5]'  # 组合开平标志
T['CombHedgeFlag'] = 'char[5]'  # 组合投机套保标志
T['Ratio'] = 'double'  # 比率
T['Money'] = 'double'  # 资金
T['LargeVolume'] = 'double'  # 大额数量
T['SequenceSeries'] = 'short'  # 序列系列号
T['CommPhaseNo'] = 'short'  # 通讯时段编号
T['SequenceLabel'] = 'char[2]'  # 序列编号
T['UnderlyingMultiple'] = 'double'  # 基础商品乘数
T['Priority'] = 'int'  # 优先级
T['ContractCode'] = 'char[41]'  # 合同编号
T['City'] = 'char[51]'  # 市
T['IsStock'] = 'char[11]'  # 是否股民
T['Channel'] = 'char[51]'  # 渠道
T['Address'] = 'char[101]'  # 通讯地址
T['ZipCode'] = 'char[7]'  # 邮政编码
T['Telephone'] = 'char[41]'  # 联系电话
T['Fax'] = 'char[41]'  # 传真
T['Mobile'] = 'char[41]'  # 手机
T['EMail'] = 'char[41]'  # 电子邮件
T['Memo'] = 'char[161]'  # 备注
T['CompanyCode'] = 'char[51]'  # 企业代码
T['Website'] = 'char[51]'  # 网站地址
T['TaxNo'] = 'char[31]'  # 税务登记号
T['BatchStatus'] = 'char'  # 处理状态
BS_NoUpload = '1'  # 未上传
BS_Uploaded = '2'  # 已上传
BS_Failed = '3'  # 审核失败
T['PropertyID'] = 'char[33]'  # 属性代码
T['PropertyName'] = 'char[65]'  # 属性名称
T['LicenseNo'] = 'char[51]'  # 营业执照号
T['AgentID'] = 'char[13]'  # 经纪人代码
T['AgentName'] = 'char[41]'  # 经纪人名称
T['AgentGroupID'] = 'char[13]'  # 经纪人组代码
T['AgentGroupName'] = 'char[41]'  # 经纪人组名称
T['ReturnStyle'] = 'char'  # 按品种返还方式
RS_All = '1'  # 按所有品种
RS_ByProduct = '2'  # 按品种
T['ReturnPattern'] = 'char'  # 返还模式
RP_ByVolume = '1'  # 按成交手数
RP_ByFeeOnHand = '2'  # 按留存手续费
T['ReturnLevel'] = 'char'  # 返还级别
RL_Level1 = '1'  # 级别1
RL_Level2 = '2'  # 级别2
RL_Level3 = '3'  # 级别3
RL_Level4 = '4'  # 级别4
RL_Level5 = '5'  # 级别5
RL_Level6 = '6'  # 级别6
RL_Level7 = '7'  # 级别7
RL_Level8 = '8'  # 级别8
RL_Level9 = '9'  # 级别9
T['ReturnStandard'] = 'char'  # 返还标准
RSD_ByPeriod = '1'  # 分阶段返还
RSD_ByStandard = '2'  # 按某一标准
T['MortgageType'] = 'char'  # 质押类型
MT_Out = '0'  # 质出
MT_In = '1'  # 质入
T['InvestorSettlementParamID'] = 'char'  # 投资者结算参数代码
ISPI_MortgageRatio = '4'  # 质押比例
ISPI_MarginWay = '5'  # 保证金算法
ISPI_BillDeposit = '9'  # 结算单结存是否包含质押
T['ExchangeSettlementParamID'] = 'char'  # 交易所结算参数代码
ESPI_MortgageRatio = '1'  # 质押比例
ESPI_OtherFundItem = '2'  # 分项资金导入项
ESPI_OtherFundImport = '3'  # 分项资金入交易所出入金
ESPI_CFFEXMinPrepa = '6'  # 中金所开户最低可用金额
ESPI_CZCESettlementType = '7'  # 郑商所结算方式
ESPI_ExchDelivFeeMode = '9'  # 交易所交割手续费收取方式
ESPI_DelivFeeMode = '0'  # 投资者交割手续费收取方式
ESPI_CZCEComMarginType = 'A'  # 郑商所组合持仓保证金收取方式
ESPI_DceComMarginType = 'B'  # 大商所套利保证金是否优惠
ESPI_OptOutDisCountRate = 'a'  # 虚值期权保证金优惠比率
ESPI_OptMiniGuarantee = 'b'  # 最低保障系数
T['SystemParamID'] = 'char'  # 系统参数代码
SPI_InvestorIDMinLength = '1'  # 投资者代码最小长度
SPI_AccountIDMinLength = '2'  # 投资者帐号代码最小长度
SPI_UserRightLogon = '3'  # 投资者开户默认登录权限
SPI_SettlementBillTrade = '4'  # 投资者交易结算单成交汇总方式
SPI_TradingCode = '5'  # 统一开户更新交易编码方式
SPI_CheckFund = '6'  # 结算是否判断存在未复核的出入金和分项资金
SPI_CommModelRight = '7'  # 是否启用手续费模板数据权限
SPI_MarginModelRight = '9'  # 是否启用保证金率模板数据权限
SPI_IsStandardActive = '8'  # 是否规范用户才能激活
SPI_UploadSettlementFile = 'U'  # 上传的交易所结算文件路径
SPI_DownloadCSRCFile = 'D'  # 上报保证金监控中心文件路径
SPI_SettlementBillFile = 'S'  # 生成的结算单文件路径
SPI_CSRCOthersFile = 'C'  # 证监会文件标识
SPI_InvestorPhoto = 'P'  # 投资者照片路径
SPI_CSRCData = 'R'  # 全结经纪公司上传文件路径
SPI_InvestorPwdModel = 'I'  # 开户密码录入方式
SPI_CFFEXInvestorSettleFile = 'F'  # 投资者中金所结算文件下载路径
SPI_InvestorIDType = 'a'  # 投资者代码编码方式
SPI_FreezeMaxReMain = 'r'  # 休眠户最高权益
SPI_IsSync = 'A'  # 手续费相关操作实时上场开关
SPI_RelieveOpenLimit = 'O'  # 解除开仓权限限制
SPI_IsStandardFreeze = 'X'  # 是否规范用户才能休眠
SPI_CZCENormalProductHedge = 'B'  # 郑商所是否开放所有品种套保交易
T['TradeParamID'] = 'char'  # 交易系统参数代码
TPID_EncryptionStandard = 'E'  # 系统加密算法
TPID_RiskMode = 'R'  # 系统风险算法
TPID_RiskModeGlobal = 'G'  # 系统风险算法是否全局 0-否 1-是
TPID_modeEncode = 'P'  # 密码加密算法
TPID_tickMode = 'T'  # 价格小数位数参数
TPID_SingleUserSessionMaxNum = 'S'  # 用户最大会话数
TPID_LoginFailMaxNum = 'L'  # 最大连续登录失败数
TPID_IsAuthForce = 'A'  # 是否强制认证
TPID_IsPosiFreeze = 'F'  # 是否冻结证券持仓
TPID_IsPosiLimit = 'M'  # 是否限仓
TPID_ForQuoteTimeInterval = 'Q'  # 郑商所询价时间间隔
T['SettlementParamValue'] = 'char[256]'  # 参数代码值
T['CounterID'] = 'char[33]'  # 计数器代码
T['InvestorGroupName'] = 'char[41]'  # 投资者分组名称
T['BrandCode'] = 'char[257]'  # 牌号
T['Warehouse'] = 'char[257]'  # 仓库
T['ProductDate'] = 'char[41]'  # 产期
T['Grade'] = 'char[41]'  # 等级
T['Classify'] = 'char[41]'  # 类别
T['Position'] = 'char[41]'  # 货位
T['Yieldly'] = 'char[41]'  # 产地
T['Weight'] = 'char[41]'  # 公定重量
T['SubEntryFundNo'] = 'int'  # 分项资金流水号
T['FileID'] = 'char'  # 文件标识
FI_SettlementFund = 'F'  # 资金数据
FI_Trade = 'T'  # 成交数据
FI_InvestorPosition = 'P'  # 投资者持仓数据
FI_SubEntryFund = 'O'  # 投资者分项资金数据
FI_CZCECombinationPos = 'C'  # 组合持仓数据
FI_CSRCData = 'R'  # 上报保证金监控中心数据
FI_CZCEClose = 'L'  # 郑商所平仓了结数据
FI_CZCENoClose = 'N'  # 郑商所非平仓了结数据
FI_PositionDtl = 'D'  # 持仓明细数据
FI_OptionStrike = 'S'  # 期权执行文件
FI_SettlementPriceComparison = 'M'  # 结算价比对文件
FI_NonTradePosChange = 'B'  # 上期所非持仓变动明细
T['FileName'] = 'char[257]'  # 文件名称
T['FileType'] = 'char'  # 文件上传类型
FUT_Settlement = '0'  # 结算
FUT_Check = '1'  # 核对
T['FileFormat'] = 'char'  # 文件格式
FFT_Txt = '0'  # 文本文件(.txt)
FFT_Zip = '1'  # 压缩文件(.zip)
FFT_DBF = '2'  # DBF文件(.dbf)
T['FileUploadStatus'] = 'char'  # 文件状态
FUS_SucceedUpload = '1'  # 上传成功
FUS_FailedUpload = '2'  # 上传失败
FUS_SucceedLoad = '3'  # 导入成功
FUS_PartSucceedLoad = '4'  # 导入部分成功
FUS_FailedLoad = '5'  # 导入失败
T['TransferDirection'] = 'char'  # 移仓方向
TD_Out = '0'  # 移出
TD_In = '1'  # 移入
T['UploadMode'] = 'char[21]'  # 上传文件类型
T['AccountID'] = 'char[13]'  # 投资者帐号
T['BankFlag'] = 'char[4]'  # 银行统一标识类型
T['BankAccount'] = 'char[41]'  # 银行账户
T['OpenName'] = 'char[61]'  # 银行账户的开户人名称
T['OpenBank'] = 'char[101]'  # 银行账户的开户行
T['BankName'] = 'char[101]'  # 银行名称
T['PublishPath'] = 'char[257]'  # 发布路径
T['OperatorID'] = 'char[65]'  # 操作员代码
T['MonthCount'] = 'int'  # 月份数量
T['AdvanceMonthArray'] = 'char[13]'  # 月份提前数组
T['DateExpr'] = 'char[1025]'  # 日期表达式
T['InstrumentIDExpr'] = 'char[41]'  # 合约代码表达式
T['InstrumentNameExpr'] = 'char[41]'  # 合约名称表达式
T['SpecialCreateRule'] = 'char'  # 特殊的创建规则
SC_NoSpecialRule = '0'  # 没有特殊创建规则
SC_NoSpringFestival = '1'  # 不包含春节
T['BasisPriceType'] = 'char'  # 挂牌基准价类型
IPT_LastSettlement = '1'  # 上一合约结算价
IPT_LaseClose = '2'  # 上一合约收盘价
T['ProductLifePhase'] = 'char'  # 产品生命周期状态
PLP_Active = '1'  # 活跃
PLP_NonActive = '2'  # 不活跃
PLP_Canceled = '3'  # 注销
T['DeliveryMode'] = 'char'  # 交割方式
DM_CashDeliv = '1'  # 现金交割
DM_CommodityDeliv = '2'  # 实物交割
T['LogLevel'] = 'char[33]'  # 日志级别
T['ProcessName'] = 'char[257]'  # 存储过程名称
T['OperationMemo'] = 'char[1025]'  # 操作摘要
T['FundIOType'] = 'char'  # 出入金类型
FIOT_FundIO = '1'  # 出入金
FIOT_Transfer = '2'  # 银期转帐
FIOT_SwapCurrency = '3'  # 银期换汇
T['FundType'] = 'char'  # 资金类型
FT_Deposite = '1'  # 银行存款
FT_ItemFund = '2'  # 分项资金
FT_Company = '3'  # 公司调整
FT_InnerTransfer = '4'  # 资金内转
T['FundDirection'] = 'char'  # 出入金方向
FD_In = '1'  # 入金
FD_Out = '2'  # 出金
T['FundStatus'] = 'char'  # 资金状态
FS_Record = '1'  # 已录入
FS_Check = '2'  # 已复核
FS_Charge = '3'  # 已冲销
T['BillNo'] = 'char[15]'  # 票据号
T['BillName'] = 'char[33]'  # 票据名称
T['PublishStatus'] = 'char'  # 发布状态
PS_None = '1'  # 未发布
PS_Publishing = '2'  # 正在发布
PS_Published = '3'  # 已发布
T['EnumValueID'] = 'char[65]'  # 枚举值代码
T['EnumValueType'] = 'char[33]'  # 枚举值类型
T['EnumValueLabel'] = 'char[65]'  # 枚举值名称
T['EnumValueResult'] = 'char[33]'  # 枚举值结果
T['SystemStatus'] = 'char'  # 系统状态
ES_NonActive = '1'  # 不活跃
ES_Startup = '2'  # 启动
ES_Initialize = '3'  # 交易开始初始化
ES_Initialized = '4'  # 交易完成初始化
ES_Close = '5'  # 收市开始
ES_Closed = '6'  # 收市完成
ES_Settlement = '7'  # 结算
T['SettlementStatus'] = 'char'  # 结算状态
STS_Initialize = '0'  # 初始
STS_Settlementing = '1'  # 结算中
STS_Settlemented = '2'  # 已结算
STS_Finished = '3'  # 结算完成
T['RangeIntType'] = 'char[33]'  # 限定值类型
T['RangeIntFrom'] = 'char[33]'  # 限定值下限
T['RangeIntTo'] = 'char[33]'  # 限定值上限
T['FunctionID'] = 'char[25]'  # 功能代码
T['FunctionValueCode'] = 'char[257]'  # 功能编码
T['FunctionName'] = 'char[65]'  # 功能名称
T['RoleID'] = 'char[11]'  # 角色编号
T['RoleName'] = 'char[41]'  # 角色名称
T['Description'] = 'char[401]'  # 描述
T['CombineID'] = 'char[25]'  # 组合编号
T['CombineType'] = 'char[25]'  # 组合类型
T['InvestorType'] = 'char'  # 投资者类型
CT_Person = '0'  # 自然人
CT_Company = '1'  # 法人
CT_Fund = '2'  # 投资基金
CT_SpecialOrgan = '3'  # 特殊法人
CT_Asset = '4'  # 资管户
T['BrokerType'] = 'char'  # 经纪公司类型
BT_Trade = '0'  # 交易会员
BT_TradeSettle = '1'  # 交易结算会员
T['RiskLevel'] = 'char'  # 风险等级
FAS_Low = '1'  # 低风险客户
FAS_Normal = '2'  # 普通客户
FAS_Focus = '3'  # 关注客户
FAS_Risk = '4'  # 风险客户
T['FeeAcceptStyle'] = 'char'  # 手续费收取方式
FAS_ByTrade = '1'  # 按交易收取
FAS_ByDeliv = '2'  # 按交割收取
FAS_None = '3'  # 不收
FAS_FixFee = '4'  # 按指定手续费收取
T['PasswordType'] = 'char'  # 密码类型
PWDT_Trade = '1'  # 交易密码
PWDT_Account = '2'  # 资金密码
T['Algorithm'] = 'char'  # 盈亏算法
AG_All = '1'  # 浮盈浮亏都计算
AG_OnlyLost = '2'  # 浮盈不计，浮亏计
AG_OnlyGain = '3'  # 浮盈计，浮亏不计
AG_None = '4'  # 浮盈浮亏都不计算
T['IncludeCloseProfit'] = 'char'  # 是否包含平仓盈利
ICP_Include = '0'  # 包含平仓盈利
ICP_NotInclude = '2'  # 不包含平仓盈利
T['AllWithoutTrade'] = 'char'  # 是否受可提比例限制
AWT_Enable = '0'  # 无仓无成交不受可提比例限制
AWT_Disable = '2'  # 受可提比例限制
AWT_NoHoldEnable = '3'  # 无仓不受可提比例限制
T['Comment'] = 'char[31]'  # 盈亏算法说明
T['Version'] = 'char[4]'  # 版本号
T['TradeCode'] = 'char[7]'  # 交易代码
T['TradeDate'] = 'char[9]'  # 交易日期
T['TradeTime'] = 'char[9]'  # 交易时间
T['TradeSerial'] = 'char[9]'  # 发起方流水号
T['TradeSerialNo'] = 'int'  # 发起方流水号
T['FutureID'] = 'char[11]'  # 期货公司代码
T['BankID'] = 'char[4]'  # 银行代码
T['BankBrchID'] = 'char[5]'  # 银行分中心代码
T['BankBranchID'] = 'char[11]'  # 分中心代码
T['OperNo'] = 'char[17]'  # 交易柜员
T['DeviceID'] = 'char[3]'  # 渠道标志
T['RecordNum'] = 'char[7]'  # 记录数
T['FutureAccount'] = 'char[22]'  # 期货资金账号
T['FuturePwdFlag'] = 'char'  # 资金密码核对标志
FPWD_UnCheck = '0'  # 不核对
FPWD_Check = '1'  # 核对
T['TransferType'] = 'char'  # 银期转账类型
TT_BankToFuture = '0'  # 银行转期货
TT_FutureToBank = '1'  # 期货转银行
T['FutureAccPwd'] = 'char[17]'  # 期货资金密码
T['CurrencyCode'] = 'char[4]'  # 币种
T['RetCode'] = 'char[5]'  # 响应代码
T['RetInfo'] = 'char[129]'  # 响应信息
T['TradeAmt'] = 'char[20]'  # 银行总余额
T['UseAmt'] = 'char[20]'  # 银行可用余额
T['FetchAmt'] = 'char[20]'  # 银行可取余额
T['TransferValidFlag'] = 'char'  # 转账有效标志
TVF_Invalid = '0'  # 无效或失败
TVF_Valid = '1'  # 有效
TVF_Reverse = '2'  # 冲正
T['CertCode'] = 'char[21]'  # 证件号码
T['Reason'] = 'char'  # 事由
RN_CD = '0'  # 错单
RN_ZT = '1'  # 资金在途
RN_QT = '2'  # 其它
T['FundProjectID'] = 'char[5]'  # 资金项目编号
T['Sex'] = 'char'  # 性别
SEX_None = '0'  # 未知
SEX_Man = '1'  # 男
SEX_Woman = '2'  # 女
T['Profession'] = 'char[101]'  # 职业
T['National'] = 'char[31]'  # 国籍
T['Province'] = 'char[51]'  # 省
T['Region'] = 'char[16]'  # 区
T['Country'] = 'char[16]'  # 国家
T['LicenseNO'] = 'char[33]'  # 营业执照
T['CompanyType'] = 'char[16]'  # 企业性质
T['BusinessScope'] = 'char[1001]'  # 经营范围
T['CapitalCurrency'] = 'char[4]'  # 注册资本币种
T['UserType'] = 'char'  # 用户类型
UT_Investor = '0'  # 投资者
UT_Operator = '1'  # 操作员
UT_SuperUser = '2'  # 管理员
T['RateType'] = 'char'  # 费率类型
RATETYPE_MarginRate = '2'  # 保证金率
T['NoteType'] = 'char'  # 通知类型
NOTETYPE_TradeSettleBill = '1'  # 交易结算单
NOTETYPE_TradeSettleMonth = '2'  # 交易结算月报
NOTETYPE_CallMarginNotes = '3'  # 追加保证金通知书
NOTETYPE_ForceCloseNotes = '4'  # 强行平仓通知书
NOTETYPE_TradeNotes = '5'  # 成交通知书
NOTETYPE_DelivNotes = '6'  # 交割通知书
T['SettlementStyle'] = 'char'  # 结算单方式
SBS_Day = '1'  # 逐日盯市
SBS_Volume = '2'  # 逐笔对冲
T['BrokerDNS'] = 'char[256]'  # 域名
T['Sentence'] = 'char[501]'  # 语句
T['SettlementBillType'] = 'char'  # 结算单类型
ST_Day = '0'  # 日报
ST_Month = '1'  # 月报
T['UserRightType'] = 'char'  # 客户权限类型
URT_Logon = '1'  # 登录
URT_Transfer = '2'  # 银期转帐
URT_EMail = '3'  # 邮寄结算单
URT_Fax = '4'  # 传真结算单
URT_ConditionOrder = '5'  # 条件单
T['MarginPriceType'] = 'char'  # 保证金价格类型
MPT_PreSettlementPrice = '1'  # 昨结算价
MPT_SettlementPrice = '2'  # 最新价
MPT_AveragePrice = '3'  # 成交均价
MPT_OpenPrice = '4'  # 开仓价
T['BillGenStatus'] = 'char'  # 结算单生成状态
BGS_None = '0'  # 未生成
BGS_NoGenerated = '1'  # 生成中
BGS_Generated = '2'  # 已生成
T['AlgoType'] = 'char'  # 算法类型
AT_HandlePositionAlgo = '1'  # 持仓处理算法
AT_FindMarginRateAlgo = '2'  # 寻找保证金率算法
T['HandlePositionAlgoID'] = 'char'  # 持仓处理算法编号
HPA_Base = '1'  # 基本
HPA_DCE = '2'  # 大连商品交易所
HPA_CZCE = '3'  # 郑州商品交易所
T['FindMarginRateAlgoID'] = 'char'  # 寻找保证金率算法编号
FMRA_Base = '1'  # 基本
FMRA_DCE = '2'  # 大连商品交易所
FMRA_CZCE = '3'  # 郑州商品交易所
T['HandleTradingAccountAlgoID'] = 'char'  # 资金处理算法编号
HTAA_Base = '1'  # 基本
HTAA_DCE = '2'  # 大连商品交易所
HTAA_CZCE = '3'  # 郑州商品交易所
T['PersonType'] = 'char'  # 联系人类型
PST_Order = '1'  # 指定下单人
PST_Open = '2'  # 开户授权人
PST_Fund = '3'  # 资金调拨人
PST_Settlement = '4'  # 结算单确认人
PST_Company = '5'  # 法人
PST_Corporation = '6'  # 法人代表
PST_LinkMan = '7'  # 投资者联系人
PST_Ledger = '8'  # 分户管理资产负责人
PST_Trustee = '9'  # 托（保）管人
PST_TrusteeCorporation = 'A'  # 托（保）管机构法人代表
PST_TrusteeOpen = 'B'  # 托（保）管机构开户授权人
PST_TrusteeContact = 'C'  # 托（保）管机构联系人
PST_ForeignerRefer = 'D'  # 境外自然人参考证件
PST_CorporationRefer = 'E'  # 法人代表参考证件
T['QueryInvestorRange'] = 'char'  # 查询范围
QIR_All = '1'  # 所有
QIR_Group = '2'  # 查询分类
QIR_Single = '3'  # 单一投资者
T['InvestorRiskStatus'] = 'char'  # 投资者风险状态
IRS_Normal = '1'  # 正常
IRS_Warn = '2'  # 警告
IRS_Call = '3'  # 追保
IRS_Force = '4'  # 强平
IRS_Exception = '5'  # 异常
T['LegID'] = 'int'  # 单腿编号
T['LegMultiple'] = 'int'  # 单腿乘数
T['ImplyLevel'] = 'int'  # 派生层数
T['ClearAccount'] = 'char[33]'  # 结算账户
T['OrganNO'] = 'char[6]'  # 结算账户
T['ClearbarchID'] = 'char[6]'  # 结算账户联行号
T['UserEventType'] = 'char'  # 用户事件类型
UET_Login = '1'  # 登录
UET_Logout = '2'  # 登出
UET_Trading = '3'  # 交易成功
UET_TradingError = '4'  # 交易失败
UET_UpdatePassword = '5'  # 修改密码
UET_Authenticate = '6'  # 客户端认证
UET_Other = '9'  # 其他
T['UserEventInfo'] = 'char[1025]'  # 用户事件信息
T['CloseStyle'] = 'char'  # 平仓方式
ICS_Close = '0'  # 先开先平
ICS_CloseToday = '1'  # 先平今再平昨
T['StatMode'] = 'char'  # 统计方式
SM_Non = '0'  # ----
SM_Instrument = '1'  # 按合约统计
SM_Product = '2'  # 按产品统计
SM_Investor = '3'  # 按投资者统计
T['ParkedOrderStatus'] = 'char'  # 预埋单状态
PAOS_NotSend = '1'  # 未发送
PAOS_Send = '2'  # 已发送
PAOS_Deleted = '3'  # 已删除
T['ParkedOrderID'] = 'char[13]'  # 预埋报单编号
T['ParkedOrderActionID'] = 'char[13]'  # 预埋撤单编号
T['VirDealStatus'] = 'char'  # 处理状态
VDS_Dealing = '1'  # 正在处理
VDS_DeaclSucceed = '2'  # 处理成功
T['OrgSystemID'] = 'char'  # 原有系统代码
ORGS_Standard = '0'  # 综合交易平台
ORGS_ESunny = '1'  # 易盛系统
ORGS_KingStarV6 = '2'  # 金仕达V6系统
T['VirTradeStatus'] = 'char'  # 交易状态
VTS_NaturalDeal = '0'  # 正常处理中
VTS_SucceedEnd = '1'  # 成功结束
VTS_FailedEND = '2'  # 失败结束
VTS_Exception = '3'  # 异常中
VTS_ManualDeal = '4'  # 已人工异常处理
VTS_MesException = '5'  # 通讯异常 ，请人工处理
VTS_SysException = '6'  # 系统出错，请人工处理
T['VirBankAccType'] = 'char'  # 银行帐户类型
VBAT_BankBook = '1'  # 存折
VBAT_BankCard = '2'  # 储蓄卡
VBAT_CreditCard = '3'  # 信用卡
T['VirementStatus'] = 'char'  # 银行帐户类型
VMS_Natural = '0'  # 正常
VMS_Canceled = '9'  # 销户
T['VirementAvailAbility'] = 'char'  # 有效标志
VAA_NoAvailAbility = '0'  # 未确认
VAA_AvailAbility = '1'  # 有效
VAA_Repeal = '2'  # 冲正
T['VirementTradeCode'] = 'char[7]'  # 交易代码
VTC_BankBankToFuture = '102001'  # 银行发起银行资金转期货
VTC_BankFutureToBank = '102002'  # 银行发起期货资金转银行
VTC_FutureBankToFuture = '202001'  # 期货发起银行资金转期货
VTC_FutureFutureToBank = '202002'  # 期货发起期货资金转银行
T['PhotoTypeName'] = 'char[41]'  # 影像类型名称
T['PhotoTypeID'] = 'char[5]'  # 影像类型代码
T['PhotoName'] = 'char[161]'  # 影像名称
T['TopicID'] = 'int'  # 主题代码
T['ReportTypeID'] = 'char[3]'  # 交易报告类型标识
T['CharacterID'] = 'char[5]'  # 交易特征代码
T['AMLParamID'] = 'char[21]'  # 参数代码
T['AMLInvestorType'] = 'char[3]'  # 投资者类型
T['AMLIdCardType'] = 'char[3]'  # 证件类型
T['AMLTradeDirect'] = 'char[3]'  # 资金进出方向
T['AMLTradeModel'] = 'char[3]'  # 资金进出方式
T['AMLParamID'] = 'char[21]'  # 参数代码
T['AMLOpParamValue'] = 'double'  # 业务参数代码值
T['AMLCustomerCardType'] = 'char[81]'  # 客户身份证件/证明文件类型
T['AMLInstitutionName'] = 'char[65]'  # 金融机构网点名称
T['AMLDistrictID'] = 'char[7]'  # 金融机构网点所在地区行政区划代码
T['AMLRelationShip'] = 'char[3]'  # 金融机构网点与大额交易的关系
T['AMLInstitutionType'] = 'char[3]'  # 金融机构网点代码类型
T['AMLInstitutionID'] = 'char[13]'  # 金融机构网点代码
T['AMLAccountType'] = 'char[5]'  # 账户类型
T['AMLTradingType'] = 'char[7]'  # 交易方式
T['AMLTransactClass'] = 'char[7]'  # 涉外收支交易分类与代码
T['AMLCapitalIO'] = 'char[3]'  # 资金收付标识
T['AMLSite'] = 'char[10]'  # 交易地点
T['AMLCapitalPurpose'] = 'char[129]'  # 资金用途
T['AMLReportType'] = 'char[2]'  # 报文类型
T['AMLSerialNo'] = 'char[5]'  # 编号
T['AMLStatus'] = 'char[2]'  # 状态
T['AMLGenStatus'] = 'char'  # Aml生成方式
GEN_Program = '0'  # 程序生成
GEN_HandWork = '1'  # 人工生成
T['AMLSeqCode'] = 'char[65]'  # 业务标识号
T['AMLFileName'] = 'char[257]'  # AML文件名
T['AMLMoney'] = 'double'  # 反洗钱资金
T['AMLFileAmount'] = 'int'  # 反洗钱资金
T['CFMMCKey'] = 'char[21]'  # 密钥类型(保证金监管)
T['CFMMCToken'] = 'char[21]'  # 令牌类型(保证金监管)
T['CFMMCKeyKind'] = 'char'  # 动态密钥类别(保证金监管)
CFMMCKK_REQUEST = 'R'  # 主动请求更新
CFMMCKK_AUTO = 'A'  # CFMMC自动更新
CFMMCKK_MANUAL = 'M'  # CFMMC手动更新
T['AMLReportName'] = 'char[81]'  # 报文名称
T['IndividualName'] = 'char[51]'  # 个人姓名
T['CurrencyID'] = 'char[4]'  # 币种代码
T['CustNumber'] = 'char[36]'  # 客户编号
T['OrganCode'] = 'char[36]'  # 机构编码
T['OrganName'] = 'char[71]'  # 机构名称
T['SuperOrganCode'] = 'char[12]'  # 上级机构编码,即期货公司总部、银行总行
T['SubBranchID'] = 'char[31]'  # 分支机构
T['SubBranchName'] = 'char[71]'  # 分支机构名称
T['BranchNetCode'] = 'char[31]'  # 机构网点号
T['BranchNetName'] = 'char[71]'  # 机构网点名称
T['OrganFlag'] = 'char[2]'  # 机构标识
T['BankCodingForFuture'] = 'char[33]'  # 银行对期货公司的编码
T['BankReturnCode'] = 'char[7]'  # 银行对返回码的定义
T['PlateReturnCode'] = 'char[5]'  # 银期转帐平台对返回码的定义
T['BankSubBranchID'] = 'char[31]'  # 银行分支机构编码
T['FutureBranchID'] = 'char[31]'  # 期货分支机构编码
T['ReturnCode'] = 'char[7]'  # 返回代码
T['OperatorCode'] = 'char[17]'  # 操作员
T['ClearDepID'] = 'char[6]'  # 机构结算帐户机构号
T['ClearBrchID'] = 'char[6]'  # 机构结算帐户联行号
T['ClearName'] = 'char[71]'  # 机构结算帐户名称
T['BankAccountName'] = 'char[71]'  # 银行帐户名称
T['InvDepID'] = 'char[6]'  # 机构投资人账号机构号
T['InvBrchID'] = 'char[6]'  # 机构投资人联行号
T['MessageFormatVersion'] = 'char[36]'  # 信息格式版本
T['Digest'] = 'char[36]'  # 摘要
T['AuthenticData'] = 'char[129]'  # 认证数据
T['PasswordKey'] = 'char[129]'  # 密钥
T['FutureAccountName'] = 'char[129]'  # 期货帐户名称
T['MobilePhone'] = 'char[21]'  # 手机
T['FutureMainKey'] = 'char[129]'  # 期货公司主密钥
T['FutureWorkKey'] = 'char[129]'  # 期货公司工作密钥
T['FutureTransKey'] = 'char[129]'  # 期货公司传输密钥
T['BankMainKey'] = 'char[129]'  # 银行主密钥
T['BankWorkKey'] = 'char[129]'  # 银行工作密钥
T['BankTransKey'] = 'char[129]'  # 银行传输密钥
T['BankServerDescription'] = 'char[129]'  # 银行服务器描述信息
T['AddInfo'] = 'char[129]'  # 附加信息
T['DescrInfoForReturnCode'] = 'char[129]'  # 返回码描述
T['CountryCode'] = 'char[21]'  # 国家代码
T['Serial'] = 'int'  # 流水号
T['PlateSerial'] = 'int'  # 平台流水号
T['BankSerial'] = 'char[13]'  # 银行流水号
T['CorrectSerial'] = 'int'  # 被冲正交易流水号
T['FutureSerial'] = 'int'  # 期货公司流水号
T['ApplicationID'] = 'int'  # 应用标识
T['BankProxyID'] = 'int'  # 银行代理标识
T['FBTCoreID'] = 'int'  # 银期转帐核心系统标识
T['ServerPort'] = 'int'  # 服务端口号
T['RepealedTimes'] = 'int'  # 已经冲正次数
T['RepealTimeInterval'] = 'int'  # 冲正时间间隔
T['TotalTimes'] = 'int'  # 每日累计转帐次数
T['FBTRequestID'] = 'int'  # 请求ID
T['TID'] = 'int'  # 交易ID
T['TradeAmount'] = 'double'  # 交易金额（元）
T['CustFee'] = 'double'  # 应收客户费用（元）
T['FutureFee'] = 'double'  # 应收期货公司费用（元）
T['SingleMaxAmt'] = 'double'  # 单笔最高限额
T['SingleMinAmt'] = 'double'  # 单笔最低限额
T['TotalAmt'] = 'double'  # 每日累计转帐额度
T['CertificationType'] = 'char'  # 证件类型
CFT_IDCard = '0'  # 身份证
CFT_Passport = '1'  # 护照
CFT_OfficerIDCard = '2'  # 军官证
CFT_SoldierIDCard = '3'  # 士兵证
CFT_HomeComingCard = '4'  # 回乡证
CFT_HouseholdRegister = '5'  # 户口簿
CFT_LicenseNo = '6'  # 营业执照号
CFT_InstitutionCodeCard = '7'  # 组织机构代码证
CFT_TempLicenseNo = '8'  # 临时营业执照号
CFT_NoEnterpriseLicenseNo = '9'  # 民办非企业登记证书
CFT_OtherCard = 'x'  # 其他证件
CFT_SuperDepAgree = 'a'  # 主管部门批文
T['FileBusinessCode'] = 'char'  # 文件业务功能
FBC_Others = '0'  # 其他
FBC_TransferDetails = '1'  # 转账交易明细对账
FBC_CustAccStatus = '2'  # 客户账户状态对账
FBC_AccountTradeDetails = '3'  # 账户类交易明细对账
FBC_FutureAccountChangeInfoDetails = '4'  # 期货账户信息变更明细对账
FBC_CustMoneyDetail = '5'  # 客户资金台账余额明细对账
FBC_CustCancelAccountInfo = '6'  # 客户销户结息明细对账
FBC_CustMoneyResult = '7'  # 客户资金余额对账结果
FBC_OthersExceptionResult = '8'  # 其它对账异常结果文件
FBC_CustInterestNetMoneyDetails = '9'  # 客户结息净额明细
FBC_CustMoneySendAndReceiveDetails = 'a'  # 客户资金交收明细
FBC_CorporationMoneyTotal = 'b'  # 法人存管银行资金交收汇总
FBC_MainbodyMoneyTotal = 'c'  # 主体间资金交收汇总
FBC_MainPartMonitorData = 'd'  # 总分平衡监管数据
FBC_PreparationMoney = 'e'  # 存管银行备付金余额
FBC_BankMoneyMonitorData = 'f'  # 协办存管银行资金监管数据
T['CashExchangeCode'] = 'char'  # 汇钞标志
CEC_Exchange = '1'  # 汇
CEC_Cash = '2'  # 钞
T['YesNoIndicator'] = 'char'  # 是或否标识
YNI_Yes = '0'  # 是
YNI_No = '1'  # 否
T['BanlanceType'] = 'char'  # 余额类型
BLT_CurrentMoney = '0'  # 当前余额
BLT_UsableMoney = '1'  # 可用余额
BLT_FetchableMoney = '2'  # 可取余额
BLT_FreezeMoney = '3'  # 冻结余额
T['Gender'] = 'char'  # 性别
GD_Unknown = '0'  # 未知状态
GD_Male = '1'  # 男
GD_Female = '2'  # 女
T['FeePayFlag'] = 'char'  # 费用支付标志
FPF_BEN = '0'  # 由受益方支付费用
FPF_OUR = '1'  # 由发送方支付费用
FPF_SHA = '2'  # 由发送方支付发起的费用，受益方支付接受的费用
T['PassWordKeyType'] = 'char'  # 密钥类型
PWKT_ExchangeKey = '0'  # 交换密钥
PWKT_PassWordKey = '1'  # 密码密钥
PWKT_MACKey = '2'  # MAC密钥
PWKT_MessageKey = '3'  # 报文密钥
T['FBTPassWordType'] = 'char'  # 密码类型
PWT_Query = '0'  # 查询
PWT_Fetch = '1'  # 取款
PWT_Transfer = '2'  # 转帐
PWT_Trade = '3'  # 交易
T['FBTEncryMode'] = 'char'  # 加密方式
EM_NoEncry = '0'  # 不加密
EM_DES = '1'  # DES
EM_3DES = '2'  # 3DES
T['BankRepealFlag'] = 'char'  # 银行冲正标志
BRF_BankNotNeedRepeal = '0'  # 银行无需自动冲正
BRF_BankWaitingRepeal = '1'  # 银行待自动冲正
BRF_BankBeenRepealed = '2'  # 银行已自动冲正
T['BrokerRepealFlag'] = 'char'  # 期商冲正标志
BRORF_BrokerNotNeedRepeal = '0'  # 期商无需自动冲正
BRORF_BrokerWaitingRepeal = '1'  # 期商待自动冲正
BRORF_BrokerBeenRepealed = '2'  # 期商已自动冲正
T['InstitutionType'] = 'char'  # 机构类别
TS_Bank = '0'  # 银行
TS_Future = '1'  # 期商
TS_Store = '2'  # 券商
T['LastFragment'] = 'char'  # 最后分片标志
LF_Yes = '0'  # 是最后分片
LF_No = '1'  # 不是最后分片
T['BankAccStatus'] = 'char'  # 银行账户状态
BAS_Normal = '0'  # 正常
BAS_Freeze = '1'  # 冻结
BAS_ReportLoss = '2'  # 挂失
T['MoneyAccountStatus'] = 'char'  # 资金账户状态
MAS_Normal = '0'  # 正常
MAS_Cancel = '1'  # 销户
T['ManageStatus'] = 'char'  # 存管状态
MSS_Point = '0'  # 指定存管
MSS_PrePoint = '1'  # 预指定
MSS_CancelPoint = '2'  # 撤销指定
T['SystemType'] = 'char'  # 应用系统类型
SYT_FutureBankTransfer = '0'  # 银期转帐
SYT_StockBankTransfer = '1'  # 银证转帐
SYT_TheThirdPartStore = '2'  # 第三方存管
T['TxnEndFlag'] = 'char'  # 银期转帐划转结果标志
TEF_NormalProcessing = '0'  # 正常处理中
TEF_Success = '1'  # 成功结束
TEF_Failed = '2'  # 失败结束
TEF_Abnormal = '3'  # 异常中
TEF_ManualProcessedForException = '4'  # 已人工异常处理
TEF_CommuFailedNeedManualProcess = '5'  # 通讯异常 ，请人工处理
TEF_SysErrorNeedManualProcess = '6'  # 系统出错，请人工处理
T['ProcessStatus'] = 'char'  # 银期转帐服务处理状态
PSS_NotProcess = '0'  # 未处理
PSS_StartProcess = '1'  # 开始处理
PSS_Finished = '2'  # 处理完成
T['CustType'] = 'char'  # 客户类型
CUSTT_Person = '0'  # 自然人
CUSTT_Institution = '1'  # 机构户
T['FBTTransferDirection'] = 'char'  # 银期转帐方向
FBTTD_FromBankToFuture = '1'  # 入金，银行转期货
FBTTD_FromFutureToBank = '2'  # 出金，期货转银行
T['OpenOrDestroy'] = 'char'  # 开销户类别
OOD_Open = '1'  # 开户
OOD_Destroy = '0'  # 销户
T['AvailabilityFlag'] = 'char'  # 有效标志
AVAF_Invalid = '0'  # 未确认
AVAF_Valid = '1'  # 有效
AVAF_Repeal = '2'  # 冲正
T['OrganType'] = 'char'  # 机构类型
OT_Bank = '1'  # 银行代理
OT_Future = '2'  # 交易前置
OT_PlateForm = '9'  # 银期转帐平台管理
T['OrganLevel'] = 'char'  # 机构级别
OL_HeadQuarters = '1'  # 银行总行或期商总部
OL_Branch = '2'  # 银行分中心或期货公司营业部
T['ProtocalID'] = 'char'  # 协议类型
PID_FutureProtocal = '0'  # 期商协议
PID_ICBCProtocal = '1'  # 工行协议
PID_ABCProtocal = '2'  # 农行协议
PID_CBCProtocal = '3'  # 中国银行协议
PID_CCBProtocal = '4'  # 建行协议
PID_BOCOMProtocal = '5'  # 交行协议
PID_FBTPlateFormProtocal = 'X'  # 银期转帐平台协议
T['ConnectMode'] = 'char'  # 套接字连接方式
CM_ShortConnect = '0'  # 短连接
CM_LongConnect = '1'  # 长连接
T['SyncMode'] = 'char'  # 套接字通信方式
SRM_ASync = '0'  # 异步
SRM_Sync = '1'  # 同步
T['BankAccType'] = 'char'  # 银行帐号类型
BAT_BankBook = '1'  # 银行存折
BAT_SavingCard = '2'  # 储蓄卡
BAT_CreditCard = '3'  # 信用卡
T['FutureAccType'] = 'char'  # 期货公司帐号类型
FAT_BankBook = '1'  # 银行存折
FAT_SavingCard = '2'  # 储蓄卡
FAT_CreditCard = '3'  # 信用卡
T['OrganStatus'] = 'char'  # 接入机构状态
OS_Ready = '0'  # 启用
OS_CheckIn = '1'  # 签到
OS_CheckOut = '2'  # 签退
OS_CheckFileArrived = '3'  # 对帐文件到达
OS_CheckDetail = '4'  # 对帐
OS_DayEndClean = '5'  # 日终清理
OS_Invalid = '9'  # 注销
T['CCBFeeMode'] = 'char'  # 建行收费模式
CCBFM_ByAmount = '1'  # 按金额扣收
CCBFM_ByMonth = '2'  # 按月扣收
T['CommApiType'] = 'char'  # 通讯API类型
CAPIT_Client = '1'  # 客户端
CAPIT_Server = '2'  # 服务端
CAPIT_UserApi = '3'  # 交易系统的UserApi
T['ServiceID'] = 'int'  # 服务编号
T['ServiceLineNo'] = 'int'  # 服务线路编号
T['ServiceName'] = 'char[61]'  # 服务名
T['LinkStatus'] = 'char'  # 连接状态
LS_Connected = '1'  # 已经连接
LS_Disconnected = '2'  # 没有连接
T['CommApiPointer'] = 'int'  # 通讯API指针
T['PwdFlag'] = 'char'  # 密码核对标志
BPWDF_NoCheck = '0'  # 不核对
BPWDF_BlankCheck = '1'  # 明文核对
BPWDF_EncryptCheck = '2'  # 密文核对
T['SecuAccType'] = 'char'  # 期货帐号类型
SAT_AccountID = '1'  # 资金帐号
SAT_CardID = '2'  # 资金卡号
SAT_SHStockholderID = '3'  # 上海股东帐号
SAT_SZStockholderID = '4'  # 深圳股东帐号
T['TransferStatus'] = 'char'  # 转账交易状态
TRFS_Normal = '0'  # 正常
TRFS_Repealed = '1'  # 被冲正
T['SponsorType'] = 'char'  # 发起方
SPTYPE_Broker = '0'  # 期商
SPTYPE_Bank = '1'  # 银行
T['ReqRspType'] = 'char'  # 请求响应类别
REQRSP_Request = '0'  # 请求
REQRSP_Response = '1'  # 响应
T['FBTUserEventType'] = 'char'  # 银期转帐用户事件类型
FBTUET_SignIn = '0'  # 签到
FBTUET_FromBankToFuture = '1'  # 银行转期货
FBTUET_FromFutureToBank = '2'  # 期货转银行
FBTUET_OpenAccount = '3'  # 开户
FBTUET_CancelAccount = '4'  # 销户
FBTUET_ChangeAccount = '5'  # 变更银行账户
FBTUET_RepealFromBankToFuture = '6'  # 冲正银行转期货
FBTUET_RepealFromFutureToBank = '7'  # 冲正期货转银行
FBTUET_QueryBankAccount = '8'  # 查询银行账户
FBTUET_QueryFutureAccount = '9'  # 查询期货账户
FBTUET_SignOut = 'A'  # 签退
FBTUET_SyncKey = 'B'  # 密钥同步
FBTUET_Other = 'Z'  # 其他
T['BankIDByBank'] = 'char[21]'  # 银行自己的编码
T['BankOperNo'] = 'char[4]'  # 银行操作员号
T['BankCustNo'] = 'char[21]'  # 银行客户号
T['DBOPSeqNo'] = 'int'  # 递增的序列号
T['TableName'] = 'char[61]'  # FBT表名
T['PKName'] = 'char[201]'  # FBT表操作主键名
T['PKValue'] = 'char[501]'  # FBT表操作主键值
T['DBOperation'] = 'char'  # 记录操作类型
DBOP_Insert = '0'  # 插入
DBOP_Update = '1'  # 更新
DBOP_Delete = '2'  # 删除
T['SyncFlag'] = 'char'  # 同步标记
SYNF_Yes = '0'  # 已同步
SYNF_No = '1'  # 未同步
T['TargetID'] = 'char[4]'  # 同步目标编号
T['SyncType'] = 'char'  # 同步类型
SYNT_OneOffSync = '0'  # 一次同步
SYNT_TimerSync = '1'  # 定时同步
SYNT_TimerFullSync = '2'  # 定时完全同步
T['FBETime'] = 'char[7]'  # 各种换汇时间
T['FBEBankNo'] = 'char[13]'  # 换汇银行行号
T['FBECertNo'] = 'char[13]'  # 换汇凭证号
T['ExDirection'] = 'char'  # 换汇方向
FBEDIR_Settlement = '0'  # 结汇
FBEDIR_Sale = '1'  # 售汇
T['FBEBankAccount'] = 'char[33]'  # 换汇银行账户
T['FBEBankAccountName'] = 'char[61]'  # 换汇银行账户名
T['FBEAmt'] = 'double'  # 各种换汇金额
T['FBEBusinessType'] = 'char[3]'  # 换汇业务类型
T['FBEPostScript'] = 'char[61]'  # 换汇附言
T['FBERemark'] = 'char[71]'  # 换汇备注
T['ExRate'] = 'double'  # 换汇汇率
T['FBEResultFlag'] = 'char'  # 换汇成功标志
FBERES_Success = '0'  # 成功
FBERES_InsufficientBalance = '1'  # 账户余额不足
FBERES_UnknownTrading = '8'  # 交易结果未知
FBERES_Fail = 'x'  # 失败
T['FBERtnMsg'] = 'char[61]'  # 换汇返回信息
T['FBEExtendMsg'] = 'char[61]'  # 换汇扩展信息
T['FBEBusinessSerial'] = 'char[31]'  # 换汇记账流水号
T['FBESystemSerial'] = 'char[21]'  # 换汇流水号
T['FBETotalExCnt'] = 'int'  # 换汇交易总笔数
T['FBEExchStatus'] = 'char'  # 换汇交易状态
FBEES_Normal = '0'  # 正常
FBEES_ReExchange = '1'  # 交易重发
T['FBEFileFlag'] = 'char'  # 换汇文件标志
FBEFG_DataPackage = '0'  # 数据包
FBEFG_File = '1'  # 文件
T['FBEAlreadyTrade'] = 'char'  # 换汇已交易标志
FBEAT_NotTrade = '0'  # 未交易
FBEAT_Trade = '1'  # 已交易
T['FBEOpenBank'] = 'char[61]'  # 换汇账户开户行
T['FBEUserEventType'] = 'char'  # 银期换汇用户事件类型
FBEUET_SignIn = '0'  # 签到
FBEUET_Exchange = '1'  # 换汇
FBEUET_ReExchange = '2'  # 换汇重发
FBEUET_QueryBankAccount = '3'  # 银行账户查询
FBEUET_QueryExchDetial = '4'  # 换汇明细查询
FBEUET_QueryExchSummary = '5'  # 换汇汇总查询
FBEUET_QueryExchRate = '6'  # 换汇汇率查询
FBEUET_CheckBankAccount = '7'  # 对账文件通知
FBEUET_SignOut = '8'  # 签退
FBEUET_Other = 'Z'  # 其他
T['FBEFileName'] = 'char[21]'  # 换汇相关文件名
T['FBEBatchSerial'] = 'char[21]'  # 换汇批次号
T['FBEReqFlag'] = 'char'  # 换汇发送标志
FBERF_UnProcessed = '0'  # 未处理
FBERF_WaitSend = '1'  # 等待发送
FBERF_SendSuccess = '2'  # 发送成功
FBERF_SendFailed = '3'  # 发送失败
FBERF_WaitReSend = '4'  # 等待重发
T['NotifyClass'] = 'char'  # 风险通知类型
NC_NOERROR = '0'  # 正常
NC_Warn = '1'  # 警示
NC_Call = '2'  # 追保
NC_Force = '3'  # 强平
NC_CHUANCANG = '4'  # 穿仓
NC_Exception = '5'  # 异常
T['RiskNofityInfo'] = 'char[257]'  # 客户风险通知消息
T['ForceCloseSceneId'] = 'char[24]'  # 强平场景编号
T['ForceCloseType'] = 'char'  # 强平单类型
FCT_Manual = '0'  # 手工强平
FCT_Single = '1'  # 单一投资者辅助强平
FCT_Group = '2'  # 批量投资者辅助强平
T['InstrumentIDs'] = 'char[101]'  # 多个产品代码,用+分隔,如cu+zn
T['RiskNotifyMethod'] = 'char'  # 风险通知途径
RNM_System = '0'  # 系统通知
RNM_SMS = '1'  # 短信通知
RNM_EMail = '2'  # 邮件通知
RNM_Manual = '3'  # 人工通知
T['RiskNotifyStatus'] = 'char'  # 风险通知状态
RNS_NotGen = '0'  # 未生成
RNS_Generated = '1'  # 已生成未发送
RNS_SendError = '2'  # 发送失败
RNS_SendOk = '3'  # 已发送未接收
RNS_Received = '4'  # 已接收未确认
RNS_Confirmed = '5'  # 已确认
T['RiskUserEvent'] = 'char'  # 风控用户操作事件
RUE_ExportData = '0'  # 导出数据
T['ParamID'] = 'int'  # 参数代码
T['ParamName'] = 'char[41]'  # 参数名
T['ParamValue'] = 'char[41]'  # 参数值
T['ConditionalOrderSortType'] = 'char'  # 条件单索引条件
COST_LastPriceAsc = '0'  # 使用最新价升序
COST_LastPriceDesc = '1'  # 使用最新价降序
COST_AskPriceAsc = '2'  # 使用卖价升序
COST_AskPriceDesc = '3'  # 使用卖价降序
COST_BidPriceAsc = '4'  # 使用买价升序
COST_BidPriceDesc = '5'  # 使用买价降序
T['SendType'] = 'char'  # 报送状态
UOAST_NoSend = '0'  # 未发送
UOAST_Sended = '1'  # 已发送
UOAST_Generated = '2'  # 已生成
UOAST_SendFail = '3'  # 报送失败
UOAST_Success = '4'  # 接收成功
UOAST_Fail = '5'  # 接收失败
UOAST_Cancel = '6'  # 取消报送
T['ClientIDStatus'] = 'char'  # 交易编码状态
UOACS_NoApply = '1'  # 未申请
UOACS_Submited = '2'  # 已提交申请
UOACS_Sended = '3'  # 已发送申请
UOACS_Success = '4'  # 完成
UOACS_Refuse = '5'  # 拒绝
UOACS_Cancel = '6'  # 已撤销编码
T['IndustryID'] = 'char[17]'  # 行业编码
T['QuestionID'] = 'char[5]'  # 特有信息编号
T['QuestionContent'] = 'char[41]'  # 特有信息说明
T['OptionID'] = 'char[13]'  # 选项编号
T['OptionContent'] = 'char[61]'  # 选项说明
T['QuestionType'] = 'char'  # 特有信息类型
QT_Radio = '1'  # 单选
QT_Option = '2'  # 多选
QT_Blank = '3'  # 填空
T['ProcessID'] = 'char[33]'  # 业务流水号
T['SeqNo'] = 'int'  # 流水号
T['UOAProcessStatus'] = 'char[3]'  # 流程状态
T['ProcessType'] = 'char[3]'  # 流程功能类型
T['BusinessType'] = 'char'  # 业务类型
BT_Request = '1'  # 请求
BT_Response = '2'  # 应答
BT_Notice = '3'  # 通知
T['CfmmcReturnCode'] = 'char'  # 监控中心返回码
CRC_Success = '0'  # 成功
CRC_Working = '1'  # 该客户已经有流程在处理中
CRC_InfoFail = '2'  # 监控中客户资料检查失败
CRC_IDCardFail = '3'  # 监控中实名制检查失败
CRC_OtherFail = '4'  # 其他错误
T['ExReturnCode'] = 'int'  # 交易所返回码
T['ClientType'] = 'char'  # 客户类型
CfMMCCT_All = '0'  # 所有
CfMMCCT_Person = '1'  # 个人
CfMMCCT_Company = '2'  # 单位
CfMMCCT_Other = '3'  # 其他
CfMMCCT_SpecialOrgan = '4'  # 特殊法人
CfMMCCT_Asset = '5'  # 资管户
T['ExchangeIDType'] = 'char'  # 交易所编号
EIDT_SHFE = 'S'  # 上海期货交易所
EIDT_CZCE = 'Z'  # 郑州商品交易所
EIDT_DCE = 'D'  # 大连商品交易所
EIDT_CFFEX = 'J'  # 中国金融期货交易所
EIDT_INE = 'N'  # 上海国际能源交易中心股份有限公司
T['ExClientIDType'] = 'char'  # 交易编码类型
ECIDT_Hedge = '1'  # 套保
ECIDT_Arbitrage = '2'  # 套利
ECIDT_Speculation = '3'  # 投机
T['ClientClassify'] = 'char[11]'  # 客户分类码
T['UOAOrganType'] = 'char[11]'  # 单位性质
T['UOACountryCode'] = 'char[11]'  # 国家代码
T['AreaCode'] = 'char[11]'  # 区号
T['FuturesID'] = 'char[21]'  # 监控中心为客户分配的代码
T['CffmcDate'] = 'char[11]'  # 日期
T['CffmcTime'] = 'char[11]'  # 时间
T['NocID'] = 'char[21]'  # 组织机构代码
T['UpdateFlag'] = 'char'  # 更新状态
UF_NoUpdate = '0'  # 未更新
UF_Success = '1'  # 更新全部信息成功
UF_Fail = '2'  # 更新全部信息失败
UF_TCSuccess = '3'  # 更新交易编码成功
UF_TCFail = '4'  # 更新交易编码失败
UF_Cancel = '5'  # 已丢弃
T['ApplyOperateID'] = 'char'  # 申请动作
AOID_OpenInvestor = '1'  # 开户
AOID_ModifyIDCard = '2'  # 修改身份信息
AOID_ModifyNoIDCard = '3'  # 修改一般信息
AOID_ApplyTradingCode = '4'  # 申请交易编码
AOID_CancelTradingCode = '5'  # 撤销交易编码
AOID_CancelInvestor = '6'  # 销户
AOID_FreezeAccount = '8'  # 账户休眠
AOID_ActiveFreezeAccount = '9'  # 激活休眠账户
T['ApplyStatusID'] = 'char'  # 申请状态
ASID_NoComplete = '1'  # 未补全
ASID_Submited = '2'  # 已提交
ASID_Checked = '3'  # 已审核
ASID_Refused = '4'  # 已拒绝
ASID_Deleted = '5'  # 已删除
T['SendMethod'] = 'char'  # 发送方式
UOASM_ByAPI = '1'  # 文件发送
UOASM_ByFile = '2'  # 电子发送
T['EventType'] = 'char[33]'  # 业务操作类型
T['EventMode'] = 'char'  # 操作方法
EvM_ADD = '1'  # 增加
EvM_UPDATE = '2'  # 修改
EvM_DELETE = '3'  # 删除
EvM_CHECK = '4'  # 复核
EvM_COPY = '5'  # 复制
EvM_CANCEL = '6'  # 注销
EvM_Reverse = '7'  # 冲销
T['UOAAutoSend'] = 'char'  # 统一开户申请自动发送
UOAA_ASR = '1'  # 自动发送并接收
UOAA_ASNR = '2'  # 自动发送，不自动接收
UOAA_NSAR = '3'  # 不自动发送，自动接收
UOAA_NSR = '4'  # 不自动发送，也不自动接收
T['QueryDepth'] = 'int'  # 查询深度
T['DataCenterID'] = 'int'  # 数据中心代码
T['FlowID'] = 'char'  # 流程ID
EvM_InvestorGroupFlow = '1'  # 投资者对应投资者组设置
EvM_InvestorRate = '2'  # 投资者手续费率设置
EvM_InvestorCommRateModel = '3'  # 投资者手续费率模板关系设置
T['CheckLevel'] = 'char'  # 复核级别
CL_Zero = '0'  # 零级复核
CL_One = '1'  # 一级复核
CL_Two = '2'  # 二级复核
T['CheckNo'] = 'int'  # 操作次数
T['CheckStatus'] = 'char'  # 复核级别
CHS_Init = '0'  # 未复核
CHS_Checking = '1'  # 复核中
CHS_Checked = '2'  # 已复核
CHS_Refuse = '3'  # 拒绝
CHS_Cancel = '4'  # 作废
T['UsedStatus'] = 'char'  # 生效状态
CHU_Unused = '0'  # 未生效
CHU_Used = '1'  # 已生效
CHU_Fail = '2'  # 生效失败
T['RateTemplateName'] = 'char[61]'  # 模型名称
T['PropertyString'] = 'char[2049]'  # 用于查询的投资属性字段
T['BankAcountOrigin'] = 'char'  # 账户来源
BAO_ByAccProperty = '0'  # 手工录入
BAO_ByFBTransfer = '1'  # 银期转账
T['MonthBillTradeSum'] = 'char'  # 结算单月报成交汇总方式
MBTS_ByInstrument = '0'  # 同日同合约
MBTS_ByDayInsPrc = '1'  # 同日同合约同价格
MBTS_ByDayIns = '2'  # 同合约
T['FBTTradeCodeEnum'] = 'char[7]'  # 银期交易代码枚举
FTC_BankLaunchBankToBroker = '102001'  # 银行发起银行转期货
FTC_BrokerLaunchBankToBroker = '202001'  # 期货发起银行转期货
FTC_BankLaunchBrokerToBank = '102002'  # 银行发起期货转银行
FTC_BrokerLaunchBrokerToBank = '202002'  # 期货发起期货转银行
T['RateTemplateID'] = 'char[9]'  # 模型代码
T['RiskRate'] = 'char[21]'  # 风险度
T['Timestamp'] = 'int'  # 时间戳
T['InvestorIDRuleName'] = 'char[61]'  # 号段规则名称
T['InvestorIDRuleExpr'] = 'char[513]'  # 号段规则表达式
T['LastDrift'] = 'int'  # 上次OTP漂移值
T['LastSuccess'] = 'int'  # 上次OTP成功值
T['AuthKey'] = 'char[41]'  # 令牌密钥
T['SerialNumber'] = 'char[17]'  # 序列号
T['OTPType'] = 'char'  # 动态令牌类型
OTP_NONE = '0'  # 无动态令牌
OTP_TOTP = '1'  # 时间令牌
T['OTPVendorsID'] = 'char[2]'  # 动态令牌提供商
T['OTPVendorsName'] = 'char[61]'  # 动态令牌提供商名称
T['OTPStatus'] = 'char'  # 动态令牌状态
OTPS_Unused = '0'  # 未使用
OTPS_Used = '1'  # 已使用
OTPS_Disuse = '2'  # 注销
T['BrokerUserType'] = 'char'  # 经济公司用户类型
BUT_Investor = '1'  # 投资者
BUT_BrokerUser = '2'  # 操作员
T['FutureType'] = 'char'  # 期货类型
FUTT_Commodity = '1'  # 商品期货
FUTT_Financial = '2'  # 金融期货
T['FundEventType'] = 'char'  # 资金管理操作类型
FET_Restriction = '0'  # 转账限额
FET_TodayRestriction = '1'  # 当日转账限额
FET_Transfer = '2'  # 期商流水
FET_Credit = '3'  # 资金冻结
FET_InvestorWithdrawAlm = '4'  # 投资者可提资金比例
FET_BankRestriction = '5'  # 单个银行帐户转账限额
FET_Accountregister = '6'  # 银期签约账户
FET_ExchangeFundIO = '7'  # 交易所出入金
FET_InvestorFundIO = '8'  # 投资者出入金
T['AccountSourceType'] = 'char'  # 资金账户来源
AST_FBTransfer = '0'  # 银期同步
AST_ManualEntry = '1'  # 手工录入
T['CodeSourceType'] = 'char'  # 交易编码来源
CST_UnifyAccount = '0'  # 统一开户(已规范)
CST_ManualEntry = '1'  # 手工录入(未规范)
T['UserRange'] = 'char'  # 操作员范围
UR_All = '0'  # 所有
UR_Single = '1'  # 单一操作员
T['TimeSpan'] = 'char[9]'  # 时间跨度
T['ImportSequenceID'] = 'char[17]'  # 动态令牌导入批次编号
T['ByGroup'] = 'char'  # 交易统计表按客户统计方式
BG_Investor = '2'  # 按投资者统计
BG_Group = '1'  # 按类统计
T['TradeSumStatMode'] = 'char'  # 交易统计表按范围统计方式
TSSM_Instrument = '1'  # 按合约统计
TSSM_Product = '2'  # 按产品统计
TSSM_Exchange = '3'  # 按交易所统计
T['ComType'] = 'int'  # 组合成交类型
T['UserProductID'] = 'char[33]'  # 产品标识
T['UserProductName'] = 'char[65]'  # 产品名称
T['UserProductMemo'] = 'char[129]'  # 产品说明
T['CSRCCancelFlag'] = 'char[2]'  # 新增或变更标志
T['CSRCDate'] = 'char[11]'  # 日期
T['CSRCInvestorName'] = 'char[201]'  # 客户名称
T['CSRCOpenInvestorName'] = 'char[101]'  # 客户名称
T['CSRCInvestorID'] = 'char[13]'  # 客户代码
T['CSRCIdentifiedCardNo'] = 'char[51]'  # 证件号码
T['CSRCClientID'] = 'char[11]'  # 交易编码
T['CSRCBankFlag'] = 'char[3]'  # 银行标识
T['CSRCBankAccount'] = 'char[23]'  # 银行账户
T['CSRCOpenName'] = 'char[401]'  # 开户人
T['CSRCMemo'] = 'char[101]'  # 说明
T['CSRCTime'] = 'char[11]'  # 时间
T['CSRCTradeID'] = 'char[21]'  # 成交流水号
T['CSRCExchangeInstID'] = 'char[31]'  # 合约代码
T['CSRCMortgageName'] = 'char[7]'  # 质押品名称
T['CSRCReason'] = 'char[3]'  # 事由
T['IsSettlement'] = 'char[2]'  # 是否为非结算会员
T['CSRCMoney'] = 'double'  # 资金
T['CSRCPrice'] = 'double'  # 价格
T['CSRCOptionsType'] = 'char[2]'  # 期权类型
T['CSRCStrikePrice'] = 'double'  # 执行价
T['CSRCTargetProductID'] = 'char[3]'  # 标的品种
T['CSRCTargetInstrID'] = 'char[31]'  # 标的合约
T['CommModelName'] = 'char[161]'  # 手续费率模板名称
T['CommModelMemo'] = 'char[1025]'  # 手续费率模板备注
T['ExprSetMode'] = 'char'  # 日期表达式设置类型
ESM_Relative = '1'  # 相对已有规则设置
ESM_Typical = '2'  # 典型设置
T['RateInvestorRange'] = 'char'  # 投资者范围
RIR_All = '1'  # 公司标准
RIR_Model = '2'  # 模板
RIR_Single = '3'  # 单一投资者
T['AgentBrokerID'] = 'char[13]'  # 代理经纪公司代码
T['DRIdentityID'] = 'int'  # 交易中心代码
T['DRIdentityName'] = 'char[65]'  # 交易中心名称
T['DBLinkID'] = 'char[31]'  # DBLink标识号
T['SyncDataStatus'] = 'char'  # 主次用系统数据同步状态
SDS_Initialize = '0'  # 未同步
SDS_Settlementing = '1'  # 同步中
SDS_Settlemented = '2'  # 已同步
T['TradeSource'] = 'char'  # 成交来源
TSRC_NORMAL = '0'  # 来自交易所普通回报
TSRC_QUERY = '1'  # 来自查询
T['FlexStatMode'] = 'char'  # 产品合约统计方式
FSM_Product = '1'  # 产品统计
FSM_Exchange = '2'  # 交易所统计
FSM_All = '3'  # 统计所有
T['ByInvestorRange'] = 'char'  # 投资者范围统计方式
BIR_Property = '1'  # 属性统计
BIR_All = '2'  # 统计所有
T['SRiskRate'] = 'char[21]'  # 风险度
T['SequenceNo12'] = 'int'  # 序号
T['PropertyInvestorRange'] = 'char'  # 投资者范围
PIR_All = '1'  # 所有
PIR_Property = '2'  # 投资者属性
PIR_Single = '3'  # 单一投资者
T['FileStatus'] = 'char'  # 文件状态
FIS_NoCreate = '0'  # 未生成
FIS_Created = '1'  # 已生成
FIS_Failed = '2'  # 生成失败
T['FileGenStyle'] = 'char'  # 文件生成方式
FGS_FileTransmit = '0'  # 下发
FGS_FileGen = '1'  # 生成
T['SysOperMode'] = 'char'  # 系统日志操作方法
SoM_Add = '1'  # 增加
SoM_Update = '2'  # 修改
SoM_Delete = '3'  # 删除
SoM_Copy = '4'  # 复制
SoM_AcTive = '5'  # 激活
SoM_CanCel = '6'  # 注销
SoM_ReSet = '7'  # 重置
T['SysOperType'] = 'char'  # 系统日志操作类型
SoT_UpdatePassword = '0'  # 修改操作员密码
SoT_UserDepartment = '1'  # 操作员组织架构关系
SoT_RoleManager = '2'  # 角色管理
SoT_RoleFunction = '3'  # 角色功能设置
SoT_BaseParam = '4'  # 基础参数设置
SoT_SetUserID = '5'  # 设置操作员
SoT_SetUserRole = '6'  # 用户角色设置
SoT_UserIpRestriction = '7'  # 用户IP限制
SoT_DepartmentManager = '8'  # 组织架构管理
SoT_DepartmentCopy = '9'  # 组织架构向查询分类复制
SoT_Tradingcode = 'A'  # 交易编码管理
SoT_InvestorStatus = 'B'  # 投资者状态维护
SoT_InvestorAuthority = 'C'  # 投资者权限管理
SoT_PropertySet = 'D'  # 属性设置
SoT_ReSetInvestorPasswd = 'E'  # 重置投资者密码
SoT_InvestorPersonalityInfo = 'F'  # 投资者个性信息维护
T['CSRCDataQueyType'] = 'char'  # 上报数据查询类型
CSRCQ_Current = '0'  # 查询当前交易日报送的数据
CSRCQ_History = '1'  # 查询历史报送的代理经纪公司的数据
T['FreezeStatus'] = 'char'  # 休眠状态
FRS_Normal = '1'  # 活跃
FRS_Freeze = '0'  # 休眠
T['StandardStatus'] = 'char'  # 规范状态
STST_Standard = '0'  # 已规范
STST_NonStandard = '1'  # 未规范
T['CSRCFreezeStatus'] = 'char[2]'  # 休眠状态
T['RightParamType'] = 'char'  # 配置类型
RPT_Freeze = '1'  # 休眠户
RPT_FreezeActive = '2'  # 激活休眠户
RPT_OpenLimit = '3'  # 开仓权限限制
RPT_RelieveOpenLimit = '4'  # 解除开仓权限限制
T['RightTemplateID'] = 'char[9]'  # 模板代码
T['RightTemplateName'] = 'char[61]'  # 模板名称
T['DataStatus'] = 'char'  # 反洗钱审核表数据状态
AMLDS_Normal = '0'  # 正常
AMLDS_Deleted = '1'  # 已删除
T['AMLCheckStatus'] = 'char'  # 审核状态
AMLCHS_Init = '0'  # 未复核
AMLCHS_Checking = '1'  # 复核中
AMLCHS_Checked = '2'  # 已复核
AMLCHS_RefuseReport = '3'  # 拒绝上报
T['AmlDateType'] = 'char'  # 日期类型
AMLDT_DrawDay = '0'  # 检查日期
AMLDT_TouchDay = '1'  # 发生日期
T['AmlCheckLevel'] = 'char'  # 审核级别
AMLCL_CheckLevel0 = '0'  # 零级审核
AMLCL_CheckLevel1 = '1'  # 一级审核
AMLCL_CheckLevel2 = '2'  # 二级审核
AMLCL_CheckLevel3 = '3'  # 三级审核
T['AmlCheckFlow'] = 'char[2]'  # 反洗钱数据抽取审核流程
T['DataType'] = 'char[129]'  # 数据类型
T['ExportFileType'] = 'char'  # 导出文件类型
EFT_CSV = '0'  # CSV
EFT_EXCEL = '1'  # Excel
EFT_DBF = '2'  # DBF
T['SettleManagerType'] = 'char'  # 结算配置类型
SMT_Before = '1'  # 结算前准备
SMT_Settlement = '2'  # 结算
SMT_After = '3'  # 结算后核对
SMT_Settlemented = '4'  # 结算后处理
T['SettleManagerID'] = 'char[33]'  # 结算配置代码
T['SettleManagerName'] = 'char[129]'  # 结算配置名称
T['SettleManagerLevel'] = 'char'  # 结算配置等级
SML_Must = '1'  # 必要
SML_Alarm = '2'  # 警告
SML_Prompt = '3'  # 提示
SML_Ignore = '4'  # 不检查
T['SettleManagerGroup'] = 'char'  # 模块分组
SMG_Exhcange = '1'  # 交易所核对
SMG_ASP = '2'  # 内部核对
SMG_CSRC = '3'  # 上报数据核对
T['CheckResultMemo'] = 'char[1025]'  # 核对结果说明
T['FunctionUrl'] = 'char[1025]'  # 功能链接
T['AuthInfo'] = 'char[129]'  # 客户端认证信息
T['AuthCode'] = 'char[17]'  # 客户端认证码
T['LimitUseType'] = 'char'  # 保值额度使用类型
LUT_Repeatable = '1'  # 可重复使用
LUT_Unrepeatable = '2'  # 不可重复使用
T['DataResource'] = 'char'  # 数据来源
DAR_Settle = '1'  # 本系统
DAR_Exchange = '2'  # 交易所
DAR_CSRC = '3'  # 报送数据
T['MarginType'] = 'char'  # 保证金类型
MGT_ExchMarginRate = '0'  # 交易所保证金率
MGT_InstrMarginRate = '1'  # 投资者保证金率
MGT_InstrMarginRateTrade = '2'  # 投资者交易保证金率
T['ActiveType'] = 'char'  # 生效类型
ACT_Intraday = '1'  # 仅当日生效
ACT_Long = '2'  # 长期生效
T['MarginRateType'] = 'char'  # 冲突保证金率类型
MRT_Exchange = '1'  # 交易所保证金率
MRT_Investor = '2'  # 投资者保证金率
MRT_InvestorTrade = '3'  # 投资者交易保证金率
T['BackUpStatus'] = 'char'  # 备份数据状态
BUS_UnBak = '0'  # 未生成备份数据
BUS_BakUp = '1'  # 备份数据生成中
BUS_BakUped = '2'  # 已生成备份数据
BUS_BakFail = '3'  # 备份数据失败
T['InitSettlement'] = 'char'  # 结算初始化状态
SIS_UnInitialize = '0'  # 结算初始化未开始
SIS_Initialize = '1'  # 结算初始化中
SIS_Initialized = '2'  # 结算初始化完成
T['ReportStatus'] = 'char'  # 报表数据生成状态
SRS_NoCreate = '0'  # 未生成报表数据
SRS_Create = '1'  # 报表数据生成中
SRS_Created = '2'  # 已生成报表数据
SRS_CreateFail = '3'  # 生成报表数据失败
T['SaveStatus'] = 'char'  # 数据归档状态
SSS_UnSaveData = '0'  # 归档未完成
SSS_SaveDatad = '1'  # 归档完成
T['SettArchiveStatus'] = 'char'  # 结算确认数据归档状态
SAS_UnArchived = '0'  # 未归档数据
SAS_Archiving = '1'  # 数据归档中
SAS_Archived = '2'  # 已归档数据
SAS_ArchiveFail = '3'  # 归档数据失败
T['CTPType'] = 'char'  # CTP交易系统类型
CTPT_Unkown = '0'  # 未知类型
CTPT_MainCenter = '1'  # 主中心
CTPT_BackUp = '2'  # 备中心
T['ToolID'] = 'char[9]'  # 工具代码
T['ToolName'] = 'char[81]'  # 工具名称
T['CloseDealType'] = 'char'  # 平仓处理类型
CDT_Normal = '0'  # 正常
CDT_SpecFirst = '1'  # 投机平仓优先
T['MortgageFundUseRange'] = 'char'  # 货币质押资金可用范围
MFUR_None = '0'  # 不能使用
MFUR_Margin = '1'  # 用于保证金
MFUR_All = '2'  # 用于手续费、盈亏、保证金
T['CurrencyUnit'] = 'double'  # 币种单位数量
T['ExchangeRate'] = 'double'  # 汇率
T['SpecProductType'] = 'char'  # 特殊产品类型
SPT_CzceHedge = '1'  # 郑商所套保产品
SPT_IneForeignCurrency = '2'  # 货币质押产品
SPT_DceOpenClose = '3'  # 大连短线开平仓产品
T['FundMortgageType'] = 'char'  # 货币质押类型
FMT_Mortgage = '1'  # 质押
FMT_Redemption = '2'  # 解质
T['AccountSettlementParamID'] = 'char'  # 投资者账户结算参数代码
ASPI_BaseMargin = '1'  # 基础保证金
ASPI_LowestInterest = '2'  # 最低权益标准
T['CurrencyName'] = 'char[31]'  # 币种名称
T['CurrencySign'] = 'char[4]'  # 币种符号
T['FundMortDirection'] = 'char'  # 货币质押方向
FMD_In = '1'  # 货币质入
FMD_Out = '2'  # 货币质出
T['BusinessClass'] = 'char'  # 换汇类别
BT_Profit = '0'  # 盈利
BT_Loss = '1'  # 亏损
BT_Other = 'Z'  # 其他
T['SwapSourceType'] = 'char'  # 换汇数据来源
SST_Manual = '0'  # 手工
SST_Automatic = '1'  # 自动生成
T['CurrExDirection'] = 'char'  # 换汇类型
CED_Settlement = '0'  # 结汇
CED_Sale = '1'  # 售汇
T['CurrencySwapStatus'] = 'char'  # 申请状态
CSS_Entry = '1'  # 已录入
CSS_Approve = '2'  # 已审核
CSS_Refuse = '3'  # 已拒绝
CSS_Revoke = '4'  # 已撤销
CSS_Send = '5'  # 已发送
CSS_Success = '6'  # 换汇成功
CSS_Failure = '7'  # 换汇失败
T['CurrExchCertNo'] = 'char[13]'  # 凭证号
T['BatchSerialNo'] = 'char[21]'  # 批次号
T['ReqFlag'] = 'char'  # 换汇发送标志
REQF_NoSend = '0'  # 未发送
REQF_SendSuccess = '1'  # 发送成功
REQF_SendFailed = '2'  # 发送失败
REQF_WaitReSend = '3'  # 等待重发
T['ResFlag'] = 'char'  # 换汇返回成功标志
RESF_Success = '0'  # 成功
RESF_InsuffiCient = '1'  # 账户余额不足
RESF_UnKnown = '8'  # 交易结果未知
T['PageControl'] = 'char[2]'  # 换汇页面控制
T['RecordCount'] = 'int'  # 记录数
T['CurrencySwapMemo'] = 'char[101]'  # 换汇需确认信息
T['ExStatus'] = 'char'  # 修改状态
EXS_Before = '0'  # 修改前
EXS_After = '1'  # 修改后
T['ClientRegion'] = 'char'  # 开户客户地域
CR_Domestic = '1'  # 国内客户
CR_GMT = '2'  # 港澳台客户
CR_Foreign = '3'  # 国外客户
T['WorkPlace'] = 'char[101]'  # 工作单位
T['BusinessPeriod'] = 'char[21]'  # 经营期限
T['WebSite'] = 'char[101]'  # 网址
T['UOAIdCardType'] = 'char[3]'  # 统一开户证件类型
T['ClientMode'] = 'char[3]'  # 开户模式
T['InvestorFullName'] = 'char[101]'  # 投资者全称
T['UOABrokerID'] = 'char[11]'  # 境外中介机构ID
T['UOAZipCode'] = 'char[11]'  # 邮政编码
T['UOAEMail'] = 'char[101]'  # 电子邮箱
T['OldCity'] = 'char[41]'  # 城市
T['CorporateIdentifiedCardNo'] = 'char[101]'  # 法人代表证件号码
T['HasBoard'] = 'char'  # 是否有董事会
HB_No = '0'  # 没有
HB_Yes = '1'  # 有
T['StartMode'] = 'char'  # 启动模式
SM_Normal = '1'  # 正常
SM_Emerge = '2'  # 应急
SM_Restore = '3'  # 恢复
T['TemplateType'] = 'char'  # 模型类型
TPT_Full = '1'  # 全量
TPT_Increment = '2'  # 增量
TPT_BackUp = '3'  # 备份
T['LoginMode'] = 'char'  # 登录模式
LM_Trade = '0'  # 交易
LM_Transfer = '1'  # 转账
T['PromptType'] = 'char'  # 日历提示类型
CPT_Instrument = '1'  # 合约上下市
CPT_Margin = '2'  # 保证金分段生效
T['LedgerManageID'] = 'char[51]'  # 分户管理资产编码
T['InvestVariety'] = 'char[101]'  # 投资品种
T['BankAccountType'] = 'char[2]'  # 账户类别
T['LedgerManageBank'] = 'char[101]'  # 开户银行
T['CffexDepartmentName'] = 'char[101]'  # 开户营业部
T['CffexDepartmentCode'] = 'char[9]'  # 营业部代码
T['HasTrustee'] = 'char'  # 是否有托管人
HT_Yes = '1'  # 有
HT_No = '0'  # 没有
T['CSRCMemo1'] = 'char[41]'  # 说明
T['AssetmgrCFullName'] = 'char[101]'  # 代理资产管理业务的期货公司全称
T['AssetmgrApprovalNO'] = 'char[51]'  # 资产管理业务批文号
T['AssetmgrMgrName'] = 'char[401]'  # 资产管理业务负责人姓名
T['AmType'] = 'char'  # 机构类型
AMT_Bank = '1'  # 银行
AMT_Securities = '2'  # 证券公司
AMT_Fund = '3'  # 基金公司
AMT_Insurance = '4'  # 保险公司
AMT_Trust = '5'  # 信托公司
AMT_Other = '9'  # 其他
T['CSRCAmType'] = 'char[5]'  # 机构类型
T['CSRCFundIOType'] = 'char'  # 出入金类型
CFIOT_FundIO = '0'  # 出入金
CFIOT_SwapCurrency = '1'  # 银期换汇
T['CusAccountType'] = 'char'  # 结算账户类型
CAT_Futures = '1'  # 期货结算账户
CAT_AssetmgrFuture = '2'  # 纯期货资管业务下的资管结算账户
CAT_AssetmgrTrustee = '3'  # 综合类资管业务下的期货资管托管账户
CAT_AssetmgrTransfer = '4'  # 综合类资管业务下的资金中转账户
T['CSRCNational'] = 'char[4]'  # 国籍
T['CSRCSecAgentID'] = 'char[11]'  # 二级代理ID
T['LanguageType'] = 'char'  # 通知语言类型
LT_Chinese = '1'  # 中文
LT_English = '2'  # 英文
T['AmAccount'] = 'char[23]'  # 投资账户
T['AssetmgrClientType'] = 'char'  # 资产管理客户类型
AMCT_Person = '1'  # 个人资管客户
AMCT_Organ = '2'  # 单位资管客户
AMCT_SpecialOrgan = '4'  # 特殊单位资管客户
T['AssetmgrType'] = 'char'  # 投资类型
ASST_Futures = '3'  # 期货类
ASST_SpecialOrgan = '4'  # 综合类
T['UOM'] = 'char[11]'  # 计量单位
T['SHFEInstLifePhase'] = 'char[3]'  # 上期所合约生命周期状态
T['SHFEProductClass'] = 'char[11]'  # 产品类型
T['PriceDecimal'] = 'char[2]'  # 价格小数位
T['InTheMoneyFlag'] = 'char[2]'  # 平值期权标志
T['CheckInstrType'] = 'char'  # 合约比较类型
CIT_HasExch = '0'  # 合约交易所不存在
CIT_HasATP = '1'  # 合约本系统不存在
CIT_HasDiff = '2'  # 合约比较不一致
T['DeliveryType'] = 'char'  # 交割类型
DT_HandDeliv = '1'  # 手工交割
DT_PersonDeliv = '2'  # 到期交割
T['BigMoney'] = 'double'  # 资金
T['MaxMarginSideAlgorithm'] = 'char'  # 大额单边保证金算法
MMSA_NO = '0'  # 不使用大额单边保证金算法
MMSA_YES = '1'  # 使用大额单边保证金算法
T['DAClientType'] = 'char'  # 资产管理客户类型
CACT_Person = '0'  # 自然人
CACT_Company = '1'  # 法人
CACT_Other = '2'  # 其他
T['CombinInstrID'] = 'char[61]'  # 套利合约代码
T['CombinSettlePrice'] = 'char[61]'  # 各腿结算价
T['DCEPriority'] = 'int'  # 优先级
T['TradeGroupID'] = 'int'  # 成交组号
T['IsCheckPrepa'] = 'int'  # 是否校验开户可用资金
T['UOAAssetmgrType'] = 'char'  # 投资类型
UOAAT_Futures = '1'  # 期货类
UOAAT_SpecialOrgan = '2'  # 综合类
T['DirectionEn'] = 'char'  # 买卖方向
DEN_Buy = '0'  # Buy
DEN_Sell = '1'  # Sell
T['OffsetFlagEn'] = 'char'  # 开平标志
OFEN_Open = '0'  # Position Opening
OFEN_Close = '1'  # Position Close
OFEN_ForceClose = '2'  # Forced Liquidation
OFEN_CloseToday = '3'  # Close Today
OFEN_CloseYesterday = '4'  # Close Prev.
OFEN_ForceOff = '5'  # Forced Reduction
OFEN_LocalForceClose = '6'  # Local Forced Liquidation
T['HedgeFlagEn'] = 'char'  # 投机套保标志
HFEN_Speculation = '1'  # Speculation
HFEN_Arbitrage = '2'  # Arbitrage
HFEN_Hedge = '3'  # Hedge
T['FundIOTypeEn'] = 'char'  # 出入金类型
FIOTEN_FundIO = '1'  # Deposit/Withdrawal
FIOTEN_Transfer = '2'  # Bank-Futures Transfer
FIOTEN_SwapCurrency = '3'  # Bank-Futures FX Exchange
T['FundTypeEn'] = 'char'  # 资金类型
FTEN_Deposite = '1'  # Bank Deposit
FTEN_ItemFund = '2'  # Payment/Fee
FTEN_Company = '3'  # Brokerage Adj
FTEN_InnerTransfer = '4'  # Internal Transfer
T['FundDirectionEn'] = 'char'  # 出入金方向
FDEN_In = '1'  # Deposit
FDEN_Out = '2'  # Withdrawal
T['FundMortDirectionEn'] = 'char'  # 货币质押方向
FMDEN_In = '1'  # Pledge
FMDEN_Out = '2'  # Redemption
T['SwapBusinessType'] = 'char[3]'  # 换汇业务种类
T['OptionsType'] = 'char'  # 期权类型
CP_CallOptions = '1'  # 看涨
CP_PutOptions = '2'  # 看跌
T['StrikeMode'] = 'char'  # 执行方式
STM_Continental = '0'  # 欧式
STM_American = '1'  # 美式
STM_Bermuda = '2'  # 百慕大
T['StrikeType'] = 'char'  # 执行类型
STT_Hedge = '0'  # 自身对冲
STT_Match = '1'  # 匹配执行
T['ApplyType'] = 'char'  # 中金所期权放弃执行申请类型
APPT_NotStrikeNum = '4'  # 不执行数量
T['GiveUpDataSource'] = 'char'  # 放弃执行申请数据来源
GUDS_Gen = '0'  # 系统生成
GUDS_Hand = '1'  # 手工添加
T['ExecOrderSysID'] = 'char[21]'  # 执行宣告系统编号
T['ExecResult'] = 'char'  # 执行结果
OER_NoExec = 'n'  # 没有执行
OER_Canceled = 'c'  # 已经取消
OER_OK = '0'  # 执行成功
OER_NoPosition = '1'  # 期权持仓不够
OER_NoDeposit = '2'  # 资金不够
OER_NoParticipant = '3'  # 会员不存在
OER_NoClient = '4'  # 客户不存在
OER_NoInstrument = '6'  # 合约不存在
OER_NoRight = '7'  # 没有执行权限
OER_InvalidVolume = '8'  # 不合理的数量
OER_NoEnoughHistoryTrade = '9'  # 没有足够的历史成交
OER_Unknown = 'a'  # 未知
T['StrikeSequence'] = 'int'  # 执行序号
T['StrikeTime'] = 'char[13]'  # 执行时间
T['CombinationType'] = 'char'  # 组合类型
COMBT_Future = '0'  # 期货组合
COMBT_BUL = '1'  # 垂直价差BUL
COMBT_BER = '2'  # 垂直价差BER
COMBT_STD = '3'  # 跨式组合
COMBT_STG = '4'  # 宽跨式组合
COMBT_PRT = '5'  # 备兑组合
COMBT_CLD = '6'  # 时间价差组合
T['OptionRoyaltyPriceType'] = 'char'  # 期权权利金价格类型
ORPT_PreSettlementPrice = '1'  # 昨结算价
ORPT_OpenPrice = '4'  # 开仓价
T['BalanceAlgorithm'] = 'char'  # 权益算法
BLAG_Default = '1'  # 不计算期权市值盈亏
BLAG_IncludeOptValLost = '2'  # 计算期权市值亏损
T['ActionType'] = 'char'  # 执行类型
ACTP_Exec = '1'  # 执行
ACTP_Abandon = '2'  # 放弃
T['ForQuoteStatus'] = 'char'  # 询价状态
FQST_Submitted = 'a'  # 已经提交
FQST_Accepted = 'b'  # 已经接受
FQST_Rejected = 'c'  # 已经被拒绝
T['ValueMethod'] = 'char'  # 取值方式
VM_Absolute = '0'  # 按绝对值
VM_Ratio = '1'  # 按比率
T['ExecOrderPositionFlag'] = 'char'  # 期权行权后是否保留期货头寸的标记
EOPF_Reserve = '0'  # 保留
EOPF_UnReserve = '1'  # 不保留
T['ExecOrderCloseFlag'] = 'char'  # 期权行权后生成的头寸是否自动平仓
EOCF_AutoClose = '0'  # 自动平仓
EOCF_NotToClose = '1'  # 免于自动平仓
T['ProductType'] = 'char'  # 产品类型
PTE_Futures = '1'  # 期货
PTE_Options = '2'  # 期权
T['CZCEUploadFileName'] = 'char'  # 郑商所结算文件名
CUFN_CUFN_O = 'O'  # ^\d{8}_zz_\d{4}
CUFN_CUFN_T = 'T'  # ^\d{8}成交表
CUFN_CUFN_P = 'P'  # ^\d{8}单腿持仓表new
CUFN_CUFN_N = 'N'  # ^\d{8}非平仓了结表
CUFN_CUFN_L = 'L'  # ^\d{8}平仓表
CUFN_CUFN_F = 'F'  # ^\d{8}资金表
CUFN_CUFN_C = 'C'  # ^\d{8}组合持仓表
CUFN_CUFN_M = 'M'  # ^\d{8}保证金参数表
T['DCEUploadFileName'] = 'char'  # 大商所结算文件名
DUFN_DUFN_O = 'O'  # ^\d{8}_dl_\d{3}
DUFN_DUFN_T = 'T'  # ^\d{8}_成交表
DUFN_DUFN_P = 'P'  # ^\d{8}_持仓表
DUFN_DUFN_F = 'F'  # ^\d{8}_资金结算表
DUFN_DUFN_C = 'C'  # ^\d{8}_优惠组合持仓明细表
DUFN_DUFN_D = 'D'  # ^\d{8}_持仓明细表
DUFN_DUFN_M = 'M'  # ^\d{8}_保证金参数表
DUFN_DUFN_S = 'S'  # ^\d{8}_期权执行表
T['SHFEUploadFileName'] = 'char'  # 上期所结算文件名
SUFN_SUFN_O = 'O'  # ^\d{4}_\d{8}_\d{8}_DailyFundChg
SUFN_SUFN_T = 'T'  # ^\d{4}_\d{8}_\d{8}_Trade
SUFN_SUFN_P = 'P'  # ^\d{4}_\d{8}_\d{8}_SettlementDetail
SUFN_SUFN_F = 'F'  # ^\d{4}_\d{8}_\d{8}_Capital
T['CFFEXUploadFileName'] = 'char'  # 中金所结算文件名
CFUFN_SUFN_T = 'T'  # ^\d{4}_SG\d{1}_\d{8}_\d{1}_Trade
CFUFN_SUFN_P = 'P'  # ^\d{4}_SG\d{1}_\d{8}_\d{1}_SettlementDetail
CFUFN_SUFN_F = 'F'  # ^\d{4}_SG\d{1}_\d{8}_\d{1}_Capital
CFUFN_SUFN_S = 'S'  # ^\d{4}_SG\d{1}_\d{8}_\d{1}_OptionExec
T['CombDirection'] = 'char'  # 组合指令方向
CMDR_Comb = '0'  # 申请组合
CMDR_UnComb = '1'  # 申请拆分


error = {
    'NONE': 0, 0: 'CTP:正确', 'INVALID_DATA_SYNC_STATUS': 1, 1: 'CTP:不在已同步状态', 'INCONSISTENT_INFORMATION': 2,
    2: 'CTP:会话信息不一致', 'INVALID_LOGIN': 3, 3: 'CTP:不合法的登录', 'USER_NOT_ACTIVE': 4, 4: 'CTP:用户不活跃',
    'DUPLICATE_LOGIN': 5, 5: 'CTP:重复的登录', 'NOT_LOGIN_YET': 6, 6: 'CTP:还没有登录', 'NOT_INITED': 7, 7: 'CTP:还没有初始化',
    'FRONT_NOT_ACTIVE': 8, 8: 'CTP:前置不活跃', 'NO_PRIVILEGE': 9, 9: 'CTP:无此权限', 'CHANGE_OTHER_PASSWORD': 10,
    10: 'CTP:修改别人的口令', 'USER_NOT_FOUND': 11, 11: 'CTP:找不到该用户', 'BROKER_NOT_FOUND': 12, 12: 'CTP:找不到该经纪公司',
    'INVESTOR_NOT_FOUND': 13, 13: 'CTP:找不到投资者', 'OLD_PASSWORD_MISMATCH': 14, 14: 'CTP:原口令不匹配', 'BAD_FIELD': 15,
    15: 'CTP:报单字段有误', 'INSTRUMENT_NOT_FOUND': 16, 16: 'CTP:找不到合约', 'INSTRUMENT_NOT_TRADING': 17, 17: 'CTP:合约不能交易',
    'NOT_EXCHANGE_PARTICIPANT': 18, 18: 'CTP:经纪公司不是交易所的会员', 'INVESTOR_NOT_ACTIVE': 19, 19: 'CTP:投资者不活跃',
    'NOT_EXCHANGE_CLIENT': 20, 20: 'CTP:投资者未在交易所开户', 'NO_VALID_TRADER_AVAILABLE': 21, 21: 'CTP:该交易席位未连接到交易所',
    'DUPLICATE_ORDER_REF': 22, 22: 'CTP:报单错误：不允许重复报单', 'BAD_ORDER_ACTION_FIELD': 23, 23: 'CTP:错误的报单操作字段',
    'DUPLICATE_ORDER_ACTION_REF': 24, 24: 'CTP:撤单已报送，不允许重复撤单', 'ORDER_NOT_FOUND': 25, 25: 'CTP:撤单找不到相应报单',
    'INSUITABLE_ORDER_STATUS': 26, 26: 'CTP:报单已全成交或已撤销，不能再撤', 'UNSUPPORTED_FUNCTION': 27, 27: 'CTP:不支持的功能',
    'NO_TRADING_RIGHT': 28, 28: 'CTP:没有报单交易权限', 'CLOSE_ONLY': 29, 29: 'CTP:只能平仓', 'OVER_CLOSE_POSITION': 30,
    30: 'CTP:平仓量超过持仓量', 'INSUFFICIENT_MONEY': 31, 31: 'CTP:资金不足', 'DUPLICATE_PK': 32, 32: 'CTP:主键重复',
    'CANNOT_FIND_PK': 33, 33: 'CTP:找不到主键', 'CAN_NOT_INACTIVE_BROKER': 34, 34: 'CTP:设置经纪公司不活跃状态失败',
    'BROKER_SYNCHRONIZING': 35, 35: 'CTP:经纪公司正在同步', 'BROKER_SYNCHRONIZED': 36, 36: 'CTP:经纪公司已同步', 'SHORT_SELL': 37,
    37: 'CTP:现货交易不能卖空', 'INVALID_SETTLEMENT_REF': 38, 38: 'CTP:不合法的结算引用', 'CFFEX_NETWORK_ERROR': 39,
    39: 'CTP:交易所网络连接失败', 'CFFEX_OVER_REQUEST': 40, 40: 'CTP:交易所未处理请求超过许可数', 'CFFEX_OVER_REQUEST_PER_SECOND': 41,
    41: 'CTP:交易所每秒发送请求数超过许可数', 'SETTLEMENT_INFO_NOT_CONFIRMED': 42, 42: 'CTP:结算结果未确认', 'DEPOSIT_NOT_FOUND': 43,
    43: 'CTP:没有对应的入金记录', 'EXCHANG_TRADING': 44, 44: 'CTP:交易所已经进入连续交易状态', 'PARKEDORDER_NOT_FOUND': 45,
    45: 'CTP:找不到预埋（撤单）单', 'PARKEDORDER_HASSENDED': 46, 46: 'CTP:预埋（撤单）单已经发送', 'PARKEDORDER_HASDELETE': 47,
    47: 'CTP:预埋（撤单）单已经删除', 'INVALID_INVESTORIDORPASSWORD': 48, 48: 'CTP:无效的投资者或者密码', 'INVALID_LOGIN_IPADDRESS': 49,
    49: 'CTP:不合法的登录IP地址', 'OVER_CLOSETODAY_POSITION': 50, 50: 'CTP:平今仓位不足', 'OVER_CLOSEYESTERDAY_POSITION': 51,
    51: 'CTP:平昨仓位不足', 'BROKER_NOT_ENOUGH_CONDORDER': 52, 52: 'CTP:经纪公司没有足够可用的条件单数量',
    'INVESTOR_NOT_ENOUGH_CONDORDER': 53, 53: 'CTP:投资者没有足够可用的条件单数量', 'BROKER_NOT_SUPPORT_CONDORDER': 54,
    54: 'CTP:经纪公司不支持条件单', 'RESEND_ORDER_BROKERINVESTOR_NOTMATCH': 55, 55: 'CTP:重发未知单经济公司/投资者不匹配',
    'SYC_OTP_FAILED': 56, 56: 'CTP:同步动态令牌失败', 'OTP_MISMATCH': 57, 57: 'CTP:动态令牌校验错误', 'OTPPARAM_NOT_FOUND': 58,
    58: 'CTP:找不到动态令牌配置信息', 'UNSUPPORTED_OTPTYPE': 59, 59: 'CTP:不支持的动态令牌类型', 'SINGLEUSERSESSION_EXCEED_LIMIT': 60,
    60: 'CTP:用户在线会话超出上限', 'EXCHANGE_UNSUPPORTED_ARBITRAGE': 61, 61: 'CTP:该交易所不支持套利类型报单',
    'NO_CONDITIONAL_ORDER_RIGHT': 62, 62: 'CTP:没有条件单交易权限', 'AUTH_FAILED': 63, 63: 'CTP:客户端认证失败', 'NOT_AUTHENT': 64,
    64: 'CTP:客户端未认证', 'SWAPORDER_UNSUPPORTED': 65, 65: 'CTP:该合约不支持互换类型报单', 'OPTIONS_ONLY_SUPPORT_SPEC': 66,
    66: 'CTP:该期权合约只支持投机类型报单', 'DUPLICATE_EXECORDER_REF': 67, 67: 'CTP:执行宣告错误，不允许重复执行',
    'RESEND_EXECORDER_BROKERINVESTOR_NOTMATCH': 68, 68: 'CTP:重发未知执行宣告经纪公司/投资者不匹配', 'EXECORDER_NOTOPTIONS': 69,
    69: 'CTP:只有期权合约可执行', 'OPTIONS_NOT_SUPPORT_EXEC': 70, 70: 'CTP:该期权合约不支持执行', 'BAD_EXECORDER_ACTION_FIELD': 71,
    71: 'CTP:执行宣告字段有误', 'DUPLICATE_EXECORDER_ACTION_REF': 72, 72: 'CTP:执行宣告撤单已报送，不允许重复撤单',
    'EXECORDER_NOT_FOUND': 73, 73: 'CTP:执行宣告撤单找不到相应执行宣告', 'OVER_EXECUTE_POSITION': 74, 74: 'CTP:执行仓位不足',
    'LOGIN_FORBIDDEN': 75, 75: 'CTP:连续登录失败次数超限，登录被禁止', 'INVALID_TRANSFER_AGENT': 76, 76: 'CTP:非法银期代理关系',
    'NO_FOUND_FUNCTION': 77, 77: 'CTP:无此功能', 'SEND_EXCHANGEORDER_FAILED': 78, 78: 'CTP:发送报单失败',
    'SEND_EXCHANGEORDERACTION_FAILED': 79, 79: 'CTP:发送报单操作失败', 'PRICETYPE_NOTSUPPORT_BYEXCHANGE': 80,
    80: 'CTP:交易所不支持的价格类型', 'BAD_EXECUTE_TYPE': 81, 81: 'CTP:错误的执行类型', 'BAD_OPTION_INSTR': 82, 82: 'CTP:无效的组合合约',
    'INSTR_NOTSUPPORT_FORQUOTE': 83, 83: 'CTP:该合约不支持询价', 'RESEND_QUOTE_BROKERINVESTOR_NOTMATCH': 84,
    84: 'CTP:重发未知报价经纪公司/投资者不匹配', 'INSTR_NOTSUPPORT_QUOTE': 85, 85: 'CTP:该合约不支持报价', 'QUOTE_NOT_FOUND': 86,
    86: 'CTP:报价撤单找不到相应报价', 'OPTIONS_NOT_SUPPORT_ABANDON': 87, 87: 'CTP:该期权合约不支持放弃执行',
    'COMBOPTIONS_SUPPORT_IOC_ONLY': 88, 88: 'CTP:该组合期权合约只支持IOC', 'OPEN_FILE_FAILED': 89, 89: 'CTP:打开文件失败',
    'NEED_RETRY': 90, 90: 'CTP：查询未就绪，请稍后重试', 'EXCHANGE_RTNERROR': 91, 91: 'CTP：交易所返回的错误',
    'QUOTE_DERIVEDORDER_ACTIONERROR': 92, 92: 'CTP:报价衍生单要等待交易所返回才能撤单', 'INSTRUMENTMAP_NOT_FOUND': 93,
    93: 'CTP:找不到组合合约映射', 'NO_TRADING_RIGHT_IN_SEPC_DR': 101, 101: 'CTP:用户在本系统没有报单权限', 'NO_DR_NO': 102,
    102: 'CTP:系统缺少灾备标示号', 'BATCHACTION_NOSUPPORT': 103, 103: 'CTP:该交易所不支持批量撤单', 'OUT_OF_TIMEINTERVAL': 113,
    113: 'CTP:当前时间禁止询价', 'OUT_OF_PRICEINTERVAL': 114, 114: 'CTP:当前价差禁止询价', 'SEND_INSTITUTION_CODE_ERROR': 1000,
    1000: 'CTP:银期转账：发送机构代码错误', 'NO_GET_PLATFORM_SN': 1001, 1001: 'CTP:银期转账：取平台流水号错误',
    'ILLEGAL_TRANSFER_BANK': 1002, 1002: 'CTP:银期转账：不合法的转账银行', 'ALREADY_OPEN_ACCOUNT': 1003, 1003: 'CTP:银期转账：已经开户',
    'NOT_OPEN_ACCOUNT': 1004, 1004: 'CTP:银期转账：未开户', 'PROCESSING': 1005, 1005: 'CTP:银期转账：处理中', 'OVERTIME': 1006,
    1006: 'CTP:银期转账：交易超时', 'RECORD_NOT_FOUND': 1007, 1007: 'CTP:银期转账：找不到记录',
    'NO_FOUND_REVERSAL_ORIGINAL_TRANSACTION': 1008, 1008: 'CTP:银期转账：找不到被冲正的原始交易', 'CONNECT_HOST_FAILED': 1009,
    1009: 'CTP:银期转账：连接主机失败', 'SEND_FAILED': 1010, 1010: 'CTP:银期转账：发送失败', 'LATE_RESPONSE': 1011,
    1011: 'CTP:银期转账：迟到应答', 'REVERSAL_BANKID_NOT_MATCH': 1012, 1012: 'CTP:银期转账：冲正交易银行代码错误',
    'REVERSAL_BANKACCOUNT_NOT_MATCH': 1013, 1013: 'CTP:银期转账：冲正交易银行账户错误', 'REVERSAL_BROKERID_NOT_MATCH': 1014,
    1014: 'CTP:银期转账：冲正交易经纪公司代码错误', 'REVERSAL_ACCOUNTID_NOT_MATCH': 1015, 1015: 'CTP:银期转账：冲正交易资金账户错误',
    'REVERSAL_AMOUNT_NOT_MATCH': 1016, 1016: 'CTP:银期转账：冲正交易交易金额错误', 'DB_OPERATION_FAILED': 1017,
    1017: 'CTP:银期转账：数据库操作错误', 'SEND_ASP_FAILURE': 1018, 1018: 'CTP:银期转账：发送到交易系统失败', 'NOT_SIGNIN': 1019,
    1019: 'CTP:银期转账：没有签到', 'ALREADY_SIGNIN': 1020, 1020: 'CTP:银期转账：已经签到', 'AMOUNT_OR_TIMES_OVER': 1021,
    1021: 'CTP:银期转账：金额或次数超限', 'NOT_IN_TRANSFER_TIME': 1022, 1022: 'CTP:银期转账：这一时间段不能转账', 'BANK_SERVER_ERROR': 1023,
    1023: '银行主机错', 'BANK_SERIAL_IS_REPEALED': 1024, 1024: 'CTP:银期转账：银行已经冲正', 'BANK_SERIAL_NOT_EXIST': 1025,
    1025: 'CTP:银期转账：银行流水不存在', 'NOT_ORGAN_MAP': 1026, 1026: 'CTP:银期转账：机构没有签约', 'EXIST_TRANSFER': 1027,
    1027: 'CTP:银期转账：存在转账，不能销户', 'BANK_FORBID_REVERSAL': 1028, 1028: 'CTP:银期转账：银行不支持冲正', 'DUP_BANK_SERIAL': 1029,
    1029: 'CTP:银期转账：重复的银行流水', 'FBT_SYSTEM_BUSY': 1030, 1030: 'CTP:银期转账：转账系统忙，稍后再试', 'MACKEY_SYNCING': 1031,
    1031: 'CTP:银期转账：MAC密钥正在同步', 'ACCOUNTID_ALREADY_REGISTER': 1032, 1032: 'CTP:银期转账：资金账户已经登记',
    'BANKACCOUNT_ALREADY_REGISTER': 1033, 1033: 'CTP:银期转账：银行账户已经登记', 'DUP_BANK_SERIAL_REDO_OK': 1034,
    1034: 'CTP:银期转账：重复的银行流水,重发成功', 'CURRENCYID_NOT_SUPPORTED': 1035, 1035: 'CTP:银期转账：该币种代码不支持',
    'INVALID_MAC': 1036, 1036: 'CTP:银期转账：MAC值验证失败', 'NOT_SUPPORT_SECAGENT_BY_BANK': 1037,
    1037: 'CTP:银期转账：不支持银行端发起的二级代理商转账和查询', 'PINKEY_SYNCING': 1038, 1038: 'CTP:银期转账：PIN密钥正在同步',
    'SECAGENT_QUERY_BY_CCB': 1039, 1039: 'CTP:银期转账：建行发起的二级代理商查询', 'NO_VALID_BANKOFFER_AVAILABLE': 2000,
    2000: 'CTP:该报盘未连接到银行', 'PASSWORD_MISMATCH': 2001, 2001: 'CTP:资金密码错误', 'DUPLATION_BANK_SERIAL': 2004,
    2004: 'CTP:银行流水号重复', 'DUPLATION_OFFER_SERIAL': 2005, 2005: 'CTP:报盘流水号重复', 'SERIAL_NOT_EXSIT': 2006,
    2006: 'CTP:被冲正流水不存在(冲正交易)', 'SERIAL_IS_REPEALED': 2007, 2007: 'CTP:原流水已冲正(冲正交易)', 'SERIAL_MISMATCH': 2008,
    2008: 'CTP:与原流水信息不符(冲正交易)', 'IdentifiedCardNo_MISMATCH': 2009, 2009: 'CTP:证件号码或类型错误', 'ACCOUNT_NOT_FUND': 2011,
    2011: 'CTP:资金账户不存在', 'ACCOUNT_NOT_ACTIVE': 2012, 2012: 'CTP:资金账户已经销户', 'NOT_ALLOW_REPEAL_BYMANUAL': 2013,
    2013: 'CTP:该交易不能执行手工冲正', 'AMOUNT_OUTOFTHEWAY': 2014, 2014: 'CTP:转帐金额错误', 'EXCHANGERATE_NOT_FOUND': 2015,
    2015: 'CTP:找不到汇率', 'WAITING_OFFER_RSP': 999999, 999999: 'CTP:等待银期报盘处理结果', 'FBE_NO_GET_PLATFORM_SN': 3001,
    3001: 'CTP:银期换汇：取平台流水号错误', 'FBE_ILLEGAL_TRANSFER_BANK': 3002, 3002: 'CTP:银期换汇：不合法的转账银行',
    'FBE_PROCESSING': 3005, 3005: 'CTP:银期换汇：处理中', 'FBE_OVERTIME': 3006, 3006: 'CTP:银期换汇：交易超时',
    'FBE_RECORD_NOT_FOUND': 3007, 3007: 'CTP:银期换汇：找不到记录', 'FBE_CONNECT_HOST_FAILED': 3009, 3009: 'CTP:银期换汇：连接主机失败',
    'FBE_SEND_FAILED': 3010, 3010: 'CTP:银期换汇：发送失败', 'FBE_LATE_RESPONSE': 3011, 3011: 'CTP:银期换汇：迟到应答',
    'FBE_DB_OPERATION_FAILED': 3017, 3017: 'CTP:银期换汇：数据库操作错误', 'FBE_NOT_SIGNIN': 3019, 3019: 'CTP:银期换汇：没有签到',
    'FBE_ALREADY_SIGNIN': 3020, 3020: 'CTP:银期换汇：已经签到', 'FBE_AMOUNT_OR_TIMES_OVER': 3021, 3021: 'CTP:银期换汇：金额或次数超限',
    'FBE_NOT_IN_TRANSFER_TIME': 3022, 3022: 'CTP:银期换汇：这一时间段不能换汇', 'FBE_BANK_SERVER_ERROR': 3023,
    3023: 'CTP:银期换汇：银行主机错', 'FBE_NOT_ORGAN_MAP': 3026, 3026: 'CTP:银期换汇：机构没有签约', 'FBE_SYSTEM_BUSY': 3030,
    3030: 'CTP:银期换汇：换汇系统忙，稍后再试', 'FBE_CURRENCYID_NOT_SUPPORTED': 3035, 3035: 'CTP:银期换汇：该币种代码不支持',
    'FBE_WRONG_BANK_ACCOUNT': 3036, 3036: 'CTP:银期换汇：银行帐号不正确', 'FBE_BANK_ACCOUNT_NO_FUNDS': 3037,
    3037: 'CTP:银期换汇：银行帐户余额不足', 'FBE_DUP_CERT_NO': 3038, 3038: 'CTP:银期换汇：凭证号重复'}
