#! /usr/bin/env bash
# 编译替换app.js

realpath() {
    [[ $1 = /* ]] && echo "$1" || echo "$PWD/${1#./}"
}

# PATHS
PROJECT_PATH=$(dirname $(dirname $(dirname $(realpath $0))))
SRC_PATH=${PROJECT_PATH}/statics/js
NOW=$(date "+%Y%m%d-%H%M%S")
NEW_NAME=app.min.${NOW}.js

echo "压缩js..."
uglifyjs --compress --mangle --output ${SRC_PATH}/${NEW_NAME} -- ${SRC_PATH}/app.js && \

echo "替换html..."
sed -i '' -e "s|investool/js/app.*.js\"{{ else }}|investool/js/${NEW_NAME}\"{{ else }}|g" ${PROJECT_PATH}/statics/html/base.html
