/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server.app.web;

import com.alibaba.arthas.tunnel.common.SimpleHttpResponse;
import com.alibaba.arthas.tunnel.server.AgentInfo;
import com.alibaba.arthas.tunnel.server.TunnelServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class ProxyController {
    private static final Logger logger = LoggerFactory.getLogger(ProxyController.class);
    @Autowired
    TunnelServer tunnelServer;

    @RequestMapping(value={"/proxy/{agentId}/**"})
    @ResponseBody
    public ResponseEntity<?> execute(@PathVariable(name="agentId", required=true) String agentId, HttpServletRequest request) throws InterruptedException, ExecutionException, TimeoutException {
        String fullPath = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        String targetUrl = fullPath.substring("/proxy/".length() + agentId.length());
        logger.info("http proxy, agentId: {}, targetUrl: {}", (Object)agentId, (Object)targetUrl);
        Optional findAgent = this.tunnelServer.findAgent(agentId);
        if (findAgent.isPresent()) {
            String requestId = RandomStringUtils.random((int)20, (boolean)true, (boolean)true).toUpperCase();
            ChannelHandlerContext agentCtx = ((AgentInfo)findAgent.get()).getChannelHandlerContext();
            Promise httpResponsePromise = GlobalEventExecutor.INSTANCE.newPromise();
            this.tunnelServer.addProxyRequestPromise(requestId, httpResponsePromise);
            URI uri = UriComponentsBuilder.newInstance().scheme("response").path("/").queryParam("method", new Object[]{"httpProxy"}).queryParam("id", new Object[]{agentId}).queryParam("targetUrl", new Object[]{targetUrl}).queryParam("requestId", new Object[]{requestId}).build().toUri();
            agentCtx.channel().writeAndFlush((Object)new TextWebSocketFrame(uri.toString()));
            logger.info("waitting for arthas agent http proxy, agentId: {}, targetUrl: {}", (Object)agentId, (Object)targetUrl);
            SimpleHttpResponse simpleHttpResponse = (SimpleHttpResponse)httpResponsePromise.get(15L, TimeUnit.SECONDS);
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.status((int)simpleHttpResponse.getStatus());
            for (Map.Entry entry : simpleHttpResponse.getHeaders().entrySet()) {
                bodyBuilder.header((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
            ResponseEntity responseEntity = bodyBuilder.body((Object)simpleHttpResponse.getContent());
            return responseEntity;
        }
        logger.error("can not find agent by agentId: {}", (Object)agentId);
        return ResponseEntity.notFound().build();
    }
}

