/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.BlockEnumMulti;
import com.hbm.config.BombConfig;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.interfaces.IBomb;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.particle.helper.ExplosionCreator;
import com.hbm.tileentity.bomb.TileEntityCrashedBomb;
import com.hbm.util.EnumUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockCrashedBomb
extends BlockEnumMulti
implements ITileEntityProvider,
IBomb {
    public BlockCrashedBomb(Material mat) {
        super(mat, EnumDudType.class, false, false);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCrashedBomb();
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float fx, float fy, float fz) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.defuser) {
            EnumDudType type = (EnumDudType)((Object)EnumUtil.grabEnumSafely(EnumDudType.class, world.func_72805_g(x, y, z)));
            if (type == EnumDudType.BALEFIRE) {
                BlockCrashedBomb.dropItems(world, x, y, z, new ItemStack(ModItems.egg_balefire_shard));
            }
            if (type == EnumDudType.CONVENTIONAL) {
                BlockCrashedBomb.dropItems(world, x, y, z, new ItemStack(ModItems.ball_tnt, 16));
            }
            if (type == EnumDudType.NUKE) {
                BlockCrashedBomb.dropItems(world, x, y, z, new ItemStack(ModItems.ball_tnt, 8), new ItemStack(ModItems.billet_plutonium, 4));
            }
            if (type == EnumDudType.SALTED) {
                BlockCrashedBomb.dropItems(world, x, y, z, new ItemStack(ModItems.ball_tnt, 8), new ItemStack(ModItems.billet_plutonium, 2), new ItemStack(ModItems.ingot_cobalt, 12));
            }
            world.func_147480_a(x, y, z, false);
            return true;
        }
        return false;
    }

    public static void dropItems(World world, int x, int y, int z, ItemStack ... drops) {
        for (ItemStack drop : drops) {
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, drop));
        }
    }

    @Override
    public IBomb.BombReturnCode explode(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            EnumDudType type = (EnumDudType)((Object)EnumUtil.grabEnumSafely(EnumDudType.class, world.func_72805_g(x, y, z)));
            world.func_147468_f(x, y, z);
            if (type == EnumDudType.BALEFIRE) {
                EntityBalefire bf = new EntityBalefire(world);
                bf.func_70107_b(x, y, z);
                bf.destructionRange = (int)((double)BombConfig.fatmanRadius * 1.25);
                world.func_72838_d((Entity)bf);
                BlockCrashedBomb.spawnMush(world, x, y, z, true);
            }
            if (type == EnumDudType.CONVENTIONAL) {
                ExplosionVNT xnt = new ExplosionVNT(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 35.0f);
                xnt.setBlockAllocator(new BlockAllocatorStandard(24));
                xnt.setBlockProcessor(new BlockProcessorStandard().setNoDrop());
                xnt.setEntityProcessor(new EntityProcessorCross(5.0).withRangeMod(1.5f));
                xnt.setPlayerProcessor(new PlayerProcessorStandard());
                xnt.explode();
                ExplosionCreator.composeEffectLarge(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            }
            if (type == EnumDudType.NUKE) {
                world.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(world, 35, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                BlockCrashedBomb.spawnMush(world, x, y, z, MainRegistry.polaroidID == 11 || world.field_73012_v.nextInt(100) == 0);
            }
            if (type == EnumDudType.SALTED) {
                world.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(world, 25, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5).moreFallout(25));
                BlockCrashedBomb.spawnMush(world, x, y, z, MainRegistry.polaroidID == 11 || world.field_73012_v.nextInt(100) == 0);
            }
        }
        return IBomb.BombReturnCode.DETONATED;
    }

    public static void spawnMush(World world, int x, int y, int z, boolean balefire) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:weapon.mukeExplosion", 15.0f, 1.0f);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "muke");
        data.func_74757_a("balefire", balefire);
        PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 250.0));
    }

    public static enum EnumDudType {
        BALEFIRE,
        CONVENTIONAL,
        NUKE,
        SALTED;

    }
}

