/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityMachineIndustrialTurbine;
import com.hbm.tileentity.machine.TileEntityTurbineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineIndustrialTurbine
extends BlockDummyable
implements ITooltipProvider,
ILookOverlay {
    private static String[] blocks = new String[]{"\u2596 ", "\u2598 ", " \u2598", " \u2596"};

    public MachineIndustrialTurbine() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineIndustrialTurbine();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().fluid().power();
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return true;
            }
            TileEntityTurbineBase entity = (TileEntityTurbineBase)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (entity != null) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(entity.func_145832_p() - 10));
                if (x == entity.field_145851_c + dir.offsetX * 3 && z == entity.field_145849_e + dir.offsetZ * 3 && y == entity.field_145848_d + 1) {
                    if (!world.field_72995_K) {
                        if (!entity.operational) {
                            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:block.chungusLever", 1.5f, 1.0f);
                            entity.onLeverPull();
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Cannot change compressor setting while operational!"));
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 3, 3, 1, 1};
    }

    @Override
    public int getOffset() {
        return 3;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, (x += dir.offsetX * o) + dir.offsetX * 3 + rot.offsetX, y, (z += dir.offsetZ * o) + dir.offsetZ * 3 + rot.offsetZ);
        this.makeExtra(world, x + dir.offsetX * 3 - rot.offsetX, y, z + dir.offsetZ * 3 - rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX * 1 + rot.offsetX, y, z - dir.offsetZ * 1 + rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX * 1 - rot.offsetX, y, z - dir.offsetZ * 1 - rot.offsetZ);
        this.makeExtra(world, x + dir.offsetX * 3, y + 2, z + dir.offsetZ * 3);
        this.makeExtra(world, x - dir.offsetX * 1, y + 2, z - dir.offsetZ * 1);
        this.makeExtra(world, x - dir.offsetX * 3, y + 1, z - dir.offsetZ * 3);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityMachineIndustrialTurbine)) {
            return;
        }
        TileEntityMachineIndustrialTurbine chungus = (TileEntityMachineIndustrialTurbine)te;
        ArrayList<String> text = new ArrayList<String>();
        FluidTank tankInput = chungus.tanks[0];
        FluidTank tankOutput = chungus.tanks[1];
        FluidType inputType = tankInput.getTankType();
        FluidType outputType = Fluids.NONE;
        if (inputType.hasTrait(FT_Coolable.class)) {
            outputType = inputType.getTrait(FT_Coolable.class).coolsTo;
        }
        int color = (int)(255.0 - 255.0 * chungus.spin) << 16 | (int)(255.0 * chungus.spin) << 8;
        int time = (int)(world.func_82737_E() / 4L % 4L);
        text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + inputType.getLocalizedName() + ": " + String.format(Locale.US, "%,d", tankInput.getFill()) + "/" + String.format(Locale.US, "%,d", tankInput.getMaxFill()) + "mB");
        text.add(EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + outputType.getLocalizedName() + ": " + String.format(Locale.US, "%,d", tankOutput.getFill()) + "/" + String.format(Locale.US, "%,d", tankOutput.getMaxFill()) + "mB");
        text.add("&[" + color + "&]" + EnumChatFormatting.RED + "<- " + EnumChatFormatting.WHITE + BobMathUtil.getShortNumber(chungus.powerBuffer) + "HE (" + EnumChatFormatting.RESET + blocks[chungus.powerBuffer <= 0L ? 0 : time] + (int)Math.round(chungus.spin * 100.0) + "%" + EnumChatFormatting.WHITE + ")");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

