/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.duna;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.ChunkProviderCelestial;
import com.hbm.dim.duna.biome.BiomeGenBaseDuna;
import com.hbm.dim.mapgen.ExperimentalCaveGenerator;
import com.hbm.dim.mapgen.MapGenPlateau;
import com.hbm.world.gen.terrain.MapGenBubble;
import net.minecraft.world.World;

public class ChunkProviderDuna
extends ChunkProviderCelestial {
    private ExperimentalCaveGenerator caveGenSmall = new ExperimentalCaveGenerator(2.0f, 12, 0.12f);
    private ExperimentalCaveGenerator caveGenV2 = new ExperimentalCaveGenerator(2.0f, 40, 3.0f);
    private MapGenPlateau genPlateau = new MapGenPlateau(this.worldObj);
    private MapGenBubble oil = new MapGenBubble(WorldConfig.dunaOilSpawn);

    public ChunkProviderDuna(World world, long seed, boolean hasMapFeatures) {
        super(world, seed, hasMapFeatures);
        this.stoneBlock = ModBlocks.duna_rock;
        this.caveGenV2.lavaBlock = ModBlocks.basalt;
        this.caveGenV2.stoneBlock = ModBlocks.duna_cobble;
        this.caveGenSmall.lavaBlock = ModBlocks.duna_sands;
        this.caveGenSmall.stoneBlock = ModBlocks.duna_rock;
        this.caveGenSmall.smallCaveSize = 0.1f;
        this.caveGenV2.onlyBiome = BiomeGenBaseDuna.dunaLowlands;
        this.caveGenSmall.ignoreBiome = BiomeGenBaseDuna.dunaLowlands;
        this.genPlateau.surfrock = ModBlocks.duna_sands;
        this.genPlateau.stoneBlock = ModBlocks.duna_rock;
        this.genPlateau.fillblock = ModBlocks.duna_sands;
        this.genPlateau.applyToBiome = BiomeGenBaseDuna.dunaHills;
        this.oil.block = ModBlocks.ore_oil;
        this.oil.meta = (byte)CelestialBody.getMeta(world);
        this.oil.replace = ModBlocks.duna_rock;
        this.oil.setSize(8, 16);
    }

    @Override
    public ChunkProviderCelestial.BlockMetaBuffer getChunkPrimer(int x, int z) {
        ChunkProviderCelestial.BlockMetaBuffer buffer = new ChunkProviderCelestial.BlockMetaBuffer();
        this.generateBlocks(x, z, buffer.blocks);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        boolean hasLowlands = false;
        boolean hasNotLowlands = false;
        boolean hasPlateau = false;
        for (int i = 0; i < this.biomesForGeneration.length; ++i) {
            if (this.biomesForGeneration[i] == BiomeGenBaseDuna.dunaLowlands) {
                hasLowlands = true;
            } else {
                hasNotLowlands = true;
            }
            if (this.biomesForGeneration[i] == BiomeGenBaseDuna.dunaHills) {
                hasPlateau = true;
            }
            if (hasLowlands && hasNotLowlands && hasPlateau) break;
        }
        if (hasPlateau) {
            this.genPlateau.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        }
        this.replaceBlocksForBiome(x, z, buffer.blocks, buffer.metas, this.biomesForGeneration);
        if (hasLowlands) {
            this.caveGenV2.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        }
        if (hasNotLowlands) {
            this.caveGenSmall.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        }
        this.oil.setMetas(buffer.metas);
        this.oil.func_151539_a(this, this.worldObj, x, z, buffer.blocks);
        return buffer;
    }
}

