/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.mapgen;

import com.hbm.dim.noise.PerlinFestival;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.MapGenBase;

public class ExperimentalCaveGenerator
extends MapGenBase {
    public Block lavaBlock;
    public Block stoneBlock;
    private final float carvingScale;
    private final int depthThreshold;
    private final float largeCaveSize;
    public float smallCaveSize = 1.0f;
    public BiomeGenBase ignoreBiome;
    public BiomeGenBase onlyBiome;
    PerlinFestival perlinNoise;

    public ExperimentalCaveGenerator() {
        this(3.0f, 30, 6.0f);
    }

    public ExperimentalCaveGenerator(float carvingScale, int depthThreshold, float largeCaveSize) {
        this.carvingScale = carvingScale;
        this.depthThreshold = depthThreshold;
        this.largeCaveSize = largeCaveSize;
        this.lavaBlock = Blocks.field_150353_l;
        this.stoneBlock = Blocks.field_150348_b;
    }

    protected void generateLargeCave(long seed, int chunkX, int chunkZ, Block[] blocks, double x, double y, double z) {
        this.generateCaveNode(seed, chunkX, chunkZ, blocks, x, y, z, (1.0f + this.field_75038_b.nextFloat()) * this.largeCaveSize, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCaveNode(long seed, int chunkX, int chunkZ, Block[] blocks, double x, double y, double z, float caveSize, float yaw, float pitch, int currentStep, int totalSteps, double caveSizeIncrease) {
        boolean flag;
        double centerX = chunkX * 16 + 8;
        double centerZ = chunkZ * 16 + 8;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Random random = new Random(seed);
        if (totalSteps <= 0) {
            int j1 = this.field_75040_a * 16 - 16;
            totalSteps = j1 - random.nextInt(j1 / 4);
        }
        boolean flag2 = false;
        if (currentStep == -1) {
            currentStep = totalSteps / 2;
            flag2 = true;
        }
        int k1 = random.nextInt(totalSteps / 2) + totalSteps / 4;
        boolean bl = flag = random.nextInt(6) == 0;
        while (currentStep < totalSteps) {
            double d6 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)currentStep * (float)Math.PI / (float)totalSteps)) * caveSize * 1.0f);
            double d7 = d6 * caveSizeIncrease;
            float f5 = MathHelper.func_76134_b((float)pitch);
            float f6 = MathHelper.func_76126_a((float)pitch);
            this.perlinNoise = new PerlinFestival(seed);
            double dynamicScale = 3.0 + Math.sin(currentStep * 4);
            double noiseFactor = this.perlinNoise.noise((x += (double)(MathHelper.func_76134_b((float)yaw) * f5)) * dynamicScale, (y += (double)f6) * dynamicScale, (z += (double)(MathHelper.func_76126_a((float)yaw) * f5)) * dynamicScale);
            if (y < (double)this.depthThreshold) {
                double noiseFactorWidth = this.perlinNoise.noise(x * 0.1, y * 0.1, z * 0.1);
                double noiseFactorHeight = this.perlinNoise.noise(x * 0.1, y * 0.2, z * 0.1);
                d6 *= 3.0 + noiseFactorWidth;
                d7 *= 2.0 + noiseFactorHeight;
                pitch = (float)((double)pitch + noiseFactor * (double)MathHelper.func_76126_a((float)((float)((double)random.nextFloat() * Math.PI))));
                yaw = (float)((double)yaw + noiseFactor * (double)MathHelper.func_76126_a((float)((float)((double)random.nextInt() * Math.PI))));
            }
            pitch = flag ? (pitch *= 0.92f) : (pitch *= 0.7f);
            pitch += f4 * 0.1f;
            yaw += f3 * 0.1f;
            f4 *= 0.9f;
            f3 *= 0.75f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f3 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag2 && currentStep == k1 && caveSize > 1.0f && totalSteps > 0) {
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, blocks, x, y, z, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, currentStep, totalSteps, 1.0);
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, blocks, x, y, z, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, currentStep, totalSteps, 1.0);
                return;
            }
            if (flag2 || random.nextInt(4) != 0) {
                double d8 = x - centerX;
                double d9 = z - centerZ;
                double d10 = totalSteps - currentStep;
                double d11 = caveSize + 2.0f + 16.0f;
                if (d8 * d8 + d9 * d9 - d10 * d10 > d11 * d11) {
                    return;
                }
                if (x >= centerX - 16.0 - d6 * 2.0 && z >= centerZ - 16.0 - d6 * 2.0 && x <= centerX + 16.0 + d6 * 2.0 && z <= centerZ + 16.0 + d6 * 2.0) {
                    int j3;
                    int k2;
                    int i4 = MathHelper.func_76128_c((double)(x - d6)) - chunkX * 16 - 1;
                    int l1 = MathHelper.func_76128_c((double)(x + d6)) - chunkX * 16 + 1;
                    int j4 = MathHelper.func_76128_c((double)(y - d7)) - 1;
                    int i2 = MathHelper.func_76128_c((double)(y + d7)) + 1;
                    int k4 = MathHelper.func_76128_c((double)(z - d6)) - chunkZ * 16 - 1;
                    int j2 = MathHelper.func_76128_c((double)(z + d6)) - chunkZ * 16 + 1;
                    if (i4 < 0) {
                        i4 = 0;
                    }
                    if (l1 > 16) {
                        l1 = 16;
                    }
                    if (j4 < 1) {
                        j4 = 1;
                    }
                    if (i2 > 248) {
                        i2 = 248;
                    }
                    if (k4 < 0) {
                        k4 = 0;
                    }
                    if (j2 > 16) {
                        j2 = 16;
                    }
                    boolean flag3 = false;
                    for (k2 = i4; !flag3 && k2 < l1; ++k2) {
                        for (int l2 = k4; !flag3 && l2 < j2; ++l2) {
                            for (int i3 = i2 + 1; !flag3 && i3 >= j4 - 1; --i3) {
                                j3 = (k2 * 16 + l2) * 256 + i3;
                                if (i3 < 0 || i3 >= 256) continue;
                                if (this.isOceanBlock(blocks, j3, k2, i3, l2, chunkX, chunkZ)) {
                                    flag3 = true;
                                }
                                if (i3 == j4 - 1 || k2 == i4 || k2 == l1 - 1 || l2 == k4 || l2 == j2 - 1) continue;
                                i3 = j4;
                            }
                        }
                    }
                    if (!flag3) {
                        double noiseScaleX = 0.05;
                        double noiseScaleZ = 0.05;
                        double noiseMagnitude = 0.3;
                        for (k2 = i4; k2 < l1; ++k2) {
                            double noiseX = this.perlinNoise.noise((double)(k2 + chunkX * 16) * noiseScaleX, y * noiseScaleX, z * noiseScaleX) * noiseMagnitude;
                            double d13 = ((double)(k2 + chunkX * 16) + 0.5 - x) / d6 + noiseX;
                            for (j3 = k4; j3 < j2; ++j3) {
                                double noiseZ = this.perlinNoise.noise(x * noiseScaleZ, y * noiseScaleZ, (double)(j3 + chunkZ * 16) * noiseScaleZ) * noiseMagnitude;
                                double d14 = ((double)(j3 + chunkZ * 16) + 0.5 - z) / d6 + noiseZ;
                                int k3 = (k2 * 16 + j3) * 256 + i2;
                                boolean flag1 = false;
                                if (!(d13 * d13 + d14 * d14 < 1.0)) continue;
                                for (int l3 = i2 - 1; l3 >= j4; --l3) {
                                    double d12 = ((double)l3 + 0.5 - y) / d7;
                                    if (d12 > -0.7 && (d13 * d13 + d12 * d12 + d14 * d14) * (1.0 + noiseFactor) < 1.0) {
                                        if (this.isTopBlock(blocks, k3, k2, l3, j3, chunkX, chunkZ)) {
                                            flag1 = true;
                                        }
                                        double carvingNoise = this.perlinNoise.noise(x * (double)this.carvingScale, y * (double)this.carvingScale, z * (double)this.carvingScale);
                                        double noiseValue = this.perlinNoise.noise(x * caveSizeIncrease, y * caveSizeIncrease, z * caveSizeIncrease);
                                        if ((d13 * d13 + d12 * d12 + d14 * d14) * (1.0 + noiseValue) < 1.0 + carvingNoise && Math.pow(d13, 2.5) + Math.pow(d14, 2.2) < 2.0) {
                                            this.digBlock(blocks, k3, k2, l3, j3, chunkX, chunkZ, flag1);
                                        }
                                        this.digBlock(blocks, k3, k2, l3, j3, chunkX, chunkZ, flag1);
                                    }
                                    --k3;
                                }
                            }
                        }
                        if (flag2) break;
                    }
                }
            }
            ++currentStep;
        }
    }

    protected void func_151538_a(World p_151538_1_, int p_151538_2_, int p_151538_3_, int p_151538_4_, int p_151538_5_, Block[] p_151538_6_) {
        int i1 = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(15) + 1) + 1);
        if (this.field_75038_b.nextInt(7) != 0) {
            i1 = 0;
        }
        for (int j1 = 0; j1 < i1; ++j1) {
            double d0 = p_151538_2_ * 16 + this.field_75038_b.nextInt(16);
            double d1 = this.field_75038_b.nextInt(this.field_75038_b.nextInt(120) + 8);
            double d2 = p_151538_3_ * 16 + this.field_75038_b.nextInt(16);
            int k1 = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.generateLargeCave(this.field_75038_b.nextLong(), p_151538_4_, p_151538_5_, p_151538_6_, d0, d1, d2);
                k1 += this.field_75038_b.nextInt(4);
            }
            for (int l1 = 0; l1 < k1; ++l1) {
                float f = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    f2 *= this.smallCaveSize * this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.0f + 1.0f;
                }
                this.generateCaveNode(this.field_75038_b.nextLong(), p_151538_4_, p_151538_5_, p_151538_6_, d0, d1, d2, f2, f, f1, 0, 0, 1.0);
            }
        }
    }

    protected boolean isOceanBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ) {
        return data[index] != null && data[index].func_149688_o().func_76224_d();
    }

    private boolean isTopBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ) {
        BiomeGenBase biome = this.field_75039_c.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
        return data[index] == biome.field_76752_A;
    }

    protected void digBlock(Block[] data, int index, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        BiomeGenBase biome = this.field_75039_c.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
        if (biome == this.ignoreBiome) {
            return;
        }
        if (this.onlyBiome != null && biome != this.onlyBiome) {
            return;
        }
        Block block = data[index];
        if (block != null && (block == this.stoneBlock || block == biome.field_76753_B || block == biome.field_76752_A || block.func_149688_o().func_76224_d())) {
            if (y < 10) {
                data[index] = this.lavaBlock;
            } else {
                data[index] = null;
                if (foundTop && data[index - 1] == biome.field_76753_B) {
                    data[index - 1] = biome.field_76752_A;
                }
            }
        }
    }
}

