/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.trait;

import com.hbm.dim.trait.CelestialBodyTrait;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FluidTrait;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CBT_Atmosphere
extends CelestialBodyTrait {
    public ArrayList<FluidEntry> fluids = new ArrayList();

    public CBT_Atmosphere() {
    }

    public CBT_Atmosphere(FluidType fluid, double pressure) {
        this.fluids.add(new FluidEntry(fluid, pressure));
    }

    public CBT_Atmosphere and(FluidType fluid, double pressure) {
        this.fluids.add(new FluidEntry(fluid, pressure));
        return this;
    }

    public CBT_Atmosphere clone() {
        CBT_Atmosphere clone = new CBT_Atmosphere();
        for (FluidEntry entry : this.fluids) {
            clone.fluids.add(new FluidEntry(entry.fluid, entry.pressure));
        }
        return clone;
    }

    public void add(FluidType fluid, double pressure) {
        for (FluidEntry entry : this.fluids) {
            if (entry.fluid != fluid) continue;
            entry.pressure += pressure;
            return;
        }
        this.fluids.add(new FluidEntry(fluid, pressure));
    }

    public void reduce(double pressure) {
        double totalPressure = this.getPressure();
        if (pressure >= totalPressure) {
            this.fluids = new ArrayList();
            return;
        }
        double pressureRatio = pressure / totalPressure;
        for (FluidEntry entry : this.fluids) {
            entry.pressure *= pressureRatio;
        }
    }

    public boolean hasFluid(FluidType fluid) {
        return this.hasFluid(fluid, 1.0E-4);
    }

    public boolean hasFluid(FluidType fluid, double abovePressure) {
        for (FluidEntry entry : this.fluids) {
            if (entry.fluid != fluid) continue;
            return entry.pressure >= abovePressure;
        }
        return false;
    }

    public boolean hasTrait(Class<? extends FluidTrait> trait) {
        return this.hasTrait(trait, 1.0E-4);
    }

    public boolean hasTrait(Class<? extends FluidTrait> trait, double abovePressure) {
        for (FluidEntry entry : this.fluids) {
            if (!(entry.pressure >= abovePressure) || !entry.fluid.hasTrait(trait)) continue;
            return true;
        }
        return false;
    }

    public FluidType getMainFluid() {
        this.sortDescending();
        FluidEntry first = this.fluids.get(0);
        return first != null ? first.fluid : Fluids.NONE;
    }

    public void sortDescending() {
        this.fluids.sort((a, b) -> Double.compare(b.pressure, a.pressure));
    }

    public double getPressure() {
        double pressure = 0.0;
        for (int i = 0; i < this.fluids.size(); ++i) {
            pressure += this.fluids.get((int)i).pressure;
        }
        return pressure;
    }

    public double getPressure(FluidType fluid) {
        for (FluidEntry entry : this.fluids) {
            if (entry.fluid != fluid) continue;
            return entry.pressure;
        }
        return 0.0;
    }

    public List<Integer> getFluidColors() {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (FluidEntry entry : this.fluids) {
            colors.add(entry.fluid.getColor());
        }
        return colors;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList fluidList = new NBTTagList();
        for (FluidEntry entry : this.fluids) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            fluidTag.func_74768_a("type", entry.fluid.getID());
            fluidTag.func_74780_a("percentage", entry.pressure);
            fluidList.func_74742_a((NBTBase)fluidTag);
        }
        nbt.func_74782_a("fluids", (NBTBase)fluidList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.fluids = new ArrayList();
        NBTTagList fluidList = nbt.func_150295_c("fluids", 10);
        for (int i = 0; i < fluidList.func_74745_c(); ++i) {
            NBTTagCompound fluidTag = fluidList.func_150305_b(i);
            FluidType fluid = Fluids.fromID(fluidTag.func_74762_e("type"));
            double percentage = fluidTag.func_74769_h("percentage");
            this.fluids.add(new FluidEntry(fluid, percentage));
        }
    }

    @Override
    public void writeToBytes(ByteBuf buf) {
        buf.writeInt(this.fluids.size());
        for (FluidEntry entry : this.fluids) {
            buf.writeInt(entry.fluid.getID());
            buf.writeFloat((float)entry.pressure);
        }
    }

    @Override
    public void readFromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.fluids = new ArrayList();
        for (int i = 0; i < size; ++i) {
            FluidType fluid = Fluids.fromID(buf.readInt());
            double percentage = buf.readFloat();
            this.fluids.add(new FluidEntry(fluid, percentage));
        }
    }

    public static class FluidEntry {
        public FluidType fluid;
        public double pressure;

        public FluidEntry(FluidType fluid, double percentage) {
            this.fluid = fluid;
            this.pressure = percentage;
        }
    }
}

