/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.main.MainRegistry;
import com.hbm.util.BobMathUtil;
import com.hbm.util.TrackerUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityNukeTorex
extends Entity {
    public double coreHeight = 3.0;
    public double convectionHeight = 3.0;
    public double torusWidth = 3.0;
    public double rollerSize = 1.0;
    public double heat = 1.0;
    public double lastSpawnY = -1.0;
    public ArrayList<Cloudlet> cloudlets = new ArrayList();
    public boolean didPlaySound = false;
    public boolean didShake = false;
    private boolean hasSufficientPressure = true;

    public EntityNukeTorex(World world) {
        super(world);
        this.field_70158_ak = true;
        this.func_70105_a(1.0f, 50.0f);
        CBT_Atmosphere atmosphere = CelestialBody.getTrait(world, CBT_Atmosphere.class);
        if (CelestialBody.inOrbit(world) || atmosphere == null || atmosphere.getPressure() < 0.01) {
            this.hasSufficientPressure = false;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(10, (Object)new Float(1.0f));
        this.field_70180_af.func_75682_a(11, (Object)new Integer(0));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float interp) {
        return 0xF000F0;
    }

    public float func_70013_c(float interp) {
        return 1.0f;
    }

    public void func_70071_h_() {
        double s = 1.5;
        double cs = 1.5;
        int maxAge = this.getMaxAge();
        if (this.field_70170_p.field_72995_K) {
            int i;
            if (this.field_70173_aa == 1) {
                this.setScale((float)s);
            }
            if (this.lastSpawnY == -1.0) {
                this.lastSpawnY = this.field_70163_u - 3.0;
            }
            if (this.field_70173_aa < 100) {
                this.field_70170_p.field_73016_r = 2;
            }
            int spawnTarget = Math.max(this.field_70170_p.func_72976_f((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70161_v)) - 3, 1);
            double moveSpeed = 0.5;
            this.lastSpawnY = Math.abs((double)spawnTarget - this.lastSpawnY) < moveSpeed ? (double)spawnTarget : (this.lastSpawnY += moveSpeed * Math.signum((double)spawnTarget - this.lastSpawnY));
            if (!this.hasSufficientPressure) {
                if (this.field_70173_aa < 40) {
                    double range = ((double)this.field_70173_aa + this.field_70146_Z.nextDouble()) * 0.6;
                    int toSpawn = this.field_70173_aa * 5;
                    int lifetime = Math.max(800 - this.field_70173_aa * 10, 40);
                    for (int i2 = 0; i2 < toSpawn; ++i2) {
                        double x2 = this.field_70165_t + this.field_70146_Z.nextGaussian() * range;
                        double y = this.field_70163_u + this.field_70146_Z.nextGaussian() * range;
                        double z = this.field_70161_v + this.field_70146_Z.nextGaussian() * range;
                        Cloudlet cloud = new Cloudlet(x2, y, z, (float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI), 0, lifetime, TorexType.STARFISH);
                        cloud.setScale(4.0f, 5.0f);
                        cloud.setMotion(this.field_70173_aa < 25 && this.field_70146_Z.nextBoolean() ? 0.5 : 0.05);
                        this.cloudlets.add(cloud);
                    }
                }
                if (this.field_70173_aa < 150 && !this.didPlaySound && MainRegistry.proxy.me() != null && (double)MainRegistry.proxy.me().func_70032_d((Entity)this) < ((double)this.field_70173_aa * 1.5 + 1.0) * 1.5) {
                    MainRegistry.proxy.playSoundClient(this.field_70165_t, this.field_70163_u, this.field_70161_v, "hbm:weapon.nuclearExplosion", 10000.0f, 1.0f);
                    this.didPlaySound = true;
                }
                for (Cloudlet cloud : this.cloudlets) {
                    cloud.update();
                }
                this.coreHeight += 0.15 / s;
                this.torusWidth += 0.05 / s;
                this.rollerSize = this.torusWidth * 0.8;
                this.convectionHeight = this.coreHeight + this.rollerSize;
                int maxHeat = (int)(50.0 * cs);
                this.heat = (double)maxHeat - Math.pow(maxHeat * this.field_70173_aa / maxAge, 1.0);
                this.cloudlets.removeIf(x -> x.isDead);
                return;
            }
            double range = (this.torusWidth - this.rollerSize) * 0.25;
            double simSpeed = this.getSimulationSpeed();
            int toSpawn = (int)Math.ceil(10.0 * simSpeed * simSpeed);
            int lifetime = Math.min(this.field_70173_aa * this.field_70173_aa + 200, maxAge - this.field_70173_aa + 200);
            for (i = 0; i < toSpawn; ++i) {
                double x3 = this.field_70165_t + this.field_70146_Z.nextGaussian() * range;
                double z = this.field_70161_v + this.field_70146_Z.nextGaussian() * range;
                Cloudlet cloud = new Cloudlet(x3, this.lastSpawnY, z, (float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI), 0, lifetime);
                cloud.setScale(1.0f + (float)this.field_70173_aa * 0.005f * (float)cs, 5.0f * (float)cs);
                this.cloudlets.add(cloud);
            }
            if (this.field_70173_aa < 150) {
                int cloudCount = this.field_70173_aa * 5;
                int shockLife = Math.max(300 - this.field_70173_aa * 20, 50);
                for (int i3 = 0; i3 < cloudCount; ++i3) {
                    Vec3 vec = Vec3.func_72443_a((double)(((double)this.field_70173_aa * 1.5 + this.field_70146_Z.nextDouble()) * 1.5), (double)0.0, (double)0.0);
                    float rot = (float)(Math.PI * 2 * this.field_70146_Z.nextDouble());
                    vec.func_72442_b(rot);
                    this.cloudlets.add(new Cloudlet(vec.field_72450_a + this.field_70165_t, this.field_70170_p.func_72976_f((int)(vec.field_72450_a + this.field_70165_t) + 1, (int)(vec.field_72449_c + this.field_70161_v)), vec.field_72449_c + this.field_70161_v, rot, 0, shockLife, TorexType.SHOCK).setScale(7.0f, 2.0f).setMotion(this.field_70173_aa > 15 ? 0.75 : 0.0));
                }
                if (!this.didPlaySound && MainRegistry.proxy.me() != null && (double)MainRegistry.proxy.me().func_70032_d((Entity)this) < ((double)this.field_70173_aa * 1.5 + 1.0) * 1.5) {
                    MainRegistry.proxy.playSoundClient(this.field_70165_t, this.field_70163_u, this.field_70161_v, "hbm:weapon.nuclearExplosion", 10000.0f, 1.0f);
                    this.didPlaySound = true;
                }
            }
            if ((double)this.field_70173_aa < 130.0 * s) {
                lifetime = (int)((double)lifetime * s);
                for (i = 0; i < 2; ++i) {
                    Cloudlet cloud = new Cloudlet(this.field_70165_t, this.field_70163_u + this.coreHeight, this.field_70161_v, (float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI), 0, lifetime, TorexType.RING);
                    cloud.setScale(1.0f + (float)this.field_70173_aa * 0.0025f * (float)(cs * cs), 3.0f * (float)(cs * cs));
                    this.cloudlets.add(cloud);
                }
            }
            if ((double)this.field_70173_aa > 130.0 * s && (double)this.field_70173_aa < 600.0 * s) {
                for (i = 0; i < 20; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        float angle = (float)(Math.PI * 2 * this.field_70146_Z.nextDouble());
                        Vec3 vec = Vec3.func_72443_a((double)(this.torusWidth + this.rollerSize * (5.0 + this.field_70146_Z.nextDouble())), (double)0.0, (double)0.0);
                        vec.func_72446_c((float)(0.06981317007977318 * (double)j));
                        vec.func_72442_b(angle);
                        Cloudlet cloud = new Cloudlet(this.field_70165_t + vec.field_72450_a, this.field_70163_u + this.coreHeight - 5.0 + (double)j * s, this.field_70161_v + vec.field_72449_c, angle, 0, (int)((double)(20 + this.field_70173_aa / 10) * (1.0 + this.field_70146_Z.nextDouble() * 0.1)), TorexType.CONDENSATION);
                        cloud.setScale(0.125f * (float)cs, 3.0f * (float)cs);
                        this.cloudlets.add(cloud);
                    }
                }
            }
            if ((double)this.field_70173_aa > 200.0 * s && (double)this.field_70173_aa < 600.0 * s) {
                for (i = 0; i < 20; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        float angle = (float)(Math.PI * 2 * this.field_70146_Z.nextDouble());
                        Vec3 vec = Vec3.func_72443_a((double)(this.torusWidth + this.rollerSize * (3.0 + this.field_70146_Z.nextDouble() * 0.5)), (double)0.0, (double)0.0);
                        vec.func_72446_c((float)(0.06981317007977318 * (double)j));
                        vec.func_72442_b(angle);
                        Cloudlet cloud = new Cloudlet(this.field_70165_t + vec.field_72450_a, this.field_70163_u + this.coreHeight + 25.0 + (double)j * cs, this.field_70161_v + vec.field_72449_c, angle, 0, (int)((double)(20 + this.field_70173_aa / 10) * (1.0 + this.field_70146_Z.nextDouble() * 0.1)), TorexType.CONDENSATION);
                        cloud.setScale(0.125f * (float)cs, 3.0f * (float)cs);
                        this.cloudlets.add(cloud);
                    }
                }
            }
            for (Cloudlet cloud : this.cloudlets) {
                cloud.update();
            }
            this.coreHeight += 0.15 / s;
            this.torusWidth += 0.05 / s;
            this.rollerSize = this.torusWidth * 0.35;
            this.convectionHeight = this.coreHeight + this.rollerSize;
            int maxHeat = (int)(50.0 * cs);
            this.heat = (double)maxHeat - Math.pow(maxHeat * this.field_70173_aa / maxAge, 1.0);
            this.cloudlets.removeIf(x -> x.isDead);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > maxAge) {
            this.func_70106_y();
        }
    }

    public EntityNukeTorex setScale(float scale) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70096_w().func_75692_b(10, (Object)Float.valueOf(scale));
        }
        this.coreHeight = this.coreHeight / 1.5 * (double)scale;
        this.convectionHeight = this.convectionHeight / 1.5 * (double)scale;
        this.torusWidth = this.torusWidth / 1.5 * (double)scale;
        this.rollerSize = this.rollerSize / 1.5 * (double)scale;
        return this;
    }

    public EntityNukeTorex setType(int type) {
        this.field_70180_af.func_75692_b(11, (Object)type);
        return this;
    }

    public double getSimulationSpeed() {
        int lifetime = this.getMaxAge();
        int simSlow = lifetime / 4;
        int life = this.field_70173_aa;
        int simStop = lifetime / 2;
        if (life > simStop) {
            return 0.0;
        }
        if (life > simSlow) {
            return 1.0 - (double)(life - simSlow) / (double)(simStop - simSlow);
        }
        return 1.0;
    }

    public double getScale() {
        return this.field_70180_af.func_111145_d(10);
    }

    public double getSaturation() {
        double d = (double)this.field_70173_aa / (double)this.getMaxAge();
        return 1.0 - d * d * d * d;
    }

    public double getGreying() {
        int lifetime = this.getMaxAge();
        int greying = lifetime * 3 / 4;
        if (this.field_70173_aa > greying) {
            return 1.0 + (double)(this.field_70173_aa - greying) / (double)(lifetime - greying);
        }
        return 1.0;
    }

    public float getAlpha() {
        int life = this.field_70173_aa;
        int lifetime = this.getMaxAge();
        int fadeOut = lifetime * 3 / 4;
        if (life > fadeOut) {
            float fac = (float)(life - fadeOut) / (float)(lifetime - fadeOut);
            return 1.0f - fac;
        }
        return 1.0f;
    }

    public int getMaxAge() {
        double s = this.getScale();
        return (int)(900.0 * s);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    public boolean func_70039_c(NBTTagCompound nbt) {
        return false;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public static void statFacStandard(World world, double x, double y, double z, float scale) {
        EntityNukeTorex.statFac(world, x, y, z, scale, 0);
    }

    public static void statFacBale(World world, double x, double y, double z, float scale) {
        EntityNukeTorex.statFac(world, x, y, z, scale, 1);
    }

    public static void statFac(World world, double x, double y, double z, float scale, int type) {
        EntityNukeTorex torex = new EntityNukeTorex(world).setScale(MathHelper.func_76131_a((float)((float)BobMathUtil.squirt((double)scale * 0.01) * 1.5f), (float)0.5f, (float)5.0f));
        torex.setType(type);
        torex.func_70107_b(x, y, z);
        torex.field_98038_p = true;
        world.func_72838_d((Entity)torex);
        TrackerUtil.setTrackingRange(world, torex, 1000);
    }

    public static void startFacAnti(World world, double x, double y, double z, float scale) {
        EntityNukeTorex torex = new EntityNukeTorex(world).setScale(MathHelper.func_76131_a((float)(scale * 0.01f), (float)0.5f, (float)5.0f)).setType(2);
        torex.func_70107_b(x, y, z);
        world.func_72838_d((Entity)torex);
        TrackerUtil.setTrackingRange(world, torex, 1000);
    }

    public static enum TorexType {
        STANDARD,
        SHOCK,
        RING,
        CONDENSATION,
        STARFISH;

    }

    public class Cloudlet {
        public double posX;
        public double posY;
        public double posZ;
        public double prevPosX;
        public double prevPosY;
        public double prevPosZ;
        public double motionX;
        public double motionY;
        public double motionZ;
        public int age;
        public int cloudletLife;
        public float angle;
        public boolean isDead = false;
        float rangeMod = 1.0f;
        public float colorMod = 1.0f;
        public Vec3 color;
        public Vec3 prevColor;
        public TorexType type;
        private float startingScale = 1.0f;
        private float growingScale = 5.0f;
        private double motionMult = 1.0;

        public Cloudlet(double posX, double posY, double posZ, float angle, int age, int maxAge) {
            this(posX, posY, posZ, angle, age, maxAge, TorexType.STANDARD);
        }

        public Cloudlet(double posX, double posY, double posZ, float angle, int age, int maxAge, TorexType type) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.age = age;
            this.cloudletLife = maxAge;
            this.angle = angle;
            this.rangeMod = 0.3f + EntityNukeTorex.this.field_70146_Z.nextFloat() * 0.7f;
            this.colorMod = 0.8f + EntityNukeTorex.this.field_70146_Z.nextFloat() * 0.2f;
            this.type = type;
            this.updateColor();
        }

        private void update() {
            ++this.age;
            if (this.age > this.cloudletLife) {
                this.isDead = true;
            }
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            Vec3 simPos = Vec3.func_72443_a((double)(EntityNukeTorex.this.field_70165_t - this.posX), (double)0.0, (double)(EntityNukeTorex.this.field_70161_v - this.posZ));
            double simPosX = EntityNukeTorex.this.field_70165_t + simPos.func_72433_c();
            double simPosZ = EntityNukeTorex.this.field_70161_v + 0.0;
            if (this.type == TorexType.STANDARD) {
                Vec3 convection = this.getConvectionMotion(simPosX, simPosZ);
                Vec3 lift = this.getLiftMotion(simPosX, simPosZ);
                double factor = MathHelper.func_151237_a((double)((this.posY - EntityNukeTorex.this.field_70163_u) / EntityNukeTorex.this.coreHeight), (double)0.0, (double)1.0);
                this.motionX = convection.field_72450_a * factor + lift.field_72450_a * (1.0 - factor);
                this.motionY = convection.field_72448_b * factor + lift.field_72448_b * (1.0 - factor);
                this.motionZ = convection.field_72449_c * factor + lift.field_72449_c * (1.0 - factor);
            } else if (this.type == TorexType.SHOCK) {
                double factor = MathHelper.func_151237_a((double)((this.posY - EntityNukeTorex.this.field_70163_u) / EntityNukeTorex.this.coreHeight), (double)0.0, (double)1.0);
                Vec3 motion = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
                motion.func_72442_b(this.angle);
                this.motionX = motion.field_72450_a * factor;
                this.motionY = motion.field_72448_b * factor;
                this.motionZ = motion.field_72449_c * factor;
            } else if (this.type == TorexType.RING) {
                Vec3 motion = this.getRingMotion(simPosX, simPosZ);
                this.motionX = motion.field_72450_a;
                this.motionY = motion.field_72448_b;
                this.motionZ = motion.field_72449_c;
            } else if (this.type == TorexType.CONDENSATION) {
                Vec3 motion = this.getCondensationMotion();
                this.motionX = motion.field_72450_a;
                this.motionY = motion.field_72448_b;
                this.motionZ = motion.field_72449_c;
            } else if (this.type == TorexType.STARFISH) {
                double factor = MathHelper.func_151237_a((double)((this.posY - EntityNukeTorex.this.field_70163_u) / EntityNukeTorex.this.coreHeight), (double)0.0, (double)1.0);
                Vec3 motion = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
                motion.func_72442_b(this.angle);
                this.motionX = motion.field_72450_a * factor;
                this.motionY = motion.field_72448_b * factor;
                this.motionZ = motion.field_72449_c * factor;
            }
            double mult = this.motionMult * EntityNukeTorex.this.getSimulationSpeed();
            this.posX += this.motionX * mult;
            this.posY += this.motionY * mult;
            this.posZ += this.motionZ * mult;
            this.updateColor();
        }

        private Vec3 getCondensationMotion() {
            Vec3 delta = Vec3.func_72443_a((double)(this.posX - EntityNukeTorex.this.field_70165_t), (double)0.0, (double)(this.posZ - EntityNukeTorex.this.field_70161_v));
            double speed = 2.0E-5 * (double)EntityNukeTorex.this.field_70173_aa;
            delta.field_72450_a *= speed;
            delta.field_72449_c *= speed;
            return delta;
        }

        private Vec3 getRingMotion(double simPosX, double simPosZ) {
            if (simPosX > EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth * 2.0) {
                return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            }
            Vec3 torusPos = Vec3.func_72443_a((double)(EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth), (double)(EntityNukeTorex.this.field_70163_u + EntityNukeTorex.this.coreHeight * 0.5), (double)EntityNukeTorex.this.field_70161_v);
            Vec3 delta = Vec3.func_72443_a((double)(torusPos.field_72450_a - simPosX), (double)(torusPos.field_72448_b - this.posY), (double)(torusPos.field_72449_c - simPosZ));
            double roller = EntityNukeTorex.this.rollerSize * (double)this.rangeMod * 0.25;
            double dist = delta.func_72433_c() / roller - 1.0;
            double func = 1.0 - Math.pow(Math.E, -dist);
            float angle = (float)(func * Math.PI * 0.5);
            Vec3 rot = Vec3.func_72443_a((double)(-delta.field_72450_a / dist), (double)(-delta.field_72448_b / dist), (double)(-delta.field_72449_c / dist));
            rot.func_72446_c(angle);
            Vec3 motion = Vec3.func_72443_a((double)(torusPos.field_72450_a + rot.field_72450_a - simPosX), (double)(torusPos.field_72448_b + rot.field_72448_b - this.posY), (double)(torusPos.field_72449_c + rot.field_72449_c - simPosZ));
            double speed = 0.001;
            motion.field_72450_a *= speed;
            motion.field_72448_b *= speed;
            motion.field_72449_c *= speed;
            motion = motion.func_72432_b();
            motion.func_72442_b(this.angle);
            return motion;
        }

        private Vec3 getConvectionMotion(double simPosX, double simPosZ) {
            Vec3 torusPos = Vec3.func_72443_a((double)(EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth), (double)(EntityNukeTorex.this.field_70163_u + EntityNukeTorex.this.coreHeight), (double)EntityNukeTorex.this.field_70161_v);
            Vec3 delta = Vec3.func_72443_a((double)(torusPos.field_72450_a - simPosX), (double)(torusPos.field_72448_b - this.posY), (double)(torusPos.field_72449_c - simPosZ));
            double roller = EntityNukeTorex.this.rollerSize * (double)this.rangeMod;
            double dist = delta.func_72433_c() / roller - 1.0;
            double func = 1.0 - Math.pow(Math.E, -dist);
            float angle = (float)(func * Math.PI * 0.5);
            Vec3 rot = Vec3.func_72443_a((double)(-delta.field_72450_a / dist), (double)(-delta.field_72448_b / dist), (double)(-delta.field_72449_c / dist));
            rot.func_72446_c(angle);
            Vec3 motion = Vec3.func_72443_a((double)(torusPos.field_72450_a + rot.field_72450_a - simPosX), (double)(torusPos.field_72448_b + rot.field_72448_b - this.posY), (double)(torusPos.field_72449_c + rot.field_72449_c - simPosZ));
            motion = motion.func_72432_b();
            motion.func_72442_b(this.angle);
            return motion;
        }

        private Vec3 getLiftMotion(double simPosX, double simPosZ) {
            double scale = MathHelper.func_151237_a((double)(1.0 - (simPosX - (EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth))), (double)0.0, (double)1.0);
            Vec3 motion = Vec3.func_72443_a((double)(EntityNukeTorex.this.field_70165_t - this.posX), (double)(EntityNukeTorex.this.field_70163_u + EntityNukeTorex.this.convectionHeight - this.posY), (double)(EntityNukeTorex.this.field_70161_v - this.posZ));
            motion = motion.func_72432_b();
            motion.field_72450_a *= scale;
            motion.field_72448_b *= scale;
            motion.field_72449_c *= scale;
            return motion;
        }

        private void updateColor() {
            this.prevColor = this.color;
            double exX = EntityNukeTorex.this.field_70165_t;
            double exY = EntityNukeTorex.this.field_70163_u + EntityNukeTorex.this.coreHeight;
            double exZ = EntityNukeTorex.this.field_70161_v;
            double distX = exX - this.posX;
            double distY = exY - this.posY;
            double distZ = exZ - this.posZ;
            double distSq = distX * distX + distY * distY + distZ * distZ;
            double dist = Math.sqrt(distSq /= EntityNukeTorex.this.heat);
            dist = Math.max(dist, 1.0);
            double col = 2.0 / dist;
            int type = EntityNukeTorex.this.field_70180_af.func_75679_c(11);
            if (this.type == TorexType.STARFISH) {
                this.color = Vec3.func_72443_a((double)Math.max(col * 8.0, 0.5), (double)Math.max(col * 1.5, 0.1), (double)Math.max(col * 0.5, 0.05));
            } else if (type == 1) {
                this.color = Vec3.func_72443_a((double)Math.max(col * 1.0, 0.25), (double)Math.max(col * 2.0, 0.25), (double)Math.max(col * 0.5, 0.25));
            } else if (type == 2) {
                Color color = Color.getHSBColor(this.angle / 2.0f / (float)Math.PI, 1.0f, 1.0f);
                this.color = this.type == TorexType.RING ? Vec3.func_72443_a((double)Math.max(col * 1.0, 0.25), (double)Math.max(col * 1.0, 0.25), (double)Math.max(col * 1.0, 0.25)) : Vec3.func_72443_a((double)((double)color.getRed() / 255.0), (double)((double)color.getGreen() / 255.0), (double)((double)color.getBlue() / 255.0));
            } else {
                this.color = Vec3.func_72443_a((double)Math.max(col * 2.0, 0.25), (double)Math.max(col * 1.5, 0.25), (double)Math.max(col * 0.5, 0.25));
            }
        }

        public Vec3 getInterpPos(float interp) {
            float scale = (float)EntityNukeTorex.this.getScale();
            Vec3 base = Vec3.func_72443_a((double)(this.prevPosX + (this.posX - this.prevPosX) * (double)interp), (double)(this.prevPosY + (this.posY - this.prevPosY) * (double)interp), (double)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)interp));
            if (this.type != TorexType.SHOCK) {
                base.field_72450_a = (base.field_72450_a - EntityNukeTorex.this.field_70165_t) * (double)scale + EntityNukeTorex.this.field_70165_t;
                base.field_72448_b = (base.field_72448_b - EntityNukeTorex.this.field_70163_u) * (double)scale + EntityNukeTorex.this.field_70163_u;
                base.field_72449_c = (base.field_72449_c - EntityNukeTorex.this.field_70161_v) * (double)scale + EntityNukeTorex.this.field_70161_v;
            }
            return base;
        }

        public Vec3 getInterpColor(float interp) {
            if (this.type == TorexType.CONDENSATION) {
                return Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0);
            }
            double greying = EntityNukeTorex.this.getGreying();
            if (this.type == TorexType.RING) {
                greying += 1.0;
            }
            return Vec3.func_72443_a((double)((this.prevColor.field_72450_a + (this.color.field_72450_a - this.prevColor.field_72450_a) * (double)interp) * greying), (double)((this.prevColor.field_72448_b + (this.color.field_72448_b - this.prevColor.field_72448_b) * (double)interp) * greying), (double)((this.prevColor.field_72449_c + (this.color.field_72449_c - this.prevColor.field_72449_c) * (double)interp) * greying));
        }

        public float getAlpha() {
            float alpha = (1.0f - (float)this.age / (float)this.cloudletLife) * EntityNukeTorex.this.getAlpha();
            if (this.type == TorexType.CONDENSATION) {
                alpha = (float)((double)alpha * 0.25);
            }
            return alpha;
        }

        public float getScale() {
            float base = this.startingScale + (float)this.age / (float)this.cloudletLife * this.growingScale;
            if (this.type != TorexType.SHOCK) {
                base *= (float)EntityNukeTorex.this.getScale();
            }
            return base;
        }

        public Cloudlet setScale(float start, float grow) {
            this.startingScale = start;
            this.growingScale = grow;
            return this;
        }

        public Cloudlet setMotion(double mult) {
            this.motionMult = mult;
            return this;
        }
    }
}

