/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.glyphid;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.MobConfig;
import com.hbm.entity.logic.EntityWaypoint;
import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.entity.mob.glyphid.EntityGlyphidNuclear;
import com.hbm.entity.mob.glyphid.GlyphidStats;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.main.ResourceManager;
import com.hbm.world.feature.GlyphidHive;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityGlyphidScout
extends EntityGlyphid {
    boolean hasTarget = false;
    int timer;
    int scoutingRange = 45;
    int minDistanceToHive = 8;
    boolean useLargeHive = false;
    float largeHiveChance = MobConfig.largeHiveChance;

    public EntityGlyphidScout(World world) {
        super(world);
        this.func_70105_a(1.25f, 0.75f);
    }

    @Override
    public boolean func_70652_k(Entity victum) {
        if (super.func_70652_k(victum) && victum instanceof EntityLivingBase) {
            ((EntityLivingBase)victum).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 3));
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getSkin() {
        return ResourceManager.glyphid_scout_tex;
    }

    @Override
    public double getScale() {
        return 0.75;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(GlyphidStats.getStats().getScout().health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(GlyphidStats.getStats().getScout().speed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(GlyphidStats.getStats().getScout().damage);
    }

    @Override
    public GlyphidStats.StatBundle getStats() {
        return GlyphidStats.getStats().statsScout;
    }

    @Override
    public boolean isArmorBroken(float amount) {
        return (double)this.field_70146_Z.nextInt(100) <= Math.min(Math.pow(amount, 2.0), 100.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70789_a != null && this.field_70173_aa % 60 == 0) {
            this.field_70789_a = this.func_70782_k();
        }
        if ((this.getCurrentTask() != 2 || this.getCurrentTask() != 5) && this.taskWaypoint == null) {
            if (MobConfig.rampantGlyphidGuidance && PollutionHandler.targetCoords != null) {
                if (!this.hasTarget) {
                    Vec3 dirVec = EntityGlyphidScout.playerBaseDirFinder(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), this.getPlayerTargetDirection());
                    EntityWaypoint target = new EntityWaypoint(this.field_70170_p);
                    target.func_70012_b(dirVec.field_72450_a, dirVec.field_72448_b, dirVec.field_72449_c, 0.0f, 0.0f);
                    target.maxAge = 300;
                    target.radius = 6;
                    target.setWaypointType(2);
                    this.field_70170_p.func_72838_d((Entity)target);
                    this.hasTarget = true;
                    this.setCurrentTask(1, target);
                }
                if (super.isAtDestination()) {
                    this.setCurrentTask(2, null);
                    this.hasTarget = false;
                }
            } else {
                this.setCurrentTask(2, null);
            }
        }
        if (this.getCurrentTask() == 2 || this.getCurrentTask() == 5) {
            if (!this.field_70170_p.field_72995_K && !this.hasTarget) {
                if (this.scoutingRange != 60 && this.hasNuclearGlyphidNearby()) {
                    this.setCurrentTask(5, null);
                }
                if (this.expandHive()) {
                    this.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 3600, 1));
                    this.hasTarget = true;
                }
            }
            if (this.taskWaypoint == null && this.hasTarget) {
                this.hasTarget = false;
            }
            if (this.getCurrentTask() == 5 && super.isAtDestination() && this.canBuildHiveHere()) {
                this.communicate(5, this.taskWaypoint);
            }
            if (this.field_70173_aa % 10 == 0 && this.isAtDestination()) {
                ++this.timer;
                if (!this.field_70170_p.field_72995_K && this.canBuildHiveHere()) {
                    if (this.timer == 1) {
                        EntityWaypoint additional = new EntityWaypoint(this.field_70170_p);
                        additional.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                        additional.setWaypointType(0);
                        EntityWaypoint home = new EntityWaypoint(this.field_70170_p);
                        home.setWaypointType(1);
                        home.setAdditionalWaypoint(additional);
                        home.func_70012_b(this.homeX, this.homeY, this.homeZ, 0.0f, 0.0f);
                        home.maxAge = 1200;
                        home.radius = 6;
                        this.field_70170_p.func_72838_d((Entity)home);
                        this.taskWaypoint = home;
                        this.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 800, 10));
                        this.communicate(1, this.taskWaypoint);
                    } else if (this.timer >= 5) {
                        this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, false, false);
                        GlyphidHive.generateSmall(this.field_70170_p, (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), this.field_70146_Z, this.field_70180_af.func_75683_a(18) != 0, false);
                        this.func_70106_y();
                    } else {
                        this.communicate(4, this.taskWaypoint);
                    }
                }
            }
        }
    }

    public boolean canBuildHiveHere() {
        int length = this.useLargeHive ? 16 : 8;
        for (int i = 0; i < 8; ++i) {
            Block block;
            float angle = (float)Math.toRadians(22.5 * (double)i);
            Vec3 rot = Vec3.func_72443_a((double)0.0, (double)0.0, (double)length);
            rot.func_72442_b(angle);
            Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + 1.0), (double)this.field_70161_v);
            Vec3 nextPos = Vec3.func_72443_a((double)(this.field_70165_t + rot.field_72450_a), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + rot.field_72449_c));
            MovingObjectPosition mop = this.field_70170_p.func_72933_a(pos, nextPos);
            if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || (block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) != ModBlocks.glyphid_base) continue;
            this.setCurrentTask(0, null);
            this.hasTarget = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAtDestination() {
        return this.getCurrentTask() == 2 && super.isAtDestination();
    }

    public boolean hasNuclearGlyphidNearby() {
        int radius = 8;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - (double)radius), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + (double)radius), (double)(this.field_70161_v + (double)radius));
        List bugs = this.field_70170_p.func_72839_b((Entity)this, bb);
        for (Entity e : bugs) {
            if (!(e instanceof EntityGlyphidNuclear)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean expandHive() {
        boolean distanceCheck;
        int nestX = this.field_70146_Z.nextInt(this.homeX + this.scoutingRange - (this.homeX - this.scoutingRange)) + (this.homeX - this.scoutingRange);
        int nestZ = this.field_70146_Z.nextInt(this.homeZ + this.scoutingRange - (this.homeZ - this.scoutingRange)) + (this.homeZ - this.scoutingRange);
        int nestY = this.field_70170_p.func_72976_f(nestX, nestZ);
        Block b = this.field_70170_p.func_147439_a(nestX, nestY - 1, nestZ);
        boolean bl = distanceCheck = Vec3.func_72443_a((double)(nestX - this.homeX), (double)(nestY - this.homeY), (double)(nestZ - this.homeZ)).func_72433_c() > (double)this.minDistanceToHive;
        if (distanceCheck && b.func_149688_o() != Material.field_151579_a && b.func_149721_r() && b != ModBlocks.glyphid_base) {
            if (b == ModBlocks.basalt) {
                this.useLargeHive = true;
                this.largeHiveChance /= 2.0f;
                this.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 1200, 3));
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityWaypoint nest = new EntityWaypoint(this.field_70170_p);
                nest.setWaypointType(this.getCurrentTask());
                nest.radius = 5;
                if (this.useLargeHive) {
                    nest.setHighPriority();
                }
                nest.func_70012_b(nestX, nestY, nestZ, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)nest);
                this.taskWaypoint = nest;
                this.setCurrentTask(this.getCurrentTask(), this.taskWaypoint);
                this.communicate(2, this.taskWaypoint);
            }
            return true;
        }
        return false;
    }

    @Override
    public void carryOutTask() {
        if (!this.field_70170_p.field_72995_K && this.taskWaypoint == null) {
            switch (this.getCurrentTask()) {
                case 3: {
                    this.func_82170_o(Potion.field_76421_d.field_76415_H);
                    this.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 400, 4));
                    EntityWaypoint additional = new EntityWaypoint(this.field_70170_p);
                    additional.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                    additional.setWaypointType(0);
                    EntityWaypoint home = new EntityWaypoint(this.field_70170_p);
                    home.setWaypointType(2);
                    home.setAdditionalWaypoint(additional);
                    home.setHighPriority();
                    home.radius = 6;
                    home.func_70012_b(this.homeX, this.homeY, this.homeZ, 0.0f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)home);
                    this.communicate(4, home);
                    break;
                }
                case 5: {
                    this.scoutingRange = 60;
                    this.minDistanceToHive = 20;
                }
            }
        }
        super.carryOutTask();
    }

    @Override
    public boolean useExtendedTargeting() {
        return false;
    }

    @Override
    protected Entity func_70782_k() {
        if (this.func_70644_a(Potion.field_76440_q)) {
            return null;
        }
        return this.field_70170_p.func_72856_b((Entity)this, 10.0);
    }

    public static Vec3 playerBaseDirFinder(Vec3 currentLocation, Vec3 target) {
        Vec3 dirVec = currentLocation.func_72444_a(target).func_72432_b();
        return Vec3.func_72443_a((double)(currentLocation.field_72450_a + dirVec.field_72450_a * 10.0), (double)(currentLocation.field_72448_b + dirVec.field_72448_b * 10.0), (double)(currentLocation.field_72449_c + dirVec.field_72449_c * 10.0));
    }

    protected Vec3 getPlayerTargetDirection() {
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 300.0);
        if (player != null) {
            return Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        }
        return PollutionHandler.targetCoords;
    }

    public boolean func_70814_o() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        int skylightSubtracted = this.field_70170_p.field_73008_k;
        if (this.field_70170_p.func_72911_I()) {
            this.field_70170_p.field_73008_k = 10;
        }
        int light = this.field_70170_p.func_72964_e(x >> 4, z >> 4).func_76629_c(x & 0xF, y, z & 0xF, this.field_70170_p.field_73008_k);
        this.field_70170_p.field_73008_k = skylightSubtracted;
        return light <= 7;
    }
}

