/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.atmosphere;

import com.hbm.blocks.BlockDummyable;
import com.hbm.config.GeneralConfig;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.entity.effect.EntityDepress;
import com.hbm.handler.ThreeInts;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.handler.atmosphere.IAtmosphereProvider;
import com.hbm.handler.atmosphere.IBlockSealable;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.main.MainRegistry;
import com.hbm.util.AdjacencyGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFence;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class AtmosphereBlob
implements Runnable {
    protected final AdjacencyGraph<ThreeInts> graph;
    protected IAtmosphereProvider handler;
    private static ThreadPoolExecutor pool = new ThreadPoolExecutor(2, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(32));
    private static HashMap<Block, Boolean> fullBounds = new HashMap();
    private boolean executing;
    private ThreeInts blockPos;
    public boolean runDepress;
    public ForgeDirection depressDir = ForgeDirection.UP;
    private LinkedHashMap<ThreeInts, Integer> plants = new LinkedHashMap();

    public AtmosphereBlob(IAtmosphereProvider handler) {
        this.handler = handler;
        this.graph = new AdjacencyGraph();
    }

    public boolean isPositionAllowed(World world, ThreeInts pos) {
        return !AtmosphereBlob.isBlockSealed(world, pos);
    }

    public static boolean isBlockSealed(World world, ThreeInts pos) {
        return AtmosphereBlob.isBlockSealed(world, pos.x, pos.y, pos.z);
    }

    public static boolean isBlockSealed(World world, int x, int y, int z) {
        if (y < 0 || y > 256) {
            return false;
        }
        if (world instanceof WorldServer && !((WorldServer)world).func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (block instanceof BlockFarmland) {
            return false;
        }
        if (block instanceof BlockFence) {
            return false;
        }
        if (block instanceof IBlockSealable) {
            return ((IBlockSealable)block).isSealed(world, x, y, z);
        }
        if (block instanceof BlockDummyable) {
            return false;
        }
        Material material = block.func_149688_o();
        if (material.func_76224_d() || !material.func_76220_a()) {
            return false;
        }
        if (material == Material.field_151584_j) {
            return false;
        }
        Boolean isFull = fullBounds.get(block);
        if (isFull != null) {
            return isFull;
        }
        AxisAlignedBB bb = null;
        try {
            bb = block.func_149668_a(null, x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bb == null) {
            fullBounds.put(block, false);
            return false;
        }
        int minX = (int)((bb.field_72340_a - (double)x) * 100.0);
        int minY = (int)((bb.field_72338_b - (double)y) * 100.0);
        int minZ = (int)((bb.field_72339_c - (double)z) * 100.0);
        int maxX = (int)((bb.field_72336_d - (double)x) * 100.0);
        int maxY = (int)((bb.field_72337_e - (double)y) * 100.0);
        int maxZ = (int)((bb.field_72334_f - (double)z) * 100.0);
        isFull = minX == 0 && minY == 0 && minZ == 0 && maxX == 100 && maxY == 100 && maxZ == 100;
        fullBounds.put(block, isFull);
        return isFull;
    }

    public int getBlobMaxRadius() {
        return this.handler.getMaxBlobRadius();
    }

    public boolean hasFluid(FluidType fluid) {
        return this.hasFluid(fluid, 0.001);
    }

    public boolean hasFluid(FluidType fluid, double abovePressure) {
        if (this.handler.getFluidType() != fluid) {
            return false;
        }
        return this.handler.getFluidPressure() >= abovePressure;
    }

    public boolean hasPressure(double abovePressure) {
        return this.handler.getFluidPressure() >= abovePressure;
    }

    public void consume(int amount) {
        this.handler.consume(amount);
    }

    public void produce(int amount) {
        this.handler.produce(amount);
    }

    public void addBlock(int x, int y, int z) {
        this.addBlock(new ThreeInts(x, y, z));
    }

    public void addBlock(ThreeInts blockPos) {
        if (!this.contains(blockPos) && (this.graph.size() == 0 || this.contains(blockPos.getPositionAtOffset(ForgeDirection.UP)) || this.contains(blockPos.getPositionAtOffset(ForgeDirection.DOWN)) || this.contains(blockPos.getPositionAtOffset(ForgeDirection.EAST)) || this.contains(blockPos.getPositionAtOffset(ForgeDirection.WEST)) || this.contains(blockPos.getPositionAtOffset(ForgeDirection.NORTH)) || this.contains(blockPos.getPositionAtOffset(ForgeDirection.SOUTH))) && !this.executing) {
            this.blockPos = blockPos;
            this.executing = true;
            if (GeneralConfig.enableThreadedAtmospheres) {
                try {
                    pool.execute(this);
                }
                catch (RejectedExecutionException e) {
                    MainRegistry.logger.warn("Atmosphere calculation at " + this.getRootPosition() + " aborted due to oversize queue!");
                }
            } else {
                this.run();
            }
        }
    }

    private void addSingleBlock(ThreeInts blockPos) {
        if (!this.graph.contains(blockPos)) {
            this.graph.add(blockPos, this.getPositionsToAdd(blockPos));
            if (this.handler.getWorld().func_147439_a(blockPos.x, blockPos.y, blockPos.z) instanceof IGrowable) {
                this.addPlant(this.handler.getWorld(), blockPos.x, blockPos.y, blockPos.z);
            }
        }
    }

    public ThreeInts getRootPosition() {
        return this.handler.getRootPosition();
    }

    protected HashSet<ThreeInts> getPositionsToAdd(ThreeInts blockPos) {
        HashSet<ThreeInts> set = new HashSet<ThreeInts>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            ThreeInts offset = blockPos.getPositionAtOffset(direction);
            if (!this.graph.contains(offset)) continue;
            set.add(offset);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ThreeInts position) {
        boolean contains;
        AdjacencyGraph<ThreeInts> adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            contains = this.graph.contains(position);
        }
        return contains;
    }

    public boolean contains(int x, int y, int z) {
        return this.contains(new ThreeInts(x, y, z));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlock(ThreeInts blockPos) {
        AdjacencyGraph<ThreeInts> adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            this.graph.remove(blockPos);
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                ThreeInts newBlock = blockPos.getPositionAtOffset(direction);
                if (!this.graph.contains(newBlock) || this.graph.doesPathExist(newBlock, this.handler.getRootPosition())) continue;
                this.runEffectOnWorldBlocks(this.handler.getWorld(), this.graph.removeAllNodesConnectedTo(newBlock));
            }
        }
    }

    public void clearBlob() {
        World world = this.handler.getWorld();
        this.runEffectOnWorldBlocks(world, this.getLocations());
        this.graph.clear();
    }

    public Set<ThreeInts> getLocations() {
        return this.graph.getKeys();
    }

    public int getBlobSize() {
        return this.graph.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Stack<ThreeInts> stack = new Stack<ThreeInts>();
        stack.push(this.blockPos);
        int maxSize = this.getBlobMaxRadius();
        HashSet<ThreeInts> addableBlocks = new HashSet<ThreeInts>();
        while (!stack.isEmpty()) {
            ThreeInts stackElement = (ThreeInts)stack.pop();
            addableBlocks.add(stackElement);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                ThreeInts searchNextPosition = stackElement.getPositionAtOffset(dir);
                if (this.graph.contains(searchNextPosition) || addableBlocks.contains(searchNextPosition)) continue;
                try {
                    if (!this.isPositionAllowed(this.handler.getWorld(), searchNextPosition)) continue;
                    if (searchNextPosition.getDistanceSquared(this.getRootPosition()) <= (double)(maxSize * maxSize)) {
                        stack.push(searchNextPosition);
                        addableBlocks.add(searchNextPosition);
                        continue;
                    }
                    if (this.runDepress) {
                        this.decompress(this.blockPos, this.depressDir);
                    }
                    this.clearBlob();
                    this.executing = false;
                    return;
                }
                catch (Exception e) {
                    MainRegistry.logger.info("Error: AtmosphereBlob has failed to form correctly due to an error. \nCurrentBlock: " + stackElement + "\tNextPos: " + searchNextPosition + "\tDir: " + dir + "\tStackSize: " + stack.size());
                    e.printStackTrace();
                    this.clearBlob();
                    this.executing = false;
                    return;
                }
            }
        }
        AdjacencyGraph<ThreeInts> adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            for (ThreeInts addableBlock : addableBlocks) {
                this.addSingleBlock(addableBlock);
            }
            this.handler.onBlobCreated(this);
        }
        this.executing = false;
    }

    protected void runEffectOnWorldBlocks(World world, Collection<ThreeInts> blocks) {
        ThreeInts root = this.handler.getRootPosition();
        CBT_Atmosphere newAtmosphere = ChunkAtmosphereManager.proxy.getAtmosphere(world, root.x, root.y, root.z, this);
        for (ThreeInts pos : blocks) {
            Block block = world.func_147439_a(pos.x, pos.y, pos.z);
            ChunkAtmosphereManager.proxy.runEffectsOnBlock(newAtmosphere, world, block, pos.x, pos.y, pos.z);
        }
    }

    public void decompress(ThreeInts pos, ForgeDirection dir) {
        World world = this.handler.getWorld();
        EntityDepress depress = new EntityDepress(world, dir.getOpposite(), 20);
        depress.field_70165_t = (double)pos.x + 0.5;
        depress.field_70163_u = (double)pos.y + 0.5;
        depress.field_70161_v = (double)pos.z + 0.5;
        world.func_72838_d((Entity)depress);
        world.func_72908_a(depress.field_70165_t, depress.field_70163_u, depress.field_70161_v, "random.explode", 1.0f, 1.6f);
        world.func_72908_a(depress.field_70165_t, depress.field_70163_u, depress.field_70161_v, "random.fizz", 1.0f, 0.25f);
    }

    public void checkGrowth() {
        World world = this.handler.getWorld();
        Iterator<Map.Entry<ThreeInts, Integer>> iterator = this.plants.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ThreeInts, Integer> entry = iterator.next();
            ThreeInts pos = entry.getKey();
            int oldMeta = entry.getValue();
            Block block = world.func_147439_a(pos.x, pos.y, pos.z);
            if (!(block instanceof IGrowable)) {
                iterator.remove();
                continue;
            }
            int newMeta = world.func_72805_g(pos.x, pos.y, pos.z);
            if (newMeta == oldMeta) continue;
            entry.setValue(newMeta);
            this.produce(Math.max(newMeta - oldMeta, 0) * 15);
        }
    }

    public void addPlant(World world, int x, int y, int z) {
        this.plants.put(new ThreeInts(x, y, z), world.func_72805_g(x, y, z));
    }
}

