/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.config.ClientConfig;
import com.hbm.handler.imc.ICompatNHNEI;
import com.hbm.interfaces.NotableComments;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemBlueprints;
import com.hbm.items.machine.ItemFluidIcon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

@NotableComments
public abstract class NEIGenericRecipeHandler
extends TemplateRecipeHandler
implements ICompatNHNEI {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsGui = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiGui = new LinkedList();
    public final String displayName;
    public final GenericRecipes recipeSet;
    public final ItemStack[] machines;

    public NEIGenericRecipeHandler(String displayName, GenericRecipes recipeSet, Block ... machines) {
        ItemStack[] machineStacks = new ItemStack[machines.length];
        for (int i = 0; i < machines.length; ++i) {
            machineStacks[i] = new ItemStack(machines[i]);
        }
        this.displayName = displayName;
        this.recipeSet = recipeSet;
        this.machines = machineStacks;
    }

    public NEIGenericRecipeHandler(String displayName, GenericRecipes recipeSet, ItemStack ... machines) {
        this.displayName = displayName;
        this.recipeSet = recipeSet;
        this.machines = machines;
    }

    public String getRecipeName() {
        return this.displayName;
    }

    @Override
    public ItemStack[] getMachinesForRecipe() {
        return this.machines;
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei.png";
    }

    public int getInputXOffset(GenericRecipe recipe, int inputCount) {
        return 0;
    }

    public int getOutputXOffset(GenericRecipe recipe, int outputCount) {
        return 0;
    }

    public int getMachineXOffset(GenericRecipe recipe) {
        return 0;
    }

    public ItemStack[] getMachines(GenericRecipe recipe) {
        return this.machines;
    }

    public int[][] getInputSlotPositions(int count) {
        if (count == 1) {
            return new int[][]{{48, 24}};
        }
        if (count == 2) {
            return new int[][]{{30, 24}, {48, 24}};
        }
        if (count == 3) {
            return new int[][]{{12, 24}, {30, 24}, {48, 24}};
        }
        if (count == 4) {
            return new int[][]{{30, 15}, {48, 15}, {30, 33}, {48, 33}};
        }
        if (count == 5) {
            return new int[][]{{12, 15}, {30, 15}, {48, 15}, {12, 33}, {30, 33}};
        }
        if (count == 6) {
            return new int[][]{{12, 15}, {30, 15}, {48, 15}, {12, 33}, {30, 33}, {48, 33}};
        }
        int[][] slots = new int[count][2];
        int cols = (count + 2) / 3;
        for (int i = 0; i < count; ++i) {
            slots[i][0] = 12 + i % cols * 18 - (cols == 4 ? 18 : 0);
            slots[i][1] = 6 + i / cols * 18;
        }
        return slots;
    }

    public int[][] getOutputSlotPositions(int count) {
        switch (count) {
            case 1: {
                return new int[][]{{102, 24}};
            }
            case 2: {
                return new int[][]{{102, 24}, {120, 24}};
            }
            case 3: {
                return new int[][]{{102, 24}, {120, 24}, {138, 24}};
            }
            case 4: {
                return new int[][]{{102, 15}, {120, 15}, {102, 33}, {120, 33}};
            }
            case 5: {
                return new int[][]{{102, 15}, {120, 15}, {102, 33}, {120, 33}, {138, 24}};
            }
            case 6: {
                return new int[][]{{102, 6}, {120, 6}, {102, 24}, {120, 24}, {102, 42}, {120, 42}};
            }
            case 7: {
                return new int[][]{{102, 6}, {120, 6}, {102, 24}, {120, 24}, {102, 42}, {120, 42}, {138, 24}};
            }
            case 8: {
                return new int[][]{{102, 6}, {120, 6}, {102, 24}, {120, 24}, {102, 42}, {120, 42}, {138, 24}, {138, 42}};
            }
        }
        return new int[count][2];
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Object o : this.recipeSet.recipeOrderedList) {
            GenericRecipe recipe = (GenericRecipe)o;
            boolean hasMatch = false;
            boolean hide = ClientConfig.NEI_HIDE_SECRETS.get();
            if (hide && recipe.isPooled()) {
                String[] pools;
                String[] stringArray = pools = recipe.getPools();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String pool = stringArray[i];
                    if (pool.startsWith("secret.")) continue block0;
                }
            }
            if (hide && recipe.inputItem != null) {
                for (RecipesCommon.AStack astack : recipe.inputItem) {
                    for (ItemStack stack : astack.extractForNEI()) {
                        if (!ModItems.excludeNEI.contains(stack.func_77973_b())) continue;
                        continue block0;
                    }
                }
            }
            if (recipe.outputItem != null) {
                for (GenericRecipes.IOutput output : recipe.outputItem) {
                    for (ItemStack stack : output.getAllPossibilities()) {
                        if (hide && ModItems.excludeNEI.contains(stack.func_77973_b())) continue block0;
                        if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)result)) continue;
                        hasMatch = true;
                    }
                }
            }
            if (recipe.outputFluid != null) {
                for (FluidStack fluid : recipe.outputFluid) {
                    if (!NEIGenericRecipeHandler.areItemsAndMetaEqual(ItemFluidIcon.make(fluid), result)) continue;
                    hasMatch = true;
                }
            }
            if (!hasMatch) continue;
            this.arecipes.add(new RecipeSet(recipe));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeID())) {
            block0: for (Object o : this.recipeSet.recipeOrderedList) {
                GenericRecipe recipe = (GenericRecipe)o;
                boolean hide = ClientConfig.NEI_HIDE_SECRETS.get();
                if (hide && recipe.isPooled()) {
                    String[] pools;
                    String[] stringArray = pools = recipe.getPools();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String pool = stringArray[i];
                        if (pool.startsWith("secret.")) continue block0;
                    }
                }
                if (hide && recipe.inputItem != null) {
                    for (RecipesCommon.AStack astack : recipe.inputItem) {
                        for (ItemStack stack : astack.extractForNEI()) {
                            if (!ModItems.excludeNEI.contains(stack.func_77973_b())) continue;
                            continue block0;
                        }
                    }
                }
                if (hide && recipe.outputItem != null) {
                    for (GenericRecipes.IOutput output : recipe.outputItem) {
                        for (ItemStack stack : output.getAllPossibilities()) {
                            if (ModItems.excludeNEI.contains(stack.func_77973_b())) continue block0;
                        }
                    }
                }
                this.arecipes.add(new RecipeSet(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals(this.getRecipeID())) {
            this.loadCraftingRecipes(this.getRecipeID(), new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Object o : this.recipeSet.recipeOrderedList) {
            GenericRecipe recipe = (GenericRecipe)o;
            boolean hasMatch = false;
            boolean hide = ClientConfig.NEI_HIDE_SECRETS.get();
            if (hide && recipe.isPooled()) {
                String[] pools;
                String[] stringArray = pools = recipe.getPools();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String pool = stringArray[i];
                    if (pool.startsWith("secret.")) continue block0;
                }
            }
            if (recipe.inputItem != null) {
                for (RecipesCommon.AStack astack : recipe.inputItem) {
                    for (ItemStack stack : astack.extractForNEI()) {
                        if (hide && ModItems.excludeNEI.contains(stack.func_77973_b())) continue block0;
                        if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
                        hasMatch = true;
                    }
                }
            }
            if (recipe.inputFluid != null) {
                for (FluidStack fluid : recipe.inputFluid) {
                    if (!NEIGenericRecipeHandler.areItemsAndMetaEqual(ItemFluidIcon.make(fluid), ingredient)) continue;
                    hasMatch = true;
                }
            }
            if (hide && recipe.outputItem != null) {
                for (GenericRecipes.IOutput output : recipe.outputItem) {
                    for (ItemStack stack : output.getAllPossibilities()) {
                        if (ModItems.excludeNEI.contains(stack.func_77973_b())) continue block0;
                    }
                }
            }
            if (!hasMatch) continue;
            this.arecipes.add(new RecipeSet(recipe));
        }
    }

    public static boolean areItemsAndMetaEqual(ItemStack sta1, ItemStack sta2) {
        return sta1.func_77973_b() == sta2.func_77973_b() && sta1.func_77960_j() == sta2.func_77960_j();
    }

    public void loadTransferRects() {
        this.transferRectsGui = new LinkedList();
        this.guiGui = new LinkedList();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(147, 1, 18, 18), this.getRecipeID(), new Object[0]));
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        RecipeSet rec = (RecipeSet)((Object)this.arecipes.get(recipe));
        for (PositionedStack pos : rec.input) {
            GuiDraw.drawTexturedModalRect((int)(pos.relx - 1), (int)(pos.rely - 1), (int)5, (int)87, (int)18, (int)18);
        }
        for (PositionedStack pos : rec.output) {
            GuiDraw.drawTexturedModalRect((int)(pos.relx - 1), (int)(pos.rely - 1), (int)5, (int)87, (int)18, (int)18);
        }
        if (rec.template == null) {
            GuiDraw.drawTexturedModalRect((int)(74 + this.getMachineXOffset(rec.recipe)), (int)14, (int)59, (int)87, (int)18, (int)36);
        } else {
            GuiDraw.drawTexturedModalRect((int)(74 + this.getMachineXOffset(rec.recipe)), (int)7, (int)77, (int)87, (int)18, (int)50);
        }
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        protected GenericRecipe recipe;
        protected PositionedStack[] input;
        protected PositionedStack[] output;
        protected PositionedStack machine;
        protected PositionedStack template;

        public RecipeSet(GenericRecipe recipe) {
            int i;
            int i2;
            super((TemplateRecipeHandler)NEIGenericRecipeHandler.this);
            this.recipe = recipe;
            int inputSize = 0;
            int outputSize = 0;
            if (recipe.inputItem != null) {
                inputSize += recipe.inputItem.length;
            }
            if (recipe.inputFluid != null) {
                inputSize += recipe.inputFluid.length;
            }
            if (recipe.outputItem != null) {
                outputSize += recipe.outputItem.length;
            }
            if (recipe.outputFluid != null) {
                outputSize += recipe.outputFluid.length;
            }
            int inputOffset = NEIGenericRecipeHandler.this.getInputXOffset(recipe, inputSize);
            int outputOffset = NEIGenericRecipeHandler.this.getOutputXOffset(recipe, outputSize);
            int machineOffset = NEIGenericRecipeHandler.this.getMachineXOffset(recipe);
            this.input = new PositionedStack[inputSize];
            int[][] inPos = NEIGenericRecipeHandler.this.getInputSlotPositions(inputSize);
            inputSize = 0;
            if (recipe.inputItem != null) {
                for (i2 = 0; i2 < recipe.inputItem.length; ++i2) {
                    this.input[i2] = new PositionedStack(recipe.inputItem[i2].extractForNEI(), inPos[i2][0] + inputOffset, inPos[i2][1]);
                    inputSize = i2 + 1;
                }
            }
            if (recipe.inputFluid != null) {
                for (i2 = 0; i2 < recipe.inputFluid.length; ++i2) {
                    this.input[inputSize + i2] = new PositionedStack((Object)ItemFluidIcon.make(recipe.inputFluid[i2]), inPos[inputSize + i2][0] + inputOffset, inPos[inputSize + i2][1]);
                }
            }
            int[][] outPos = NEIGenericRecipeHandler.this.getOutputSlotPositions(outputSize);
            this.output = new PositionedStack[outputSize];
            outputSize = 0;
            if (recipe.outputItem != null) {
                for (i = 0; i < recipe.outputItem.length; ++i) {
                    this.output[i] = new PositionedStack((Object)recipe.outputItem[i].getAllPossibilities(), outPos[i][0] + outputOffset, outPos[i][1]);
                    outputSize = i + 1;
                }
            }
            if (recipe.outputFluid != null) {
                for (i = 0; i < recipe.outputFluid.length; ++i) {
                    this.output[outputSize + i] = new PositionedStack((Object)ItemFluidIcon.make(recipe.outputFluid[i]), outPos[outputSize + i][0] + outputOffset, outPos[outputSize + i][1]);
                }
            }
            if (recipe.isPooled()) {
                String[] pools = recipe.getPools();
                ItemStack[] blueprints = new ItemStack[pools.length];
                for (int i3 = 0; i3 < pools.length; ++i3) {
                    blueprints[i3] = ItemBlueprints.make(pools[i3]);
                }
                this.template = new PositionedStack((Object)blueprints, 75 + machineOffset, 10);
            }
            ItemStack[] machineStacks = NEIGenericRecipeHandler.this.getMachines(recipe);
            this.machine = new PositionedStack((Object)machineStacks, 75 + machineOffset, this.template == null ? 31 : 38);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIGenericRecipeHandler.this.cycleticks / 20, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> other = new ArrayList<PositionedStack>();
            for (int i = 0; i < this.output.length; ++i) {
                other.add(this.output[i]);
            }
            other.add(this.machine);
            if (this.template != null) {
                other.add(this.template);
            }
            return this.getCycledIngredients(NEIGenericRecipeHandler.this.cycleticks / 20, other);
        }
    }
}

