/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import api.hbm.energymk2.IBatteryItem;
import com.hbm.inventory.container.ContainerBatterySocket;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.machine.storage.TileEntityBatterySocket;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GUIBatterySocket
extends GuiInfoContainer {
    private static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/storage/gui_battery_socket.png");
    private TileEntityBatterySocket battery;

    public GUIBatterySocket(InventoryPlayer invPlayer, TileEntityBatterySocket tedf) {
        super(new ContainerBatterySocket(invPlayer, tedf));
        this.battery = tedf;
        this.field_146999_f = 176;
        this.field_147000_g = 181;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        String[] desc;
        super.func_73863_a(mouseX, mouseY, f);
        if (this.battery.slots[0] != null && this.battery.slots[0].func_77973_b() instanceof IBatteryItem) {
            IBatteryItem item = (IBatteryItem)this.battery.slots[0].func_77973_b();
            String deltaText = BobMathUtil.getShortNumber(Math.abs(this.battery.delta)) + "HE/s";
            deltaText = this.battery.delta > 0L ? EnumChatFormatting.GREEN + "+" + deltaText : (this.battery.delta < 0L ? EnumChatFormatting.RED + "-" + deltaText : EnumChatFormatting.YELLOW + "+" + deltaText);
            String[] info = new String[]{BobMathUtil.getShortNumber(item.getCharge(this.battery.slots[0])) + "/" + BobMathUtil.getShortNumber(item.getMaxCharge(this.battery.slots[0])) + "HE", deltaText};
            this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 62, this.field_147009_r + 69 - 52, 34, 52, mouseX, mouseY, info);
        }
        String lang = null;
        switch (this.battery.priority) {
            case LOW: {
                lang = "low";
                break;
            }
            case HIGH: {
                lang = "high";
                break;
            }
            default: {
                lang = "normal";
            }
        }
        ArrayList<String> priority = new ArrayList<String>();
        priority.add(I18nUtil.resolveKey("battery.priority." + lang, new Object[0]));
        priority.add(I18nUtil.resolveKey("battery.priority.recommended", new Object[0]));
        for (String s : desc = I18nUtil.resolveKeyArray("battery.priority." + lang + ".desc", new Object[0])) {
            priority.add(s);
        }
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 125, this.field_147009_r + 35, 16, 16, mouseX, mouseY, priority);
    }

    protected void func_73864_a(int x, int y, int i) {
        super.func_73864_a(x, y, i);
        NBTTagCompound data = new NBTTagCompound();
        if (this.checkClick(x, y, 106, 16, 18, 18)) {
            this.click();
            data.func_74757_a("low", true);
        }
        if (this.checkClick(x, y, 106, 52, 18, 18)) {
            this.click();
            data.func_74757_a("high", true);
        }
        if (this.checkClick(x, y, 125, 35, 16, 16)) {
            this.click();
            data.func_74757_a("priority", true);
        }
        if (!data.func_82582_d()) {
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.battery.field_145851_c, this.battery.field_145848_d, this.battery.field_145849_e));
        }
    }

    protected void func_146979_b(int i, int j) {
        String name = this.battery.func_145818_k_() ? this.battery.func_145825_b() : I18n.func_135052_a((String)this.battery.func_145825_b(), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.battery.slots[0] != null && this.battery.slots[0].func_77973_b() instanceof IBatteryItem) {
            IBatteryItem item = (IBatteryItem)this.battery.slots[0].func_77973_b();
            long power = item.getCharge(this.battery.slots[0]);
            long maxPower = item.getMaxCharge(this.battery.slots[0]);
            if (power > 92233720368547758L) {
                power /= 100L;
                maxPower /= 100L;
            }
            if (maxPower <= 1L) {
                maxPower = 1L;
            }
            int p = (int)(power * 52L / maxPower);
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 69 - p, 176, 52 - p, 34, p);
        }
        this.func_73729_b(this.field_147003_i + 106, this.field_147009_r + 16, 176, 52 + this.battery.redLow * 18, 18, 18);
        this.func_73729_b(this.field_147003_i + 106, this.field_147009_r + 52, 176, 52 + this.battery.redHigh * 18, 18, 18);
        this.func_73729_b(this.field_147003_i + 125, this.field_147009_r + 35, 194, 52 + this.battery.priority.ordinal() * 16 - 16, 16, 16);
    }
}

