/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.module;

import com.google.common.annotations.Beta;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.util.BobMathUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class NumberDisplay {
    protected GuiInfoContainer gui;
    private int displayX;
    private int displayY;
    private int color;
    @Nonnegative
    private byte padding = (byte)3;
    private boolean blink = false;
    private float maxNum;
    private float minNum;
    private boolean customBounds = false;
    private boolean isFloat = false;
    private byte floatPad = 1;
    private boolean pads = false;
    @Nonnegative
    private byte digitLength = (byte)3;
    private Number numIn = 0;
    private char[] toDisp = new char[]{'0', '0', '0'};
    @Nonnegative
    private short dispOffset = 0;
    private int verticalLength = 5;
    private int horizontalLength = 4;
    private int thickness = 1;

    public NumberDisplay(GuiInfoContainer gui, int x, int y, EnumChatFormatting c) {
        this(gui, x, y);
        this.setColor(this.enumToColor(c));
    }

    public NumberDisplay(GuiInfoContainer gui, int x, int y, int color) {
        this(gui, x, y);
        this.setColor(color);
    }

    public NumberDisplay(GuiInfoContainer gui, int x, int y) {
        this.displayX = x;
        this.displayY = y;
        this.setColor(0xFFFF55);
        this.gui = gui;
    }

    private int enumToColor(EnumChatFormatting c) {
        if (c.func_96302_c()) {
            switch (c) {
                case AQUA: {
                    return 0x55FFFF;
                }
                case BLACK: {
                    return 0;
                }
                case BLUE: {
                    return 0x5555FF;
                }
                case DARK_AQUA: {
                    return 43690;
                }
                case DARK_BLUE: {
                    return 170;
                }
                case DARK_GRAY: {
                    return 0x555555;
                }
                case DARK_GREEN: {
                    return 43520;
                }
                case DARK_PURPLE: {
                    return 0xAA00AA;
                }
                case DARK_RED: {
                    return 0xAA0000;
                }
                case GOLD: {
                    return 0xFFAA00;
                }
                case GRAY: {
                    return 0xAAAAAA;
                }
                case GREEN: {
                    return 0x55FF55;
                }
                case LIGHT_PURPLE: {
                    return 0xFF55FF;
                }
                case RED: {
                    return 0xFF5555;
                }
                case WHITE: {
                    return 0xFFFFFF;
                }
                case YELLOW: {
                    return 0xFFFF55;
                }
            }
        }
        return 0xFFFF55;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void drawNumber(char[] num) {
        if (this.blink && !BobMathUtil.getBlink()) {
            return;
        }
        short gap = (short)(this.digitLength - num.length);
        for (int i = 0; i < num.length; ++i) {
            if (num[i] == '.') {
                gap = (short)(gap - 1);
            }
            this.dispOffset = (short)((this.padding + this.horizontalLength + 2 * this.thickness) * (i + gap));
            this.drawChar(num[i]);
        }
        if (this.pads) {
            this.padOut(gap);
        }
    }

    public void drawNumber() {
        if (this.isFloat) {
            this.formatForFloat();
        }
        this.drawNumber(this.toDisp);
    }

    public void drawNumber(Number num) {
        this.setNumber(num);
        this.drawNumber();
    }

    private void padOut(short gap) {
        if (gap == 0) {
            return;
        }
        for (int i = 0; i < gap; ++i) {
            this.dispOffset = (short)((this.padding + this.horizontalLength + 2 * this.thickness) * i);
            this.drawChar('0');
        }
    }

    public void drawChar(char num) {
        switch (num) {
            case '1': {
                this.drawVertical(1, 0);
                this.drawVertical(1, 1);
                break;
            }
            case '2': {
                this.drawHorizontal(0);
                this.drawVertical(1, 0);
                this.drawHorizontal(1);
                this.drawVertical(0, 1);
                this.drawHorizontal(2);
                break;
            }
            case '3': {
                this.drawHorizontal(0);
                this.drawHorizontal(1);
                this.drawHorizontal(2);
                this.drawVertical(1, 0);
                this.drawVertical(1, 1);
                break;
            }
            case '4': {
                this.drawVertical(0, 0);
                this.drawVertical(1, 0);
                this.drawVertical(1, 1);
                this.drawHorizontal(1);
                break;
            }
            case '5': {
                this.drawHorizontal(0);
                this.drawHorizontal(1);
                this.drawHorizontal(2);
                this.drawVertical(0, 0);
                this.drawVertical(1, 1);
                break;
            }
            case '6': {
                this.drawHorizontal(0);
                this.drawHorizontal(1);
                this.drawHorizontal(2);
                this.drawVertical(0, 0);
                this.drawVertical(0, 1);
                this.drawVertical(1, 1);
                break;
            }
            case '7': {
                this.drawHorizontal(0);
                this.drawVertical(1, 0);
                this.drawVertical(1, 1);
                break;
            }
            case '8': {
                this.drawHorizontal(0);
                this.drawHorizontal(1);
                this.drawHorizontal(2);
                this.drawVertical(0, 0);
                this.drawVertical(1, 0);
                this.drawVertical(0, 1);
                this.drawVertical(1, 1);
                break;
            }
            case '9': {
                this.drawHorizontal(0);
                this.drawHorizontal(1);
                this.drawHorizontal(2);
                this.drawVertical(0, 0);
                this.drawVertical(1, 0);
                this.drawVertical(1, 1);
                break;
            }
            case '0': {
                this.drawHorizontal(0);
                this.drawHorizontal(2);
                this.drawVertical(0, 0);
                this.drawVertical(0, 1);
                this.drawVertical(1, 0);
                this.drawVertical(1, 1);
                break;
            }
            case '-': {
                this.drawHorizontal(1);
                break;
            }
            case '.': {
                this.drawPeriod();
                break;
            }
            default: {
                this.drawHorizontal(0);
                this.drawHorizontal(1);
                this.drawHorizontal(2);
                this.drawVertical(0, 0);
                this.drawVertical(0, 1);
            }
        }
    }

    private void drawHorizontal(int pos) {
        byte offset = (byte)(pos * (this.verticalLength + this.thickness));
        this.renderSegment(this.gui.getGuiLeft() + this.displayX + this.dispOffset + this.thickness, this.gui.getGuiTop() + this.displayY + offset, this.horizontalLength, this.thickness);
    }

    private void drawPeriod() {
        this.renderSegment(this.gui.getGuiLeft() + this.displayX + this.dispOffset + this.padding - (int)Math.ceil(this.padding / 2) + (this.horizontalLength + this.thickness), this.gui.getGuiLeft() + this.displayY + 2 * (this.verticalLength + this.thickness), this.thickness, this.thickness);
    }

    private void drawVertical(int posX, int posY) {
        byte offsetX = (byte)(posX * (this.horizontalLength + this.thickness));
        byte offsetY = (byte)(posY * (this.verticalLength + this.thickness));
        this.renderSegment(this.gui.getGuiLeft() + this.displayX + offsetX + this.dispOffset, this.gui.getGuiTop() + this.displayY + offsetY + this.thickness, this.thickness, this.verticalLength);
    }

    private void renderSegment(int renX, int renY, int width, int height) {
        Tessellator tess = Tessellator.field_78398_a;
        float z = this.gui.getZLevel();
        GL11.glDisable((int)3553);
        tess.func_78382_b();
        tess.func_78378_d(this.color);
        tess.func_78377_a((double)renX, (double)(renY + height), (double)z);
        tess.func_78377_a((double)(renX + width), (double)(renY + height), (double)z);
        tess.func_78377_a((double)(renX + width), (double)(renY + 0), (double)z);
        tess.func_78377_a((double)renX, (double)renY, (double)z);
        tess.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public void setNumber(Number num) {
        this.numIn = num;
        if (this.customBounds) {
            this.numIn = MathHelper.func_151237_a((double)num.doubleValue(), (double)this.minNum, (double)this.maxNum);
        }
        if (this.isFloat) {
            this.formatForFloat();
        } else {
            this.toDisp = new Long(Math.round(this.numIn.doubleValue())).toString().toCharArray();
            this.toDisp = this.truncOrExpand();
        }
    }

    public Number getNumber() {
        return this.numIn;
    }

    public char[] getDispNumber() {
        return (char[])this.toDisp.clone();
    }

    public NumberDisplay setBlinks(boolean doesBlink) {
        this.blink = doesBlink;
        return this;
    }

    public NumberDisplay setPadding(@Nonnegative int p) {
        this.padding = (byte)p;
        return this;
    }

    public NumberDisplay setDigitLength(@Nonnegative int l) {
        this.digitLength = (byte)l;
        this.toDisp = this.truncOrExpand();
        return this;
    }

    public NumberDisplay setSegmentSize(int vertical, int horizontal, int thickness) {
        this.verticalLength = vertical;
        this.horizontalLength = horizontal;
        this.thickness = thickness;
        return this;
    }

    public NumberDisplay setMaxMin(float max, float min) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum value is larger than maximum value!");
        }
        this.maxNum = max;
        this.minNum = min;
        this.customBounds = true;
        return this;
    }

    public NumberDisplay setPadNumber() {
        this.pads = true;
        return this;
    }

    public NumberDisplay setFloat() {
        return this.setFloat(1);
    }

    public NumberDisplay setFloat(@Nonnegative int pad) {
        this.floatPad = (byte)pad;
        this.isFloat = true;
        this.formatForFloat();
        return this;
    }

    private void formatForFloat() {
        BigDecimal bd = new BigDecimal(this.numIn.toString());
        bd = bd.setScale((int)this.floatPad, RoundingMode.HALF_UP);
        char[] proc = bd.toString().toCharArray();
        proc = Double.valueOf(BobMathUtil.roundDecimal(this.numIn.doubleValue(), this.floatPad)).toString().toCharArray();
        this.toDisp = proc.length == this.digitLength ? proc : this.truncOrExpand();
    }

    @Beta
    private char[] truncOrExpand() {
        if (this.isFloat) {
            char[] out = Arrays.copyOf(this.toDisp, (int)this.digitLength);
            for (int i = 0; i < this.digitLength; ++i) {
                if (out[i] != '\u0000') continue;
                out[i] = 48;
            }
            return (char[])out.clone();
        }
        return this.toDisp;
    }
}

