/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.qmaw;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hbm.interfaces.NotableComments;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.qmaw.QuickManualAndWiki;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.item.ItemStack;

@NotableComments
public class QMAWLoader
implements IResourceManagerReloadListener {
    public static final HashSet<File> registeredModFiles = new HashSet();
    public static final Gson gson = new Gson();
    public static final JsonParser parser = new JsonParser();
    public static HashMap<String, QuickManualAndWiki> qmaw = new HashMap();
    public static HashMap<RecipesCommon.ComparableStack, QuickManualAndWiki> triggers = new HashMap();

    public void func_110549_a(IResourceManager resMan) {
        long timestamp = System.currentTimeMillis();
        MainRegistry.logger.info("[QMAW] Reloading manual...");
        QMAWLoader.init();
        MainRegistry.logger.info("[QMAW] Loaded " + qmaw.size() + " manual entries! (" + (System.currentTimeMillis() - timestamp) + "ms)");
    }

    public static void registerModFileURL(File file) {
        registeredModFiles.add(file);
    }

    public static void init() {
        qmaw.clear();
        triggers.clear();
        QMAWLoader.agonyEngine();
    }

    public static void agonyEngine() {
        for (File modFile : registeredModFiles) {
            QMAWLoader.logJarAttempt(modFile.getName());
            QMAWLoader.dissectZip(modFile);
        }
        File devEnvManualFolder = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("/eclipse/.".replace('/', File.separatorChar), "") + "/src/main/resources/assets/hbm/manual".replace('/', File.separatorChar));
        if (devEnvManualFolder.exists() && devEnvManualFolder.isDirectory()) {
            MainRegistry.logger.info("[QMAW] Exploring " + devEnvManualFolder.getAbsolutePath());
            QMAWLoader.dissectManualFolder(devEnvManualFolder);
        }
        ResourcePackRepository repo = Minecraft.func_71410_x().func_110438_M();
        for (Object o : repo.func_110613_c()) {
            ResourcePackRepository.Entry entry = (ResourcePackRepository.Entry)o;
            IResourcePack pack = entry.func_110514_c();
            QMAWLoader.logPackAttempt(pack.func_130077_b());
            if (pack instanceof FileResourcePack) {
                QMAWLoader.dissectZip(((FileResourcePack)pack).field_110597_b);
            }
            if (!(pack instanceof FolderResourcePack)) continue;
            QMAWLoader.dissectFolder(((FolderResourcePack)pack).field_110597_b);
        }
    }

    public static void logJarAttempt(String name) {
        MainRegistry.logger.info("[QMAW] Dissecting jar " + name);
    }

    public static void logPackAttempt(String name) {
        MainRegistry.logger.info("[QMAW] Dissecting resource " + name);
    }

    public static void logFoundManual(String name) {
        MainRegistry.logger.info("[QMAW] Found manual " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dissectZip(File zipFile) {
        if (zipFile == null) {
            MainRegistry.logger.info("[QMAW] Pack file does not exist!");
            return;
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> enumerator = zip.entries();
            while (enumerator.hasMoreElements()) {
                ZipEntry entry = enumerator.nextElement();
                String name = entry.getName();
                if (!name.startsWith("assets/hbm/manual/") || !name.endsWith(".json")) continue;
                InputStream fileStream = zip.getInputStream(entry);
                InputStreamReader reader = new InputStreamReader(fileStream, StandardCharsets.UTF_8);
                try {
                    JsonObject obj = (JsonObject)parser.parse((Reader)reader);
                    String manName = name.replace("assets/hbm/manual/", "");
                    QMAWLoader.registerJson(manName, obj);
                    reader.close();
                    QMAWLoader.logFoundManual(manName);
                }
                catch (Exception ex) {
                    MainRegistry.logger.info("[QMAW] Error reading manual " + name + ": " + ex);
                }
            }
        }
        catch (Exception ex) {
            MainRegistry.logger.info("[QMAW] Error dissecting zip " + zipFile.getName() + ": " + ex);
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void dissectFolder(File folder) {
        File manualFolder = new File(folder, "/assets/hbm/manual");
        if (manualFolder.exists() && manualFolder.isDirectory()) {
            QMAWLoader.dissectManualFolder(manualFolder);
        }
    }

    public static void dissectManualFolder(File folder) {
        File[] files;
        for (File file : files = folder.listFiles()) {
            String name = file.getName();
            if (file.isFile() && name.endsWith(".json")) {
                try {
                    InputStreamReader reader = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
                    JsonObject obj = (JsonObject)parser.parse((Reader)reader);
                    QMAWLoader.registerJson(name, obj);
                    QMAWLoader.logFoundManual(name);
                }
                catch (Exception ex) {
                    MainRegistry.logger.info("[QMAW] Error reading manual " + name + ": " + ex);
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            QMAWLoader.dissectManualFolder(file);
        }
    }

    public static void registerJson(String file, JsonObject json) {
        String name = json.get("name").getAsString();
        if (qmaw.containsKey(name)) {
            MainRegistry.logger.info("[QMAW] Skipping existing entry " + file);
            return;
        }
        QuickManualAndWiki qmaw = new QuickManualAndWiki(name);
        if (json.has("icon")) {
            qmaw.setIcon(SerializableRecipe.readItemStack(json.get("icon").getAsJsonArray()));
        }
        JsonObject title = json.get("title").getAsJsonObject();
        for (Object part : title.entrySet()) {
            qmaw.addTitle((String)part.getKey(), ((JsonElement)part.getValue()).getAsString());
        }
        JsonObject content = json.get("content").getAsJsonObject();
        for (Map.Entry part : content.entrySet()) {
            qmaw.addLang((String)part.getKey(), ((JsonElement)part.getValue()).getAsString());
        }
        JsonArray triggers = json.get("trigger").getAsJsonArray();
        for (JsonElement element : triggers) {
            ItemStack trigger = SerializableRecipe.readItemStack(element.getAsJsonArray());
            if (trigger == null || trigger.func_77973_b() == ModItems.nothing) {
                MainRegistry.logger.info("[QMAW] Manual " + file + " references nonexistant trigger " + element.toString());
                continue;
            }
            QMAWLoader.triggers.put(new RecipesCommon.ComparableStack(trigger).makeSingular(), qmaw);
        }
        if (!qmaw.contents.isEmpty()) {
            QMAWLoader.qmaw.put(name, qmaw);
        }
    }
}

