/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.anim;

import com.hbm.config.ClientConfig;

public class BusAnimationKeyframe {
    public double value = 0.0;
    public IType interpolationType = IType.LINEAR;
    public EType easingType = EType.AUTO;
    public int originalDuration = 1;
    public int duration = 1;
    public double leftX;
    public double leftY;
    public HType leftType;
    public double rightX;
    public double rightY;
    public HType rightType;
    public double amplitude;
    public double period;
    public double back;
    static final double pow_min = 9.765625E-4;
    static final double pow_scale = 1.0009775161743164;

    public BusAnimationKeyframe() {
    }

    public BusAnimationKeyframe(double value, int duration) {
        this();
        this.value = value;
        this.originalDuration = this.duration = (int)((double)duration / Math.max(0.001, ClientConfig.GUN_ANIMATION_SPEED.get()));
    }

    public BusAnimationKeyframe(double value, int duration, IType interpolation) {
        this(value, duration);
        this.interpolationType = interpolation;
    }

    public BusAnimationKeyframe(double value, int duration, IType interpolation, EType easing) {
        this(value, duration, interpolation);
        this.easingType = easing;
    }

    public double interpolate(double startTime, double currentTime, BusAnimationKeyframe previous) {
        if (previous == null) {
            previous = new BusAnimationKeyframe();
        }
        double a = this.value;
        double b = previous.value;
        double t = this.time(startTime, currentTime, this.duration);
        double begin = previous.value;
        double change = this.value - previous.value;
        double time = currentTime - startTime;
        if (Math.abs(previous.value - this.value) < 1.0E-6) {
            return this.value;
        }
        if (previous.interpolationType == IType.BEZIER) {
            double len2;
            double v1x = startTime;
            double v1y = previous.value;
            double v2x = previous.rightX;
            double v2y = previous.rightY;
            double v3x = this.leftX;
            double v3y = this.leftY;
            double v4x = startTime + (double)this.duration;
            double v4y = this.value;
            double h1x = v1x - v2x;
            double h1y = v1y - v2y;
            double h2x = v4x - v3x;
            double h2y = v4y - v3y;
            double len = v4x - v1x;
            double len1 = Math.abs(h1x);
            if (len1 + (len2 = Math.abs(h2x)) != 0.0) {
                double fac;
                if (len1 > len) {
                    fac = len / len1;
                    v2x = v1x - fac * h1x;
                    v2y = v1y - fac * h1y;
                }
                if (len2 > len) {
                    fac = len / len2;
                    v3x = v4x - fac * h2x;
                    v3y = v4y - fac * h2y;
                }
            }
            double curveT = this.findZero(currentTime, v1x, v2x, v3x, v4x);
            return this.cubicBezier(v1y, v2y, v3y, v4y, curveT);
        }
        if (previous.interpolationType == IType.BACK) {
            switch (previous.easingType) {
                case EASE_IN: {
                    return this.BLI_easing_back_ease_in(time, begin, change, this.duration, previous.back);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_back_ease_in_out(time, begin, change, this.duration, previous.back);
                }
            }
            return this.BLI_easing_back_ease_out(time, begin, change, this.duration, previous.back);
        }
        if (previous.interpolationType == IType.BOUNCE) {
            switch (previous.easingType) {
                case EASE_IN: {
                    return this.BLI_easing_bounce_ease_in(time, begin, change, this.duration);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_bounce_ease_in_out(time, begin, change, this.duration);
                }
            }
            return this.BLI_easing_bounce_ease_out(time, begin, change, this.duration);
        }
        if (previous.interpolationType == IType.CIRC) {
            switch (previous.easingType) {
                case EASE_OUT: {
                    return this.BLI_easing_circ_ease_out(time, begin, change, this.duration);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_circ_ease_in_out(time, begin, change, this.duration);
                }
            }
            return this.BLI_easing_circ_ease_in(time, begin, change, this.duration);
        }
        if (previous.interpolationType == IType.CUBIC) {
            switch (previous.easingType) {
                case EASE_OUT: {
                    return this.BLI_easing_cubic_ease_out(time, begin, change, this.duration);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_cubic_ease_in_out(time, begin, change, this.duration);
                }
            }
            return this.BLI_easing_cubic_ease_in(time, begin, change, this.duration);
        }
        if (previous.interpolationType == IType.ELASTIC) {
            switch (previous.easingType) {
                case EASE_IN: {
                    return this.BLI_easing_elastic_ease_in(time, begin, change, this.duration, previous.amplitude, previous.period);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_elastic_ease_in_out(time, begin, change, this.duration, previous.amplitude, previous.period);
                }
            }
            return this.BLI_easing_elastic_ease_out(time, begin, change, this.duration, previous.amplitude, previous.period);
        }
        if (previous.interpolationType == IType.EXPO) {
            switch (previous.easingType) {
                case EASE_OUT: {
                    return this.BLI_easing_expo_ease_out(time, begin, change, this.duration);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_expo_ease_in_out(time, begin, change, this.duration);
                }
            }
            return this.BLI_easing_expo_ease_in(time, begin, change, this.duration);
        }
        if (previous.interpolationType == IType.QUAD) {
            switch (previous.easingType) {
                case EASE_OUT: {
                    return this.BLI_easing_quad_ease_out(time, begin, change, this.duration);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_quad_ease_in_out(time, begin, change, this.duration);
                }
            }
            return this.BLI_easing_quad_ease_in(time, begin, change, this.duration);
        }
        if (previous.interpolationType == IType.QUART) {
            switch (previous.easingType) {
                case EASE_OUT: {
                    return this.BLI_easing_quart_ease_out(time, begin, change, this.duration);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_quart_ease_in_out(time, begin, change, this.duration);
                }
            }
            return this.BLI_easing_quart_ease_in(time, begin, change, this.duration);
        }
        if (previous.interpolationType == IType.QUINT) {
            switch (previous.easingType) {
                case EASE_OUT: {
                    return this.BLI_easing_quint_ease_out(time, begin, change, this.duration);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_quint_ease_in_out(time, begin, change, this.duration);
                }
            }
            return this.BLI_easing_quint_ease_in(time, begin, change, this.duration);
        }
        if (previous.interpolationType == IType.SINE) {
            switch (previous.easingType) {
                case EASE_OUT: {
                    return this.BLI_easing_sine_ease_out(time, begin, change, this.duration);
                }
                case EASE_IN_OUT: {
                    return this.BLI_easing_sine_ease_in_out(time, begin, change, this.duration);
                }
            }
            return this.BLI_easing_sine_ease_in(time, begin, change, this.duration);
        }
        return (a - b) * t + b;
    }

    private double sqrt3(double d) {
        if (d > 1.0E-6) {
            return Math.exp(Math.log(d) / 3.0);
        }
        if (d > -1.0E-6) {
            return 0.0;
        }
        return -Math.exp(Math.log(-d) / 3.0);
    }

    private double time(double start, double end, double duration) {
        if (this.interpolationType == IType.SIN_UP) {
            return -Math.sin(((end - start) / duration * Math.PI + Math.PI) / 2.0) + 1.0;
        }
        if (this.interpolationType == IType.SIN_DOWN) {
            return Math.sin((end - start) / duration * Math.PI / 2.0);
        }
        if (this.interpolationType == IType.SIN_FULL) {
            return (-Math.cos((end - start) / duration * Math.PI) + 1.0) / 2.0;
        }
        return (end - start) / duration;
    }

    private double solveCubic(double c0, double c1, double c2, double c3) {
        if (c3 > 1.0E-6 || c3 < -1.0E-6) {
            double p;
            double q;
            double d;
            double a = c2 / c3;
            double b = c1 / c3;
            double c = c0 / c3;
            if ((d = (q = (2.0 * (a /= 3.0) * a * a - a * b + c) / 2.0) * q + (p = b / 3.0 - a * a) * p * p) > 1.0E-6) {
                double t = Math.sqrt(d);
                return this.sqrt3(-q + t) + this.sqrt3(-q - t) - a;
            }
            if (d > -1.0E-6) {
                double t = this.sqrt3(-q);
                double result = 2.0 * t - a;
                if (result < 1.0E-6 || result > 1.000001) {
                    result = -t - a;
                }
                return result;
            }
            double phi = Math.acos(-q / Math.sqrt(-(p * p * p)));
            double t = Math.sqrt(-p);
            p = Math.cos(phi / 3.0);
            q = Math.sqrt(3.0 - 3.0 * p * p);
            double result = 2.0 * t * p - a;
            if (result < 1.0E-6 || result > 1.000001) {
                result = -t * (p + q) - a;
            }
            if (result < 1.0E-6 || result > 1.000001) {
                result = -t * (p - q) - a;
            }
            return result;
        }
        double a = c2;
        double b = c1;
        double c = c0;
        if (a > 1.0E-6) {
            double p = b * b - 4.0 * a * c;
            if (p > 1.0E-6) {
                double result = (-b - (p = Math.sqrt(p))) / (2.0 * a);
                if (result < 1.0E-6 || result > 1.000001) {
                    result = (-b + p) / (2.0 * a);
                }
                return result;
            }
            if (p > -1.0E-6) {
                return -b / (2.0 * a);
            }
        }
        if (b > 1.0E-6) {
            return -c / b;
        }
        return 0.0;
    }

    private double findZero(double t, double x1, double x2, double x3, double x4) {
        double c0 = x1 - t;
        double c1 = 3.0 * (x2 - x1);
        double c2 = 3.0 * (x1 - 2.0 * x2 + x3);
        double c3 = x4 - x1 + 3.0 * (x2 - x3);
        return this.solveCubic(c0, c1, c2, c3);
    }

    private double cubicBezier(double y1, double y2, double y3, double y4, double t) {
        double c0 = y1;
        double c1 = 3.0 * (y2 - y1);
        double c2 = 3.0 * (y1 - 2.0 * y2 + y3);
        double c3 = y4 - y1 + 3.0 * (y2 - y3);
        return c0 + t * c1 + t * t * c2 + t * t * t * c3;
    }

    double BLI_easing_back_ease_in(double time, double begin, double change, double duration, double overshoot) {
        return change * (time /= duration) * time * ((overshoot + 1.0) * time - overshoot) + begin;
    }

    double BLI_easing_back_ease_out(double time, double begin, double change, double duration, double overshoot) {
        time = time / duration - 1.0;
        return change * (time * time * ((overshoot + 1.0) * time + overshoot) + 1.0) + begin;
    }

    double BLI_easing_back_ease_in_out(double time, double begin, double change, double duration, double overshoot) {
        double d;
        overshoot *= (double)1.525f;
        time /= duration / 2.0;
        if (d < 1.0) {
            return change / 2.0 * (time * time * ((overshoot + 1.0) * time - overshoot)) + begin;
        }
        return change / 2.0 * ((time -= 2.0) * time * ((overshoot + 1.0) * time + overshoot) + 2.0) + begin;
    }

    double BLI_easing_bounce_ease_out(double time, double begin, double change, double duration) {
        if ((time /= duration) < 0.3636363744735718) {
            return change * (7.5625 * time * time) + begin;
        }
        if (time < 0.7272727489471436) {
            return change * (7.5625 * (time -= 0.5454545617103577) * time + 0.75) + begin;
        }
        if (time < 0.9090909361839294) {
            return change * (7.5625 * (time -= 0.8181818127632141) * time + 0.9375) + begin;
        }
        return change * (7.5625 * (time -= 0.9545454382896423) * time + 0.984375) + begin;
    }

    double BLI_easing_bounce_ease_in(double time, double begin, double change, double duration) {
        return change - this.BLI_easing_bounce_ease_out(duration - time, 0.0, change, duration) + begin;
    }

    double BLI_easing_bounce_ease_in_out(double time, double begin, double change, double duration) {
        if (time < duration / 2.0) {
            return this.BLI_easing_bounce_ease_in(time * 2.0, 0.0, change, duration) * 0.5 + begin;
        }
        return this.BLI_easing_bounce_ease_out(time * 2.0 - duration, 0.0, change, duration) * 0.5 + change * 0.5 + begin;
    }

    double BLI_easing_circ_ease_in(double time, double begin, double change, double duration) {
        return -change * (Math.sqrt(1.0 - (time /= duration) * time) - 1.0) + begin;
    }

    double BLI_easing_circ_ease_out(double time, double begin, double change, double duration) {
        time = time / duration - 1.0;
        return change * Math.sqrt(1.0 - time * time) + begin;
    }

    double BLI_easing_circ_ease_in_out(double time, double begin, double change, double duration) {
        double d;
        time /= duration / 2.0;
        if (d < 1.0) {
            return -change / 2.0 * (Math.sqrt(1.0 - time * time) - 1.0) + begin;
        }
        return change / 2.0 * (Math.sqrt(1.0 - (time -= 2.0) * time) + 1.0) + begin;
    }

    double BLI_easing_cubic_ease_in(double time, double begin, double change, double duration) {
        return change * (time /= duration) * time * time + begin;
    }

    double BLI_easing_cubic_ease_out(double time, double begin, double change, double duration) {
        time = time / duration - 1.0;
        return change * (time * time * time + 1.0) + begin;
    }

    double BLI_easing_cubic_ease_in_out(double time, double begin, double change, double duration) {
        double d;
        time /= duration / 2.0;
        if (d < 1.0) {
            return change / 2.0 * time * time * time + begin;
        }
        return change / 2.0 * ((time -= 2.0) * time * time + 2.0) + begin;
    }

    double elastic_blend(double time, double change, double duration, double amplitude, double s, double f) {
        if (change != 0.0) {
            double t = Math.abs(s);
            f = amplitude != 0.0 ? (f *= amplitude / Math.abs(change)) : 0.0;
            if (Math.abs(time * duration) < t) {
                double l = Math.abs(time * duration) / t;
                f = f * l + (1.0 - l);
            }
        }
        return f;
    }

    double BLI_easing_elastic_ease_in(double time, double begin, double change, double duration, double amplitude, double period) {
        double s;
        double f = 1.0;
        if (time == 0.0) {
            return begin;
        }
        if ((time /= duration) == 1.0) {
            return begin + change;
        }
        time -= 1.0;
        if (period == 0.0) {
            period = duration * (double)0.3f;
        }
        if (amplitude == 0.0 || amplitude < Math.abs(change)) {
            s = period / 4.0;
            f = this.elastic_blend(time, change, duration, amplitude, s, f);
            amplitude = change;
        } else {
            s = period / (Math.PI * 2) * Math.asin(change / amplitude);
        }
        return -f * (amplitude * Math.pow(2.0, 10.0 * time) * Math.sin((time * duration - s) * (Math.PI * 2) / period)) + begin;
    }

    double BLI_easing_elastic_ease_out(double time, double begin, double change, double duration, double amplitude, double period) {
        double s;
        double f = 1.0;
        if (time == 0.0) {
            return begin;
        }
        if ((time /= duration) == 1.0) {
            return begin + change;
        }
        time = -time;
        if (period == 0.0) {
            period = duration * (double)0.3f;
        }
        if (amplitude == 0.0 || amplitude < Math.abs(change)) {
            s = period / 4.0;
            f = this.elastic_blend(time, change, duration, amplitude, s, f);
            amplitude = change;
        } else {
            s = period / (Math.PI * 2) * Math.asin(change / amplitude);
        }
        return f * (amplitude * Math.pow(2.0, 10.0 * time) * Math.sin((time * duration - s) * (Math.PI * 2) / period)) + change + begin;
    }

    double BLI_easing_elastic_ease_in_out(double time, double begin, double change, double duration, double amplitude, double period) {
        double s;
        double f = 1.0;
        if (time == 0.0) {
            return begin;
        }
        if ((time /= duration / 2.0) == 2.0) {
            return begin + change;
        }
        time -= 1.0;
        if (period == 0.0) {
            period = duration * 0.45000001788139343;
        }
        if (amplitude == 0.0 || amplitude < Math.abs(change)) {
            s = period / 4.0;
            f = this.elastic_blend(time, change, duration, amplitude, s, f);
            amplitude = change;
        } else {
            s = period / (Math.PI * 2) * Math.asin(change / amplitude);
        }
        if (time < 0.0) {
            return (f *= -0.5) * (amplitude * Math.pow(2.0, 10.0 * time) * Math.sin((time * duration - s) * (Math.PI * 2) / period)) + begin;
        }
        time = -time;
        return (f *= 0.5) * (amplitude * Math.pow(2.0, 10.0 * time) * Math.sin((time * duration - s) * (Math.PI * 2) / period)) + change + begin;
    }

    double BLI_easing_expo_ease_in(double time, double begin, double change, double duration) {
        if (time == 0.0) {
            return begin;
        }
        return change * (Math.pow(2.0, 10.0 * (time / duration - 1.0)) - 9.765625E-4) * 1.0009775161743164 + begin;
    }

    double BLI_easing_expo_ease_out(double time, double begin, double change, double duration) {
        if (time == 0.0) {
            return begin;
        }
        return change * (1.0 - (Math.pow(2.0, -10.0 * time / duration) - 9.765625E-4) * 1.0009775161743164) + begin;
    }

    double BLI_easing_expo_ease_in_out(double time, double begin, double change, double duration) {
        double duration_half = duration / 2.0;
        double change_half = change / 2.0;
        if (time <= duration_half) {
            return this.BLI_easing_expo_ease_in(time, begin, change_half, duration_half);
        }
        return this.BLI_easing_expo_ease_out(time - duration_half, begin + change_half, change_half, duration_half);
    }

    double BLI_easing_linear_ease(double time, double begin, double change, double duration) {
        return change * time / duration + begin;
    }

    double BLI_easing_quad_ease_in(double time, double begin, double change, double duration) {
        return change * (time /= duration) * time + begin;
    }

    double BLI_easing_quad_ease_out(double time, double begin, double change, double duration) {
        return -change * (time /= duration) * (time - 2.0) + begin;
    }

    double BLI_easing_quad_ease_in_out(double time, double begin, double change, double duration) {
        double d;
        time /= duration / 2.0;
        if (d < 1.0) {
            return change / 2.0 * time * time + begin;
        }
        return -change / 2.0 * ((time -= 1.0) * (time - 2.0) - 1.0) + begin;
    }

    double BLI_easing_quart_ease_in(double time, double begin, double change, double duration) {
        return change * (time /= duration) * time * time * time + begin;
    }

    double BLI_easing_quart_ease_out(double time, double begin, double change, double duration) {
        time = time / duration - 1.0;
        return -change * (time * time * time * time - 1.0) + begin;
    }

    double BLI_easing_quart_ease_in_out(double time, double begin, double change, double duration) {
        double d;
        time /= duration / 2.0;
        if (d < 1.0) {
            return change / 2.0 * time * time * time * time + begin;
        }
        return -change / 2.0 * ((time -= 2.0) * time * time * time - 2.0) + begin;
    }

    double BLI_easing_quint_ease_in(double time, double begin, double change, double duration) {
        return change * (time /= duration) * time * time * time * time + begin;
    }

    double BLI_easing_quint_ease_out(double time, double begin, double change, double duration) {
        time = time / duration - 1.0;
        return change * (time * time * time * time * time + 1.0) + begin;
    }

    double BLI_easing_quint_ease_in_out(double time, double begin, double change, double duration) {
        double d;
        time /= duration / 2.0;
        if (d < 1.0) {
            return change / 2.0 * time * time * time * time * time + begin;
        }
        return change / 2.0 * ((time -= 2.0) * time * time * time * time + 2.0) + begin;
    }

    double BLI_easing_sine_ease_in(double time, double begin, double change, double duration) {
        return -change * Math.cos(time / duration * Math.PI / 2.0) + change + begin;
    }

    double BLI_easing_sine_ease_out(double time, double begin, double change, double duration) {
        return change * Math.sin(time / duration * Math.PI / 2.0) + begin;
    }

    double BLI_easing_sine_ease_in_out(double time, double begin, double change, double duration) {
        return -change / 2.0 * (Math.cos(Math.PI * time / duration) - 1.0) + begin;
    }

    public static enum HType {
        FREE,
        ALIGNED,
        VECTOR,
        AUTO,
        AUTO_CLAMPED;

    }

    public static enum EType {
        AUTO,
        EASE_IN,
        EASE_OUT,
        EASE_IN_OUT;

    }

    public static enum IType {
        CONSTANT,
        LINEAR,
        SIN_UP,
        SIN_DOWN,
        SIN_FULL,
        BEZIER,
        SINE,
        QUAD,
        CUBIC,
        QUART,
        QUINT,
        EXPO,
        CIRC,
        BOUNCE,
        ELASTIC,
        BACK;

    }
}

