/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderLiberator
extends ItemRenderWeaponBase {
    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.25f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderLiberator.standardAimingTransform(stack, -1.5f * offset, -1.25f * offset, 1.25f * offset, 0.0, -0.578125, 0.25);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.liberator_tex);
        double scale = 0.375;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] lift = HbmAnimations.getRelevantTransformation("LIFT");
        double[] latch = HbmAnimations.getRelevantTransformation("LATCH");
        double[] brk = HbmAnimations.getRelevantTransformation("BREAK");
        double[] shell1 = HbmAnimations.getRelevantTransformation("SHELL1");
        double[] shell2 = HbmAnimations.getRelevantTransformation("SHELL2");
        double[] shell3 = HbmAnimations.getRelevantTransformation("SHELL3");
        double[] shell4 = HbmAnimations.getRelevantTransformation("SHELL4");
        GL11.glTranslated((double)0.0, (double)-1.0, (double)-3.0);
        GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)3.0);
        GL11.glTranslated((double)0.0, (double)-3.0, (double)-3.0);
        GL11.glRotated((double)lift[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)3.0, (double)3.0);
        GL11.glTranslated((double)(recoil[0] * 2.0), (double)recoil[1], (double)recoil[2]);
        GL11.glRotated((double)(recoil[2] * 10.0), (double)1.0, (double)0.0, (double)0.0);
        GL11.glShadeModel((int)7425);
        ResourceManager.liberator.renderPart("Gun");
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-0.5, (double)0.75);
        GL11.glRotated((double)brk[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.5, (double)-0.75);
        ResourceManager.liberator.renderPart("Barrel");
        GL11.glPushMatrix();
        GL11.glTranslated((double)shell1[0], (double)shell1[1], (double)shell1[2]);
        ResourceManager.liberator.renderPart("Shell1");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)shell2[0], (double)shell2[1], (double)shell2[2]);
        ResourceManager.liberator.renderPart("Shell2");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)shell3[0], (double)shell3[1], (double)shell3[2]);
        ResourceManager.liberator.renderPart("Shell3");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)shell4[0], (double)shell4[1], (double)shell4[2]);
        ResourceManager.liberator.renderPart("Shell4");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.15625, (double)0.75);
        GL11.glRotated((double)latch[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.15625, (double)-0.75);
        ResourceManager.liberator.renderPart("Latch");
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        double smokeScale = 0.375;
        GunConfig cfg = gun.getConfig(stack, 0);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.25, (double)7.25);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(0.25 / smokeScale));
        ItemRenderLiberator.renderSmokeNodes(cfg.smokeNodes, 1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-0.5 / smokeScale));
        ItemRenderLiberator.renderSmokeNodes(cfg.smokeNodes, 1.0);
        GL11.glTranslated((double)0.0, (double)(0.5 / smokeScale), (double)0.0);
        ItemRenderLiberator.renderSmokeNodes(cfg.smokeNodes, 1.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)(0.5 / smokeScale));
        ItemRenderLiberator.renderSmokeNodes(cfg.smokeNodes, 1.0);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.5, (double)8.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(90.0 * gun.shotRand), (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
        ItemRenderLiberator.renderMuzzleFlash(gun.lastShot[0], 75, 5.0);
        GL11.glPopMatrix();
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        GL11.glTranslated((double)0.0, (double)1.0, (double)3.0);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 1.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)0.5, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -8.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type, Object ... data) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.liberator_tex);
        ResourceManager.liberator.renderAll();
        GL11.glShadeModel((int)7424);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            long shot;
            EntityLivingBase ent = (EntityLivingBase)data[1];
            double shotRand = 0.0;
            if (ent == Minecraft.func_71410_x().field_71439_g) {
                ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
                shot = gun.lastShot[0];
                shotRand = gun.shotRand;
            } else {
                shot = ItemRenderWeaponBase.flashMap.getOrDefault(ent, -1L);
                if (shot < 0L) {
                    return;
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.5, (double)8.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 * shotRand), (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
            ItemRenderLiberator.renderMuzzleFlash(shot, 75, 5.0);
            GL11.glPopMatrix();
        }
    }
}

