/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderPepperbox
extends ItemRenderWeaponBase {
    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.5f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.5);
        float offset = 0.8f;
        ItemRenderPepperbox.standardAimingTransform(stack, -1.25f * offset, -0.75f * offset, 1.0f * offset, 0.0, -0.3125, 0.5);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        double scale = 0.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glShadeModel((int)7425);
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] cylinder = HbmAnimations.getRelevantTransformation("ROTATE");
        double[] hammer = HbmAnimations.getRelevantTransformation("HAMMER");
        double[] trigger = HbmAnimations.getRelevantTransformation("TRIGGER");
        double[] translate = HbmAnimations.getRelevantTransformation("TRANSLATE");
        double[] loader = HbmAnimations.getRelevantTransformation("LOADER");
        double[] shot = HbmAnimations.getRelevantTransformation("SHOT");
        GL11.glTranslated((double)translate[0], (double)translate[1], (double)translate[2]);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-5.0);
        GL11.glRotated((double)recoil[0], (double)-1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)5.0);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.5, (double)7.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        ItemRenderPepperbox.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 0.5);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.pepperbox_tex);
        if (loader[0] != 0.0 || loader[1] != 0.0 || loader[2] != 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)loader[0], (double)loader[1], (double)loader[2]);
            ResourceManager.pepperbox.renderPart("Speedloader");
            if (shot[0] != 0.0) {
                ResourceManager.pepperbox.renderPart("Shot");
            }
            GL11.glPopMatrix();
        }
        ResourceManager.pepperbox.renderPart("Grip");
        GL11.glPushMatrix();
        GL11.glRotated((double)cylinder[0], (double)0.0, (double)0.0, (double)1.0);
        ResourceManager.pepperbox.renderPart("Cylinder");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.375, (double)-1.875);
        GL11.glRotated((double)hammer[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.375, (double)1.875);
        ResourceManager.pepperbox.renderPart("Hammer");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-trigger[0] * 0.5));
        ResourceManager.pepperbox.renderPart("Trigger");
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.5, (double)7.0);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(90.0 * gun.shotRand), (double)1.0, (double)0.0, (double)0.0);
        ItemRenderPepperbox.renderMuzzleFlash(gun.lastShot[0]);
        GL11.glRotated((double)45.0, (double)1.0, (double)0.0, (double)0.0);
        ItemRenderPepperbox.renderMuzzleFlash(gun.lastShot[0]);
        GL11.glPopMatrix();
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        GL11.glTranslated((double)0.0, (double)1.0, (double)3.0);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 1.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -7.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type, Object ... data) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.pepperbox_tex);
        ResourceManager.pepperbox.renderPart("Grip");
        ResourceManager.pepperbox.renderPart("Cylinder");
        ResourceManager.pepperbox.renderPart("Hammer");
        ResourceManager.pepperbox.renderPart("Trigger");
        GL11.glShadeModel((int)7424);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            long shot;
            EntityLivingBase ent = (EntityLivingBase)data[1];
            double shotRand = 0.0;
            if (ent == Minecraft.func_71410_x().field_71439_g) {
                ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
                shot = gun.lastShot[0];
                shotRand = gun.shotRand;
            } else {
                shot = ItemRenderWeaponBase.flashMap.getOrDefault(ent, -1L);
                if (shot < 0L) {
                    return;
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.5, (double)7.0);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 * shotRand), (double)1.0, (double)0.0, (double)0.0);
            ItemRenderPepperbox.renderMuzzleFlash(shot);
            GL11.glRotated((double)45.0, (double)1.0, (double)0.0, (double)0.0);
            ItemRenderPepperbox.renderMuzzleFlash(shot);
            GL11.glPopMatrix();
        }
    }
}

