/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.item.ItemRenderMissileGeneric;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.tileentity.bomb.TileEntityLaunchPadLarge;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderLaunchPadLarge
extends TileEntitySpecialRenderer
implements IItemRendererProvider {
    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        switch (tileEntity.func_145832_p() - 10) {
            case 2: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        TileEntityLaunchPadLarge pad = (TileEntityLaunchPadLarge)tileEntity;
        this.func_147499_a(ResourceManager.missile_erector_tex);
        ResourceManager.missile_erector.renderPart("Pad");
        if (pad.formFactor >= 0 && pad.formFactor < ItemMissile.MissileFormFactor.values().length) {
            ItemMissile.MissileFormFactor formFactor = ItemMissile.MissileFormFactor.values()[pad.formFactor];
            String[] parts = null;
            double[] offset = null;
            switch (formFactor) {
                case ABM: {
                    parts = new String[]{"ABM_Pad", "ABM_Erector", "ABM_Pivot", "ABM_Rope"};
                    offset = new double[]{1.5, 1.25};
                    this.func_147499_a(ResourceManager.missile_erector_abm_tex);
                    break;
                }
                case MICRO: {
                    parts = new String[]{"Micro_Pad", "Micro_Erector", "Micro_Pivot", "Micro_Rope"};
                    offset = new double[]{1.5, 1.25};
                    this.func_147499_a(ResourceManager.missile_erector_micro_tex);
                    break;
                }
                case V2: {
                    parts = new String[]{"V2_Pad", "V2_Erector", "V2_Pivot", "V2_Rope"};
                    offset = new double[]{1.75, 1.25};
                    this.func_147499_a(ResourceManager.missile_erector_v2_tex);
                    break;
                }
                case STRONG: {
                    parts = new String[]{"Strong_Pad", "Strong_Erector", "Strong_Pivot", "Strong_Rope"};
                    offset = new double[]{3.0, 1.5};
                    this.func_147499_a(ResourceManager.missile_erector_strong_tex);
                    break;
                }
                case HUGE: {
                    parts = new String[]{"Huge_Pad", "Huge_Erector", "Huge_Pivot", "Huge_Rope"};
                    offset = new double[]{3.0, 1.5};
                    this.func_147499_a(ResourceManager.missile_erector_huge_tex);
                    break;
                }
                case ATLAS: {
                    parts = new String[]{"Atlas_Pad", "Atlas_Erector", "Atlas_Pivot", "Atlas_Rope"};
                    offset = new double[]{4.0, 1.5};
                    this.func_147499_a(ResourceManager.missile_erector_atlas_tex);
                    break;
                }
                case OTHER: {
                    parts = new String[]{"ABM_Pad", "ABM_Erector", "ABM_Pivot", "ABM_Rope"};
                    offset = new double[]{1.5, 1.25};
                    this.func_147499_a(ResourceManager.missile_erector_abm_tex);
                }
            }
            float erectorAngle = pad.prevErector + (pad.erector - pad.prevErector) * f;
            float erectorLift = pad.prevLift + (pad.lift - pad.prevLift) * f;
            GL11.glPushMatrix();
            GL11.glShadeModel((int)7425);
            ResourceManager.missile_erector.renderPart(parts[0]);
            if (pad.toRender != null && pad.erected) {
                ResourceManager.missile_erector.renderPart(parts[3]);
            }
            GL11.glTranslated((double)0.0, (double)offset[1], (double)(-offset[0]));
            GL11.glRotatef((float)(-erectorAngle), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)(-offset[1]), (double)offset[0]);
            ResourceManager.missile_erector.renderPart(parts[2]);
            GL11.glTranslatef((float)0.0f, (float)erectorLift, (float)0.0f);
            ResourceManager.missile_erector.renderPart(parts[1]);
            GL11.glShadeModel((int)7424);
            if (pad.erected) {
                GL11.glPopMatrix();
                GL11.glPushMatrix();
            }
            if (pad.toRender != null && (pad.erected || pad.readyToLoad)) {
                GL11.glTranslated((double)0.0, (double)2.0, (double)0.0);
                Consumer<TextureManager> renderer = ItemRenderMissileGeneric.renderers.get(new RecipesCommon.ComparableStack(pad.toRender).makeSingular());
                if (renderer != null) {
                    renderer.accept(this.field_147501_a.field_147553_e);
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @Override
    public Item getItemForRenderer() {
        return Item.func_150898_a((Block)ModBlocks.launch_pad_large);
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                GL11.glTranslated((double)0.0, (double)-3.75, (double)0.0);
                GL11.glScaled((double)1.625, (double)1.625, (double)1.625);
            }

            @Override
            public void renderCommonWithStack(ItemStack item) {
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glShadeModel((int)7425);
                RenderLaunchPadLarge.this.func_147499_a(ResourceManager.missile_erector_tex);
                ResourceManager.missile_erector.renderPart("Pad");
                RenderLaunchPadLarge.this.func_147499_a(ResourceManager.missile_erector_atlas_tex);
                ResourceManager.missile_erector.renderPart("Atlas_Pad");
                ResourceManager.missile_erector.renderPart("Atlas_Erector");
                ResourceManager.missile_erector.renderPart("Atlas_Pivot");
                GL11.glShadeModel((int)7424);
            }
        };
    }
}

