/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata.satellites;

import com.hbm.items.ModItems;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.SatelliteDysonRelay;
import com.hbm.saveddata.satellites.SatelliteHorizons;
import com.hbm.saveddata.satellites.SatelliteLaser;
import com.hbm.saveddata.satellites.SatelliteLunarMiner;
import com.hbm.saveddata.satellites.SatelliteMapper;
import com.hbm.saveddata.satellites.SatelliteMiner;
import com.hbm.saveddata.satellites.SatelliteRadar;
import com.hbm.saveddata.satellites.SatelliteRailgun;
import com.hbm.saveddata.satellites.SatelliteRelay;
import com.hbm.saveddata.satellites.SatelliteResonator;
import com.hbm.saveddata.satellites.SatelliteScanner;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class Satellite {
    public static final List<Class<? extends Satellite>> satellites = new ArrayList<Class<? extends Satellite>>();
    public static final HashMap<Item, Class<? extends Satellite>> itemToClass = new HashMap();
    private static final ResourceLocation satelliteTexture = new ResourceLocation("hbm", "textures/misc/space/satellite.png");
    public List<InterfaceActions> ifaceAcs = new ArrayList<InterfaceActions>();
    public List<CoordActions> coordAcs = new ArrayList<CoordActions>();
    public Interfaces satIface = Interfaces.NONE;

    public static void register() {
        Satellite.registerSatellite(SatelliteMapper.class, ModItems.sat_mapper);
        Satellite.registerSatellite(SatelliteScanner.class, ModItems.sat_scanner);
        Satellite.registerSatellite(SatelliteRadar.class, ModItems.sat_radar);
        Satellite.registerSatellite(SatelliteLaser.class, ModItems.sat_laser);
        Satellite.registerSatellite(SatelliteResonator.class, ModItems.sat_resonator);
        Satellite.registerSatellite(SatelliteRelay.class, ModItems.sat_foeq);
        Satellite.registerSatellite(SatelliteMiner.class, ModItems.sat_miner);
        Satellite.registerSatellite(SatelliteLunarMiner.class, ModItems.sat_lunar_miner);
        Satellite.registerSatellite(SatelliteDysonRelay.class, ModItems.sat_dyson_relay);
        Satellite.registerSatellite(SatelliteHorizons.class, ModItems.sat_gerald);
        Satellite.registerSatellite(SatelliteRailgun.class, ModItems.sat_war);
    }

    public static void registerSatellite(Class<? extends Satellite> sat, Item item) {
        if (!itemToClass.containsKey(item) && !itemToClass.containsValue(sat)) {
            satellites.add(sat);
            itemToClass.put(item, sat);
        }
    }

    public static void orbit(World world, int id, int freq, double x, double y, double z) {
        if (world.field_72995_K) {
            return;
        }
        Satellite sat = Satellite.create(id);
        if (sat != null) {
            SatelliteSavedData data = SatelliteSavedData.getData(world, (int)x, (int)z);
            data.sats.put(freq, sat);
            sat.onOrbit(world, x, y, z);
            data.func_76185_a();
        }
    }

    public static Satellite create(int id) {
        Satellite sat = null;
        try {
            Class<? extends Satellite> c = satellites.get(id);
            sat = c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sat;
    }

    public static int getIDFromItem(Item item) {
        Class<? extends Satellite> sat = itemToClass.get(item);
        return satellites.indexOf(sat);
    }

    public int getID() {
        return satellites.indexOf(this.getClass());
    }

    public void writeToNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public void serialize(ByteBuf buf) {
    }

    public void deserialize(ByteBuf buf) {
    }

    public void onOrbit(World world, double x, double y, double z) {
    }

    public void onClick(World world, int x, int z) {
    }

    public void onCoordAction(World world, EntityPlayer player, int x, int y, int z) {
    }

    protected abstract float[] getColor();

    public void render(float partialTicks, WorldClient world, Minecraft mc, float solarAngle, long id) {
        Satellite.renderDefault(partialTicks, world, mc, solarAngle, id, this.getColor());
    }

    public static void renderDefault(float partialTicks, WorldClient world, Minecraft mc, float solarAngle, long seed, float[] color) {
        if (color[3] <= 0.0f) {
            return;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        double ticks = (double)(System.currentTimeMillis() % 30000L) / 50.0;
        GL11.glPushMatrix();
        GL11.glRotatef((float)(solarAngle * -360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-40.0f + (float)(seed % 800L) * 0.1f - 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((float)(seed % 50L) * 0.1f - 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)(seed % 80L) * 0.1f - 2.5f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotated((double)(ticks / 600.0 * -360.0), (double)1.0, (double)0.0, (double)0.0);
        GL11.glColor4f((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        mc.field_71446_o.func_110577_a(satelliteTexture);
        float size = 0.5f;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-size), 100.0, (double)(-size), 0.0, 0.0);
        tessellator.func_78374_a((double)size, 100.0, (double)(-size), 0.0, 1.0);
        tessellator.func_78374_a((double)size, 100.0, (double)size, 1.0, 1.0);
        tessellator.func_78374_a((double)(-size), 100.0, (double)size, 1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public float getInterp() {
        return 0.0f;
    }

    public static enum Interfaces {
        NONE,
        SAT_PANEL,
        SAT_COORD;

    }

    public static enum CoordActions {
        HAS_Y;

    }

    public static enum InterfaceActions {
        HAS_MAP,
        CAN_CLICK,
        SHOW_COORDS,
        HAS_RADAR,
        HAS_ORES;

    }
}

