/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.dim.CelestialBody;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerDriveProcessor;
import com.hbm.inventory.gui.GUIMachineDriveProcessor;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCircuit;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.EnumUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineDriveProcessor
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
IEnergyReceiverMK2 {
    public long power;
    public long maxPower = 2000L;
    public boolean isProcessing;
    public int progress;
    public int maxProgress = 100;
    public String status = "";
    public boolean hasDrive = false;
    private int lastTier;
    AxisAlignedBB bb = null;

    public TileEntityMachineDriveProcessor() {
        super(4);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 3, this.power, this.maxPower);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            if ((double)this.power < (double)this.maxPower * 0.75) {
                this.isProcessing = false;
                this.status = EnumChatFormatting.RED + "No power ";
            } else if (this.slots[0] == null || this.slots[0].func_77973_b() != ModItems.full_drive) {
                this.isProcessing = false;
                this.status = "";
            } else if (this.getProcessingTier() < ItemVOTVdrive.getProcessingTier(this.slots[0], CelestialBody.getBody(this.field_145850_b))) {
                this.isProcessing = false;
                this.status = EnumChatFormatting.RED + "Low tier ";
            }
            if (this.lastTier != this.getProcessingTier()) {
                this.status = "";
            }
            if (this.isProcessing) {
                this.power -= 200L;
                this.status = EnumChatFormatting.GREEN + "" + EnumChatFormatting.ITALIC + "Processing  ";
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    this.progress = 0;
                    this.isProcessing = false;
                    ItemVOTVdrive.setProcessed(this.slots[0], true);
                    this.status = EnumChatFormatting.GREEN + "Done! ";
                }
            } else {
                this.progress = 0;
            }
            this.lastTier = this.getProcessingTier();
            this.hasDrive = this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.full_drive;
            this.networkPackNT(15);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeBoolean(this.isProcessing);
        buf.writeInt(this.progress);
        buf.writeBoolean(this.hasDrive);
        BufferUtil.writeString(buf, this.status);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.isProcessing = buf.readBoolean();
        this.progress = buf.readInt();
        this.hasDrive = buf.readBoolean();
        this.status = BufferUtil.readString(buf);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74778_a("status", this.status);
        nbt.func_74768_a("lastTier", this.lastTier);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.progress = nbt.func_74762_e("progress");
        this.status = nbt.func_74779_i("status");
        this.lastTier = nbt.func_74762_e("lastTier");
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    private int getProcessingTier() {
        if (this.slots[2] == null || this.slots[2].func_77973_b() != ModItems.circuit) {
            return 0;
        }
        ItemCircuit.EnumCircuitType num = (ItemCircuit.EnumCircuitType)((Object)EnumUtil.grabEnumSafely(ItemCircuit.EnumCircuitType.class, this.slots[2].func_77960_j()));
        switch (num) {
            case PROCESST1: {
                return 1;
            }
            case PROCESST2: {
                return 2;
            }
            case PROCESST3: {
                return 3;
            }
        }
        return 0;
    }

    private void processDrive(boolean process) {
        if (!process) {
            this.isProcessing = false;
            return;
        }
        if ((double)this.power < (double)this.maxPower * 0.75) {
            return;
        }
        if (this.slots[0] == null || this.slots[0].func_77973_b() != ModItems.full_drive) {
            return;
        }
        if (ItemVOTVdrive.getProcessed(this.slots[0])) {
            return;
        }
        if (this.getProcessingTier() >= ItemVOTVdrive.getProcessingTier(this.slots[0], CelestialBody.getBody(this.field_145850_b))) {
            this.isProcessing = true;
        }
    }

    private void cloneDrive() {
        if ((double)this.power < (double)this.maxPower * 0.75) {
            return;
        }
        if (this.slots[0] == null || this.slots[0].func_77973_b() != ModItems.full_drive) {
            return;
        }
        if (this.slots[1] == null || this.slots[1].func_77973_b() != ModItems.hard_drive) {
            this.status = EnumChatFormatting.RED + "No target ";
            return;
        }
        ItemVOTVdrive.markCopied(this.slots[0]);
        this.slots[1] = this.slots[0].func_77946_l();
        this.status = EnumChatFormatting.GREEN + "Drive cloned ";
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("process")) {
            this.processDrive(data.func_74767_n("process"));
        }
        if (data.func_74764_b("clone")) {
            this.cloneDrive();
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerDriveProcessor(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineDriveProcessor(player.field_71071_by, this);
    }

    @Override
    public String getName() {
        return "container.machineDriveProcessor";
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }
}

