/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.dim.CelestialBody;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;

public class TileEntityMachineGasDock
extends TileEntityMachineBase
implements IFluidStandardTransceiver {
    public FluidTank[] tanks = new FluidTank[3];
    public boolean hasRocket = true;
    public int launchTicks = 0;
    private AxisAlignedBB renderBoundingBox;
    private DirPos[] conPos;

    public TileEntityMachineGasDock() {
        super(0);
        this.tanks[0] = new FluidTank(Fluids.JOOLGAS, 64000);
        this.tanks[1] = new FluidTank(Fluids.HYDROGEN, 32000);
        this.tanks[2] = new FluidTank(Fluids.OXYGEN, 32000);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        nbt.func_74757_a("hasRocker", this.hasRocket);
        this.tanks[0].readFromNBT(nbt, "gas");
        this.tanks[1].readFromNBT(nbt, "f1");
        this.tanks[2].readFromNBT(nbt, "f2");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74767_n("hasRocker");
        this.tanks[0].writeToNBT(nbt, "gas");
        this.tanks[1].writeToNBT(nbt, "f1");
        this.tanks[2].writeToNBT(nbt, "f2");
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[0].getFill() <= 0) continue;
                this.sendFluid(this.tanks[0], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            CelestialBody planet = CelestialBody.getPlanet(this.field_145850_b);
            this.launchTicks = MathHelper.func_76125_a((int)(this.launchTicks + (this.hasRocket ? -1 : 1)), (int)(this.hasRocket ? -20 : 0), (int)100);
            if (planet.gas != null) {
                this.tanks[0].setTankType(planet.gas);
                if (this.hasFuel() && this.launchTicks <= -20) {
                    this.hasRocket = false;
                    this.collectGas();
                } else if (this.launchTicks >= 100) {
                    this.hasRocket = true;
                }
            }
            this.networkPackNT(150);
        } else {
            this.launchTicks = MathHelper.func_76125_a((int)(this.launchTicks + (this.hasRocket ? -1 : 1)), (int)(this.hasRocket ? -20 : 0), (int)100);
            if (this.launchTicks > 0 && this.launchTicks < 100) {
                ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5 + (double)this.launchTicks, (double)this.field_145849_e + 0.5, 0.0, -1.0, 0.0);
                if (this.launchTicks < 10) {
                    ExplosionLarge.spawnShock(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, 1 + this.field_145850_b.field_73012_v.nextInt(3), 1.0 + this.field_145850_b.field_73012_v.nextGaussian());
                }
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.hasRocket);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.hasRocket = buf.readBoolean();
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            for (int i = 1; i < this.tanks.length; ++i) {
                if (this.tanks[i].getTankType() == Fluids.NONE) continue;
                this.trySubscribe(this.tanks[i].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
    }

    private void collectGas() {
        if (this.tanks[1].getFill() < 500) {
            return;
        }
        if (this.tanks[2].getFill() < 500) {
            return;
        }
        if (this.tanks[0].getFill() + 8000 > this.tanks[0].getMaxFill()) {
            return;
        }
        this.tanks[1].setFill(this.tanks[1].getFill() - 500);
        this.tanks[2].setFill(this.tanks[2].getFill() - 500);
        this.tanks[0].setFill(this.tanks[0].getFill() + 8000);
    }

    private boolean hasFuel() {
        return this.tanks[1].getFill() >= 500 && this.tanks[2].getFill() >= 500;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBoundingBox == null) {
            this.renderBoundingBox = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.renderBoundingBox;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2]};
    }

    protected DirPos[] getConPos() {
        if (this.conPos == null) {
            ArrayList<DirPos> list = new ArrayList<DirPos>();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    list.add(new DirPos(this.field_145851_c + x, this.field_145848_d - 1, this.field_145849_e + z, Library.NEG_Y));
                }
            }
            for (int i = -1; i <= 1; ++i) {
                list.add(new DirPos(this.field_145851_c + i, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z));
                list.add(new DirPos(this.field_145851_c + i, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z));
                list.add(new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + i, Library.POS_X));
                list.add(new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + i, Library.NEG_X));
            }
            this.conPos = list.toArray(new DirPos[0]);
        }
        return this.conPos;
    }

    @Override
    public String getName() {
        return "container.gasDock";
    }
}

