/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockOreFluid;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityOilDrillBase
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IConfigurableMachine,
IPersistentNBT,
IGUIProvider,
IUpgradeInfoProvider,
IFluidCopiable {
    public int indicator = 0;
    public long power;
    public FluidTank[] tanks;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    public int speedLevel;
    public int energyLevel;
    public int overLevel;
    protected HashSet<Tuple.Triplet<Integer, Integer, Integer>> trace = new HashSet();

    public TileEntityOilDrillBase() {
        super(8);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.OIL, 64000);
        this.tanks[1] = new FluidTank(Fluids.GAS, 64000);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        boolean empty = this.power == 0L;
        for (FluidTank tank : this.tanks) {
            if (tank.getFill() <= 0) continue;
            empty = false;
        }
        if (!empty) {
            nbt.func_74772_a("power", this.power);
            for (int i = 0; i < this.tanks.length; ++i) {
                this.tanks[i].writeToNBT(nbt, "t" + i);
            }
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.tanks[0].unloadTank(1, 2, this.slots);
            this.tanks[1].unloadTank(3, 4, this.slots);
            this.upgradeManager.checkSlots(this, this.slots, 5, 7);
            this.speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            this.energyLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            this.overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE) + 1;
            int abLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.AFTERBURN);
            int toBurn = Math.min(this.tanks[1].getFill(), abLevel * 10);
            if (toBurn > 0) {
                this.tanks[1].setFill(this.tanks[1].getFill() - toBurn);
                this.power += (long)(toBurn * 5);
                if (this.power > this.getMaxPower()) {
                    this.power = this.getMaxPower();
                }
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[0].getFill() > 0) {
                    this.sendFluid(this.tanks[0], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                if (this.tanks[1].getFill() <= 0) continue;
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.power >= (long)this.getPowerReqEff() && this.tanks[0].getFill() < this.tanks[0].getMaxFill() && this.tanks[1].getFill() < this.tanks[1].getMaxFill()) {
                this.power -= (long)this.getPowerReqEff();
                if (this.field_145850_b.func_82737_E() % (long)this.getDelayEff() == 0L) {
                    this.indicator = 0;
                    for (int y = this.field_145848_d - 1; y >= this.getDrillDepth(); --y) {
                        if (this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) != ModBlocks.oil_pipe) {
                            if (!this.trySuck(y)) {
                                this.tryDrill(y);
                            }
                            break;
                        }
                        if (y != this.getDrillDepth()) continue;
                        this.indicator = 1;
                    }
                }
            } else {
                this.indicator = 2;
            }
            this.networkPackNT(25);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.indicator);
        for (FluidTank tank : this.tanks) {
            tank.serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.indicator = buf.readInt();
        for (FluidTank tank : this.tanks) {
            tank.deserialize(buf);
        }
    }

    public boolean canPump() {
        return true;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 5 && i <= 7 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    public int getPowerReqEff() {
        int req = this.getPowerReq();
        return (req + req / 4 * this.speedLevel - req / 4 * this.energyLevel) * this.overLevel;
    }

    public int getDelayEff() {
        int delay = this.getDelay();
        return Math.max((delay - delay / 4 * this.speedLevel + delay / 10 * this.energyLevel) / this.overLevel, 1);
    }

    public abstract int getPowerReq();

    public abstract int getDelay();

    public void tryDrill(int y) {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        if (b.func_149638_a(null) < 1000.0f) {
            this.onDrill(y);
            this.field_145850_b.func_147449_b(this.field_145851_c, y, this.field_145849_e, ModBlocks.oil_pipe);
        } else {
            this.indicator = 2;
        }
    }

    public void onDrill(int y) {
    }

    public int getDrillDepth() {
        return 5;
    }

    public boolean trySuck(int y) {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        if (!this.canSuckBlock(b)) {
            return false;
        }
        if (!this.canPump()) {
            return true;
        }
        this.trace.clear();
        return this.suckRec(this.field_145851_c, y, this.field_145849_e, 0);
    }

    public boolean canSuckBlock(Block b) {
        return b instanceof BlockOreFluid && b != ModBlocks.ore_bedrock_oil || BlockOreFluid.getFullBlock(b) != null;
    }

    public boolean suckRec(int x, int y, int z, int layer) {
        Tuple.Triplet<Integer, Integer, Integer> pos = new Tuple.Triplet<Integer, Integer, Integer>(x, y, z);
        if (this.trace.contains(pos)) {
            return false;
        }
        this.trace.add(pos);
        if (layer > 64) {
            return false;
        }
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if (b instanceof BlockOreFluid) {
            this.onSuck((BlockOreFluid)b, x, y, z);
            return true;
        }
        if (BlockOreFluid.getFullBlock(b) != null) {
            ForgeDirection[] dirs;
            for (ForgeDirection dir : dirs = BobMathUtil.getShuffledDirs()) {
                if (!this.suckRec(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, layer + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public void onSuck(BlockOreFluid block, int x, int y, int z) {
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        this.tanks[0].setTankType(block.getPrimaryFluid(meta));
        this.tanks[1].setTankType(block.getSecondaryFluid(meta));
        this.tanks[0].setFill(Math.min(this.tanks[0].getFill() + this.getPrimaryFluidAmount(block, meta), this.tanks[0].getMaxFill()));
        if (this.tanks[1].getTankType() != Fluids.NONE) {
            this.tanks[1].setFill(Math.min(this.tanks[1].getFill() + this.getSecondaryFluidAmount(block, meta), this.tanks[1].getMaxFill()));
        }
        this.attemptDrain(block, x, y, z, meta);
    }

    protected int getPrimaryFluidAmount(BlockOreFluid block, int meta) {
        return block.getPrimaryFluidAmount(meta);
    }

    protected int getSecondaryFluidAmount(BlockOreFluid block, int meta) {
        return block.getSecondaryFluidAmount(meta);
    }

    protected void attemptDrain(BlockOreFluid block, int x, int y, int z, int meta) {
        block.drain(this.field_145850_b, x, y, z, meta, 1.0);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[0];
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    public abstract DirPos[] getConPos();

    protected void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE || type == ItemMachineUpgrade.UpgradeType.AFTERBURN;
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.AFTERBURN, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

