/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IToolable;
import com.hbm.blocks.IBlockMultiPass;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.ICopiable;
import com.hbm.render.block.RenderBlockMultipass;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.Network;
import li.cil.oc.api.internal.Colored;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class BlockOpenComputersCablePaintable
extends BlockContainer
implements IToolable,
IBlockMultiPass {
    @SideOnly(value=Side.CLIENT)
    protected IIcon overlay;
    @SideOnly(value=Side.CLIENT)
    protected IIcon overlayColor;

    public BlockOpenComputersCablePaintable() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOpenComputersCablePaintable();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("hbm:oc_cable_base");
        this.overlay = reg.func_94245_a("hbm:oc_cable_overlay");
        this.overlayColor = reg.func_94245_a("hbm:oc_cable_color");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityOpenComputersCablePaintable pipe;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityOpenComputersCablePaintable && (pipe = (TileEntityOpenComputersCablePaintable)tile).block != null) {
            if (RenderBlockMultipass.currentPass == 1) {
                return this.overlay;
            }
            if (RenderBlockMultipass.currentPass == 2) {
                return this.overlayColor;
            }
            return pipe.block.func_149691_a(side, pipe.meta);
        }
        return RenderBlockMultipass.currentPass == 1 ? this.overlay : (RenderBlockMultipass.currentPass == 2 ? this.overlayColor : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (RenderBlockMultipass.currentPass == 2) {
            TileEntityOpenComputersCablePaintable tile = (TileEntityOpenComputersCablePaintable)world.func_147438_o(x, y, z);
            if (tile == null) {
                return 0xFFFFFF;
            }
            return tile.getColor();
        }
        return 0xFFFFFF;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fX, float fY, float fZ) {
        ItemStack stack = player.func_70694_bm();
        if (stack == null) {
            return super.func_149727_a(world, x, y, z, player, side, fX, fY, fZ);
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            TileEntityOpenComputersCablePaintable pipe;
            TileEntity tile;
            ItemBlock ib = (ItemBlock)stack.func_77973_b();
            Block block = ib.field_150939_a;
            if (block.func_149686_d() && block != this && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityOpenComputersCablePaintable && (pipe = (TileEntityOpenComputersCablePaintable)tile).block == null) {
                pipe.block = block;
                pipe.meta = stack.func_77960_j() & 0xF;
                world.func_147471_g(x, y, z);
                pipe.func_70296_d();
                return true;
            }
        } else {
            boolean isDye = false;
            int[] dicts = OreDictionary.getOreIDs((ItemStack)stack);
            for (int dict : dicts) {
                String dictName = OreDictionary.getOreName((int)dict);
                if (!dictName.equals("dye")) continue;
                isDye = true;
            }
            if (isDye) {
                Object tile = (TileEntityOpenComputersCablePaintable)world.func_147438_o(x, y, z);
                ((TileEntityOpenComputersCablePaintable)tile).setColor(CompatHandler.OCColors.fromDye(stack).getColor());
                world.func_147471_g(x, y, z);
                tile.func_70296_d();
            }
        }
        return super.func_149727_a(world, x, y, z, player, side, fX, fY, fZ);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        TileEntityOpenComputersCablePaintable pipe;
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityOpenComputersCablePaintable && (pipe = (TileEntityOpenComputersCablePaintable)tile).block != null) {
            pipe.block = null;
            world.func_147471_g(x, y, z);
            pipe.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public int getPasses() {
        return 3;
    }

    public int func_149645_b() {
        return IBlockMultiPass.getRenderType();
    }

    @Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.SidedEnvironment", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.Colored", modid="OpenComputers")})
    public static class TileEntityOpenComputersCablePaintable
    extends TileEntityLoadedBase
    implements Environment,
    SidedEnvironment,
    Colored,
    ICopiable {
        protected Node node;
        protected boolean addedToNetwork = false;
        private Block block;
        private int meta;
        private Block lastBlock;
        private int lastMeta;
        private CompatHandler.OCColors color = CompatHandler.OCColors.LIGHTGRAY;

        public TileEntityOpenComputersCablePaintable() {
            this.node = Network.newNode((Environment)this, (Visibility)Visibility.None).create();
        }

        public void func_145845_h() {
            super.func_145845_h();
            if (this.field_145850_b.field_72995_K && (this.lastBlock != this.block || this.lastMeta != this.meta)) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.lastBlock = this.block;
                this.lastMeta = this.meta;
            }
            if (!this.func_145831_w().field_72995_K && !this.addedToNetwork) {
                this.addedToNetwork = true;
                Network.joinOrCreateNetwork((TileEntity)this);
            }
        }

        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            int id = nbt.func_74762_e("block");
            this.block = id == 0 ? null : Block.func_149729_e((int)id);
            this.meta = nbt.func_74762_e("meta");
            this.color = CompatHandler.OCColors.fromInt(nbt.func_74762_e("dyeColor"));
            if (this.node != null && this.node.host() == this) {
                this.node.load(nbt.func_74775_l("oc:node"));
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            if (this.block != null) {
                nbt.func_74768_a("block", Block.func_149682_b((Block)this.block));
            }
            nbt.func_74768_a("meta", this.meta);
            nbt.func_74768_a("dyeColor", this.color.getColor());
            if (this.node != null && this.node.host() == this) {
                NBTTagCompound nodeNbt = new NBTTagCompound();
                this.node.save(nodeNbt);
                nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
            }
        }

        @Override
        public NBTTagCompound getSettings(World world, int x, int y, int z) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.block != null) {
                nbt.func_74768_a("paintblock", Block.func_149682_b((Block)this.block));
                nbt.func_74768_a("paintmeta", this.meta);
            }
            return nbt;
        }

        @Override
        public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
            if (nbt.func_74764_b("paintblock")) {
                this.block = Block.func_149729_e((int)nbt.func_74762_e("paintblock"));
                this.meta = nbt.func_74762_e("paintmeta");
                this.color = CompatHandler.OCColors.fromInt(nbt.func_74762_e("dyeColor"));
            }
        }

        public Node node() {
            return this.node;
        }

        public Node sidedNode(ForgeDirection side) {
            if (side == ForgeDirection.UNKNOWN) {
                return null;
            }
            int neighborX = this.field_145851_c + side.offsetX;
            int neighborY = this.field_145848_d + side.offsetY;
            int neighborZ = this.field_145849_e + side.offsetZ;
            TileEntity neighbor = this.field_145850_b.func_147438_o(neighborX, neighborY, neighborZ);
            if (!(neighbor instanceof Colored)) {
                if (neighbor instanceof Environment) {
                    return this.node;
                }
                return null;
            }
            Colored cable = (Colored)neighbor;
            if (cable.getColor() == this.color.getColor()) {
                return this.node;
            }
            return null;
        }

        public void onConnect(Node node) {
        }

        public void onDisconnect(Node node) {
        }

        public void onMessage(Message message) {
        }

        @Override
        public void onChunkUnload() {
            super.onChunkUnload();
            if (this.node != null) {
                this.node.remove();
            }
        }

        public void func_145843_s() {
            super.func_145843_s();
            if (this.node != null) {
                this.node.remove();
            }
        }

        public boolean canConnect(ForgeDirection side) {
            if (side == ForgeDirection.UNKNOWN) {
                return false;
            }
            int neighborX = this.field_145851_c + side.offsetX;
            int neighborY = this.field_145848_d + side.offsetY;
            int neighborZ = this.field_145849_e + side.offsetZ;
            TileEntity neighbor = this.field_145850_b.func_147438_o(neighborX, neighborY, neighborZ);
            if (!(neighbor instanceof Colored)) {
                return neighbor instanceof Environment;
            }
            Colored cable = (Colored)neighbor;
            return cable.getColor() == this.color.getColor();
        }

        public void setColor(int newColor) {
            this.color = CompatHandler.OCColors.fromInt(newColor);
        }

        public int getColor() {
            return this.color.getColor();
        }
    }
}

