/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.commands;

import com.hbm.lib.HbmWorld;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.gen.nbt.SpawnCondition;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class CommandLocate
extends CommandBase {
    private static final int MAX_DISTANCE = 256;

    public String func_71517_b() {
        return "ntmlocate";
    }

    public String func_71518_a(ICommandSender sender) {
        return String.format(Locale.US, "%s/%s structure <name> %s- Locates the nearest structure with a given name.", EnumChatFormatting.GREEN, this.func_71517_b(), EnumChatFormatting.LIGHT_PURPLE);
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            throw new PlayerNotFoundException();
        }
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equals("structure")) {
            int chunkZ;
            EntityPlayer player = (EntityPlayer)sender;
            SpawnCondition structure = NBTStructure.getStructure(args[1]);
            if (structure == null) {
                ChatComponentTranslation message = new ChatComponentTranslation("commands.locate.no_match", new Object[0]);
                message.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                sender.func_145747_a((IChatComponent)message);
                return;
            }
            int chunkX = MathHelper.func_76128_c((double)player.field_70165_t) / 16;
            ChunkCoordIntPair pos = this.getNearestLocationTo(structure, player.field_70170_p, chunkX, chunkZ = MathHelper.func_76128_c((double)player.field_70161_v) / 16);
            if (pos == null) {
                ChatComponentTranslation message = new ChatComponentTranslation("commands.locate.none_found", new Object[0]);
                message.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                sender.func_145747_a((IChatComponent)message);
                return;
            }
            ChatComponentTranslation message = new ChatComponentTranslation("commands.locate.success.coordinates", new Object[]{structure.name, pos.field_77276_a * 16, pos.field_77275_b * 16});
            message.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
            sender.func_145747_a((IChatComponent)message);
        } else if (args[0].equals("list")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(String.join((CharSequence)", ", NBTStructure.listStructures())));
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    private ChunkCoordIntPair getNearestLocationTo(SpawnCondition spawn, World world, int chunkX, int chunkZ) {
        if (HbmWorld.worldGenerator.getStructureAt(world, chunkX, chunkZ) == spawn) {
            return new ChunkCoordIntPair(chunkX, chunkZ);
        }
        for (int radius = 1; radius < 256; ++radius) {
            for (int x = chunkX - radius; x <= chunkX + radius; ++x) {
                if (HbmWorld.worldGenerator.getStructureAt(world, x, chunkZ - radius) == spawn) {
                    return new ChunkCoordIntPair(x, chunkZ - radius);
                }
                if (HbmWorld.worldGenerator.getStructureAt(world, x, chunkZ + radius) != spawn) continue;
                return new ChunkCoordIntPair(x, chunkZ + radius);
            }
            for (int z = chunkZ - radius; z <= chunkZ + radius; ++z) {
                if (HbmWorld.worldGenerator.getStructureAt(world, chunkX - radius, z) == spawn) {
                    return new ChunkCoordIntPair(chunkX - radius, z);
                }
                if (HbmWorld.worldGenerator.getStructureAt(world, chunkX + radius, z) != spawn) continue;
                return new ChunkCoordIntPair(chunkX + radius, z);
            }
        }
        return null;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandLocate.func_71530_a((String[])args, (String[])new String[]{"structure", "list"});
        }
        if (args.length == 2 && args[0].equals("structure")) {
            List<String> structures = NBTStructure.listStructures();
            return CommandLocate.func_71530_a((String[])args, (String[])structures.toArray(new String[structures.size()]));
        }
        return Collections.emptyList();
    }
}

