/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.config.FalloutConfigJSON;
import com.hbm.config.WorldConfig;
import com.hbm.entity.item.EntityFallingBlockNT;
import com.hbm.entity.logic.EntityExplosionChunkloading;
import com.hbm.world.WorldUtil;
import com.hbm.world.biome.BiomeGenCraterBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityFalloutRain
extends EntityExplosionChunkloading {
    private boolean firstTick = true;
    private int tickDelay = BombConfig.fDelay;
    private final List<Long> chunksToProcess = new ArrayList<Long>();
    private final List<Long> outerChunksToProcess = new ArrayList<Long>();

    public EntityFalloutRain(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public EntityFalloutRain(World p_i1582_1_, int maxAge) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70178_ae = true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            long start = System.currentTimeMillis();
            if (this.firstTick) {
                if (this.chunksToProcess.isEmpty() && this.outerChunksToProcess.isEmpty()) {
                    this.gatherChunks();
                }
                this.firstTick = false;
            }
            if (this.tickDelay == 0) {
                this.tickDelay = BombConfig.fDelay;
                while (System.currentTimeMillis() < start + (long)BombConfig.mk5) {
                    int z;
                    int x;
                    boolean biomeModified;
                    int chunkPosZ;
                    int chunkPosX;
                    long chunkPos;
                    if (!this.chunksToProcess.isEmpty()) {
                        chunkPos = this.chunksToProcess.remove(this.chunksToProcess.size() - 1);
                        chunkPosX = (int)(chunkPos & Integer.MAX_VALUE);
                        chunkPosZ = (int)(chunkPos >> 32 & Integer.MAX_VALUE);
                        biomeModified = false;
                        for (x = chunkPosX << 4; x < (chunkPosX << 4) + 16; ++x) {
                            for (z = chunkPosZ << 4; z < (chunkPosZ << 4) + 16; ++z) {
                                double percent = Math.hypot((double)x - this.field_70165_t, (double)z - this.field_70161_v) * 100.0 / (double)this.getScale();
                                this.stomp(x, z, percent);
                                BiomeGenBase biome = EntityFalloutRain.getBiomeChange(percent, this.getScale(), this.field_70170_p.func_72807_a(x, z));
                                if (biome == null) continue;
                                WorldUtil.setBiome(this.field_70170_p, x, z, biome);
                                biomeModified = true;
                            }
                        }
                        if (!biomeModified) continue;
                        WorldUtil.syncBiomeChange(this.field_70170_p, chunkPosX << 4, chunkPosZ << 4);
                        continue;
                    }
                    if (!this.outerChunksToProcess.isEmpty()) {
                        chunkPos = this.outerChunksToProcess.remove(this.outerChunksToProcess.size() - 1);
                        chunkPosX = (int)(chunkPos & Integer.MAX_VALUE);
                        chunkPosZ = (int)(chunkPos >> 32 & Integer.MAX_VALUE);
                        biomeModified = false;
                        for (x = chunkPosX << 4; x < (chunkPosX << 4) + 16; ++x) {
                            for (z = chunkPosZ << 4; z < (chunkPosZ << 4) + 16; ++z) {
                                double distance = Math.hypot((double)x - this.field_70165_t, (double)z - this.field_70161_v);
                                if (!(distance <= (double)this.getScale())) continue;
                                double percent = distance * 100.0 / (double)this.getScale();
                                this.stomp(x, z, percent);
                                BiomeGenBase biome = EntityFalloutRain.getBiomeChange(percent, this.getScale(), this.field_70170_p.func_72807_a(x, z));
                                if (biome == null) continue;
                                WorldUtil.setBiome(this.field_70170_p, x, z, biome);
                                biomeModified = true;
                            }
                        }
                        if (!biomeModified) continue;
                        WorldUtil.syncBiomeChange(this.field_70170_p, chunkPosX << 4, chunkPosZ << 4);
                        continue;
                    }
                    this.clearChunkLoader();
                    this.func_70106_y();
                    break;
                }
            }
            --this.tickDelay;
        }
    }

    public static BiomeGenBase getBiomeChange(double dist, int scale, BiomeGenBase original) {
        if (!WorldConfig.enableCraterBiomes) {
            return null;
        }
        if (scale >= 150 && dist < 15.0) {
            return BiomeGenCraterBase.craterInnerBiome;
        }
        if (scale >= 100 && dist < 55.0 && original != BiomeGenCraterBase.craterInnerBiome) {
            return BiomeGenCraterBase.craterBiome;
        }
        if (scale >= 25 && original != BiomeGenCraterBase.craterInnerBiome && original != BiomeGenCraterBase.craterBiome) {
            return BiomeGenCraterBase.craterOuterBiome;
        }
        return null;
    }

    private void gatherChunks() {
        LinkedHashSet<Long> chunks = new LinkedHashSet<Long>();
        LinkedHashSet<Long> outerChunks = new LinkedHashSet<Long>();
        int outerRange = this.getScale();
        int adjustedMaxAngle = 20 * outerRange / 32;
        for (int angle = 0; angle <= adjustedMaxAngle; ++angle) {
            Vec3 vector = Vec3.func_72443_a((double)outerRange, (double)0.0, (double)0.0);
            vector.func_72442_b((float)((double)angle * Math.PI / 180.0 / ((double)adjustedMaxAngle / 360.0)));
            outerChunks.add(ChunkCoordIntPair.func_77272_a((int)((int)(this.field_70165_t + vector.field_72450_a) >> 4), (int)((int)(this.field_70161_v + vector.field_72449_c) >> 4)));
        }
        for (int distance = 0; distance <= outerRange; distance += 8) {
            for (int angle = 0; angle <= adjustedMaxAngle; ++angle) {
                Vec3 vector = Vec3.func_72443_a((double)distance, (double)0.0, (double)0.0);
                vector.func_72442_b((float)((double)angle * Math.PI / 180.0 / ((double)adjustedMaxAngle / 360.0)));
                long chunkCoord = ChunkCoordIntPair.func_77272_a((int)((int)(this.field_70165_t + vector.field_72450_a) >> 4), (int)((int)(this.field_70161_v + vector.field_72449_c) >> 4));
                if (outerChunks.contains(chunkCoord)) continue;
                chunks.add(chunkCoord);
            }
        }
        this.chunksToProcess.addAll(chunks);
        this.outerChunksToProcess.addAll(outerChunks);
        Collections.reverse(this.chunksToProcess);
        Collections.reverse(this.outerChunksToProcess);
    }

    private void stomp(int x, int z, double dist) {
        int depth = 0;
        for (int y = 255; y >= 0; --y) {
            double d;
            double chance;
            if (depth >= 3) {
                return;
            }
            Block b = this.field_70170_p.func_147439_a(x, y, z);
            if (b.func_149688_o() == Material.field_151579_a || b == ModBlocks.fallout) continue;
            if (b == ModBlocks.volcano_core) {
                this.field_70170_p.func_147465_d(x, y, z, ModBlocks.volcano_rad_core, this.field_70170_p.func_72805_g(x, y, z), 3);
                continue;
            }
            Block ab = this.field_70170_p.func_147439_a(x, y + 1, z);
            int meta = this.field_70170_p.func_72805_g(x, y, z);
            if (depth == 0 && b != ModBlocks.fallout && (ab == Blocks.field_150350_a || ab.isReplaceable((IBlockAccess)this.field_70170_p, x, y + 1, z) && !ab.func_149688_o().func_76224_d()) && (chance = 0.1 - Math.pow(((d = dist / 100.0) - 0.7) * 1.0, 2.0)) >= this.field_70146_Z.nextDouble() && ModBlocks.fallout.func_149742_c(this.field_70170_p, x, y + 1, z)) {
                this.setBlock(x, y + 1, z, ModBlocks.fallout);
            }
            if (dist < 65.0 && b.isFlammable((IBlockAccess)this.field_70170_p, x, y, z, ForgeDirection.UP) && this.field_70146_Z.nextInt(5) == 0 && this.field_70170_p.func_147439_a(x, y + 1, z).isAir((IBlockAccess)this.field_70170_p, x, y + 1, z)) {
                this.setBlock(x, y + 1, z, (Block)Blocks.field_150480_ab);
            }
            boolean eval = false;
            for (FalloutConfigJSON.FalloutEntry entry : FalloutConfigJSON.entries) {
                if (!entry.eval(this.field_70170_p, x, y, z, b, meta, dist)) continue;
                if (entry.isSolid()) {
                    ++depth;
                }
                eval = true;
                break;
            }
            float hardness = b.func_149712_f(this.field_70170_p, x, y, z);
            if (y > 0 && dist < 65.0 && hardness <= Blocks.field_150417_aV.func_149638_a(null) && hardness >= 0.0f && !(b instanceof BlockDummyable) && this.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150350_a) {
                for (int i = 0; i <= depth; ++i) {
                    Block block = this.field_70170_p.func_147439_a(x, y + i, z);
                    hardness = block.func_149712_f(this.field_70170_p, x, y + i, z);
                    if (!(hardness <= Blocks.field_150417_aV.func_149638_a(null)) || !(hardness >= 0.0f)) continue;
                    EntityFallingBlockNT entityfallingblock = new EntityFallingBlockNT(this.field_70170_p, (double)x + 0.5, (double)y + 0.5 + (double)i, (double)z + 0.5, block, this.field_70170_p.func_72805_g(x, y + i, z));
                    entityfallingblock.canDrop = false;
                    this.field_70170_p.func_72838_d((Entity)entityfallingblock);
                }
            }
            if (eval || !b.func_149721_r()) continue;
            ++depth;
        }
    }

    public void setBlock(int x, int y, int z, Block block) {
        this.setBlock(x, y, z, block, 0);
    }

    public void setBlock(int x, int y, int z, Block block, int meta) {
        this.field_70170_p.func_147465_d(x, y, z, block, meta, 3);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.setScale(tag.func_74762_e("scale"));
        this.chunksToProcess.addAll(this.readChunksFromIntArray(tag.func_74759_k("chunks")));
        this.outerChunksToProcess.addAll(this.readChunksFromIntArray(tag.func_74759_k("outerChunks")));
    }

    private Collection<Long> readChunksFromIntArray(int[] data) {
        ArrayList<Long> coords = new ArrayList<Long>();
        boolean firstPart = true;
        int x = 0;
        for (int coord : data) {
            if (firstPart) {
                x = coord;
            } else {
                coords.add(ChunkCoordIntPair.func_77272_a((int)x, (int)coord));
            }
            firstPart = !firstPart;
        }
        return coords;
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("scale", this.getScale());
        tag.func_74783_a("chunks", this.writeChunksToIntArray(this.chunksToProcess));
        tag.func_74783_a("outerChunks", this.writeChunksToIntArray(this.outerChunksToProcess));
    }

    private int[] writeChunksToIntArray(List<Long> coords) {
        int[] data = new int[coords.size() * 2];
        for (int i = 0; i < coords.size(); ++i) {
            data[i * 2] = (int)(coords.get(i) & Integer.MAX_VALUE);
            data[i * 2 + 1] = (int)(coords.get(i) >> 32 & Integer.MAX_VALUE);
        }
        return data;
    }

    public void setScale(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    public int getScale() {
        int scale = this.field_70180_af.func_75679_c(16);
        return scale == 0 ? 1 : scale;
    }
}

