/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public class FusionRecipe
extends GenericRecipe {
    public long ignitionTemp;
    public long outputTemp;
    public double neutronFlux;
    public float r = 1.0f;
    public float g = 0.2f;
    public float b = 0.6f;

    public FusionRecipe(String name) {
        super(name);
    }

    public FusionRecipe setInputEnergy(long ignitionTemp) {
        this.ignitionTemp = ignitionTemp;
        return this;
    }

    public FusionRecipe setOutputEnergy(long outputTemp) {
        this.outputTemp = outputTemp;
        return this;
    }

    public FusionRecipe setOutputFlux(double neutronFlux) {
        this.neutronFlux = neutronFlux;
        return this;
    }

    public FusionRecipe setRGB(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }

    @Override
    public List<String> print() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EnumChatFormatting.YELLOW + this.getLocalizedName());
        this.duration(list);
        this.power(list);
        list.add(EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("gui.recipe.fusionIn", new Object[0]) + ": " + BobMathUtil.getShortNumber(this.ignitionTemp) + "KyU/t");
        list.add(EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("gui.recipe.fusionOut", new Object[0]) + ": " + BobMathUtil.getShortNumber(this.outputTemp) + "TU/t");
        list.add(EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey("gui.recipe.fusionFlux", new Object[0]) + ": " + (double)((int)(this.neutronFlux * 10.0)) / 10.0 + " flux/t");
        this.input(list);
        this.output(list);
        return list;
    }
}

