/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.hbm.config.GeneralConfig;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.items.BrokenItem;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCircuit;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;

public class PrecAssRecipes
extends GenericRecipes<GenericRecipe> {
    public static final PrecAssRecipes INSTANCE = new PrecAssRecipes();

    @Override
    public int inputItemLimit() {
        return 9;
    }

    @Override
    public int inputFluidLimit() {
        return 1;
    }

    @Override
    public int outputItemLimit() {
        return 9;
    }

    @Override
    public int outputFluidLimit() {
        return 1;
    }

    @Override
    public String getFileName() {
        return "hbmPrecisionAssembly.json";
    }

    @Override
    public GenericRecipe instantiateRecipe(String name) {
        return new GenericRecipe(name);
    }

    @Override
    public void registerDefaults() {
        if (GeneralConfig.enable528) {
            this.registerPair(new GenericRecipe("precass.chip").setup(100, 200L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.SILICON), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 3), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireFine(), 4)).setPools("528.chip"), OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.CHIP), 50, GeneralConfig.enableExpensiveMode ? 10 : 90);
            this.registerPair(new GenericRecipe("precass.chip_bismoid").setup(200, 1000L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.SILICON), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_BISMOID.nugget(), 2), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireFine(), 4)).inputFluids(new FluidStack(Fluids.PERFLUOROMETHYL, 1000)).setPools("528.chip_bismoid"), OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.CHIP_BISMOID), 50, GeneralConfig.enableExpensiveMode ? 10 : 75);
            this.registerPair(new GenericRecipe("precass.chip_quantum").setup(300, 20000L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 8, (Enum)ItemCircuit.EnumCircuitType.SILICON), new RecipesCommon.OreDictStack(OreDictManager.BSCCO.wireDense(), 2), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.pellet_charged, 4), new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireFine(), 8)).inputFluids(new FluidStack(Fluids.HELIUM4, 4000)).setPools("528.chip_quantum"), OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.CHIP_QUANTUM), 50, GeneralConfig.enableExpensiveMode ? 10 : 50);
            this.registerPair(new GenericRecipe("precass.atomic_clock").setup(200, 2000L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 8, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.ZR.wireFine(), 8), new RecipesCommon.OreDictStack(OreDictManager.SR.dust(), 1)).setPools("528.strontium"), OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.ATOMIC_CLOCK), 50, GeneralConfig.enableExpensiveMode ? 10 : 50);
            this.registerPair(new GenericRecipe("precass.controller").setup(400, 15000L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 32, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, 32, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR), new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER_CHASSIS), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_1), new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 16)).inputFluids(new FluidStack(Fluids.PERFLUOROMETHYL, 1000)), OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER), 10, GeneralConfig.enableExpensiveMode ? 50 : 90);
            this.registerPair(new GenericRecipe("precass.controller_advanced").setup(600, 25000L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.CHIP_BISMOID), new RecipesCommon.ComparableStack(ModItems.circuit, 48, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.ATOMIC_CLOCK), new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER_CHASSIS), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3), new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 24)).inputFluids(new FluidStack(Fluids.PERFLUOROMETHYL, 4000)), OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED), 10, GeneralConfig.enableExpensiveMode ? 33 : 75);
            this.registerPair(new GenericRecipe("precass.controller_quantum").setup(600, 250000L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.CHIP_QUANTUM), new RecipesCommon.ComparableStack(ModItems.circuit, 48, (Enum)ItemCircuit.EnumCircuitType.CHIP_BISMOID), new RecipesCommon.ComparableStack(ModItems.circuit, 8, (Enum)ItemCircuit.EnumCircuitType.ATOMIC_CLOCK), new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER_ADVANCED), new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_1), new RecipesCommon.OreDictStack(OreDictManager.PB.wireFine(), 32)).inputFluids(new FluidStack(Fluids.PERFLUOROMETHYL_COLD, 6000)), OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER_QUANTUM), 5, GeneralConfig.enableExpensiveMode ? 10 : 50);
            this.addFirstUpgrade(ModItems.upgrade_speed_1, ModItems.upgrade_speed_2, "precass.upgrade_speed_ii");
            this.addSecondUpgrade(ModItems.upgrade_speed_2, ModItems.upgrade_speed_3, "precass.upgrade_speed_iii");
            this.addFirstUpgrade(ModItems.upgrade_effect_1, ModItems.upgrade_effect_2, "precass.upgrade_effect_ii");
            this.addSecondUpgrade(ModItems.upgrade_effect_2, ModItems.upgrade_effect_3, "precass.upgrade_effect_iii");
            this.addFirstUpgrade(ModItems.upgrade_power_1, ModItems.upgrade_power_2, "precass.upgrade_power_ii");
            this.addSecondUpgrade(ModItems.upgrade_power_2, ModItems.upgrade_power_3, "precass.upgrade_power_iii");
            this.addFirstUpgrade(ModItems.upgrade_fortune_1, ModItems.upgrade_fortune_2, "precass.upgrade_fortune_ii");
            this.addSecondUpgrade(ModItems.upgrade_fortune_2, ModItems.upgrade_fortune_3, "precass.upgrade_fortune_iii");
            this.addFirstUpgrade(ModItems.upgrade_afterburn_1, ModItems.upgrade_afterburn_2, "precass.upgrade_ab_ii");
            this.addSecondUpgrade(ModItems.upgrade_afterburn_2, ModItems.upgrade_afterburn_3, "precass.upgrade_ab_iii");
            this.registerPair(new GenericRecipe("precass.upgrade_overdive_i").setup(200, 1000L).inputItems(new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_effect_3, 1), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.ADVANCED)), new ItemStack(ModItems.upgrade_overdrive_1), 10, GeneralConfig.enableExpensiveMode ? 10 : 50);
            this.registerPair(new GenericRecipe("precass.upgrade_overdive_ii").setup(600, 5000L).inputItems(new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_1, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_effect_3, 1), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.ingot_cft, 8), new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_BOARD)), new ItemStack(ModItems.upgrade_overdrive_2), 10, GeneralConfig.enableExpensiveMode ? 10 : 50);
            this.registerPair(new GenericRecipe("precass.upgrade_overdive_iii").setup(1200, 100000L).inputItems(new RecipesCommon.ComparableStack(ModItems.upgrade_overdrive_2, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_speed_3, 1), new RecipesCommon.ComparableStack(ModItems.upgrade_effect_3, 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_BISMOIDBRONZE.ingot(), 16), new RecipesCommon.ComparableStack(ModItems.ingot_cft, 16), new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.BISMOID)), new ItemStack(ModItems.upgrade_overdrive_3), 5, GeneralConfig.enableExpensiveMode ? 10 : 50);
        }
        int min = 1200;
        this.register(new GenericRecipe("precass.blueprints").setup(5 * min, 20000L).inputItems(new RecipesCommon.ComparableStack(Items.field_151121_aF, 16), new RecipesCommon.OreDictStack("dyeBlue", 16), new RecipesCommon.ComparableStack(Items.field_151115_aP, 4, (Enum)ItemFishFood.FishType.PUFFERFISH)).outputItems(new GenericRecipes.ChanceOutputMulti(new GenericRecipes.ChanceOutput(new ItemStack(ModItems.blueprint_folder, 1, 0), 10), new GenericRecipes.ChanceOutput(new ItemStack(Items.field_151121_aF, 16, 0), 90))));
        this.register(new GenericRecipe("precass.beigeprints").setup(5 * min, 50000L).inputItems(new RecipesCommon.ComparableStack(Items.field_151121_aF, 24), new RecipesCommon.OreDictStack(OreDictManager.CINNABAR.gem(), 24), new RecipesCommon.ComparableStack(Items.field_151115_aP, 8, (Enum)ItemFishFood.FishType.PUFFERFISH)).outputItems(new GenericRecipes.ChanceOutputMulti(new GenericRecipes.ChanceOutput(new ItemStack(ModItems.blueprint_folder, 1, 1), 5), new GenericRecipes.ChanceOutput(new ItemStack(Items.field_151121_aF, 24, 0), 95))));
    }

    public void addFirstUpgrade(Item lower, Item higher, String name) {
        this.registerPair(new GenericRecipe(name).setup(300, 10000L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 8, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM), new RecipesCommon.ComparableStack(lower), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4)), new ItemStack(higher), 15, 25);
    }

    public void addSecondUpgrade(Item lower, Item higher, String name) {
        this.registerPair(new GenericRecipe(name).setup(400, 25000L).inputItems(new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.CHIP), new RecipesCommon.ComparableStack(ModItems.circuit, 16, (Enum)ItemCircuit.EnumCircuitType.CAPACITOR_TANTALIUM), new RecipesCommon.ComparableStack(lower), new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 4)).inputFluids(new FluidStack(Fluids.SOLVENT, 500)), new ItemStack(higher), 5, 10);
    }

    public void registerPair(GenericRecipe recipe, ItemStack output, int chance, int reclaim) {
        FluidStack[] fluid;
        recipe.outputItems(new GenericRecipes.ChanceOutputMulti(new GenericRecipes.ChanceOutput(output, chance), new GenericRecipes.ChanceOutput(BrokenItem.make(output), 100 - chance)));
        this.register(recipe);
        float fReclaim = (float)reclaim / 100.0f;
        GenericRecipes.IOutput[] recycle = new GenericRecipes.IOutput[recipe.inputItem.length];
        for (int i = 0; i < recycle.length; ++i) {
            ItemStack stack = recipe.inputItem[i].extractForNEI().get(0).func_77946_l();
            recycle[i] = new GenericRecipes.ChanceOutput(stack, fReclaim);
        }
        FluidStack[] fluidStackArray = fluid = recipe.inputFluid != null ? new FluidStack[1] : null;
        if (fluid != null) {
            fluid[0] = new FluidStack(recipe.inputFluid[0].type, Math.round((float)recipe.inputFluid[0].fill * fReclaim));
        }
        this.register(new GenericRecipe(recipe.getInternalName() + ".recycle").setup(recipe.duration, recipe.power).setNameWrapper("precass.recycle").setIcon(BrokenItem.make(output)).inputItems(new RecipesCommon.NBTStack(BrokenItem.make(output))).outputItems(recycle).outputFluids(fluid));
    }
}

