/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.ItemStackUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class RefineryRecipes
extends SerializableRecipe {
    public static final int oil_frac_heavy = 50;
    public static final int oil_frac_naph = 25;
    public static final int oil_frac_light = 15;
    public static final int oil_frac_petro = 10;
    public static final int crack_frac_naph = 40;
    public static final int crack_frac_light = 30;
    public static final int crack_frac_aroma = 15;
    public static final int crack_frac_unsat = 15;
    public static final int oilds_frac_heavy = 30;
    public static final int oilds_frac_naph = 35;
    public static final int oilds_frac_light = 20;
    public static final int oilds_frac_unsat = 15;
    public static final int crackds_frac_naph = 35;
    public static final int crackds_frac_light = 35;
    public static final int crackds_frac_aroma = 15;
    public static final int crackds_frac_unsat = 15;
    private static Map<FluidType, RefineryRecipe> recipes = new HashMap<FluidType, RefineryRecipe>();

    @Override
    public void registerDefaults() {
        recipes.put(Fluids.HOTOIL, new RefineryRecipe(new FluidStack(Fluids.HEAVYOIL, 50), new FluidStack(Fluids.NAPHTHA, 25), new FluidStack(Fluids.LIGHTOIL, 15), new FluidStack(Fluids.PETROLEUM, 10), new ItemStack(ModItems.sulfur)));
        recipes.put(Fluids.HOTCRACKOIL, new RefineryRecipe(new FluidStack(Fluids.NAPHTHA_CRACK, 40), new FluidStack(Fluids.LIGHTOIL_CRACK, 30), new FluidStack(Fluids.AROMATICS, 15), new FluidStack(Fluids.UNSATURATEDS, 15), OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRACK)));
        recipes.put(Fluids.HOTOIL_DS, new RefineryRecipe(new FluidStack(Fluids.HEAVYOIL, 30), new FluidStack(Fluids.NAPHTHA_DS, 35), new FluidStack(Fluids.LIGHTOIL_DS, 20), new FluidStack(Fluids.UNSATURATEDS, 15), OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.PARAFFIN)));
        recipes.put(Fluids.HOTCRACKOIL_DS, new RefineryRecipe(new FluidStack(Fluids.NAPHTHA_DS, 35), new FluidStack(Fluids.LIGHTOIL_DS, 35), new FluidStack(Fluids.AROMATICS, 15), new FluidStack(Fluids.UNSATURATEDS, 15), OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.PARAFFIN)));
    }

    public static RefineryRecipe getRefinery(FluidType oil) {
        return recipes.get(oil);
    }

    @Override
    public String getFileName() {
        return "hbmRefinery.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public String getComment() {
        return "Inputs always assume 100mB, input ammount cannot be changed.";
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = recipe.getAsJsonObject();
        FluidType type = Fluids.fromName(obj.get("input").getAsString());
        FluidStack o0 = RefineryRecipes.readFluidStack(obj.get("output0").getAsJsonArray());
        FluidStack o1 = RefineryRecipes.readFluidStack(obj.get("output1").getAsJsonArray());
        FluidStack o2 = RefineryRecipes.readFluidStack(obj.get("output2").getAsJsonArray());
        FluidStack o3 = RefineryRecipes.readFluidStack(obj.get("output3").getAsJsonArray());
        ItemStack solid = RefineryRecipes.readItemStack(obj.get("solid").getAsJsonArray());
        recipes.put(type, new RefineryRecipe(o0, o1, o2, o3, solid));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        writer.name("input").value(((FluidType)rec.getKey()).getName());
        for (int i = 0; i < 4; ++i) {
            writer.name("output" + i);
            RefineryRecipes.writeFluidStack(((RefineryRecipe)rec.getValue()).outputs[i], writer);
        }
        writer.name("solid");
        RefineryRecipes.writeItemStack(((RefineryRecipe)rec.getValue()).solid, writer);
    }

    public static HashMap<Object, Object[]> getRefineryRecipe() {
        HashMap<Object, Object[]> recipes = new HashMap<Object, Object[]>();
        for (Map.Entry<FluidType, RefineryRecipe> recipe : RefineryRecipes.recipes.entrySet()) {
            RefineryRecipe fluids = recipe.getValue();
            recipes.put(ItemFluidIcon.make(recipe.getKey(), 1000), new ItemStack[]{ItemFluidIcon.make(fluids.outputs[0].type, fluids.outputs[0].fill * 10), ItemFluidIcon.make(fluids.outputs[1].type, fluids.outputs[1].fill * 10), ItemFluidIcon.make(fluids.outputs[2].type, fluids.outputs[2].fill * 10), ItemFluidIcon.make(fluids.outputs[3].type, fluids.outputs[3].fill * 10), ItemStackUtil.carefulCopy(fluids.solid)});
        }
        return recipes;
    }

    public static class RefineryRecipe {
        public FluidStack[] outputs;
        public ItemStack solid;

        public RefineryRecipe(FluidStack f0, FluidStack f1, FluidStack f2, FluidStack f3, ItemStack f4) {
            this.outputs = new FluidStack[]{f0, f1, f2, f3};
            this.solid = f4;
        }
    }
}

