/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes.anvil;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.inventory.recipes.AssemblerRecipes;
import com.hbm.inventory.recipes.anvil.AnvilSmithingCyanideRecipe;
import com.hbm.inventory.recipes.anvil.AnvilSmithingHotRecipe;
import com.hbm.inventory.recipes.anvil.AnvilSmithingMold;
import com.hbm.inventory.recipes.anvil.AnvilSmithingRecipe;
import com.hbm.inventory.recipes.anvil.AnvilSmithingRenameRecipe;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.food.ItemFlask;
import com.hbm.items.machine.ItemBatterySC;
import com.hbm.items.machine.ItemCircuit;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class AnvilRecipes
extends SerializableRecipe {
    public static List<AnvilSmithingRecipe> smithingRecipes = new ArrayList<AnvilSmithingRecipe>();
    public static List<AnvilConstructionRecipe> constructionRecipes = new ArrayList<AnvilConstructionRecipe>();

    public static void register() {
        AnvilRecipes.registerSmithing();
    }

    @Override
    public String getFileName() {
        return "hbmAnvil.json";
    }

    @Override
    public Object getRecipeObject() {
        return constructionRecipes;
    }

    @Override
    public void deleteRecipes() {
        constructionRecipes.clear();
    }

    @Override
    public void registerDefaults() {
        AnvilRecipes.registerConstruction();
    }

    public static void registerSmithing() {
        Block[] anvils;
        for (Block anvil : anvils = new Block[]{ModBlocks.anvil_iron, ModBlocks.anvil_lead}) {
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_steel, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_desh, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_saturnite, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_ferrouranium, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_ferrouranium, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_bismuth_bronze, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.BBRONZE.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_arsenic_bronze, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.ABRONZE.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_schrabidate, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.SBD.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_dnt, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_osmiridium, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack(OreDictManager.OSMIRIDIUM.ingot(), 10)));
        }
        for (int i = 0; i < 9; ++i) {
            smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.ingot_steel_dusted, 1, i + 1), new RecipesCommon.ComparableStack(ModItems.ingot_steel_dusted, 1, i), new RecipesCommon.ComparableStack(ModItems.ingot_steel_dusted, 1, i)));
        }
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.ingot_chainsteel, 1), new RecipesCommon.ComparableStack(ModItems.ingot_steel_dusted, 1, 9), new RecipesCommon.ComparableStack(ModItems.ingot_steel_dusted, 1, 9)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.ingot_meteorite_forged, 1), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.blade_meteorite, 1), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite_forged), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite_forged)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.meteorite_sword_reforged, 1), new RecipesCommon.ComparableStack(ModItems.meteorite_sword_seared), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite_forged)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.cobalt_decorated_sword, 1), new RecipesCommon.ComparableStack(ModItems.cobalt_sword), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.cobalt_decorated_pickaxe, 1), new RecipesCommon.ComparableStack(ModItems.cobalt_pickaxe), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.cobalt_decorated_axe, 1), new RecipesCommon.ComparableStack(ModItems.cobalt_axe), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.cobalt_decorated_shovel, 1), new RecipesCommon.ComparableStack(ModItems.cobalt_shovel), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite)));
        smithingRecipes.add(new AnvilSmithingHotRecipe(3, new ItemStack(ModItems.cobalt_decorated_hoe, 1), new RecipesCommon.ComparableStack(ModItems.cobalt_hoe), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite)));
        smithingRecipes.add(new AnvilSmithingRecipe(1916169, new ItemStack(ModItems.wings_murk, 1), new RecipesCommon.ComparableStack(ModItems.wings_limp), new RecipesCommon.ComparableStack(ModItems.particle_tachyon)));
        smithingRecipes.add(new AnvilSmithingRecipe(4, new ItemStack(ModItems.flask_infusion, 1, ItemFlask.EnumInfusion.SHIELD.ordinal()), new RecipesCommon.ComparableStack(ModItems.gem_alexandrite), new RecipesCommon.ComparableStack(ModItems.bottle_nuka)));
        smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModItems.ingot_gunmetal, 1), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), new RecipesCommon.OreDictStack(OreDictManager.AL.ingot())));
        smithingRecipes.add(new AnvilSmithingMold(0, new RecipesCommon.OreDictStack(OreDictManager.GOLD.nugget()), new RecipesCommon.OreDictStack("nugget")));
        smithingRecipes.add(new AnvilSmithingMold(1, new RecipesCommon.OreDictStack(OreDictManager.U.billet()), new RecipesCommon.OreDictStack("billet")));
        smithingRecipes.add(new AnvilSmithingMold(2, new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot()), new RecipesCommon.OreDictStack("ingot")));
        smithingRecipes.add(new AnvilSmithingMold(3, new RecipesCommon.OreDictStack(OreDictManager.IRON.plate()), new RecipesCommon.OreDictStack("plate")));
        smithingRecipes.add(new AnvilSmithingMold(19, new RecipesCommon.OreDictStack(OreDictManager.IRON.plateCast()), new RecipesCommon.OreDictStack("plateTriple")));
        smithingRecipes.add(new AnvilSmithingMold(4, new RecipesCommon.OreDictStack(OreDictManager.CU.wireFine()), new RecipesCommon.OreDictStack("wireFine")));
        smithingRecipes.add(new AnvilSmithingMold(5, new RecipesCommon.ComparableStack(ModItems.blade_titanium), new ItemStack[]{new ItemStack(ModItems.blade_titanium), new ItemStack(ModItems.blade_tungsten)}));
        smithingRecipes.add(new AnvilSmithingMold(6, new RecipesCommon.ComparableStack(ModItems.blades_steel), new ItemStack[]{new ItemStack(ModItems.blades_steel), new ItemStack(ModItems.blades_titanium), new ItemStack(ModItems.blades_advanced_alloy)}));
        smithingRecipes.add(new AnvilSmithingMold(7, new RecipesCommon.ComparableStack(ModItems.stamp_iron_flat), new ItemStack[]{new ItemStack(ModItems.stamp_stone_flat), new ItemStack(ModItems.stamp_iron_flat), new ItemStack(ModItems.stamp_steel_flat), new ItemStack(ModItems.stamp_titanium_flat), new ItemStack(ModItems.stamp_obsidian_flat)}));
        smithingRecipes.add(new AnvilSmithingMold(8, new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell()), new RecipesCommon.OreDictStack(MaterialShapes.SHELL.name())));
        smithingRecipes.add(new AnvilSmithingMold(9, new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe()), new RecipesCommon.OreDictStack(MaterialShapes.PIPE.name())));
        smithingRecipes.add(new AnvilSmithingMold(10, new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 9), new RecipesCommon.OreDictStack("ingot", 9)));
        smithingRecipes.add(new AnvilSmithingMold(11, new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 9), new RecipesCommon.OreDictStack("plate", 9)));
        smithingRecipes.add(new AnvilSmithingMold(12, new RecipesCommon.OreDictStack(OreDictManager.IRON.block()), new RecipesCommon.OreDictStack("block")));
        smithingRecipes.add(new AnvilSmithingMold(20, new RecipesCommon.OreDictStack(OreDictManager.ALLOY.wireDense(), 1), new RecipesCommon.OreDictStack("wireDense", 1)));
        smithingRecipes.add(new AnvilSmithingMold(21, new RecipesCommon.OreDictStack(OreDictManager.ALLOY.wireDense(), 9), new RecipesCommon.OreDictStack("wireDense", 9)));
        smithingRecipes.add(new AnvilSmithingCyanideRecipe());
        smithingRecipes.add(new AnvilSmithingRenameRecipe());
    }

    public static void registerConstruction() {
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_iron))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_gold))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.TI.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_titanium))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_aluminium))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_steel))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.PB.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_lead))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_copper))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_advanced_alloy))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GUNMETAL.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_gunmetal))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_weaponsteel))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_saturnite))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_dura_steel))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_schrabidium))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot()), new AnvilOutput(new ItemStack(ModItems.plate_combine_steel))).setTier(3));
        for (NTMMaterial mat : Mats.orderedList) {
            if (!mat.autogen.contains(MaterialShapes.WIRE) || !OreDictionary.doesOreNameExist((String)MaterialShapes.INGOT.make(mat))) continue;
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(MaterialShapes.INGOT.name() + mat.names[0]), new AnvilOutput(new ItemStack(ModItems.wire_fine, 8, mat.id))).setTier(4));
        }
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.COAL.dust()), new AnvilOutput(new ItemStack(Items.field_151044_h))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.NETHERQUARTZ.dust()), new AnvilOutput(new ItemStack(Items.field_151128_bU))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.LAPIS.dust()), new AnvilOutput(new ItemStack(Items.field_151100_aR, 1, 4))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust()), new AnvilOutput(new ItemStack(Items.field_151045_i))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.EMERALD.dust()), new AnvilOutput(new ItemStack(Items.field_151166_bC))).setTier(3));
        AnvilRecipes.registerConstructionRecipes();
        AnvilRecipes.registerConstructionAmmo();
        AnvilRecipes.registerConstructionUpgrades();
        AnvilRecipes.registerConstructionRecycling();
    }

    public static void registerConstructionRecipes() {
        int i;
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 16), new RecipesCommon.ComparableStack(ModItems.ingot_firebrick, 16), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.machine_annihilator))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_aluminium, 4))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.BE.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_beryllium, 4))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.PB.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_lead, 4))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_red_copper, 4))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_steel, 4))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_titanium, 4))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 1), new AnvilOutput(new ItemStack(ModBlocks.deco_tungsten, 4))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 4), new RecipesCommon.ComparableStack(ModBlocks.depth_brick)}, new AnvilOutput(new ItemStack(ModBlocks.depth_dnt))).setTier(1916169));
        for (NTMMaterial mat : Mats.orderedList) {
            if (!mat.autogen.contains(MaterialShapes.SHELL)) continue;
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(MaterialShapes.PLATE.name() + mat.names[0], 4), new AnvilOutput(new ItemStack(ModItems.shell, 1, mat.id))).setTier(1));
        }
        for (NTMMaterial mat : Mats.orderedList) {
            if (!mat.autogen.contains(MaterialShapes.PIPE)) continue;
            String key = OreDictionary.doesOreNameExist((String)(MaterialShapes.PLATE.name() + mat.names[0])) ? MaterialShapes.PLATE.name() + mat.names[0] : MaterialShapes.INGOT.name() + mat.names[0];
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(key, 3), new AnvilOutput(new ItemStack(ModItems.pipe, 1, mat.id))).setTier(1));
        }
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.coil_copper, 2), new AnvilOutput(new ItemStack(ModItems.coil_copper_torus))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.coil_advanced_alloy, 2), new AnvilOutput(new ItemStack(ModItems.coil_advanced_torus))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.coil_gold, 2), new AnvilOutput(new ItemStack(ModItems.coil_gold_torus))).setTier(1).setOverlay(OverlayType.CONSTRUCTION));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 2), new RecipesCommon.ComparableStack(ModItems.coil_copper), new RecipesCommon.ComparableStack(ModItems.coil_copper_torus)}, new AnvilOutput(new ItemStack(ModItems.motor, 2))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.motor), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 2), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.coil_gold_torus)}, new AnvilOutput(new ItemStack(ModItems.motor_desh, 1))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 4), new RecipesCommon.ComparableStack(ModItems.ingot_firebrick, 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 4)}, new AnvilOutput(new ItemStack(ModBlocks.machine_difurnace_off))).setTier(1));
        boolean exp = GeneralConfig.enableExpensiveMode;
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 2), exp ? new RecipesCommon.ComparableStack(ModItems.circuit, 2, (Enum)ItemCircuit.EnumCircuitType.ANALOG) : new RecipesCommon.ComparableStack(ModItems.circuit, 4, (Enum)ItemCircuit.EnumCircuitType.VACUUM_TUBE)}, new AnvilOutput(new ItemStack(ModBlocks.machine_assembly_machine))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("cobblestone", 8), new RecipesCommon.OreDictStack("plankWood", 16), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.PB.pipe(), 2)}, new AnvilOutput(new ItemStack(ModBlocks.pump_steam))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.PB.pipe(), 4), new RecipesCommon.ComparableStack(ModItems.motor, 2), new RecipesCommon.ComparableStack(ModItems.circuit, 4, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal())}, new AnvilOutput(new ItemStack(ModBlocks.pump_electric))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150460_al), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.heater_firebox))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_firebrick, 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.heater_oven))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150348_b, 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 4)}, new AnvilOutput(new ItemStack(ModBlocks.machine_ashpit))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.tank_steel, 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 3), new RecipesCommon.OreDictStack(OreDictManager.TI.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.heater_oilburner))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.ComparableStack(ModItems.coil_tungsten, 8), new RecipesCommon.ComparableStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC.ordinal())}, new AnvilOutput(new ItemStack(ModBlocks.heater_electric))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.RUBBER.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 3)}, new AnvilOutput(new ItemStack(ModBlocks.heater_heatex))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 16), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.ComparableStack(ModBlocks.steel_grate, 16)}, new AnvilOutput(new ItemStack(ModBlocks.furnace_steel))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 8), new RecipesCommon.OreDictStack("logWood", 16), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 2), new RecipesCommon.OreDictStack("ingotBrick", 16)}, new AnvilOutput(new ItemStack(ModBlocks.furnace_combination))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Blocks.field_150417_aV, 8), new RecipesCommon.ComparableStack(ModItems.ingot_firebrick, 16), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.machine_rotary_furnace))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("plankWood", 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.coil_copper, 4), new RecipesCommon.ComparableStack(ModItems.gear_large, 1, 0)}, new AnvilOutput(new ItemStack(ModBlocks.machine_stirling))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.BE.ingot(), 6), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.coil_gold, 16), new RecipesCommon.ComparableStack(ModItems.gear_large, 1, 1)}, new AnvilOutput(new ItemStack(ModBlocks.machine_stirling_steel))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.reinforced_stone, 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 2), new RecipesCommon.ComparableStack(ModItems.coil_copper, 4), new RecipesCommon.ComparableStack(ModItems.gear_large, 1)}, new AnvilOutput(new ItemStack(ModBlocks.machine_steam_engine))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack("plankWood", 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.sawblade)}, new AnvilOutput(new ItemStack(ModBlocks.machine_sawmill))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_firebrick, 20), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.machine_crucible))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 16), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8)}, new AnvilOutput(new ItemStack(ModBlocks.machine_boiler))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 2), new RecipesCommon.ComparableStack(ModItems.coil_copper, 4), new RecipesCommon.OreDictStack(OreDictManager.W.bolt(), 4), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal())}, new AnvilOutput(new ItemStack(ModBlocks.machine_soldering_station))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 4), new RecipesCommon.OreDictStack(OreDictManager.W.ingot(), 8), new RecipesCommon.ComparableStack(ModBlocks.machine_transformer, 1), new RecipesCommon.ComparableStack(ModItems.arc_electrode, 2)}, new AnvilOutput(new ItemStack(ModBlocks.machine_arc_welder))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 8), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 4)}, new AnvilOutput(new ItemStack(ModBlocks.machine_industrial_boiler))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 12), new RecipesCommon.OreDictStack(OreDictManager.CU.ingot(), 2), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), new RecipesCommon.ComparableStack(ModItems.sawblade)}, new AnvilOutput(new ItemStack(ModBlocks.machine_autosaw))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.brick_concrete, 64), new RecipesCommon.ComparableStack(Blocks.field_150411_aY, 128), new RecipesCommon.ComparableStack(ModBlocks.machine_condenser, 4)}, new AnvilOutput(new ItemStack(ModBlocks.machine_tower_small))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModBlocks.concrete_smooth, 128), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 32), new RecipesCommon.ComparableStack(ModBlocks.machine_condenser, 16), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 8)}, new AnvilOutput(new ItemStack(ModBlocks.machine_tower_large))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(Items.field_151103_aS, 16), new RecipesCommon.ComparableStack(Items.field_151116_aA, 4), new RecipesCommon.ComparableStack(Items.field_151008_G, 24)}, new AnvilOutput(new ItemStack(ModItems.wings_limp))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.sulfur, 12), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 6), new RecipesCommon.ComparableStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.BASIC.ordinal())}, new AnvilOutput(new ItemStack(ModBlocks.machine_deuterium_extractor))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.deuterium_filter, 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.shell(), 5), new RecipesCommon.OreDictStack(OreDictManager.STEEL.pipe(), 12), new RecipesCommon.ComparableStack(ModBlocks.concrete_asbestos, 8), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 16), new RecipesCommon.OreDictStack(Fluids.SOURGAS.getDict(1000), 8)}, new AnvilOutput(new ItemStack(ModBlocks.machine_deuterium_tower))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 2), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 8), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 8), new RecipesCommon.ComparableStack(ModItems.coil_copper, 4)}, new AnvilOutput(new ItemStack(ModBlocks.red_pylon_large))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 8), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 8), new RecipesCommon.ComparableStack(ModItems.plate_polymer, 12), new RecipesCommon.ComparableStack(ModItems.coil_copper, 8)}, new AnvilOutput(new ItemStack(ModBlocks.substation, 2))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.ComparableStack(Blocks.field_150336_V, 16), new RecipesCommon.ComparableStack(ModBlocks.steel_grate, 2)}, new AnvilOutput(new ItemStack(ModBlocks.chimney_brick))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_CONCRETE.any(), 64), new RecipesCommon.ComparableStack(ModBlocks.steel_grate, 4), new RecipesCommon.ComparableStack(ModItems.filter_coal, 4)}, new AnvilOutput(new ItemStack(ModBlocks.chimney_industrial))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.tank_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 2), new RecipesCommon.ComparableStack(ModItems.nuclear_waste, 10)}, new AnvilOutput(new ItemStack(ModBlocks.yellow_barrel))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.tank_steel, 1), new RecipesCommon.OreDictStack(OreDictManager.PB.plate(), 2), new RecipesCommon.ComparableStack(ModItems.nuclear_waste_vitrified, 10)}, new AnvilOutput(new ItemStack(ModBlocks.vitrified_barrel))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.man_core, 1), new RecipesCommon.OreDictStack(OreDictManager.BE.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.screwdriver, 1)}, new AnvilOutput(new ItemStack(ModItems.demon_core_open))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 1)}, new AnvilOutput(new ItemStack(ModItems.plate_desh, 4))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.nugget_bismuth, 2), new RecipesCommon.OreDictStack(OreDictManager.U238.billet(), 2), new RecipesCommon.OreDictStack(OreDictManager.NB.dust(), 1)}, new AnvilOutput(new ItemStack(ModItems.plate_bismuth, 1))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.EUPH.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.AT.dust(), 3), new RecipesCommon.OreDictStack(OreDictManager.BI.dust(), 1), new RecipesCommon.OreDictStack(OreDictManager.VOLCANIC.gem(), 1), new RecipesCommon.ComparableStack(ModItems.ingot_osmiridium)}, new AnvilOutput(new ItemStack(ModItems.plate_euphemium, 4))).setTier(6));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.DNT.ingot(), 4), new RecipesCommon.ComparableStack(ModItems.powder_spark_mix, 2), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 1)}, new AnvilOutput(new ItemStack(ModItems.plate_dineutronium, 4))).setTier(7));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.STEEL.bolt(), 4)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_titanium))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.NB.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.plate_armor_titanium, 1)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_ajr, 2))).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.ALLOY.plate(), 4), new RecipesCommon.ComparableStack(ModItems.plate_armor_titanium, 1), new RecipesCommon.OreDictStack(OreDictManager.W.wireFine(), 8)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_hev))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 4), new RecipesCommon.OreDictStack(OreDictManager.STAR.ingot(), 1), new RecipesCommon.OreDictStack(OreDictManager.MAGTUNG.wireFine(), 8)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_lunar))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.ingot_meteorite_forged, 4), new RecipesCommon.OreDictStack(OreDictManager.DESH.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.billet_yharonite, 1)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_fau))).setTier(6));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.plate_dineutronium, 4), new RecipesCommon.ComparableStack(ModItems.particle_sparkticle, 1), new RecipesCommon.ComparableStack(ModItems.plate_armor_fau, 6)}, new AnvilOutput(new ItemStack(ModItems.plate_armor_dnt))).setTier(7));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.missile_doomsday_rusted, 1), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot(), 8), new RecipesCommon.OreDictStack(OreDictManager.AL.plateWelded(), 2), new RecipesCommon.OreDictStack(OreDictManager.PU239.billet(), 3)}, new AnvilOutput(new ItemStack(ModItems.missile_doomsday))).setTier(5));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.ingot_u233, 1), new AnvilOutput(new ItemStack(ModItems.plate_fuel_u233))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.ingot_u235, 1), new AnvilOutput(new ItemStack(ModItems.plate_fuel_u235))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.ingot_mox_fuel, 1), new AnvilOutput(new ItemStack(ModItems.plate_fuel_mox))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.ingot_pu239, 1), new AnvilOutput(new ItemStack(ModItems.plate_fuel_pu239))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.ingot_schrabidium, 1), new AnvilOutput(new ItemStack(ModItems.plate_fuel_sa326))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.billet_ra226be, 1), new AnvilOutput(new ItemStack(ModItems.plate_fuel_ra226be))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.billet_pu238be, 1), new AnvilOutput(new ItemStack(ModItems.plate_fuel_pu238be))).setTier(4));
        for (i = 0; i < 15; i += 3) {
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 1), new AnvilOutput(new ItemStack(ModBlocks.fluid_duct_box, 1, i))).setTier(2).setOverlay(OverlayType.CONSTRUCTION));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 1), new AnvilOutput(new ItemStack(ModBlocks.fluid_duct_box, 1, i + 1))).setTier(2).setOverlay(OverlayType.CONSTRUCTION));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 1), new AnvilOutput(new ItemStack(ModBlocks.fluid_duct_box, 1, i + 2))).setTier(2).setOverlay(OverlayType.CONSTRUCTION));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.fluid_duct_box, 1, i), new AnvilOutput(new ItemStack(ModItems.plate_iron))).setTier(2).setOverlay(OverlayType.RECYCLING));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.fluid_duct_box, 1, i + 1), new AnvilOutput(new ItemStack(ModItems.plate_copper))).setTier(2).setOverlay(OverlayType.RECYCLING));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.fluid_duct_box, 1, i + 2), new AnvilOutput(new ItemStack(ModItems.plate_aluminium))).setTier(2).setOverlay(OverlayType.RECYCLING));
            constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 1), new RecipesCommon.ComparableStack(ModItems.plate_polymer)}, new AnvilOutput(new ItemStack(ModBlocks.fluid_duct_exhaust, 8, i))).setTier(2).setOverlay(OverlayType.CONSTRUCTION));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.fluid_duct_exhaust, 8, i), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_iron)), new AnvilOutput(new ItemStack(ModItems.plate_polymer))}).setTier(2));
        }
        for (i = 0; i < 5; ++i) {
            constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.MINGRADE.ingot(), 1), new RecipesCommon.ComparableStack(ModItems.plate_polymer)}, new AnvilOutput(new ItemStack(ModBlocks.red_cable_box, 16, i))).setTier(2).setOverlay(OverlayType.CONSTRUCTION));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.red_cable_box, 16, i), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_red_copper, 1)), new AnvilOutput(new ItemStack(ModItems.plate_polymer))}).setTier(2));
        }
    }

    public static void registerConstructionAmmo() {
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.stamp_iron_flat), new RecipesCommon.OreDictStack(OreDictManager.GUNMETAL.ingot(), 2)}, new AnvilOutput(new ItemStack(ModItems.stamp_9))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.stamp_iron_flat), new RecipesCommon.OreDictStack(OreDictManager.GUNMETAL.ingot(), 2)}, new AnvilOutput(new ItemStack(ModItems.stamp_50))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.stamp_desh_flat), new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.stamp_desh_9))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.stamp_desh_flat), new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.stamp_desh_50))).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 2)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 16))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot(), 2)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 17))).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 22))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 23))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 24))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 25))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 26))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 27))).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.mold_base), new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot(), 4)}, new AnvilOutput(new ItemStack(ModItems.mold, 1, 28))).setTier(2));
    }

    public static void registerConstructionUpgrades() {
    }

    public static void registerConstructionRecycling() {
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.RARE)), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.fragment_boron)), new AnvilOutput(new ItemStack(ModItems.fragment_boron), 0.5f), new AnvilOutput(new ItemStack(ModItems.fragment_lanthanium), 0.1f), new AnvilOutput(new ItemStack(ModItems.fragment_cobalt)), new AnvilOutput(new ItemStack(ModItems.fragment_cobalt), 0.5f), new AnvilOutput(new ItemStack(ModItems.fragment_cerium), 0.1f), new AnvilOutput(new ItemStack(ModItems.fragment_neodymium), 0.5f), new AnvilOutput(new ItemStack(ModItems.fragment_niobium), 0.5f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_titanium, 4), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_titanium, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_red_copper, 4), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_red_copper, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_tungsten, 4), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_tungsten, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_aluminium, 4), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_aluminium, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_steel, 4), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_steel, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_rusty_steel, 8), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_steel, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_lead, 4), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_lead, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_beryllium, 4), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_beryllium, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_asbestos, 4), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_asbestos, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.heater_firebox), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 8)), new AnvilOutput(new ItemStack(ModItems.ingot_copper, 6))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.heater_oven), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_firebrick, 16)), new AnvilOutput(new ItemStack(ModItems.ingot_copper, 8))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.machine_stirling), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 6)), new AnvilOutput(new ItemStack(ModItems.ingot_copper, 8)), new AnvilOutput(new ItemStack(ModItems.coil_copper, 4)), new AnvilOutput(new ItemStack(ModItems.gear_large, 1))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.machine_stirling, 1, 1), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 6)), new AnvilOutput(new ItemStack(ModItems.ingot_copper, 8)), new AnvilOutput(new ItemStack(ModItems.coil_copper, 4))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.machine_stirling_steel), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 16)), new AnvilOutput(new ItemStack(ModItems.ingot_beryllium, 6)), new AnvilOutput(new ItemStack(ModItems.ingot_copper, 8)), new AnvilOutput(new ItemStack(ModItems.coil_gold, 16)), new AnvilOutput(new ItemStack(ModItems.gear_large, 1, 1))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.gear_large, 1, 1), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 8)), new AnvilOutput(new ItemStack(ModItems.ingot_titanium, 1))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.gear_large), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_iron, 8)), new AnvilOutput(new ItemStack(ModItems.ingot_copper, 1))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.machine_stirling_steel, 1, 1), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 16)), new AnvilOutput(new ItemStack(ModItems.ingot_beryllium, 6)), new AnvilOutput(new ItemStack(ModItems.ingot_copper, 8)), new AnvilOutput(new ItemStack(ModItems.coil_gold, 16))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.barrel_tcalloy), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_titanium, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 4)), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 1), 0.25f)}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_computer), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.crt_display, 1)), new AnvilOutput(new ItemStack(ModItems.scrap, 3)), new AnvilOutput(new ItemStack(ModItems.wire_fine, 4, Mats.MAT_COPPER.id)), new AnvilOutput(new ItemStack(ModItems.circuit, 2, ItemCircuit.EnumCircuitType.PCB.ordinal())), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), 0.5f), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal()), 0.75f), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.CAPACITOR.ordinal()), 0.5f), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ANALOG.ordinal()), 0.1f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_crt, 1, Short.MAX_VALUE), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.crt_display, 1)), new AnvilOutput(new ItemStack(ModItems.scrap, 2)), new AnvilOutput(new ItemStack(ModItems.wire_fine, 2, Mats.MAT_COPPER.id)), new AnvilOutput(new ItemStack(ModItems.wire_fine, 2, Mats.MAT_GOLD.id), 0.25f), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), 0.25f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_toaster, 1, 0), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_iron, 3)), new AnvilOutput(new ItemStack(ModItems.scrap, 1)), new AnvilOutput(new ItemStack(ModItems.coil_tungsten, 1)), new AnvilOutput(new ItemStack(Items.field_151025_P, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.fusion_core, 1), 0.01f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_toaster, 1, 1), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 3)), new AnvilOutput(new ItemStack(ModItems.scrap, 1)), new AnvilOutput(new ItemStack(ModItems.coil_tungsten, 2)), new AnvilOutput(new ItemStack(Items.field_151025_P, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.battery_sc, 1, ItemBatterySC.EnumBatterySC.RA226.ordinal()), 0.1f), new AnvilOutput(new ItemStack(ModItems.fusion_core, 1), 0.05f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.deco_toaster, 1, 2), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.powder_sawdust, 4)), new AnvilOutput(new ItemStack(ModItems.scrap, 1)), new AnvilOutput(new ItemStack(ModItems.coil_tungsten, 4)), new AnvilOutput(new ItemStack(Items.field_151025_P, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.fusion_core, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.fusion_core, 1), 0.5f), new AnvilOutput(new ItemStack(ModItems.gem_alexandrite, 1), 0.25f), new AnvilOutput(new ItemStack(ModItems.flame_pony, 1), 0.01f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.radiorec), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 4)), new AnvilOutput(new ItemStack(ModItems.wire_fine, 1, Mats.MAT_COPPER.id)), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), 0.5f), new AnvilOutput(new ItemStack(ModItems.ingot_polymer, 1), 0.25f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.tape_recorder), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_steel, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_tungsten, 1), 0.25f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.pole_top), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_tungsten, 3)), new AnvilOutput(new ItemStack(ModItems.ingot_red_copper, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_beryllium, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_beryllium, 1), 0.5f)}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.pole_satellite_receiver), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_steel, 3)), new AnvilOutput(new ItemStack(ModItems.ingot_steel, 2), 0.5f), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.VACUUM_TUBE.ordinal()), 0.5f), new AnvilOutput(new ItemStack(ModItems.wire_fine, 1, Mats.MAT_MINGRADE.id))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.filing_cabinet), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.plate_steel, 2)), new AnvilOutput(new ItemStack(ModItems.plate_steel, 2), 0.5f), new AnvilOutput(new ItemStack(ModItems.plate_polymer, 2), 0.25f), new AnvilOutput(new ItemStack(ModItems.scrap, 1))}).setTier(1));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_uranium), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_uranium, 3)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 2))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_source), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_ra226be, 3)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 2))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_boron), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_boron, 2)), new AnvilOutput(new ItemStack(Items.field_151055_y, 2))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_detector), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_boron, 2)), new AnvilOutput(new ItemStack(ModItems.motor, 1)), new AnvilOutput(OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.VACUUM_TUBE))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_lithium), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.lithium, 1)), new AnvilOutput(new ItemStack(ModItems.cell_empty, 1))}).setTier(2));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_moderator), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModBlocks.block_graphite, 4))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_absorber), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_boron, 8))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_reflector), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.neutron_reflector, 8))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_control), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_absorber, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_graphite, 2)), new AnvilOutput(new ItemStack(ModItems.motor, 2))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_control_mod), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_control, 1)), new AnvilOutput(new ItemStack(ModBlocks.block_graphite, 4)), new AnvilOutput(new ItemStack(ModItems.nugget_bismuth, 4))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_control_auto), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_control, 1)), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.ADVANCED.ordinal())), new AnvilOutput(new ItemStack(ModItems.crt_display, 1))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_rod_reasim), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.ingot_zirconium, 4)), new AnvilOutput(new ItemStack(ModItems.shell, 2, Mats.MAT_STEEL.id))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_rod_reasim_mod), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_rod_reasim, 1)), new AnvilOutput(new ItemStack(ModBlocks.block_graphite, 4)), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 4))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_outgasser), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModBlocks.steel_grate, 6)), new AnvilOutput(new ItemStack(ModItems.tank_steel, 1)), new AnvilOutput(new ItemStack((Block)Blocks.field_150438_bZ, 1))}).setTier(4));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_storage), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModBlocks.crate_steel, 2))}).setTier(4));
        if (!GeneralConfig.enable528) {
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_rod), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.shell, 2, Mats.MAT_STEEL.id))}).setTier(4));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_rod_mod), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_rod, 1)), new AnvilOutput(new ItemStack(ModBlocks.block_graphite, 4)), new AnvilOutput(new ItemStack(ModItems.nugget_bismuth, 4))}).setTier(4));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_boiler), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModItems.pipe, 6, Mats.MAT_COPPER.id)), new AnvilOutput(new ItemStack(ModItems.shell, 2, Mats.MAT_COPPER.id))}).setTier(4));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.rbmk_cooler), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModBlocks.rbmk_blank, 1)), new AnvilOutput(new ItemStack(ModBlocks.steel_grate, 4)), new AnvilOutput(new ItemStack(ModItems.plate_polymer, 4))}).setTier(4));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.reactor_research), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.ingot_steel, 8)), new AnvilOutput(new ItemStack(ModItems.ingot_tcalloy, 4)), new AnvilOutput(new ItemStack(ModItems.motor_desh, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_boron, 5)), new AnvilOutput(new ItemStack(ModItems.plate_lead, 8)), new AnvilOutput(new ItemStack(ModItems.crt_display, 3)), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC.ordinal())), new AnvilOutput(new ItemStack(ModItems.circuit, 1, ItemCircuit.EnumCircuitType.BASIC.ordinal()), 0.5f)}).setTier(4));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_plutonium), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_pu_mix, 2)), new AnvilOutput(new ItemStack(ModItems.billet_uranium, 1)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 2))}).setTier(2));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_pu239), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_pu239, 1)), new AnvilOutput(new ItemStack(ModItems.billet_pu_mix, 1)), new AnvilOutput(new ItemStack(ModItems.billet_uranium, 1)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 2))}).setTier(2));
        } else {
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_plutonium), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_pu_mix, 2)), new AnvilOutput(new ItemStack(ModItems.billet_nuclear_waste, 1)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 1))}).setTier(2));
            constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.pile_rod_pu239), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.billet_pu239, 1)), new AnvilOutput(new ItemStack(ModItems.billet_pu_mix, 1)), new AnvilOutput(new ItemStack(ModItems.billet_nuclear_waste, 1)), new AnvilOutput(new ItemStack(ModItems.plate_iron, 2))}).setTier(2));
        }
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.machine_turbine), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.turbine_titanium, 1)), new AnvilOutput(new ItemStack(ModItems.coil_copper, 2)), new AnvilOutput(new ItemStack(ModItems.ingot_steel, 4))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.yellow_barrel), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.tank_steel, 1)), new AnvilOutput(new ItemStack(ModItems.plate_lead, 2)), new AnvilOutput(new ItemStack(ModItems.nuclear_waste, 10))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModBlocks.vitrified_barrel), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.tank_steel, 1)), new AnvilOutput(new ItemStack(ModItems.plate_lead, 2)), new AnvilOutput(new ItemStack(ModItems.nuclear_waste_vitrified, 10))}).setTier(3));
        constructionRecipes.add(new AnvilConstructionRecipe((RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.egg_glyphid), new AnvilOutput[]{new AnvilOutput(new ItemStack(ModItems.glyphid_meat, 2)), new AnvilOutput(new ItemStack(ModItems.glyphid_meat, 1), 0.5f), new AnvilOutput(new ItemStack(Items.field_151103_aS, 1), 0.75f), new AnvilOutput(new ItemStack(Items.field_151062_by, 1), 0.5f)}).setTier(1));
    }

    public static void pullFromAssembler(RecipesCommon.ComparableStack result, int tier) {
        AssemblerRecipes.AssemblerRecipe recipe = AssemblerRecipes.recipes.get(result);
        if (recipe != null) {
            constructionRecipes.add(new AnvilConstructionRecipe(recipe.ingredients, new AnvilOutput(result.toStack())).setTier(tier));
        }
    }

    public static List<AnvilSmithingRecipe> getSmithing() {
        return smithingRecipes;
    }

    public static List<AnvilConstructionRecipe> getConstruction() {
        return constructionRecipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        String overlayName;
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack[] inputs = AnvilRecipes.readAStackArray(obj.get("inputs").getAsJsonArray());
        Tuple.Pair<ItemStack, Float>[] outputs = AnvilRecipes.readItemStackArrayChance(obj.get("outputs").getAsJsonArray());
        int tierLower = obj.get("tierLower").getAsInt();
        int tierUpper = obj.has("tierUpper") ? obj.get("tierUpper").getAsInt() : -1;
        OverlayType overlay = OverlayType.NONE;
        if (obj.has("overlay") && (overlay = OverlayType.valueOf(overlayName = obj.get("overlay").getAsString())) == null) {
            overlay = OverlayType.NONE;
        }
        constructionRecipes.add(new AnvilConstructionRecipe(inputs, outputs).setTierRange(tierLower, tierUpper).setOverlay(overlay));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        AnvilConstructionRecipe rec = (AnvilConstructionRecipe)recipe;
        writer.name("inputs").beginArray();
        for (RecipesCommon.AStack aStack : rec.input) {
            AnvilRecipes.writeAStack(aStack, writer);
        }
        writer.endArray();
        writer.name("outputs").beginArray();
        for (AnvilOutput anvilOutput : rec.output) {
            AnvilRecipes.writeItemStackChance(new Tuple.Pair<ItemStack, Float>(anvilOutput.stack, Float.valueOf(anvilOutput.chance)), writer);
        }
        writer.endArray();
        writer.name("tierLower").value((long)rec.tierLower);
        writer.name("tierUpper").value((long)rec.tierUpper);
        writer.name("overlay").value(rec.overlay.name());
    }

    public static enum OverlayType {
        NONE,
        CONSTRUCTION,
        RECYCLING,
        SMITHING;

    }

    public static class AnvilOutput {
        public ItemStack stack;
        public float chance;

        public AnvilOutput(ItemStack stack) {
            this(stack, 1.0f);
        }

        public AnvilOutput(ItemStack stack, float chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }

    public static class AnvilConstructionRecipe {
        public List<RecipesCommon.AStack> input = new ArrayList<RecipesCommon.AStack>();
        public List<AnvilOutput> output = new ArrayList<AnvilOutput>();
        public int tierLower = 0;
        public int tierUpper = -1;
        OverlayType overlay = OverlayType.NONE;

        public AnvilConstructionRecipe(RecipesCommon.AStack input, AnvilOutput output) {
            this.input.add(input);
            this.output.add(output);
            this.setOverlay(OverlayType.SMITHING);
        }

        public AnvilConstructionRecipe(RecipesCommon.AStack[] input, AnvilOutput output) {
            for (RecipesCommon.AStack stack : input) {
                this.input.add(stack);
            }
            this.output.add(output);
            this.setOverlay(OverlayType.CONSTRUCTION);
        }

        public AnvilConstructionRecipe(RecipesCommon.AStack input, AnvilOutput[] output) {
            this.input.add(input);
            for (AnvilOutput out : output) {
                this.output.add(out);
            }
            this.setOverlay(OverlayType.RECYCLING);
        }

        public AnvilConstructionRecipe(RecipesCommon.AStack[] input, AnvilOutput[] output) {
            for (RecipesCommon.AStack stack : input) {
                this.input.add(stack);
            }
            for (AnvilOutput out : output) {
                this.output.add(out);
            }
            this.setOverlay(OverlayType.NONE);
        }

        public AnvilConstructionRecipe(RecipesCommon.AStack[] input, Tuple.Pair<ItemStack, Float>[] output) {
            for (RecipesCommon.AStack stack : input) {
                this.input.add(stack);
            }
            for (Tuple.Pair<ItemStack, Float> out : output) {
                this.output.add(new AnvilOutput((ItemStack)out.getKey(), ((Float)out.getValue()).floatValue()));
            }
            this.setOverlay(OverlayType.NONE);
        }

        public AnvilConstructionRecipe setTier(int tier) {
            this.tierLower = tier;
            if (GeneralConfig.enableLBSM && GeneralConfig.enableLBSMUnlockAnvil) {
                this.tierLower = 1;
            }
            return this;
        }

        public AnvilConstructionRecipe setTierRange(int lower, int upper) {
            this.tierLower = lower;
            this.tierUpper = upper;
            if (GeneralConfig.enableLBSM && GeneralConfig.enableLBSMUnlockAnvil) {
                this.tierUpper = 1;
                this.tierLower = 1;
            }
            return this;
        }

        public boolean isTierValid(int tier) {
            if (this.tierUpper == -1) {
                return tier >= this.tierLower;
            }
            return tier >= this.tierLower && tier <= this.tierUpper;
        }

        public AnvilConstructionRecipe setOverlay(OverlayType overlay) {
            this.overlay = overlay;
            return this;
        }

        public OverlayType getOverlay() {
            return this.overlay;
        }

        public ItemStack getDisplay() {
            switch (this.overlay) {
                case NONE: {
                    return this.output.get((int)0).stack.func_77946_l();
                }
                case CONSTRUCTION: {
                    return this.output.get((int)0).stack.func_77946_l();
                }
                case SMITHING: {
                    return this.output.get((int)0).stack.func_77946_l();
                }
                case RECYCLING: {
                    for (RecipesCommon.AStack stack : this.input) {
                        if (!(stack instanceof RecipesCommon.ComparableStack)) continue;
                        return ((RecipesCommon.ComparableStack)stack).toStack();
                    }
                    return this.output.get((int)0).stack.func_77946_l();
                }
            }
            return new ItemStack(Items.field_151035_b);
        }
    }
}

