/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.Multimap;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.items.armor.ArmorFSBPowered;
import com.hbm.items.armor.ArmorNCRPAMelee;
import com.hbm.items.armor.ArmorNCRPARanged;
import com.hbm.items.armor.IPAMelee;
import com.hbm.items.armor.IPARanged;
import com.hbm.items.armor.IPAWeaponsProvider;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.model.ModelArmorNCRPA;
import com.hbm.render.tileentity.IItemRendererProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ArmorNCRPA
extends ArmorFSBPowered
implements IItemRendererProvider,
IPAWeaponsProvider {
    @SideOnly(value=Side.CLIENT)
    ModelArmorNCRPA[] models;
    private static final UUID speed = UUID.fromString("6ab858ba-d712-485c-bae9-e5e765fc555a");
    public static final ArmorNCRPAMelee meleeComponent = new ArmorNCRPAMelee();
    public static final ArmorNCRPARanged rangedComponent = new ArmorNCRPARanged();

    public ArmorNCRPA(ItemArmor.ArmorMaterial material, int slot, String texture, long maxPower, long chargeRate, long consumption, long drain) {
        super(material, slot, texture, maxPower, chargeRate, consumption, drain);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.models == null) {
            this.models = new ModelArmorNCRPA[4];
            for (int i = 0; i < 4; ++i) {
                this.models[i] = new ModelArmorNCRPA(i);
            }
        }
        return this.models[armorSlot];
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this != ModItems.ncrpa_plate) {
            return;
        }
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(speed, "NCRPA SPEED", 0.1, 0));
        player.func_110140_aT().func_111148_a(multimap);
        if (player.func_70051_ag()) {
            player.func_110140_aT().func_111147_b(multimap);
        }
        if (world.func_82737_E() % 20L != 0L) {
            return;
        }
        if (HbmPlayerProps.getData((EntityPlayer)player).enableHUD) {
            player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 300, 0, true));
        }
    }

    @Override
    public Item getItemForRenderer() {
        return this;
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                ArmorFSB.setupRenderInv();
            }

            @Override
            public void renderNonInv() {
                ArmorFSB.setupRenderNonInv();
            }

            @Override
            public void renderCommon() {
                if (ArmorNCRPA.this.field_77881_a == 0) {
                    GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
                }
                ArmorFSB.renderStandard(ResourceManager.armor_ncr, ArmorNCRPA.this.field_77881_a, ResourceManager.ncrpa_helmet, ResourceManager.ncrpa_chest, ResourceManager.ncrpa_arm, ResourceManager.ncrpa_leg, "Helmet,Eyes", "Chest", "LeftArm", "RightArm", "LeftLeg", "RightLeg", "LeftBoot", "RightBoot");
            }
        };
    }

    @Override
    public IPAMelee getMeleeComponent(EntityPlayer entity) {
        if (ArmorNCRPA.hasFSBArmorIgnoreCharge(entity)) {
            return meleeComponent;
        }
        return null;
    }

    @Override
    public IPARanged getRangedComponent(EntityPlayer entity) {
        if (ArmorNCRPA.hasFSBArmorIgnoreCharge(entity)) {
            return rangedComponent;
        }
        return null;
    }
}

