/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.anim;

import com.hbm.render.anim.BusAnimationSequence;
import java.util.HashMap;
import java.util.Map;

public class BusAnimation {
    private final HashMap<String, BusAnimationSequence> animationBuses = new HashMap();
    private int totalTime = 0;

    public BusAnimation addBus(String name, BusAnimationSequence bus) {
        this.animationBuses.put(name, bus);
        int duration = bus.getTotalTime();
        if (duration > this.totalTime) {
            this.totalTime = duration;
        }
        return this;
    }

    public void updateTime() {
        for (Map.Entry<String, BusAnimationSequence> sequence : this.animationBuses.entrySet()) {
            int time = sequence.getValue().getTotalTime();
            if (time <= this.totalTime) continue;
            this.totalTime = time;
        }
    }

    public BusAnimationSequence getBus(String name) {
        return this.animationBuses.get(name);
    }

    public void setTimeMult(double mult) {
        for (Map.Entry<String, BusAnimationSequence> sequence : this.animationBuses.entrySet()) {
            sequence.getValue().multiplyTime(mult);
        }
    }

    public double[] getTimedTransformation(String name, int millis) {
        if (this.animationBuses.containsKey(name)) {
            return this.animationBuses.get(name).getTransformation(millis);
        }
        return null;
    }

    public int getDuration() {
        return this.totalTime;
    }
}

