/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.icon;

import com.hbm.main.MainRegistry;
import com.hbm.render.icon.RGBMutator;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureAtlasSpriteMutatable
extends TextureAtlasSprite {
    private RGBMutator mutator;
    public String basePath = "textures/items";
    private int mipmap = 0;
    private int anisotropic = 0;

    public TextureAtlasSpriteMutatable(String iconName, RGBMutator mutator) {
        super(iconName);
        this.mutator = mutator;
    }

    public TextureAtlasSpriteMutatable setBlockAtlas() {
        this.mipmap = Minecraft.func_71410_x().field_71474_y.field_151442_I;
        this.anisotropic = Minecraft.func_71410_x().field_71474_y.field_151443_J;
        this.basePath = "textures/blocks";
        return this;
    }

    public void func_147964_a(BufferedImage[] frames, AnimationMetadataSection animMeta, boolean anisotropicFiltering) {
        if (this.mutator != null) {
            for (int i = 0; i < frames.length; ++i) {
                BufferedImage frame = frames[i];
                if (frame == null) continue;
                this.mutator.mutate(frame, i, frames.length);
            }
        }
        super.func_147964_a(frames, animMeta, anisotropicFiltering);
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager man, ResourceLocation resourcelocation) {
        String pathName = resourcelocation.func_110623_a();
        String tunkatedPath = pathName.substring(0, pathName.indexOf(45));
        resourcelocation = new ResourceLocation(resourcelocation.func_110624_b(), tunkatedPath);
        ResourceLocation resourcelocation1 = this.completeResourceLocation(resourcelocation, 0);
        try {
            IResource iresource = man.func_110536_a(resourcelocation1);
            BufferedImage[] abufferedimage = new BufferedImage[1 + this.mipmap];
            abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
            TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
            if (texturemetadatasection != null) {
                int l;
                List list = texturemetadatasection.func_148535_c();
                if (!list.isEmpty()) {
                    int k = abufferedimage[0].getWidth();
                    l = abufferedimage[0].getHeight();
                    if (MathHelper.func_151236_b((int)k) != k || MathHelper.func_151236_b((int)l) != l) {
                        throw new RuntimeException("Unable to load extra miplevels, source-texture is not power of two");
                    }
                }
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    l = (Integer)iterator3.next();
                    if (l <= 0 || l >= abufferedimage.length - 1 || abufferedimage[l] != null) continue;
                    ResourceLocation resourcelocation2 = this.completeResourceLocation(resourcelocation, l);
                    try {
                        abufferedimage[l] = ImageIO.read(man.func_110536_a(resourcelocation2).func_110527_b());
                    }
                    catch (IOException ioexception) {
                        MainRegistry.logger.error("Unable to load miplevel {} from: {}", new Object[]{l, resourcelocation2, ioexception});
                    }
                }
            }
            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
            this.func_147964_a(abufferedimage, animationmetadatasection, (float)this.anisotropic > 1.0f);
        }
        catch (RuntimeException runtimeexception) {
            FMLClientHandler.instance().trackBrokenTexture(resourcelocation1, runtimeexception.getMessage());
            return true;
        }
        catch (IOException ioexception1) {
            FMLClientHandler.instance().trackMissingTexture(resourcelocation1);
            return true;
        }
        return false;
    }

    private ResourceLocation completeResourceLocation(ResourceLocation loc, int mipmap) {
        return mipmap == 0 ? new ResourceLocation(loc.func_110624_b(), String.format("%s/%s%s", this.basePath, loc.func_110623_a(), ".png")) : new ResourceLocation(loc.func_110624_b(), String.format("%s/mipmaps/%s.%d%s", this.basePath, loc.func_110623_a(), mipmap, ".png"));
    }
}

