/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mods.XWeaponModManager;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderStarF
extends ItemRenderWeaponBase {
    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.25f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderStarF.standardAimingTransform(stack, -1.75f * offset, -1.75f * offset, 2.5f * offset, 0.0, -0.953125, 1.0);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.star_f_tex);
        double scale = 0.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] hammer = HbmAnimations.getRelevantTransformation("HAMMER");
        double[] tilt = HbmAnimations.getRelevantTransformation("TILT");
        double[] turn = HbmAnimations.getRelevantTransformation("TURN");
        double[] mag = HbmAnimations.getRelevantTransformation("MAG");
        double[] bullet = HbmAnimations.getRelevantTransformation("BULLET");
        double[] slide = HbmAnimations.getRelevantTransformation("SLIDE");
        GL11.glTranslated((double)0.0, (double)-2.0, (double)-8.0);
        GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)2.0, (double)8.0);
        GL11.glTranslated((double)0.0, (double)1.0, (double)-3.0);
        GL11.glRotated((double)turn[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)tilt[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.0, (double)3.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)recoil[2]);
        GL11.glShadeModel((int)7425);
        ResourceManager.star_f.renderPart("Gun");
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.75, (double)-4.25);
        GL11.glRotated((double)(60.0 * (hammer[0] - 1.0)), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.75, (double)4.25);
        ResourceManager.star_f.renderPart("Hammer");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)(slide[2] * 2.3125));
        ResourceManager.star_f.renderPart("Slide");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)mag[0], (double)mag[1], (double)mag[2]);
        ResourceManager.star_f.renderPart("Mag");
        GL11.glTranslated((double)bullet[0], (double)bullet[1], (double)bullet[2]);
        ResourceManager.star_f.renderPart("Bullet");
        GL11.glPopMatrix();
        if (this.hasSilencer(stack)) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)2.375, (double)-0.25);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.uzi_tex);
            ResourceManager.uzi.renderPart("Silencer");
            GL11.glPopMatrix();
        } else {
            double smokeScale = 0.5;
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)3.0, (double)6.125);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
            ItemRenderStarF.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 0.75);
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)3.0, (double)6.125);
            GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 * gun.shotRand), (double)1.0, (double)0.0, (double)0.0);
            ItemRenderStarF.renderMuzzleFlash(gun.lastShot[0], 75, 7.5);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        GL11.glTranslated((double)0.0, (double)-0.25, (double)1.75);
        double scale = 0.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 1.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-1.0, (double)-0.5, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -6.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.25, (double)-5.0);
    }

    @Override
    public void renderModTable(ItemStack stack, int index) {
        GL11.glEnable((int)2896);
        this.renderStandardGun(stack);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type, Object ... data) {
        GL11.glEnable((int)2896);
        boolean silenced = this.hasSilencer(stack);
        if (silenced && type == IItemRenderer.ItemRenderType.INVENTORY) {
            double scale = 0.625;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-6.0);
        }
        this.renderStandardGun(stack);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED && !silenced) {
            long shot;
            EntityLivingBase ent = (EntityLivingBase)data[1];
            double shotRand = 0.0;
            if (ent == Minecraft.func_71410_x().field_71439_g) {
                ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
                shot = gun.lastShot[0];
                shotRand = gun.shotRand;
            } else {
                shot = ItemRenderWeaponBase.flashMap.getOrDefault(ent, -1L);
                if (shot < 0L) {
                    return;
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)3.0, (double)6.25);
            GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 * shotRand), (double)1.0, (double)0.0, (double)0.0);
            ItemRenderStarF.renderMuzzleFlash(shot, 75, 7.5);
            GL11.glPopMatrix();
        }
    }

    public boolean hasSilencer(ItemStack stack) {
        return XWeaponModManager.hasUpgrade(stack, 0, 201);
    }

    public void renderStandardGun(ItemStack stack) {
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.star_f_tex);
        ResourceManager.star_f.renderPart("Gun");
        ResourceManager.star_f.renderPart("Slide");
        ResourceManager.star_f.renderPart("Mag");
        ResourceManager.star_f.renderPart("Hammer");
        boolean silenced = this.hasSilencer(stack);
        if (silenced) {
            GL11.glTranslated((double)0.0, (double)2.375, (double)-0.25);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.uzi_tex);
            ResourceManager.uzi.renderPart("Silencer");
        }
        GL11.glShadeModel((int)7424);
    }
}

