/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTank;

public abstract class TileEntityMachineBase
extends TileEntityLoadedBase
implements ISidedInventory {
    public ItemStack[] slots;
    private String customName;

    public TileEntityMachineBase(int slotCount) {
        this.slots = new ItemStack[slotCount];
    }

    public void markChanged() {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : this.getName();
    }

    public abstract String getName();

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return false;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.slots[slot] != null) {
            if (this.slots[slot].field_77994_a <= amount) {
                ItemStack itemStack = this.slots[slot];
                this.slots[slot] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[slot].func_77979_a(amount);
            if (this.slots[slot].field_77994_a == 0) {
                this.slots[slot] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.func_94041_b(slot, itemStack);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public int getGaugeScaled(int i, FluidTank tank) {
        return tank.getFluidAmount() * i / tank.getCapacity();
    }

    public abstract void func_145845_h();

    @Deprecated
    public void handleButtonPacket(int value, int meta) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
        this.customName = nbt.func_74779_i("name");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
        if (this.customName != null) {
            nbt.func_74778_a("name", this.customName);
        }
    }

    public void updateRedstoneConnection(DirPos pos) {
        Block block2;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        ForgeDirection dir = pos.getDir();
        Block block1 = this.field_145850_b.func_147439_a(x, y, z);
        block1.onNeighborChange((IBlockAccess)this.field_145850_b, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        block1.func_149695_a(this.field_145850_b, x, y, z, this.func_145838_q());
        if (block1.isNormalCube((IBlockAccess)this.field_145850_b, x, y, z) && (block2 = this.field_145850_b.func_147439_a(x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ)).getWeakChanges((IBlockAccess)this.field_145850_b, x, y, z)) {
            block2.onNeighborChange((IBlockAccess)this.field_145850_b, x, y, z, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            block2.func_149695_a(this.field_145850_b, x, y, z, this.func_145838_q());
        }
    }
}

