/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardSenderMK2;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineIntake
extends TileEntityLoadedBase
implements IEnergyReceiverMK2,
IFluidStandardSenderMK2 {
    public FluidTank compair = new FluidTank(Fluids.AIR, 1000);
    public long power;
    public float fan = 0.0f;
    public float prevFan = 0.0f;
    private AudioWrapper audio;
    AxisAlignedBB bb = null;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.power >= this.getMaxPower() / 20L) {
                this.compair.setFill(this.compair.getMaxFill());
                this.power -= this.getMaxPower() / 20L;
            }
            for (DirPos pos : this.getConPos()) {
                if (this.compair.getFill() > 0) {
                    this.tryProvide(this.compair, this.field_145850_b, pos);
                }
                this.trySubscribe(this.field_145850_b, pos);
            }
            this.networkPackNT(50);
        } else {
            this.prevFan = this.fan;
            if (this.power >= this.getMaxPower() / 20L) {
                this.fan += 45.0f;
                if (this.fan >= 360.0f) {
                    this.fan -= 360.0f;
                    this.prevFan -= 360.0f;
                }
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updateVolume(this.getVolume(0.25f));
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ, rot.getOpposite())};
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.motor", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f, 10.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        this.compair.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.compair.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.compair.readFromNBT(nbt, "compair");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.compair.writeToNBT(nbt, "compair");
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return type == Fluids.AIR && dir != ForgeDirection.UP && dir != ForgeDirection.DOWN;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 2000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.compair};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.compair};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

