/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.handler.CasingEjector;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.container.ContainerTurretBase;
import com.hbm.inventory.gui.GUITurretSentry;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.factory.XFactory9mm;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.turret.TileEntityTurretBaseNT;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTurretSentry
extends TileEntityTurretBaseNT
implements IGUIProvider {
    protected boolean didJustShootLeft = false;
    protected boolean retractingLeft = false;
    public double barrelLeftPos = 0.0;
    public double lastBarrelLeftPos = 0.0;
    protected boolean didJustShootRight = false;
    protected boolean retractingRight = false;
    public double barrelRightPos = 0.0;
    public double lastBarrelRightPos = 0.0;
    static List<Integer> configs = new ArrayList<Integer>();
    boolean shotSide = false;
    int timer;
    protected static CasingEjector ejector;

    @Override
    protected List<Integer> getAmmoList() {
        return configs;
    }

    @Override
    public String getName() {
        return "container.turretSentry";
    }

    @Override
    public double getTurretDepression() {
        return 20.0;
    }

    @Override
    public double getTurretElevation() {
        return 20.0;
    }

    @Override
    public int getDecetorInterval() {
        return 10;
    }

    @Override
    public double getDecetorRange() {
        return 24.0;
    }

    @Override
    public double getDecetorGrace() {
        return 2.0;
    }

    @Override
    public long getMaxPower() {
        return 1000L;
    }

    @Override
    public long getConsumption() {
        return 5L;
    }

    @Override
    public double getBarrelLength() {
        return 1.25;
    }

    @Override
    public double getAcceptableInaccuracy() {
        return 15.0;
    }

    @Override
    public boolean hasThermalVision() {
        return false;
    }

    @Override
    public Vec3 getHorizontalOffset() {
        return Vec3.func_72443_a((double)0.5, (double)0.0, (double)0.5);
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.lastBarrelLeftPos = this.barrelLeftPos;
            this.lastBarrelRightPos = this.barrelRightPos;
            float retractSpeed = 0.5f;
            float pushSpeed = 0.25f;
            if (this.retractingLeft) {
                this.barrelLeftPos += (double)retractSpeed;
                if (this.barrelLeftPos >= 1.0) {
                    this.retractingLeft = false;
                }
            } else {
                this.barrelLeftPos -= (double)pushSpeed;
                if (this.barrelLeftPos < 0.0) {
                    this.barrelLeftPos = 0.0;
                }
            }
            if (this.retractingRight) {
                this.barrelRightPos += (double)retractSpeed;
                if (this.barrelRightPos >= 1.0) {
                    this.retractingRight = false;
                }
            } else {
                this.barrelRightPos -= (double)pushSpeed;
                if (this.barrelRightPos < 0.0) {
                    this.barrelRightPos = 0.0;
                }
            }
        }
        super.func_145845_h();
    }

    @Override
    public void updateFiringTick() {
        BulletConfig conf;
        ++this.timer;
        if (this.timer % 10 == 0 && (conf = this.getFirstConfigLoaded()) != null) {
            this.cachedCasingConfig = conf.casing;
            this.spawnBullet(conf, 5.0f);
            this.conusmeAmmo(conf.ammo);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:turret.sentry_fire", 2.0f, 1.0f);
            Vec3 pos = this.getTurretPos();
            Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
            vec.func_72446_c((float)(-this.rotationPitch));
            vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
            Vec3 side = Vec3.func_72443_a((double)(0.125 * (double)(this.shotSide ? 1 : -1)), (double)0.0, (double)0.0);
            side.func_72442_b((float)(-this.rotationYaw));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "vanillaExt");
            data.func_74778_a("mode", "largeexplode");
            data.func_74776_a("size", 1.0f);
            data.func_74774_a("count", (byte)1);
            PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, pos.field_72450_a + vec.field_72450_a + side.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c + side.field_72449_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            if (this.shotSide) {
                this.didJustShootLeft = true;
            } else {
                this.didJustShootRight = true;
            }
            this.shotSide = !this.shotSide;
        }
    }

    @Override
    protected Vec3 getCasingSpawnPos() {
        Vec3 pos = this.getTurretPos();
        Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.25, (double)-0.125);
        vec.func_72446_c((float)(-this.rotationPitch));
        vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
        return Vec3.func_72443_a((double)(pos.field_72450_a + vec.field_72450_a), (double)(pos.field_72448_b + vec.field_72448_b), (double)(pos.field_72449_c + vec.field_72449_c));
    }

    @Override
    protected CasingEjector getEjector() {
        return ejector.setMotion(0.2, 0.2, 0.0);
    }

    @Override
    public boolean usesCasings() {
        return true;
    }

    @Override
    protected void seekNewTarget() {
        Entity lastTarget = this.target;
        super.seekNewTarget();
        if (lastTarget != this.target && this.target != null) {
            this.field_145850_b.func_72956_a(this.target, "hbm:turret.sentry_lockon", 2.0f, 1.5f);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.didJustShootLeft);
        buf.writeBoolean(this.didJustShootRight);
        this.didJustShootLeft = false;
        this.didJustShootRight = false;
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.retractingLeft = buf.readBoolean();
        this.retractingRight = buf.readBoolean();
    }

    @Override
    protected void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, ForgeDirection.DOWN);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerTurretBase(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITurretSentry(player.field_71071_by, this);
    }

    static {
        configs.add(XFactory9mm.p9_sp.id);
        configs.add(XFactory9mm.p9_fmj.id);
        configs.add(XFactory9mm.p9_jhp.id);
        configs.add(XFactory9mm.p9_ap.id);
        ejector = new CasingEjector().setMotion(-0.3, 0.6, 0.0).setAngleRange(0.01f, 0.01f);
    }
}

