/*
 * Decompiled with CFR 0.152.
 */
package lang_project_id.jvmcheck;

import lang_project_id.jvmcheck.JvmCheckConstants_Actual;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class JvmCheck
implements IStartup,
JvmCheckConstants_Actual {
    public static String getJavaVersionProperty() {
        return System.getProperty("java.version");
    }

    public static int getJavaVersion() {
        String versionProperty = JvmCheck.getJavaVersionProperty();
        String[] versionSegments = versionProperty.split("\\.");
        if (versionSegments.length < 2) {
            return -1;
        }
        String javaVersionStr = versionSegments[1];
        try {
            return Integer.parseInt(javaVersionStr);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void earlyStartup() {
        final int javaVersion = JvmCheck.getJavaVersion();
        if (javaVersion >= 8) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell activeShell = JvmCheck.getActiveWorkbenchShell();
                String message = "Could not start Goclipse because Java version is: " + javaVersion + "\nVersion " + 8 + " is required";
                System.err.println(message);
                if (activeShell == null) {
                    return;
                }
                MessageDialog.openError((Shell)activeShell, (String)"Error", (String)message);
            }
        });
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JvmCheck.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }
}

